/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.goodness;

import net.adaptivebox.global.IUpdateCycleEngine;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;

public class ACRComparator
implements IGoodnessCompareEngine,
IUpdateCycleEngine {
    private Library socialPool;
    private double epsilon_t = 0.0;
    private double RU = 0.75;
    private double RL = 0.25;
    private double BETAF = 0.618;
    private double BETAL = 0.618;
    private double BETAU = 1.382;
    private double T = -1.0;
    private double TthR = 0.5;

    public ACRComparator(Library library, int n) {
        this.socialPool = library;
        this.T = n;
        this.epsilon_t = library.getExtremalVcon(true);
    }

    public static int compare(double d, double d2) {
        if (d < d2) {
            return 0;
        }
        if (d > d2) {
            return 2;
        }
        return 1;
    }

    public int compare(double[] dArray, double[] dArray2) {
        if (Math.max(dArray[0], dArray2[0]) <= Math.max(0.0, this.epsilon_t)) {
            return ACRComparator.compare(dArray[1], dArray2[1]);
        }
        return ACRComparator.compare(dArray[0], dArray2[0]);
    }

    public void updateCycle(int n) {
        double d = (double)this.socialPool.getVconThanNum(this.epsilon_t) / (double)this.socialPool.getPopSize();
        if ((double)n > this.TthR * this.T && this.T != -1.0) {
            this.epsilon_t *= this.BETAF;
        } else {
            if (d > this.RU) {
                this.epsilon_t *= this.BETAL;
            }
            if (d < this.RL) {
                this.epsilon_t *= this.BETAU;
            }
        }
    }
}

