/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.knowledge;

import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;

public class Library {
    private SearchPoint[] libPoints = new SearchPoint[0];
    protected int gIndex = -1;

    public Library(SearchPoint[] searchPointArray) {
        this.libPoints = searchPointArray;
    }

    public Library(int n, ProblemEncoder problemEncoder) {
        this.libPoints = new SearchPoint[n];
        for (int i = 0; i < n; ++i) {
            this.libPoints[i] = problemEncoder.getEncodedSearchPoint();
        }
    }

    public SearchPoint getGbest() {
        return this.getSelectedPoint(this.gIndex);
    }

    public void refreshGbest(IGoodnessCompareEngine iGoodnessCompareEngine) {
        this.gIndex = this.tournamentSelection(iGoodnessCompareEngine, this.getPopSize() - 1, true);
    }

    public int getPopSize() {
        return this.libPoints.length;
    }

    public SearchPoint getSelectedPoint(int n) {
        return this.libPoints[n];
    }

    public static boolean replace(IGoodnessCompareEngine iGoodnessCompareEngine, SearchPoint searchPoint, SearchPoint searchPoint2) {
        boolean bl = false;
        if (iGoodnessCompareEngine.compare(searchPoint.getEncodeInfo(), searchPoint2.getEncodeInfo()) < 2) {
            searchPoint2.importPoint(searchPoint);
            bl = true;
        }
        return bl;
    }

    public int tournamentSelection(IGoodnessCompareEngine iGoodnessCompareEngine, int n, boolean bl) {
        int[] nArray = RandomGenerator.randomSelection(this.getPopSize(), n);
        int n2 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            int n3 = iGoodnessCompareEngine.compare(this.libPoints[nArray[i]].getEncodeInfo(), this.libPoints[n2].getEncodeInfo());
            if (bl != n3 < 2) continue;
            n2 = nArray[i];
        }
        return n2;
    }

    public double getExtremalVcon(boolean bl) {
        double d = -1.0E308;
        for (int i = 0; i < this.libPoints.length; ++i) {
            if (this.libPoints[i].getEncodeInfo()[0] > d != bl) continue;
            d = this.libPoints[i].getEncodeInfo()[0];
        }
        return d;
    }

    public int getVconThanNum(double d) {
        int n = 0;
        for (int i = 0; i < this.libPoints.length; ++i) {
            if (!(this.libPoints[i].getEncodeInfo()[0] <= d)) continue;
            ++n;
        }
        return n;
    }
}

