/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.space;

import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.space.DesignDim;

public class DesignSpace {
    private DesignDim[] dimProps;

    public DesignSpace(int n) {
        this.dimProps = new DesignDim[n];
    }

    public DesignDim getDimAt(int n) {
        return this.dimProps[n];
    }

    public void setElemAt(DesignDim designDim, int n) {
        this.dimProps[n] = designDim;
    }

    public int getDimension() {
        if (this.dimProps == null) {
            return -1;
        }
        return this.dimProps.length;
    }

    public double boundAdjustAt(double d, int n) {
        return this.dimProps[n].paramBound.boundAdjust(d);
    }

    public void annulusAdjust(double[] dArray) {
        for (int i = 0; i < this.getDimension(); ++i) {
            dArray[i] = this.dimProps[i].paramBound.annulusAdjust(dArray[i]);
        }
    }

    public void randomAdjust(double[] dArray) {
        for (int i = 0; i < this.getDimension(); ++i) {
            dArray[i] = this.dimProps[i].paramBound.randomAdjust(dArray[i]);
        }
    }

    public boolean satisfyCondition(double[] dArray) {
        for (int i = 0; i < this.getDimension(); ++i) {
            if (this.dimProps[i].paramBound.isSatisfyCondition(dArray[i])) continue;
            return false;
        }
        return true;
    }

    public void mutationAt(double[] dArray, int n) {
        dArray[n] = this.dimProps[n].paramBound.getRandomValue();
    }

    public double mutationUniformAtPointAsCenter(double d, int n) {
        double d2 = this.getMagnitudeIn(n) / 2.0;
        return d += RandomGenerator.doubleRangeRandom(-1.0 * d2, d2);
    }

    public double getUpValueAt(int n) {
        return this.dimProps[n].paramBound.maxValue;
    }

    public double getLowValueAt(int n) {
        return this.dimProps[n].paramBound.minValue;
    }

    public double getMagnitudeIn(int n) {
        return this.dimProps[n].paramBound.getLength();
    }

    public boolean initilizeGeneAtPointAsCenter(double[] dArray) {
        if (dArray.length != this.getDimension()) {
            return false;
        }
        int n = 0;
        while (n < dArray.length) {
            double d = this.getMagnitudeIn(n) / 2.0;
            int n2 = n++;
            dArray[n2] = dArray[n2] + RandomGenerator.doubleRangeRandom(-1.0 * d, d);
        }
        return true;
    }

    public void initializeGene(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.dimProps[i].paramBound.getRandomValue();
        }
    }

    public double[] getFreshGene() {
        double[] dArray = new double[this.getDimension()];
        this.initializeGene(dArray);
        return dArray;
    }

    public void getMappingPoint(double[] dArray) {
        for (int i = 0; i < this.getDimension(); ++i) {
            dArray[i] = this.dimProps[i].paramBound.annulusAdjust(dArray[i]);
            if (!this.dimProps[i].isDiscrete()) continue;
            dArray[i] = this.dimProps[i].getGrainedValue(dArray[i]);
        }
    }

    public double[] getRealLoc(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i];
        }
        this.annulusAdjust(dArray2);
        return dArray2;
    }
}

