#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>

#include <glib.h>
#include <gmodule.h>

#include "playerctrl.h"

/**
 * playerctrl.c
 * This is wrapper functions for XMMS API.
 * It enables dynamic loading of the player's library
 */

gchar * player_control_get_command(Players id) {
	gchar *cmdstr;
	switch (id) {
		case PLAYER_XMMS:
			cmdstr = CMD_XMMS;
			break;
		case PLAYER_BEEP:
			cmdstr = CMD_BEEP;
			break;
		case PLAYER_AUDACIOUS:
			cmdstr = CMD_AUDACIOUS;
			break;
		default:
			return NULL;
			break;
	}
	return cmdstr;
}

PlayerCtrl * player_control_get_instance(Players id) {
	gchar *libname;
	switch (id) {
		case PLAYER_XMMS:
			libname = LIB_XMMS;
			break;
		case PLAYER_BEEP:
			libname = LIB_BEEP;
			break;
		case PLAYER_AUDACIOUS:
			libname = LIB_AUDACIOUS;
			break;
		default:
			return NULL;
			break;
	}
	return player_control_load_library(libname);
}

void player_control_close(PlayerCtrl *instance) {
	if (instance->library)
		g_module_close(instance->library);
	g_free(instance);
}

gboolean player_control_has_library(gchar *libname) {
	GModule *library;
	gchar *filename;

	filename = g_module_build_path(NULL, libname);
	library = g_module_open(filename, G_MODULE_BIND_LAZY);
	g_free(filename);

	if (library) {
		g_module_close(library);
		return TRUE;
	} else {
		return FALSE;
	}
}

PlayerCtrl * player_control_load_library(gchar *libname) {
	PlayerCtrl *instance;
	gchar *filename;

	instance = g_new0(PlayerCtrl, 1);

	filename = g_module_build_path(NULL, libname);
	instance->library = g_module_open(filename, G_MODULE_BIND_LAZY);
	g_free(filename);

	if (! instance->library)
		return NULL;

	/********************* start binding *********************/

	g_module_symbol(instance->library, "xmms_remote_playlist",
			(gpointer *) &instance->player_playlist);
	g_module_symbol(instance->library, "xmms_remote_get_version",
			(gpointer *) &instance->player_get_version);
	g_module_symbol(instance->library, "xmms_remote_playlist_add",
			(gpointer *) &instance->player_playlist_add);
	g_module_symbol(instance->library, "xmms_remote_playlist_delete",
			(gpointer *) &instance->player_playlist_delete);
	g_module_symbol(instance->library, "xmms_remote_play",
			(gpointer *) &instance->player_play);
	g_module_symbol(instance->library, "xmms_remote_pause",
			(gpointer *) &instance->player_pause);
	g_module_symbol(instance->library, "xmms_remote_stop",
			(gpointer *) &instance->player_stop);
	g_module_symbol(instance->library, "xmms_remote_is_playing",
			(gpointer *) &instance->player_is_playing);
	g_module_symbol(instance->library, "xmms_remote_is_paused",
			(gpointer *) &instance->player_is_paused);
	g_module_symbol(instance->library, "xmms_remote_get_playlist_pos",
			(gpointer *) &instance->player_get_playlist_pos);
	g_module_symbol(instance->library, "xmms_remote_set_playlist_pos",
			(gpointer *) &instance->player_set_playlist_pos);
	g_module_symbol(instance->library, "xmms_remote_get_playlist_length",
			(gpointer *) &instance->player_get_playlist_length);
	g_module_symbol(instance->library, "xmms_remote_playlist_clear",
			(gpointer *) &instance->player_playlist_clear);
	g_module_symbol(instance->library, "xmms_remote_get_output_time",
			(gpointer *) &instance->player_get_output_time);
	g_module_symbol(instance->library, "xmms_remote_jump_to_time",
			(gpointer *) &instance->player_jump_to_time);
	g_module_symbol(instance->library, "xmms_remote_get_volume",
			(gpointer *) &instance->player_get_volume);
	g_module_symbol(instance->library, "xmms_remote_get_main_volume",
			(gpointer *) &instance->player_get_main_volume);
	g_module_symbol(instance->library, "xmms_remote_get_balance",
			(gpointer *) &instance->player_get_balance);
	g_module_symbol(instance->library, "xmms_remote_set_volume",
			(gpointer *) &instance->player_set_volume);
	g_module_symbol(instance->library, "xmms_remote_set_main_volume",
			(gpointer *) &instance->player_set_main_volume);
	g_module_symbol(instance->library, "xmms_remote_set_balance",
			(gpointer *) &instance->player_set_balance);
	g_module_symbol(instance->library, "xmms_remote_get_skin",
			(gpointer *) &instance->player_get_skin);
	g_module_symbol(instance->library, "xmms_remote_set_skin",
			(gpointer *) &instance->player_set_skin);
	g_module_symbol(instance->library, "xmms_remote_get_playlist_file",
			(gpointer *) &instance->player_get_playlist_file);
	g_module_symbol(instance->library, "xmms_remote_get_playlist_title",
			(gpointer *) &instance->player_get_playlist_title);
	g_module_symbol(instance->library, "xmms_remote_get_playlist_time",
			(gpointer *) &instance->player_get_playlist_time);
	g_module_symbol(instance->library, "xmms_remote_get_info",
			(gpointer *) &instance->player_get_info);
	g_module_symbol(instance->library, "xmms_remote_main_win_toggle",
			(gpointer *) &instance->player_main_win_toggle);
	g_module_symbol(instance->library, "xmms_remote_pl_win_toggle",
			(gpointer *) &instance->player_pl_win_toggle);
	g_module_symbol(instance->library, "xmms_remote_eq_win_toggle",
			(gpointer *) &instance->player_eq_win_toggle);
	g_module_symbol(instance->library, "xmms_remote_is_main_win",
			(gpointer *) &instance->player_is_main_win);
	g_module_symbol(instance->library, "xmms_remote_is_pl_win",
			(gpointer *) &instance->player_is_pl_win);
	g_module_symbol(instance->library, "xmms_remote_is_eq_win",
			(gpointer *) &instance->player_is_eq_win);
	g_module_symbol(instance->library, "xmms_remote_show_prefs_box",
			(gpointer *) &instance->player_show_prefs_box);
	g_module_symbol(instance->library, "xmms_remote_toggle_aot",
			(gpointer *) &instance->player_toggle_aot);
	g_module_symbol(instance->library, "xmms_remote_eject",
			(gpointer *) &instance->player_eject);
	g_module_symbol(instance->library, "xmms_remote_playlist_prev",
			(gpointer *) &instance->player_playlist_prev);
	g_module_symbol(instance->library, "xmms_remote_playlist_next",
			(gpointer *) &instance->player_playlist_next);
	g_module_symbol(instance->library, "xmms_remote_playlist_add_url_string",
			(gpointer *) &instance->player_playlist_add_url_string);
	g_module_symbol(instance->library, "xmms_remote_is_running",
			(gpointer *) &instance->player_is_running);
	g_module_symbol(instance->library, "xmms_remote_toggle_repeat",
			(gpointer *) &instance->player_toggle_repeat);
	g_module_symbol(instance->library, "xmms_remote_toggle_shuffle",
			(gpointer *) &instance->player_toggle_shuffle);
	g_module_symbol(instance->library, "xmms_remote_is_repeat",
			(gpointer *) &instance->player_is_repeat);
	g_module_symbol(instance->library, "xmms_remote_is_shuffle",
			(gpointer *) &instance->player_is_shuffle);
	g_module_symbol(instance->library, "xmms_remote_get_eq",
			(gpointer *) &instance->player_get_eq);
	g_module_symbol(instance->library, "xmms_remote_get_eq_preamp",
			(gpointer *) &instance->player_get_eq_preamp);
	g_module_symbol(instance->library, "xmms_remote_get_eq_band",
			(gpointer *) &instance->player_get_eq_band);
	g_module_symbol(instance->library, "xmms_remote_set_eq",
			(gpointer *) &instance->player_set_eq);
	g_module_symbol(instance->library, "xmms_remote_set_eq_preamp",
			(gpointer *) &instance->player_set_eq_preamp);
	g_module_symbol(instance->library, "xmms_remote_set_eq_band",
			(gpointer *) &instance->player_set_eq_band);
	/* Added in XMMS 1.2.1 */
	g_module_symbol(instance->library, "xmms_remote_quit",
			(gpointer *) &instance->player_quit);
	/* Added in XMMS 1.2.6 */
	g_module_symbol(instance->library, "xmms_remote_play_pause",
			(gpointer *) &instance->player_play_pause);
	g_module_symbol(instance->library, "xmms_remote_playlist_ins_url_string",
			(gpointer *) &instance->player_playlist_ins_url_string);
	/* Added in XMMS 1.2.11 */
	g_module_symbol(instance->library, "xmms_remote_playqueue_add",
			(gpointer *) &instance->player_playqueue_add);
	g_module_symbol(instance->library, "xmms_remote_playqueue_remove",
			(gpointer *) &instance->player_playqueue_remove);
	g_module_symbol(instance->library, "xmms_remote_get_playqueue_length",
			(gpointer *) &instance->player_get_playqueue_length);
	g_module_symbol(instance->library, "xmms_remote_toggle_advance",
			(gpointer *) &instance->player_toggle_advance);
	g_module_symbol(instance->library, "xmms_remote_is_advance",
			(gpointer *) &instance->player_is_advance);
	/* Added in BMP 0.9.7 */
	g_module_symbol(instance->library, "xmms_remote_activate",
			(gpointer *) &instance->player_activate);
	/* Added in Audacious 1.1 */
	g_module_symbol(instance->library, "xmms_remote_show_jtf_box",
			(gpointer *) &instance->player_show_jtf_box);
	g_module_symbol(instance->library, "xmms_remote_playqueue_clear",
			(gpointer *) &instance->player_playqueue_clear);
	g_module_symbol(instance->library, "xmms_remote_playqueue_is_queued",
			(gpointer *) &instance->player_playqueue_is_queued);
	g_module_symbol(instance->library, "xmms_remote_get_playqueue_position",
			(gpointer *) &instance->player_get_playqueue_position);
	g_module_symbol(instance->library, "xmms_remote_get_playqueue_queue_position",
			(gpointer *) &instance->player_get_playqueue_queue_position);

	/********************* end binding *********************/
	
	return instance;
}

/* <Leader>ere (create binding codes)
File.open("/usr/include/audacious/beepctrl.h") {|file|
	buf = ""
	file.each() {|line|
		case line
		when /\s*.+(xmms_remote.+)\(.+/
			print "g_module_symbol(instance->library, \"#{$1}\","
			print "(gpointer *) &instance->player#{$1[11..-1]});"
		when /\/\*.*\*\//
			print(line.strip)
		end
	}
}
*/
