<?xml version="1.0" encoding="UTF-8"?>
<!--

    OpenOffice.org - a multi-platform office productivity suite
 
    $RCSfile: master_chapter_numbering.xsl,v $
 
    $Revision: 1.5 $
 
    last change: $Author: rt $ $Date: 2005/09/08 22:08:50 $
 
    The Contents of this file are made available subject to
    the terms of GNU Lesser General Public License Version 2.1.
 
 
      GNU Lesser General Public License Version 2.1
      =============================================
      Copyright 2005 by Sun Microsystems, Inc.
      901 San Antonio Road, Palo Alto, CA 94303, USA
 
      This library is free software; you can redistribute it and/or
      modify it under the terms of the GNU Lesser General Public
      License version 2.1, as published by the Free Software Foundation.
 
      This library is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
      Lesser General Public License for more details.
 
      You should have received a copy of the GNU Lesser General Public
      License along with this library; if not, write to the Free Software
      Foundation, Inc., 59 Temple Place, Suite 330, Boston,
      MA  02111-1307  USA
 
-->
<!--
	For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:office="http://openoffice.org/2000/office"
		xmlns:style="http://openoffice.org/2000/style"
		xmlns:text="http://openoffice.org/2000/text"
		xmlns:table="http://openoffice.org/2000/table"
		xmlns:draw="http://openoffice.org/2000/drawing"
		xmlns:fo="http://www.w3.org/1999/XSL/Format"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:number="http://openoffice.org/2000/datastyle"
		xmlns:svg="http://www.w3.org/2000/svg"
		xmlns:chart="http://openoffice.org/2000/chart"
		xmlns:dr3d="http://openoffice.org/2000/dr3d"
		xmlns:math="http://www.w3.org/1998/Math/MathML"
		xmlns:form="http://openoffice.org/2000/form"
		xmlns:script="http://openoffice.org/2000/script"
		xmlns:dc="http://purl.org/dc/elements/1.1/"
		xmlns:meta="http://openoffice.org/2000/meta"
		xmlns:config="http://openoffice.org/2001/config"
		xmlns:help="http://openoffice.org/2000/help"
		xmlns:sxg="http://www.jclark.com/xt/java/org.openoffice.xslt.OOoMasterDocument"
		xmlns:java="http://xml.apache.org/xslt/java"
		xmlns="http://www.w3.org/1999/xhtml"
		version="1.0"
		exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help java sxg">


	<!-- ************************** -->
	<!-- *** Chapter Numbering  *** -->
	<!-- ************************** -->


	<!-- The chapter number of the current document (child of a master document) is dependent of the amount
		 of chapters of the same level in preceding documents (preceding children of the master document). -->
	<xsl:param name="precedingChapterLevel1" select="0" />
	<xsl:param name="precedingChapterLevel2" select="0" />
	<xsl:param name="precedingChapterLevel3" select="0" />
	<xsl:param name="precedingChapterLevel4" select="0" />
	<xsl:param name="precedingChapterLevel5" select="0" />
	<xsl:param name="precedingChapterLevel6" select="0" />
	<xsl:param name="precedingChapterLevel7" select="0" />
	<xsl:param name="precedingChapterLevel8" select="0" />
	<xsl:param name="precedingChapterLevel9" select="0" />
	<xsl:param name="precedingChapterLevel10" select="0" />

	<!-- Office documents containing a table of contents,
		gonna link for usability reason above each chapter to the preceding and following document and the content table -->
	<xsl:param name="contentTableURL" />


	<xsl:template name="get-heading-number">
		<xsl:param name="globalData" />
		<xsl:param name="precedingChapterLevel1" />

		<xsl:choose>
			<xsl:when test="$currentChildContentRef">
				<xsl:variable name="currentFileHeadingNo">
					<xsl:call-template name="get-current-file-heading-no" />
				</xsl:variable>
				<xsl:variable name="testResult" select="$contentTableHeadings/heading[$currentChildContentRef = @file-url][number($currentFileHeadingNo)]" />
				<xsl:call-template name="get-global-heading-no">
					<xsl:with-param name="currentFileHeadingNo" select="translate($testResult/@absolute-chapter-level, '_', '.')" />
					<xsl:with-param name="precedingChapterLevel1" select="$precedingChapterLevel1" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- When the chapter is in the master document itself the link has to be relative (e.g. #index) a absolute href does not
					work with the browser. In case of chapter in the master document, the output URL of the master document was taken. -->
				<xsl:variable name="currentFileHeadingNo">
					<xsl:call-template name="get-current-file-heading-no" />
				</xsl:variable>
				<xsl:variable name="testResult" select="$globalData/content-table-headings/heading[$contentTableURL = @file-url][number($currentFileHeadingNo)]" />

				<xsl:call-template name="get-global-heading-no">
					<xsl:with-param name="currentFileHeadingNo" select="translate($testResult/@absolute-chapter-level, '_', '.')" />
					<xsl:with-param name="precedingChapterLevel1" select="$precedingChapterLevel1" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>

		<!-- Note: Two white-space as default indent after heading number,
				   Currently @style:num-suffix will be neglected -->
		<xsl:text>&#160;&#160;</xsl:text>
	</xsl:template>


	<xsl:template name="get-current-file-heading-no">
		<xsl:choose>
			<xsl:when test="function-available('sxg:get-current-child-heading-no')">
				<xsl:value-of select="sxg:get-current-child-heading-no()" />
			</xsl:when>
			<xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getCurrentChildHeadingNo')">
				<xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.getCurrentChildHeadingNo()" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getCurrentChildHeadingNo()</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<xsl:template name="get-global-heading-no">
		<xsl:param name="currentFileHeadingNo" />
		<xsl:param name="precedingChapterLevel1" />

		<xsl:choose>
			<xsl:when test="function-available('sxg:get-global-heading-no')">
				<xsl:value-of select="sxg:get-global-heading-no(string($currentFileHeadingNo), number($precedingChapterLevel1))" />
			</xsl:when>
			<xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getGlobalHeadingNo')">
				<xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.getGlobalHeadingNo(string($currentFileHeadingNo), number($precedingChapterLevel1))" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getGlobalHeadingNo</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<xsl:template name="get-next-current-file-heading-no">
		<xsl:param name="file" />
		<xsl:choose>
			<xsl:when test="function-available('sxg:get-next-current-child-heading-no')">
				<xsl:value-of select="sxg:get-next-current-child-heading-no($file)" />
			</xsl:when>
			<xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getNextCurrentChildHeadingNo')">
				<xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.getNextCurrentChildHeadingNo($file)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getNextCurrentChildHeadingNo</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>