########
## DO NOT RUN THIS FILE DIRECTLY
## USE TRAY.PY INSTEAD
## nothing bad will happen if you do
## but that is not the preferred method
## tray.py automatically picks the correct version
## of the tray icon to use
########

########
##thanks to Arne Brix for programming most of this
##released under the GNU Public License
##see http://www.gnu.org/copyleft/gpl.html for details
##this will only work in Edgy and above because of gtk requirements
##to run the tray icon
########
import os,sys
if __name__ == '__main__':
    os.chdir(os.path.dirname(os.path.normpath(os.path.join(os.getcwd(),sys.argv[0]))))
import gtk, gobject, dbus, dbus.service, os, sys, locale, gettext, signal, time
if getattr(dbus, 'version', (0,0,0)) >= (0,41,0):
    import dbus.glib

#############
# Declare the connections to our daemon.
# Without them nothing useful will happen.
# The daemon should be running as root.
# Some connections aren't used so they are commented.
bus = dbus.SystemBus()
try:
    print 'attempting to connect daemon...'
    proxy_obj = bus.get_object('org.wicd.daemon', '/org/wicd/daemon')
    print 'success'
except:
    print 'daemon not running...'
    import misc
    misc.PromptToStartDaemon()
    sys.exit(0)
daemon = dbus.Interface(proxy_obj, 'org.wicd.daemon')
wireless = dbus.Interface(proxy_obj, 'org.wicd.daemon.wireless')
wired = dbus.Interface(proxy_obj, 'org.wicd.daemon.wired')
config = dbus.Interface(proxy_obj, 'org.wicd.daemon.config')
#############

local_path = os.path.realpath(os.path.dirname(sys.argv[0])) + '/translations'
langs = []
lc, encoding = locale.getdefaultlocale()
if (lc):
    langs = [lc]
osLanguage = os.environ.get('LANGUAGE', None)
if (osLanguage):
    langs += osLanguage.split(":")
langs += ["en_US"]
lang = gettext.translation('wicd', local_path, languages=langs, fallback = True)
_ = lang.gettext
language = {}

language['connected_to_wireless'] = _('Connected to $A at $B% (IP: $C)')
language['connected_to_wired'] = _('Connected to wired network (IP: $A)')
language['not_connected'] = _('Not connected')

tr=None
tooltip = gtk.Tooltips()
pic=None
lastWinId = 0

def open_wicd_gui():
    global lastWinId
    ret = 0
    if lastWinId != 0:
       os.kill(lastWinId,signal.SIGQUIT)
       ret = os.waitpid(lastWinId,0)[1]
       lastWinId = 0
    if ret == 0:
       lastWinId = os.spawnlpe(os.P_NOWAIT, './gui.py', os.environ)

def wired_profile_chooser():
    print 'profile chooser is running'
    os.spawnlpe(os.P_WAIT, './gui.py', os.environ)

def set_signal_image():
    global LastStrength
    global stillWired  # Keeps us from resetting the wired info over and over
    global network  # Declared as global so it gets initialized before first use
    global last_bytes_sent # Remember how many bytes were last sent
    global last_bytes_received
    global max_leap_rec, max_leap_trans
    # Read the data from the network activity table
    # This really should be done through the daemon,
    # But this version of the daemon won't be used in 1.4.0
    # (the current experimental branch) so for now I'll do it like this
    
    transmitting = False
    receiving = False
    
    device_data = open('/proc/net/dev','r').read().split('\n')
    for line in device_data:
        if daemon.GetWirelessInterface() in line:
            # sample line
            #  eth1:75105317   61801    0    0    0     0          0         0  4718484   47923    0    0    0     0       0          0
            print line
            line = line.replace(':',' ') #swap the : for a space for easy splitting
            parts = line.split(' ')
            
            for piece in parts:
                if piece == '':
                    parts.remove(piece)
 
            #max_leap_trans -= 100000 #to keep it balanced
            #max_leap_rec -= 1000
            
            if parts[1] == '' or parts[9] == '':
                transmitting = False
                receiving = False
            else:
                if int(parts[9]) > int(last_bytes_sent)+(float(max_leap_trans)/20.0):
                    if int(last_bytes_sent) != -1 and (int(parts[9]) - int(last_bytes_sent)) > max_leap_trans:
                        max_leap_trans = int(parts[9]) - int(last_bytes_sent)
                    if last_bytes_sent != -1:
                        transmitting = True
                    last_bytes_sent = parts[9]
                else:
                    print 'not trans'
                    print (int(parts[9]) - int(last_bytes_sent))    
                    print 'm|',max_leap_trans
                    transmitting = False
                
                
                if int(parts[1]) > int(last_bytes_received)+(float(max_leap_rec)/20.0):
                    if int(last_bytes_received) != -1 and (int(parts[1]) - int(last_bytes_received)) > max_leap_rec:
                        max_leap_trans = int(parts[1]) - int(last_bytes_received)
                    if last_bytes_received != -1:
                        receiving = True
                    last_bytes_received = int(parts[1])
                else:
                    print 'not rec'
                    receiving = False

    data_string = ""
    if transmitting and receiving:
        data_string = "both-"
    elif transmitting:
        data_string = "transmitting-"
    elif receiving:
        data_string = "receiving-"
    else:
        data_string = "idle-"

    # Disable logging if debugging isn't on to prevent log spam
    if not daemon.GetDebugMode():
        config.DisableLogging()

    # Check if wired profile chooser should be launched
    if daemon.GetNeedWiredProfileChooser() == True:
        wired_profile_chooser()
        daemon.SetNeedWiredProfileChooser(False)

    # Check for active wired connection
    wired_ip = wired.GetWiredIP()
    if wired.CheckPluggedIn() == True and wired_ip != None:
        # Only set image/tooltip if it hasn't been set already
        if stillWired == False:
            tr.set_from_file("images/wired.png")
            tr.set_tooltip(language['connected_to_wired'].replace('$A',
                                                                  wired_ip))
            stillWired = True
            lock = ''
    else:
        # Check to see if we were using a wired connection that has now become
        # unplugged or disabled.
        if stillWired == True:
            tr.set_from_file("images/no-signal.png")
            tr.set_tooltip(language['not_connected'])
        stillWired = False

        wireless_ip = wireless.GetWirelessIP()
        # If ip returns as None, we are probably returning from hibernation
        # and need to force signal to 0 to avoid crashing.
        if wireless_ip != None:
            if daemon.GetSignalDisplayType() == 0:
                wireless_signal = int(wireless.GetCurrentSignalStrength())
            else:
                wireless_signal = int(wireless.GetCurrentDBMStrength())
        else:
            wireless_signal = 0


        # Only update if the signal strength has changed because doing I/O
        # calls is expensive, and the icon flickers
        if (wireless_signal != LastStrength or
            network != wireless.GetCurrentNetwork() or wireless_signal == 0) \
            and wireless_ip != None:

            LastStrength = wireless_signal
            # Set the string to '' so that when it is put in "high-signal" +
            # lock + ".png", there will be nothing
            lock = ''
            # curNetID needs to be checked because a negative value
            # will break the tray when passed to GetWirelessProperty.
            curNetID = wireless.GetCurrentNetworkID()
            if wireless_signal > 0 and curNetID > -1 and \
               wireless.GetWirelessProperty(curNetID,"encryption"):
                # Set the string to '-lock' so that it will display the
                # lock picture
                lock = '-lock'
            network = str(wireless.GetCurrentNetwork())
            tr.set_tooltip(language['connected_to_wireless'].replace
                           ('$A', network).replace
                           ('$B', daemon.FormatSignalForPrinting(str(wireless_signal))).replace
                           ('$C', str(wireless_ip)))
                           
            if daemon.GetSignalDisplayType()== 0:
                if wireless_signal > 75:
                    tr.set_from_file("images/" + data_string + "high-signal" + lock + ".png")
                elif wireless_signal > 50:
                    tr.set_from_file("images/" + data_string + "good-signal" + lock + ".png")
                elif wireless_signal > 25:
                    tr.set_from_file("images/" + data_string + "low-signal" + lock + ".png")
                elif wireless_signal > 0:
                    tr.set_from_file("images/" + data_string + "bad-signal" + lock + ".png")
                elif wireless_signal == 0:
                    tr.set_from_file("images/no-signal.png")
                    auto_reconnect()
            else:
                if wireless_signal >= -60:
                    tr.set_from_file("images/" + data_string + "high-signal" + lock + ".png")
                elif wireless_signal >= -70:
                    tr.set_from_file("images/" + data_string + "good-signal" + lock + ".png")
                elif wireless_signal >= -80:
                    tr.set_from_file("images/" + data_string + "low-signal" + lock + ".png")
                else:
                    tr.set_from_file("images/bad-signal" + lock + ".png")

        elif wireless_ip is None and wired_ip is None:
            tr.set_from_file("images/no-signal.png")
            tr.set_tooltip(language['not_connected'])
            auto_reconnect()
        
        elif tr.current_icon_path.startswith(data_string) == False:
            print ":"+tr.current_icon_path
            print "|"+data_string+tr.current_icon_path[tr.current_icon_path.find('-')+1:]
            tr.set_from_file("images/"+data_string+tr.current_icon_path[tr.current_icon_path.find('-')+1:])

    if not daemon.GetDebugMode():
        config.EnableLogging()

    return True

def auto_reconnect():
    # Auto-reconnect code - not sure how well this works.  I know that
    # without the ForcedDisconnect check it reconnects you when a
    # disconnect is forced.  People who have disconnection problems need
    # to test it to determine if it actually works.
    #
    # First it will attempt to reconnect to the last known wireless network
    # and if that fails it should run a scan and try to connect to a wired
    # network or any wireless network set to autoconnect.

    global lastAutoReconnectTime

    # prevent the tray from going scan crazy when it doesn't have a network
    if time.time() - lastAutoReconnectTime < 30:
        return

    lastAutoReconnectTime = time.time()

    global triedReconnect

    if wireless.GetAutoReconnect() == True and \
        daemon.CheckIfConnecting() == False and \
        wireless.GetForcedDisconnect() == False:
        curNetID = wireless.GetCurrentNetworkID()
        if curNetID > -1:  # Needs to be a valid network to try to connect to
            if triedReconnect == False:
                print 'Trying to autoreconnect to last used network'
                wireless.ConnectWireless(curNetID)
                triedReconnect = True
            elif wireless.CheckIfWirelessConnecting() == False:
                print "Couldn't reconnect to last used network,\
                       scanning for an autoconnect network..."
                daemon.AutoConnect(True)
        else:
            daemon.AutoConnect(True)

class TrackerStatusIcon(gtk.StatusIcon):
    def __init__(self):
        gtk.StatusIcon.__init__(self)
        menu = '''
                <ui>
                <menubar name="Menubar">
                <menu action="Menu">
                <menuitem action="Connect"/>
                <separator/>
                <menuitem action="About"/>
                <menuitem action="Quit"/>
                </menu>
                </menubar>
                </ui>
        '''
        actions = [
                ('Menu',  None, 'Menu'),
                ('Connect', gtk.STOCK_CONNECT, '_Connect...', None,
                 'Connect to network', self.on_preferences),
                ('About', gtk.STOCK_ABOUT, '_About...', None,
                 'About wicd-tray-icon', self.on_about),
                ('Quit',gtk.STOCK_QUIT,'_Quit',None,'Quit wicd-tray-icon',
                 self.on_quit),
                ]
        ag = gtk.ActionGroup('Actions')
        ag.add_actions(actions)
        self.manager = gtk.UIManager()
        self.manager.insert_action_group(ag, 0)
        self.manager.add_ui_from_string(menu)
        self.menu = self.manager.get_widget('/Menubar/Menu/About').props.parent
        self.current_icon_path = ''
        self.set_from_file("images/no-signal.png")
        self.set_visible(True)
        self.connect('activate', self.on_activate)
        self.connect('popup-menu', self.on_popup_menu)
        self.set_from_file("images/no-signal.png")
        self.set_tooltip("Initializing wicd...")

        wireless.SetForcedDisconnect(False)

    def on_activate(self, data):
        open_wicd_gui()

    def on_quit(self,widget):
        sys.exit()

    def on_popup_menu(self, status, button, time):
        self.menu.popup(None, None, None, button, time)

    def on_preferences(self, data):
        open_wicd_gui()

    def on_about(self, data):
        dialog = gtk.AboutDialog()
        dialog.set_name('wicd tray icon')
        dialog.set_version('0.2')  # Might be time to move the version number up?
        dialog.set_comments('an icon that shows your network connectivity')
        dialog.set_website('http://wicd.sourceforge.net')
        dialog.run()
        dialog.destroy()

    def set_from_file(self,path):
        if path != self.current_icon_path:
            self.current_icon_path = path
        gtk.StatusIcon.set_from_file(self,path)

LastStrength = -2
stillWired = False
network = ''
triedReconnect = False
last_bytes_sent = -1
last_bytes_received = -1
max_leap_rec = 100000
max_leap_trans = 10000

global lastAutoReconnectTime
lastAutoReconnectTime = 0 

tr=TrackerStatusIcon()
gobject.timeout_add(3000,set_signal_image)
gtk.main()
