/*
 *  libghal
 *
 *  Copyright (c) 2007 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GHAL_PRIVATE_H__
#define __GHAL_PRIVATE_H__

#include "ghal-types.h"
#include "ghal-context.h"
#include "ghal-device.h"
#include "ghal-drive.h"
#include "ghal-volume.h"

#include <dbus/dbus-glib.h>
#include <libhal.h>
#include <libhal-storage.h>

G_BEGIN_DECLS

LibHalContext *_ghal_context_peek_libhal_context(GHalContext *context);
DBusGConnection *_ghal_context_peek_dbus_g_connection(GHalContext *context);
GHalDevice *_ghal_context_peek_device_cache(GHalContext *context,
                                            const gchar *udi);

void _ghal_device_set_context(GHalDevice *device,
                              GHalContext *context);
GHalContext *_ghal_device_peek_context(GHalDevice *device);
void _ghal_device_set_udi(GHalDevice *device,
                          const gchar *udi);

void _ghal_device_new_capability(GHalDevice *device,
                                 const gchar *capability);
void _ghal_device_lost_capability(GHalDevice *device,
                                  const gchar *capability);
void _ghal_device_property_changed(GHalDevice *device,
                                   const gchar *property,
                                   GhalPropertyChangeType change_type);
void _ghal_device_condition(GHalDevice *device,
                            const gchar *condition_name,
                            const gchar *condition_detail);

void _ghal_drive_volume_added(GHalDrive *drive,
                              GHalVolume *volume);
void _ghal_drive_volume_removed(GHalDrive *drive,
                                GHalVolume *volume);

LibHalDrive *_ghal_drive_peek_libhal_drive(GHalDrive *drive);

LibHalVolume *_ghal_volume_peek_libhal_volume(GHalVolume *volume);

G_END_DECLS

#endif  /* __GHAL_PRIVATE_H__ */
