/* 0.9.7.2 on Fri Jun 12 16:20:45 2009 */

#define PY_SSIZE_T_CLEAN
#include "Python.h"
#include "structmember.h"
#ifndef PY_LONG_LONG
  #define PY_LONG_LONG LONG_LONG
#endif
#if PY_VERSION_HEX < 0x02050000
  typedef int Py_ssize_t;
  #define PY_SSIZE_T_MAX INT_MAX
  #define PY_SSIZE_T_MIN INT_MIN
  #define PyInt_FromSsize_t(z) PyInt_FromLong(z)
  #define PyInt_AsSsize_t(o)	PyInt_AsLong(o)
#endif
#ifndef WIN32
  #ifndef __stdcall
    #define __stdcall
  #endif
  #ifndef __cdecl
    #define __cdecl
  #endif
#endif
#ifdef __cplusplus
#define __PYX_EXTERN_C extern "C"
#else
#define __PYX_EXTERN_C extern
#endif
#include <math.h>
#include "python-compat.h"
#include "_dirstate_helpers_c.h"
#include "stdlib.h"
#include "sys/stat.h"
#include "string.h"


typedef struct {PyObject **p; char *s;} __Pyx_InternTabEntry; /*proto*/
typedef struct {PyObject **p; char *s; long n;} __Pyx_StringTabEntry; /*proto*/

static PyObject *__pyx_m;
static PyObject *__pyx_b;
static int __pyx_lineno;
static char *__pyx_filename;
static char **__pyx_f;

static char __pyx_mdoc[] = "Helper functions for DirState.\n\nThis is the python implementation for DirState functions.\n";

static PyObject *__Pyx_Import(PyObject *name, PyObject *from_list); /*proto*/

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name); /*proto*/

static PyObject *__Pyx_GetItemInt(PyObject *o, Py_ssize_t i); /*proto*/

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb); /*proto*/

static int __Pyx_SetItemInt(PyObject *o, Py_ssize_t i, PyObject *v); /*proto*/

static PyObject *__Pyx_UnpackItem(PyObject *); /*proto*/
static int __Pyx_EndUnpack(PyObject *); /*proto*/

static int __Pyx_GetException(PyObject **type, PyObject **value, PyObject **tb); /*proto*/

static void __Pyx_WriteUnraisable(char *name); /*proto*/

static int __Pyx_InternStrings(__Pyx_InternTabEntry *t); /*proto*/

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t); /*proto*/

static int __Pyx_SetVtable(PyObject *dict, void *vtable); /*proto*/

static void __Pyx_AddTraceback(char *funcname); /*proto*/

/* Declarations from _dirstate_helpers_c */

struct __pyx_obj_19_dirstate_helpers_c_Reader {
  PyObject_HEAD
  struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *__pyx_vtab;
  PyObject *state;
  PyObject *text;
  char *text_cstr;
  int text_size;
  char *end_cstr;
  char *cur_cstr;
  char *next;
};

struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC {
  PyObject_HEAD
  struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *__pyx_vtab;
  PyObject *old_dirname_to_file_id;
  PyObject *new_dirname_to_file_id;
  PyObject *uninteresting;
  PyObject *last_source_parent;
  PyObject *last_target_parent;
  PyObject *include_unchanged;
  PyObject *use_filesystem_for_exec;
  PyObject *utf8_decode;
  PyObject *searched_specific_files;
  PyObject *search_specific_files;
  PyObject *state;
  PyObject *current_root;
  PyObject *current_root_unicode;
  PyObject *root_entries;
  int root_entries_pos;
  int root_entries_len;
  PyObject *root_abspath;
  int source_index;
  int target_index;
  int want_unversioned;
  PyObject *tree;
  PyObject *dir_iterator;
  int block_index;
  PyObject *current_block;
  int current_block_pos;
  PyObject *current_block_list;
  PyObject *current_dir_info;
  PyObject *current_dir_list;
  int path_index;
  PyObject *root_dir_info;
  PyObject *bisect_left;
  PyObject *pathjoin;
  PyObject *fstat;
  PyObject *sha_file;
};


struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader {
  char *(*get_next)(struct __pyx_obj_19_dirstate_helpers_c_Reader *,int *);
  PyObject *(*get_next_str)(struct __pyx_obj_19_dirstate_helpers_c_Reader *);
  int (*_init)(struct __pyx_obj_19_dirstate_helpers_c_Reader *);
  PyObject *(*_get_entry)(struct __pyx_obj_19_dirstate_helpers_c_Reader *,int,void **,int *);
};
static struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *__pyx_vtabptr_19_dirstate_helpers_c_Reader;


struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC {
  PyObject *(*_process_entry)(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *,PyObject *,PyObject *);
  void (*_update_current_block)(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *);
  PyObject *(*_iter_next)(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *);
  PyObject *(*_maybe_tree_ref)(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *,PyObject *);
  PyObject *(*_loop_one_block)(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *);
};
static struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *__pyx_vtabptr_19_dirstate_helpers_c_ProcessEntryC;

static PyTypeObject *__pyx_ptype_19_dirstate_helpers_c_Reader = 0;
static PyTypeObject *__pyx_ptype_19_dirstate_helpers_c_ProcessEntryC = 0;
static int __pyx_v_19_dirstate_helpers_c_ERROR_PATH_NOT_FOUND;
static int __pyx_v_19_dirstate_helpers_c_ERROR_DIRECTORY;
static PyObject *__pyx_v_19_dirstate_helpers_c__kind_absent;
static PyObject *__pyx_v_19_dirstate_helpers_c__kind_file;
static PyObject *__pyx_v_19_dirstate_helpers_c__kind_directory;
static PyObject *__pyx_v_19_dirstate_helpers_c__kind_symlink;
static PyObject *__pyx_v_19_dirstate_helpers_c__kind_relocated;
static PyObject *__pyx_v_19_dirstate_helpers_c__kind_tree_reference;
static PyObject *__pyx_k16;
static PyObject *__pyx_k17;
static PyObject *__pyx_k18;
static void *__pyx_f_19_dirstate_helpers_c__my_memrchr(void *,int,size_t); /*proto*/
static PyObject *__pyx_f_19_dirstate_helpers_c_safe_string_from_size(char *,Py_ssize_t); /*proto*/
static int __pyx_f_19_dirstate_helpers_c__is_aligned(void *); /*proto*/
static int __pyx_f_19_dirstate_helpers_c__cmp_by_dirs(char *,int,char *,int); /*proto*/
static int __pyx_f_19_dirstate_helpers_c__cmp_path_by_dirblock(char *,int,char *,int); /*proto*/
static int __pyx_f_19_dirstate_helpers_c_minikind_from_mode(int); /*proto*/
static PyObject *__pyx_f_19_dirstate_helpers_c__pack_stat(PyObject *); /*proto*/
static PyObject *__pyx_f_19_dirstate_helpers_c__update_entry(PyObject *,PyObject *,PyObject *,PyObject *); /*proto*/
static char __pyx_f_19_dirstate_helpers_c__minikind_from_string(PyObject *); /*proto*/
static PyObject *__pyx_f_19_dirstate_helpers_c__minikind_to_kind(char); /*proto*/
static int __pyx_f_19_dirstate_helpers_c__versioned_minikind(char); /*proto*/


/* Implementation of _dirstate_helpers_c */

static char __pyx_k11[] = "bzrlib.dirstate";
static char __pyx_k13[] = "bzrlib.osutils";
static char __pyx_k26[] = "tree-reference";

static PyObject *__pyx_n_binascii;
static PyObject *__pyx_n_bisect;
static PyObject *__pyx_n_errno;
static PyObject *__pyx_n_os;
static PyObject *__pyx_n_stat;
static PyObject *__pyx_n_sys;
static PyObject *__pyx_n_bzrlib;
static PyObject *__pyx_n_cache_utf8;
static PyObject *__pyx_n_errors;
static PyObject *__pyx_n_osutils;
static PyObject *__pyx_n_DirState;
static PyObject *__pyx_n_pathjoin;
static PyObject *__pyx_n_splitpath;
static PyObject *__pyx_n_b2a_base64;
static PyObject *__pyx_n__encode;
static PyObject *__pyx_n_struct;
static PyObject *__pyx_n_pack;
static PyObject *__pyx_n_absent;
static PyObject *__pyx_n_file;
static PyObject *__pyx_n_directory;
static PyObject *__pyx_n_symlink;
static PyObject *__pyx_n_relocated;

static PyObject *__pyx_k11p;
static PyObject *__pyx_k13p;
static PyObject *__pyx_k26p;

static void *__pyx_f_19_dirstate_helpers_c__my_memrchr(void *__pyx_v_s,int __pyx_v_c,size_t __pyx_v_n) {
  char *__pyx_v_pos;
  char *__pyx_v_start;
  void *__pyx_r;
  int __pyx_1;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":127 */
  __pyx_v_start = ((char *)__pyx_v_s);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":128 */
  __pyx_v_pos = ((__pyx_v_start + __pyx_v_n) - 1);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":129 */
  while (1) {
    __pyx_1 = (__pyx_v_pos >= __pyx_v_start);
    if (!__pyx_1) break;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":130 */
    __pyx_1 = ((__pyx_v_pos[0]) == __pyx_v_c);
    if (__pyx_1) {
      __pyx_r = ((void *)__pyx_v_pos);
      goto __pyx_L0;
      goto __pyx_L4;
    }
    __pyx_L4:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":132 */
    __pyx_v_pos = (__pyx_v_pos - 1);
  }

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":133 */
  __pyx_r = NULL;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_k27p;

static char __pyx_k27[] = "Must be a single character string, not %s";

static PyObject *__pyx_f_19_dirstate_helpers_c__py_memrchr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_19_dirstate_helpers_c__py_memrchr[] = "Just to expose _my_memrchr for testing.\n\n    :param s: The Python string to search\n    :param c: The character to search for\n    :return: The offset to the last instance of \'c\' in s\n    ";
static PyObject *__pyx_f_19_dirstate_helpers_c__py_memrchr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_s = 0;
  PyObject *__pyx_v_c = 0;
  void *__pyx_v__s;
  void *__pyx_v_found;
  int __pyx_v_length;
  char *__pyx_v__c;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  static char *__pyx_argnames[] = {"s","c",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_s, &__pyx_v_c)) return 0;
  Py_INCREF(__pyx_v_s);
  Py_INCREF(__pyx_v_c);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":148 */
  __pyx_v__s = PyString_AsString(__pyx_v_s);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":149 */
  __pyx_v_length = PyString_Size(__pyx_v_s);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":151 */
  __pyx_v__c = PyString_AsString(__pyx_v_c);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":152 */
  #ifndef PYREX_WITHOUT_ASSERTIONS
  if (!(PyString_Size(__pyx_v_c) == 1)) {
    __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; goto __pyx_L1;}
    Py_INCREF(__pyx_v_c);
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_c);
    __pyx_2 = PyNumber_Remainder(__pyx_k27p, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 153; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    PyErr_SetObject(PyExc_AssertionError, __pyx_2);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 152; goto __pyx_L1;}
  }
  #endif

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":154 */
  __pyx_v_found = __pyx_f_19_dirstate_helpers_c__my_memrchr(__pyx_v__s,(__pyx_v__c[0]),__pyx_v_length);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":155 */
  __pyx_3 = (__pyx_v_found == NULL);
  if (__pyx_3) {
    Py_INCREF(Py_None);
    __pyx_r = Py_None;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":157 */
  __pyx_1 = PyInt_FromLong((((char *)__pyx_v_found) - ((char *)__pyx_v__s))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 157; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("_dirstate_helpers_c._py_memrchr");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_s);
  Py_DECREF(__pyx_v_c);
  return __pyx_r;
}

static PyObject *__pyx_k28p;

static char __pyx_k28[] = "tried to create a string with an invalid size: %d @0x%x";

static PyObject *__pyx_f_19_dirstate_helpers_c_safe_string_from_size(char *__pyx_v_s,Py_ssize_t __pyx_v_size) {
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":160 */
  __pyx_1 = (__pyx_v_size < 0);
  if (__pyx_1) {
    __pyx_2 = PyInt_FromSsize_t(__pyx_v_size); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 164; goto __pyx_L1;}
    __pyx_3 = PyInt_FromLong(((int)__pyx_v_s)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 164; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 164; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_2);
    PyTuple_SET_ITEM(__pyx_4, 1, __pyx_3);
    __pyx_2 = 0;
    __pyx_3 = 0;
    __pyx_2 = PyNumber_Remainder(__pyx_k28p, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 164; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
    __pyx_2 = 0;
    __pyx_4 = PyObject_CallObject(PyExc_AssertionError, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":165 */
  __pyx_2 = PyString_FromStringAndSize(__pyx_v_s,__pyx_v_size); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 165; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("_dirstate_helpers_c.safe_string_from_size");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static int __pyx_f_19_dirstate_helpers_c__is_aligned(void *__pyx_v_ptr) {
  int __pyx_r;
  __pyx_r = ((((intptr_t)__pyx_v_ptr) & ((sizeof(int)) - 1)) == 0);
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static int __pyx_f_19_dirstate_helpers_c__cmp_by_dirs(char *__pyx_v_path1,int __pyx_v_size1,char *__pyx_v_path2,int __pyx_v_size2) {
  unsigned char *__pyx_v_cur1;
  unsigned char *__pyx_v_cur2;
  unsigned char *__pyx_v_end1;
  unsigned char *__pyx_v_end2;
  int *__pyx_v_cur_int1;
  int *__pyx_v_cur_int2;
  int *__pyx_v_end_int1;
  int *__pyx_v_end_int2;
  int __pyx_r;
  int __pyx_1;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":186 */
  __pyx_1 = (__pyx_v_path1 == __pyx_v_path2);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_size1 == __pyx_v_size2);
  }
  if (__pyx_1) {
    __pyx_r = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":189 */
  __pyx_v_end1 = (((unsigned char *)__pyx_v_path1) + __pyx_v_size1);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":190 */
  __pyx_v_end2 = (((unsigned char *)__pyx_v_path2) + __pyx_v_size2);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":197 */
  __pyx_1 = __pyx_f_19_dirstate_helpers_c__is_aligned(__pyx_v_path1);
  if (__pyx_1) {
    __pyx_1 = __pyx_f_19_dirstate_helpers_c__is_aligned(__pyx_v_path2);
  }
  if (__pyx_1) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":198 */
    __pyx_v_cur_int1 = ((int *)__pyx_v_path1);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":199 */
    __pyx_v_cur_int2 = ((int *)__pyx_v_path2);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":200 */
    __pyx_v_end_int1 = ((int *)((__pyx_v_path1 + __pyx_v_size1) - (__pyx_v_size1 % (sizeof(int)))));

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":201 */
    __pyx_v_end_int2 = ((int *)((__pyx_v_path2 + __pyx_v_size2) - (__pyx_v_size2 % (sizeof(int)))));

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":203 */
    while (1) {
      __pyx_1 = (__pyx_v_cur_int1 < __pyx_v_end_int1);
      if (__pyx_1) {
        __pyx_1 = (__pyx_v_cur_int2 < __pyx_v_end_int2);
      }
      if (!__pyx_1) break;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":204 */
      __pyx_1 = ((__pyx_v_cur_int1[0]) != (__pyx_v_cur_int2[0]));
      if (__pyx_1) {
        goto __pyx_L5;
        goto __pyx_L6;
      }
      __pyx_L6:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":206 */
      __pyx_v_cur_int1 = (__pyx_v_cur_int1 + 1);

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":207 */
      __pyx_v_cur_int2 = (__pyx_v_cur_int2 + 1);
    }
    __pyx_L5:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":209 */
    __pyx_v_cur1 = ((unsigned char *)__pyx_v_cur_int1);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":210 */
    __pyx_v_cur2 = ((unsigned char *)__pyx_v_cur_int2);
    goto __pyx_L3;
  }
  /*else*/ {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":212 */
    __pyx_v_cur1 = ((unsigned char *)__pyx_v_path1);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":213 */
    __pyx_v_cur2 = ((unsigned char *)__pyx_v_path2);
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":215 */
  while (1) {
    __pyx_1 = (__pyx_v_cur1 < __pyx_v_end1);
    if (__pyx_1) {
      __pyx_1 = (__pyx_v_cur2 < __pyx_v_end2);
    }
    if (!__pyx_1) break;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":216 */
    __pyx_1 = ((__pyx_v_cur1[0]) == (__pyx_v_cur2[0]));
    if (__pyx_1) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":218 */
      __pyx_v_cur1 = (__pyx_v_cur1 + 1);

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":219 */
      __pyx_v_cur2 = (__pyx_v_cur2 + 1);

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":220 */
      goto __pyx_L7;
      goto __pyx_L9;
    }
    __pyx_L9:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":222 */
    __pyx_1 = ((__pyx_v_cur1[0]) == '/');
    if (__pyx_1) {
      __pyx_r = (-1);
      goto __pyx_L0;
      goto __pyx_L10;
    }
    __pyx_1 = ((__pyx_v_cur2[0]) == '/');
    if (__pyx_1) {
      __pyx_r = 1;
      goto __pyx_L0;
      goto __pyx_L10;
    }
    __pyx_1 = ((__pyx_v_cur1[0]) < (__pyx_v_cur2[0]));
    if (__pyx_1) {
      __pyx_r = (-1);
      goto __pyx_L0;
      goto __pyx_L10;
    }
    /*else*/ {
      __pyx_r = 1;
      goto __pyx_L0;
    }
    __pyx_L10:;
    __pyx_L7:;
  }

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":232 */
  __pyx_1 = (__pyx_v_cur1 < __pyx_v_end1);
  if (__pyx_1) {
    __pyx_r = 1;
    goto __pyx_L0;
    goto __pyx_L11;
  }
  __pyx_L11:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":234 */
  __pyx_1 = (__pyx_v_cur2 < __pyx_v_end2);
  if (__pyx_1) {
    __pyx_r = (-1);
    goto __pyx_L0;
    goto __pyx_L12;
  }
  __pyx_L12:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":237 */
  __pyx_r = 0;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_k29p;
static PyObject *__pyx_k30p;

static char __pyx_k29[] = "'path1' must be a plain string, not %s: %r";
static char __pyx_k30[] = "'path2' must be a plain string, not %s: %r";

static PyObject *__pyx_f_19_dirstate_helpers_c_cmp_by_dirs_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_19_dirstate_helpers_c_cmp_by_dirs_c[] = "Compare two paths directory by directory.\n\n    This is equivalent to doing::\n\n       cmp(path1.split(\'/\'), path2.split(\'/\'))\n\n    The idea is that you should compare path components separately. This\n    differs from plain ``cmp(path1, path2)`` for paths like ``\'a-b\'`` and\n    ``a/b``. \"a-b\" comes after \"a\" but would come before \"a/b\" lexically.\n\n    :param path1: first path\n    :param path2: second path\n    :return: negative number if ``path1`` comes first,\n        0 if paths are equal,\n        and positive number if ``path2`` sorts first\n    ";
static PyObject *__pyx_f_19_dirstate_helpers_c_cmp_by_dirs_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_path1 = 0;
  PyObject *__pyx_v_path2 = 0;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"path1","path2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_path1, &__pyx_v_path2)) return 0;
  Py_INCREF(__pyx_v_path1);
  Py_INCREF(__pyx_v_path2);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":257 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path1));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path1);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path1);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path1);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path1);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k29p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 258; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 258; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 258; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":260 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path2));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 262; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path2);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path2);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 262; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 262; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path2);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path2);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k30p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 262; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 261; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 261; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 261; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":263 */
  __pyx_2 = PyInt_FromLong(__pyx_f_19_dirstate_helpers_c__cmp_by_dirs(PyString_AsString(__pyx_v_path1),PyString_Size(__pyx_v_path1),PyString_AsString(__pyx_v_path2),PyString_Size(__pyx_v_path2))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 263; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_c.cmp_by_dirs_c");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_path1);
  Py_DECREF(__pyx_v_path2);
  return __pyx_r;
}

static PyObject *__pyx_k31p;
static PyObject *__pyx_k32p;

static char __pyx_k31[] = "'path1' must be a plain string, not %s: %r";
static char __pyx_k32[] = "'path2' must be a plain string, not %s: %r";

static PyObject *__pyx_f_19_dirstate_helpers_c__cmp_path_by_dirblock_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_19_dirstate_helpers_c__cmp_path_by_dirblock_c[] = "Compare two paths based on what directory they are in.\n\n    This generates a sort order, such that all children of a directory are\n    sorted together, and grandchildren are in the same order as the\n    children appear. But all grandchildren come after all children.\n\n    In other words, all entries in a directory are sorted together, and\n    directorys are sorted in cmp_by_dirs order.\n\n    :param path1: first path\n    :param path2: the second path\n    :return: negative number if ``path1`` comes first,\n        0 if paths are equal\n        and a positive number if ``path2`` sorts first\n    ";
static PyObject *__pyx_f_19_dirstate_helpers_c__cmp_path_by_dirblock_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_path1 = 0;
  PyObject *__pyx_v_path2 = 0;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"path1","path2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_path1, &__pyx_v_path2)) return 0;
  Py_INCREF(__pyx_v_path1);
  Py_INCREF(__pyx_v_path2);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":285 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path1));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 287; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path1);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path1);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 287; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 287; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path1);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path1);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k31p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 287; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 286; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 286; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 286; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":288 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path2));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 290; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path2);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path2);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 290; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 290; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path2);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path2);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k32p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 290; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 289; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 289; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 289; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":291 */
  __pyx_2 = PyInt_FromLong(__pyx_f_19_dirstate_helpers_c__cmp_path_by_dirblock(PyString_AsString(__pyx_v_path1),PyString_Size(__pyx_v_path1),PyString_AsString(__pyx_v_path2),PyString_Size(__pyx_v_path2))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 291; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_c._cmp_path_by_dirblock_c");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_path1);
  Py_DECREF(__pyx_v_path2);
  return __pyx_r;
}

static char __pyx_k33[] = "";
static char __pyx_k34[] = "";

static int __pyx_f_19_dirstate_helpers_c__cmp_path_by_dirblock(char *__pyx_v_path1,int __pyx_v_path1_len,char *__pyx_v_path2,int __pyx_v_path2_len) {
  char *__pyx_v_dirname1;
  int __pyx_v_dirname1_len;
  char *__pyx_v_dirname2;
  int __pyx_v_dirname2_len;
  char *__pyx_v_basename1;
  int __pyx_v_basename1_len;
  char *__pyx_v_basename2;
  int __pyx_v_basename2_len;
  int __pyx_v_cur_len;
  int __pyx_v_cmp_val;
  int __pyx_r;
  int __pyx_1;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":314 */
  __pyx_1 = (__pyx_v_path1_len == 0);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_path2_len == 0);
  }
  if (__pyx_1) {
    __pyx_r = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":317 */
  __pyx_1 = (__pyx_v_path1 == __pyx_v_path2);
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_path1_len == __pyx_v_path2_len);
  }
  if (__pyx_1) {
    __pyx_r = 0;
    goto __pyx_L0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":320 */
  __pyx_1 = (__pyx_v_path1_len == 0);
  if (__pyx_1) {
    __pyx_r = (-1);
    goto __pyx_L0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":323 */
  __pyx_1 = (__pyx_v_path2_len == 0);
  if (__pyx_1) {
    __pyx_r = 1;
    goto __pyx_L0;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":326 */
  __pyx_v_basename1 = ((char *)__pyx_f_19_dirstate_helpers_c__my_memrchr(__pyx_v_path1,'/',__pyx_v_path1_len));

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":328 */
  __pyx_1 = (__pyx_v_basename1 == NULL);
  if (__pyx_1) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":329 */
    __pyx_v_basename1 = __pyx_v_path1;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":330 */
    __pyx_v_basename1_len = __pyx_v_path1_len;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":331 */
    __pyx_v_dirname1 = __pyx_k33;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":332 */
    __pyx_v_dirname1_len = 0;
    goto __pyx_L6;
  }
  /*else*/ {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":334 */
    __pyx_v_dirname1 = __pyx_v_path1;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":335 */
    __pyx_v_dirname1_len = (__pyx_v_basename1 - __pyx_v_path1);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":336 */
    __pyx_v_basename1 = (__pyx_v_basename1 + 1);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":337 */
    __pyx_v_basename1_len = ((__pyx_v_path1_len - __pyx_v_dirname1_len) - 1);
  }
  __pyx_L6:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":339 */
  __pyx_v_basename2 = ((char *)__pyx_f_19_dirstate_helpers_c__my_memrchr(__pyx_v_path2,'/',__pyx_v_path2_len));

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":341 */
  __pyx_1 = (__pyx_v_basename2 == NULL);
  if (__pyx_1) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":342 */
    __pyx_v_basename2 = __pyx_v_path2;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":343 */
    __pyx_v_basename2_len = __pyx_v_path2_len;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":344 */
    __pyx_v_dirname2 = __pyx_k34;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":345 */
    __pyx_v_dirname2_len = 0;
    goto __pyx_L7;
  }
  /*else*/ {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":347 */
    __pyx_v_dirname2 = __pyx_v_path2;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":348 */
    __pyx_v_dirname2_len = (__pyx_v_basename2 - __pyx_v_path2);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":349 */
    __pyx_v_basename2 = (__pyx_v_basename2 + 1);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":350 */
    __pyx_v_basename2_len = ((__pyx_v_path2_len - __pyx_v_dirname2_len) - 1);
  }
  __pyx_L7:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":352 */
  __pyx_v_cmp_val = __pyx_f_19_dirstate_helpers_c__cmp_by_dirs(__pyx_v_dirname1,__pyx_v_dirname1_len,__pyx_v_dirname2,__pyx_v_dirname2_len);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":354 */
  __pyx_1 = (__pyx_v_cmp_val != 0);
  if (__pyx_1) {
    __pyx_r = __pyx_v_cmp_val;
    goto __pyx_L0;
    goto __pyx_L8;
  }
  __pyx_L8:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":357 */
  __pyx_v_cur_len = __pyx_v_basename1_len;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":358 */
  __pyx_1 = (__pyx_v_basename2_len < __pyx_v_basename1_len);
  if (__pyx_1) {
    __pyx_v_cur_len = __pyx_v_basename2_len;
    goto __pyx_L9;
  }
  __pyx_L9:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":361 */
  __pyx_v_cmp_val = memcmp(__pyx_v_basename1,__pyx_v_basename2,__pyx_v_cur_len);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":362 */
  __pyx_1 = (__pyx_v_cmp_val != 0);
  if (__pyx_1) {
    __pyx_r = __pyx_v_cmp_val;
    goto __pyx_L0;
    goto __pyx_L10;
  }
  __pyx_L10:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":364 */
  __pyx_1 = (__pyx_v_basename1_len == __pyx_v_basename2_len);
  if (__pyx_1) {
    __pyx_r = 0;
    goto __pyx_L0;
    goto __pyx_L11;
  }
  __pyx_L11:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":366 */
  __pyx_1 = (__pyx_v_basename1_len < __pyx_v_basename2_len);
  if (__pyx_1) {
    __pyx_r = (-1);
    goto __pyx_L0;
    goto __pyx_L12;
  }
  __pyx_L12:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":368 */
  __pyx_r = 1;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_k35p;
static PyObject *__pyx_k36p;

static char __pyx_k35[] = "you must pass a python list for 'paths' not: %s %r";
static char __pyx_k36[] = "you must pass a string for 'path' not: %s %r";

static PyObject *__pyx_f_19_dirstate_helpers_c__bisect_path_left_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_19_dirstate_helpers_c__bisect_path_left_c[] = "Return the index where to insert path into paths.\n\n    This uses a path-wise comparison so we get::\n        a\n        a-b\n        a=b\n        a/b\n    Rather than::\n        a\n        a-b\n        a/b\n        a=b\n    :param paths: A list of paths to search through\n    :param path: A single path to insert\n    :return: An offset where \'path\' can be inserted.\n    :seealso: bisect.bisect_left\n    ";
static PyObject *__pyx_f_19_dirstate_helpers_c__bisect_path_left_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_paths = 0;
  PyObject *__pyx_v_path = 0;
  int __pyx_v__lo;
  int __pyx_v__hi;
  int __pyx_v__mid;
  char *__pyx_v_path_cstr;
  int __pyx_v_path_size;
  char *__pyx_v_cur_cstr;
  int __pyx_v_cur_size;
  void *__pyx_v_cur;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_ssize_t __pyx_4;
  static char *__pyx_argnames[] = {"paths","path",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_paths, &__pyx_v_path)) return 0;
  Py_INCREF(__pyx_v_paths);
  Py_INCREF(__pyx_v_path);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":398 */
  __pyx_1 = (!PyList_CheckExact(__pyx_v_paths));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; goto __pyx_L1;}
    Py_INCREF(__pyx_v_paths);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_paths);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_paths);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_paths);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k35p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 399; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 399; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 399; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":401 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k36p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 403; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 402; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 402; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 402; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":405 */
  __pyx_4 = PyObject_Length(__pyx_v_paths); if (__pyx_4 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 405; goto __pyx_L1;}
  __pyx_v__hi = __pyx_4;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":406 */
  __pyx_v__lo = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":408 */
  __pyx_v_path_cstr = PyString_AsString(__pyx_v_path);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":409 */
  __pyx_v_path_size = PyString_Size(__pyx_v_path);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":411 */
  while (1) {
    __pyx_1 = (__pyx_v__lo < __pyx_v__hi);
    if (!__pyx_1) break;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":412 */
    __pyx_v__mid = ((__pyx_v__lo + __pyx_v__hi) / 2);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":413 */
    __pyx_v_cur = PyList_GET_ITEM(__pyx_v_paths,__pyx_v__mid);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":414 */
    __pyx_v_cur_cstr = PyString_AS_STRING(__pyx_v_cur);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":415 */
    __pyx_v_cur_size = PyString_GET_SIZE(__pyx_v_cur);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":416 */
    __pyx_1 = (__pyx_f_19_dirstate_helpers_c__cmp_path_by_dirblock(__pyx_v_cur_cstr,__pyx_v_cur_size,__pyx_v_path_cstr,__pyx_v_path_size) < 0);
    if (__pyx_1) {
      __pyx_v__lo = (__pyx_v__mid + 1);
      goto __pyx_L6;
    }
    /*else*/ {
      __pyx_v__hi = __pyx_v__mid;
    }
    __pyx_L6:;
  }

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":420 */
  __pyx_2 = PyInt_FromLong(__pyx_v__lo); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 420; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_c._bisect_path_left_c");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_paths);
  Py_DECREF(__pyx_v_path);
  return __pyx_r;
}

static PyObject *__pyx_k37p;
static PyObject *__pyx_k38p;

static char __pyx_k37[] = "you must pass a python list for 'paths' not: %s %r";
static char __pyx_k38[] = "you must pass a string for 'path' not: %s %r";

static PyObject *__pyx_f_19_dirstate_helpers_c__bisect_path_right_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_19_dirstate_helpers_c__bisect_path_right_c[] = "Return the index where to insert path into paths.\n\n    This uses a path-wise comparison so we get::\n        a\n        a-b\n        a=b\n        a/b\n    Rather than::\n        a\n        a-b\n        a/b\n        a=b\n    :param paths: A list of paths to search through\n    :param path: A single path to insert\n    :return: An offset where \'path\' can be inserted.\n    :seealso: bisect.bisect_right\n    ";
static PyObject *__pyx_f_19_dirstate_helpers_c__bisect_path_right_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_paths = 0;
  PyObject *__pyx_v_path = 0;
  int __pyx_v__lo;
  int __pyx_v__hi;
  int __pyx_v__mid;
  char *__pyx_v_path_cstr;
  int __pyx_v_path_size;
  char *__pyx_v_cur_cstr;
  int __pyx_v_cur_size;
  void *__pyx_v_cur;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_ssize_t __pyx_4;
  static char *__pyx_argnames[] = {"paths","path",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_paths, &__pyx_v_path)) return 0;
  Py_INCREF(__pyx_v_paths);
  Py_INCREF(__pyx_v_path);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":450 */
  __pyx_1 = (!PyList_CheckExact(__pyx_v_paths));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 452; goto __pyx_L1;}
    Py_INCREF(__pyx_v_paths);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_paths);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 452; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 452; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_paths);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_paths);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k37p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 452; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 451; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 451; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 451; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":453 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_path));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 455; goto __pyx_L1;}
    Py_INCREF(__pyx_v_path);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_path);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 455; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 455; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_path);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_path);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k38p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 455; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 454; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 454; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 454; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":457 */
  __pyx_4 = PyObject_Length(__pyx_v_paths); if (__pyx_4 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 457; goto __pyx_L1;}
  __pyx_v__hi = __pyx_4;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":458 */
  __pyx_v__lo = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":460 */
  __pyx_v_path_cstr = PyString_AsString(__pyx_v_path);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":461 */
  __pyx_v_path_size = PyString_Size(__pyx_v_path);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":463 */
  while (1) {
    __pyx_1 = (__pyx_v__lo < __pyx_v__hi);
    if (!__pyx_1) break;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":464 */
    __pyx_v__mid = ((__pyx_v__lo + __pyx_v__hi) / 2);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":465 */
    __pyx_v_cur = PyList_GET_ITEM(__pyx_v_paths,__pyx_v__mid);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":466 */
    __pyx_v_cur_cstr = PyString_AS_STRING(__pyx_v_cur);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":467 */
    __pyx_v_cur_size = PyString_GET_SIZE(__pyx_v_cur);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":468 */
    __pyx_1 = (__pyx_f_19_dirstate_helpers_c__cmp_path_by_dirblock(__pyx_v_path_cstr,__pyx_v_path_size,__pyx_v_cur_cstr,__pyx_v_cur_size) < 0);
    if (__pyx_1) {
      __pyx_v__hi = __pyx_v__mid;
      goto __pyx_L6;
    }
    /*else*/ {
      __pyx_v__lo = (__pyx_v__mid + 1);
    }
    __pyx_L6:;
  }

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":472 */
  __pyx_2 = PyInt_FromLong(__pyx_v__lo); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 472; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_c._bisect_path_right_c");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_paths);
  Py_DECREF(__pyx_v_path);
  return __pyx_r;
}

static PyObject *__pyx_k39p;
static PyObject *__pyx_k40p;

static char __pyx_k39[] = "you must pass a python list for 'dirblocks' not: %s %r";
static char __pyx_k40[] = "you must pass a string for dirname not: %s %r";

static PyObject *__pyx_f_19_dirstate_helpers_c_bisect_dirblock_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_19_dirstate_helpers_c_bisect_dirblock_c[] = "Return the index where to insert dirname into the dirblocks.\n\n    The return value idx is such that all directories blocks in dirblock[:idx]\n    have names < dirname, and all blocks in dirblock[idx:] have names >=\n    dirname.\n\n    Optional args lo (default 0) and hi (default len(dirblocks)) bound the\n    slice of a to be searched.\n    ";
static PyObject *__pyx_f_19_dirstate_helpers_c_bisect_dirblock_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_dirblocks = 0;
  PyObject *__pyx_v_dirname = 0;
  PyObject *__pyx_v_lo = 0;
  PyObject *__pyx_v_hi = 0;
  PyObject *__pyx_v_cache = 0;
  int __pyx_v__lo;
  int __pyx_v__hi;
  int __pyx_v__mid;
  char *__pyx_v_dirname_cstr;
  int __pyx_v_dirname_size;
  char *__pyx_v_cur_cstr;
  int __pyx_v_cur_size;
  void *__pyx_v_cur;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_ssize_t __pyx_4;
  static char *__pyx_argnames[] = {"dirblocks","dirname","lo","hi","cache",0};
  __pyx_v_lo = __pyx_k16;
  __pyx_v_hi = __pyx_k17;
  __pyx_v_cache = __pyx_k18;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO|OOO", __pyx_argnames, &__pyx_v_dirblocks, &__pyx_v_dirname, &__pyx_v_lo, &__pyx_v_hi, &__pyx_v_cache)) return 0;
  Py_INCREF(__pyx_v_dirblocks);
  Py_INCREF(__pyx_v_dirname);
  Py_INCREF(__pyx_v_lo);
  Py_INCREF(__pyx_v_hi);
  Py_INCREF(__pyx_v_cache);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":494 */
  __pyx_1 = (!PyList_CheckExact(__pyx_v_dirblocks));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 496; goto __pyx_L1;}
    Py_INCREF(__pyx_v_dirblocks);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_dirblocks);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 496; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 496; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_dirblocks);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_dirblocks);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k39p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 496; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 495; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 495; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 495; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":497 */
  __pyx_1 = (!PyString_CheckExact(__pyx_v_dirname));
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 499; goto __pyx_L1;}
    Py_INCREF(__pyx_v_dirname);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_dirname);
    __pyx_3 = PyObject_CallObject(((PyObject *)(&PyType_Type)), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 499; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 499; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    Py_INCREF(__pyx_v_dirname);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_dirname);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k40p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 499; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_TypeError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":500 */
  __pyx_1 = __pyx_v_hi == Py_None;
  if (__pyx_1) {
    __pyx_4 = PyObject_Length(__pyx_v_dirblocks); if (__pyx_4 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 501; goto __pyx_L1;}
    __pyx_v__hi = __pyx_4;
    goto __pyx_L4;
  }
  /*else*/ {
    __pyx_1 = PyInt_AsLong(__pyx_v_hi); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 503; goto __pyx_L1;}
    __pyx_v__hi = __pyx_1;
  }
  __pyx_L4:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":505 */
  __pyx_1 = PyInt_AsLong(__pyx_v_lo); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 505; goto __pyx_L1;}
  __pyx_v__lo = __pyx_1;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":506 */
  __pyx_v_dirname_cstr = PyString_AsString(__pyx_v_dirname);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":507 */
  __pyx_v_dirname_size = PyString_Size(__pyx_v_dirname);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":509 */
  while (1) {
    __pyx_1 = (__pyx_v__lo < __pyx_v__hi);
    if (!__pyx_1) break;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":510 */
    __pyx_v__mid = ((__pyx_v__lo + __pyx_v__hi) / 2);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":513 */
    __pyx_v_cur = PyTuple_GET_ITEM(PyList_GET_ITEM(__pyx_v_dirblocks,__pyx_v__mid),0);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":515 */
    __pyx_v_cur_cstr = PyString_AS_STRING(__pyx_v_cur);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":516 */
    __pyx_v_cur_size = PyString_GET_SIZE(__pyx_v_cur);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":517 */
    __pyx_1 = (__pyx_f_19_dirstate_helpers_c__cmp_by_dirs(__pyx_v_cur_cstr,__pyx_v_cur_size,__pyx_v_dirname_cstr,__pyx_v_dirname_size) < 0);
    if (__pyx_1) {
      __pyx_v__lo = (__pyx_v__mid + 1);
      goto __pyx_L7;
    }
    /*else*/ {
      __pyx_v__hi = __pyx_v__mid;
    }
    __pyx_L7:;
  }

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":521 */
  __pyx_2 = PyInt_FromLong(__pyx_v__lo); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 521; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_c.bisect_dirblock_c");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_dirblocks);
  Py_DECREF(__pyx_v_dirname);
  Py_DECREF(__pyx_v_lo);
  Py_DECREF(__pyx_v_hi);
  Py_DECREF(__pyx_v_cache);
  return __pyx_r;
}

static int __pyx_f_19_dirstate_helpers_c_6Reader___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_19_dirstate_helpers_c_6Reader___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_text = 0;
  PyObject *__pyx_v_state = 0;
  int __pyx_r;
  static char *__pyx_argnames[] = {"text","state",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_text, &__pyx_v_state)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_text);
  Py_INCREF(__pyx_v_state);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":537 */
  Py_INCREF(__pyx_v_state);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->state);
  ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->state = __pyx_v_state;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":538 */
  Py_INCREF(__pyx_v_text);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->text);
  ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->text = __pyx_v_text;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":539 */
  ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->text_cstr = PyString_AsString(__pyx_v_text);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":540 */
  ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->text_size = PyString_Size(__pyx_v_text);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":541 */
  ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->end_cstr = (((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->text_cstr + ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->text_size);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":542 */
  ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->cur_cstr = ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->text_cstr;

  __pyx_r = 0;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_text);
  Py_DECREF(__pyx_v_state);
  return __pyx_r;
}

static PyObject *__pyx_n_DirstateCorrupt;

static PyObject *__pyx_k41p;
static PyObject *__pyx_k42p;
static PyObject *__pyx_k43p;

static char __pyx_k41[] = "get_next() called when cur_str is NULL";
static char __pyx_k42[] = "get_next() called when there are no chars left";
static char __pyx_k43[] = "failed to find trailing NULL (\\0). Trailing garbage: %r";

static char *__pyx_f_19_dirstate_helpers_c_6Reader_get_next(struct __pyx_obj_19_dirstate_helpers_c_Reader *__pyx_v_self,int *__pyx_v_size) {
  char *__pyx_v_next;
  Py_ssize_t __pyx_v_extra_len;
  char *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":549 */
  __pyx_1 = (__pyx_v_self->cur_cstr == NULL);
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 550; goto __pyx_L1;}
    Py_INCREF(__pyx_k41p);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k41p);
    __pyx_3 = PyObject_CallObject(PyExc_AssertionError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 550; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 550; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_self->cur_cstr >= __pyx_v_self->end_cstr);
  if (__pyx_1) {
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 552; goto __pyx_L1;}
    Py_INCREF(__pyx_k42p);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k42p);
    __pyx_3 = PyObject_CallObject(PyExc_AssertionError, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 552; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 552; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":554 */
  __pyx_v_next = __pyx_v_self->cur_cstr;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":555 */
  __pyx_v_self->cur_cstr = ((char *)memchr(__pyx_v_next,'\0',(__pyx_v_self->end_cstr - __pyx_v_next)));

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":556 */
  __pyx_1 = (__pyx_v_self->cur_cstr == NULL);
  if (__pyx_1) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":557 */
    __pyx_v_extra_len = (__pyx_v_self->end_cstr - __pyx_v_next);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":558 */
    __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
    __pyx_3 = PyObject_GetAttr(__pyx_2, __pyx_n_DirstateCorrupt); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = __pyx_f_19_dirstate_helpers_c_safe_string_from_size(__pyx_v_next,__pyx_v_extra_len); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; goto __pyx_L1;}
    __pyx_4 = PyNumber_Remainder(__pyx_k43p, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->state);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self->state);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_4);
    __pyx_4 = 0;
    __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":562 */
  (__pyx_v_size[0]) = (__pyx_v_self->cur_cstr - __pyx_v_next);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":563 */
  __pyx_v_self->cur_cstr = (__pyx_v_self->cur_cstr + 1);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":564 */
  __pyx_r = __pyx_v_next;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("_dirstate_helpers_c.Reader.get_next");
  __pyx_r = NULL;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_f_19_dirstate_helpers_c_6Reader_get_next_str(struct __pyx_obj_19_dirstate_helpers_c_Reader *__pyx_v_self) {
  int __pyx_v_size;
  char *__pyx_v_next;
  PyObject *__pyx_r;
  char *__pyx_1;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":570 */
  __pyx_1 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 570; goto __pyx_L1;}
  __pyx_v_next = __pyx_1;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":571 */
  __pyx_2 = __pyx_f_19_dirstate_helpers_c_safe_string_from_size(__pyx_v_next,__pyx_v_size); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 571; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("_dirstate_helpers_c.Reader.get_next_str");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_k44p;

static char __pyx_k44[] = "First character should be null not: %s";

static int __pyx_f_19_dirstate_helpers_c_6Reader__init(struct __pyx_obj_19_dirstate_helpers_c_Reader *__pyx_v_self) {
  char *__pyx_v_first;
  int __pyx_v_size;
  int __pyx_r;
  char *__pyx_1;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":584 */
  __pyx_1 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 584; goto __pyx_L1;}
  __pyx_v_first = __pyx_1;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":585 */
  __pyx_2 = ((__pyx_v_first[0]) != '\0');
  if (__pyx_2) {
    __pyx_2 = (__pyx_v_size == 0);
  }
  if (__pyx_2) {
    __pyx_3 = PyString_FromString(__pyx_v_first); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 587; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 587; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k44p, __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 587; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 586; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_AssertionError, __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 586; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 586; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":588 */
  __pyx_r = 0;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("_dirstate_helpers_c.Reader._init");
  __pyx_r = (-1);
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_k45p;

static char __pyx_k45[] = "Bad parse, we expected to end on \\n, not: %d %s: %s";

static PyObject *__pyx_f_19_dirstate_helpers_c_6Reader__get_entry(struct __pyx_obj_19_dirstate_helpers_c_Reader *__pyx_v_self,int __pyx_v_num_trees,void **__pyx_v_p_current_dirname,int *__pyx_v_new_block) {
  PyObject *__pyx_v_path_name_file_id_key;
  char *__pyx_v_entry_size_cstr;
  unsigned long __pyx_v_entry_size;
  char *__pyx_v_executable_cstr;
  int __pyx_v_is_executable;
  char *__pyx_v_dirname_cstr;
  char *__pyx_v_trailing;
  int __pyx_v_cur_size;
  int __pyx_v_i;
  PyObject *__pyx_v_minikind;
  PyObject *__pyx_v_fingerprint;
  PyObject *__pyx_v_info;
  PyObject *__pyx_v_dirname;
  PyObject *__pyx_v_trees;
  PyObject *__pyx_v_ret;
  PyObject *__pyx_r;
  char *__pyx_1;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_path_name_file_id_key = Py_None; Py_INCREF(Py_None);
  __pyx_v_minikind = Py_None; Py_INCREF(Py_None);
  __pyx_v_fingerprint = Py_None; Py_INCREF(Py_None);
  __pyx_v_info = Py_None; Py_INCREF(Py_None);
  __pyx_v_dirname = Py_None; Py_INCREF(Py_None);
  __pyx_v_trees = Py_None; Py_INCREF(Py_None);
  __pyx_v_ret = Py_None; Py_INCREF(Py_None);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":625 */
  __pyx_1 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_cur_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 625; goto __pyx_L1;}
  __pyx_v_dirname_cstr = __pyx_1;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":633 */
  __pyx_2 = (__pyx_v_cur_size != PyString_GET_SIZE((__pyx_v_p_current_dirname[0])));
  if (!__pyx_2) {
    __pyx_2 = (strncmp(__pyx_v_dirname_cstr,PyString_AS_STRING((__pyx_v_p_current_dirname[0])),(__pyx_v_cur_size + 1)) != 0);
  }
  if (__pyx_2) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":642 */
    __pyx_3 = __pyx_f_19_dirstate_helpers_c_safe_string_from_size(__pyx_v_dirname_cstr,__pyx_v_cur_size); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 642; goto __pyx_L1;}
    Py_DECREF(__pyx_v_dirname);
    __pyx_v_dirname = __pyx_3;
    __pyx_3 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":643 */
    (__pyx_v_p_current_dirname[0]) = ((void *)__pyx_v_dirname);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":644 */
    (__pyx_v_new_block[0]) = 1;
    goto __pyx_L2;
  }
  /*else*/ {
    (__pyx_v_new_block[0]) = 0;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":651 */
  __pyx_3 = (PyObject *)(__pyx_v_p_current_dirname[0]);
  Py_INCREF(__pyx_3);
  __pyx_4 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next_str(__pyx_v_self); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 652; goto __pyx_L1;}
  __pyx_5 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next_str(__pyx_v_self); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 653; goto __pyx_L1;}
  __pyx_6 = PyTuple_New(3); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 651; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_6, 0, __pyx_3);
  PyTuple_SET_ITEM(__pyx_6, 1, __pyx_4);
  PyTuple_SET_ITEM(__pyx_6, 2, __pyx_5);
  __pyx_3 = 0;
  __pyx_4 = 0;
  __pyx_5 = 0;
  Py_DECREF(__pyx_v_path_name_file_id_key);
  __pyx_v_path_name_file_id_key = __pyx_6;
  __pyx_6 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":669 */
  __pyx_3 = PyList_New(0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 669; goto __pyx_L1;}
  Py_DECREF(__pyx_v_trees);
  __pyx_v_trees = __pyx_3;
  __pyx_3 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":670 */
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_num_trees; ++__pyx_v_i) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":671 */
    __pyx_4 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next_str(__pyx_v_self); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 671; goto __pyx_L1;}
    Py_DECREF(__pyx_v_minikind);
    __pyx_v_minikind = __pyx_4;
    __pyx_4 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":672 */
    __pyx_5 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next_str(__pyx_v_self); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 672; goto __pyx_L1;}
    Py_DECREF(__pyx_v_fingerprint);
    __pyx_v_fingerprint = __pyx_5;
    __pyx_5 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":673 */
    __pyx_1 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_cur_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 673; goto __pyx_L1;}
    __pyx_v_entry_size_cstr = __pyx_1;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":674 */
    __pyx_v_entry_size = strtoul(__pyx_v_entry_size_cstr,NULL,10);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":675 */
    __pyx_1 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_cur_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 675; goto __pyx_L1;}
    __pyx_v_executable_cstr = __pyx_1;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":676 */
    __pyx_v_is_executable = ((__pyx_v_executable_cstr[0]) == 'y');

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":677 */
    __pyx_6 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next_str(__pyx_v_self); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 677; goto __pyx_L1;}
    Py_DECREF(__pyx_v_info);
    __pyx_v_info = __pyx_6;
    __pyx_6 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":678 */
    __pyx_3 = PyLong_FromUnsignedLong(__pyx_v_entry_size); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 681; goto __pyx_L1;}
    __pyx_4 = PyInt_FromLong(__pyx_v_is_executable); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 682; goto __pyx_L1;}
    __pyx_5 = PyTuple_New(5); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 679; goto __pyx_L1;}
    Py_INCREF(__pyx_v_minikind);
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_v_minikind);
    Py_INCREF(__pyx_v_fingerprint);
    PyTuple_SET_ITEM(__pyx_5, 1, __pyx_v_fingerprint);
    PyTuple_SET_ITEM(__pyx_5, 2, __pyx_3);
    PyTuple_SET_ITEM(__pyx_5, 3, __pyx_4);
    Py_INCREF(__pyx_v_info);
    PyTuple_SET_ITEM(__pyx_5, 4, __pyx_v_info);
    __pyx_3 = 0;
    __pyx_4 = 0;
    __pyx_2 = PyList_Append(__pyx_v_trees,__pyx_5); if (__pyx_2 == (-1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 678; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
  }

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":687 */
  __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 687; goto __pyx_L1;}
  Py_INCREF(__pyx_v_path_name_file_id_key);
  PyTuple_SET_ITEM(__pyx_6, 0, __pyx_v_path_name_file_id_key);
  Py_INCREF(__pyx_v_trees);
  PyTuple_SET_ITEM(__pyx_6, 1, __pyx_v_trees);
  Py_DECREF(__pyx_v_ret);
  __pyx_v_ret = __pyx_6;
  __pyx_6 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":691 */
  __pyx_1 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)__pyx_v_self->__pyx_vtab)->get_next(__pyx_v_self,(&__pyx_v_cur_size)); if (__pyx_1 == NULL) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 691; goto __pyx_L1;}
  __pyx_v_trailing = __pyx_1;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":692 */
  __pyx_2 = (__pyx_v_cur_size != 1);
  if (!__pyx_2) {
    __pyx_2 = ((__pyx_v_trailing[0]) != '\n');
  }
  if (__pyx_2) {
    __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 693; goto __pyx_L1;}
    __pyx_4 = PyObject_GetAttr(__pyx_3, __pyx_n_DirstateCorrupt); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 693; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_5 = PyInt_FromLong(__pyx_v_cur_size); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}
    __pyx_6 = __pyx_f_19_dirstate_helpers_c_safe_string_from_size(__pyx_v_trailing,__pyx_v_cur_size); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(3); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_5);
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_6);
    Py_INCREF(__pyx_v_ret);
    PyTuple_SET_ITEM(__pyx_3, 2, __pyx_v_ret);
    __pyx_5 = 0;
    __pyx_6 = 0;
    __pyx_5 = PyNumber_Remainder(__pyx_k45p, __pyx_3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 693; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->state);
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_v_self->state);
    PyTuple_SET_ITEM(__pyx_6, 1, __pyx_5);
    __pyx_5 = 0;
    __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_6); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 693; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 693; goto __pyx_L1;}
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":697 */
  Py_INCREF(__pyx_v_ret);
  __pyx_r = __pyx_v_ret;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("_dirstate_helpers_c.Reader._get_entry");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_path_name_file_id_key);
  Py_DECREF(__pyx_v_minikind);
  Py_DECREF(__pyx_v_fingerprint);
  Py_DECREF(__pyx_v_info);
  Py_DECREF(__pyx_v_dirname);
  Py_DECREF(__pyx_v_trees);
  Py_DECREF(__pyx_v_ret);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n__num_present_parents;
static PyObject *__pyx_n__num_entries;
static PyObject *__pyx_n__dirblocks;
static PyObject *__pyx_n__split_root_dirblock_into_contents;

static PyObject *__pyx_k46p;
static PyObject *__pyx_k47p;
static PyObject *__pyx_k48p;
static PyObject *__pyx_k49p;

static char __pyx_k46[] = "";
static char __pyx_k47[] = "";
static char __pyx_k48[] = "";
static char __pyx_k49[] = "We read the wrong number of entries. We expected to read %s, but read %s";

static PyObject *__pyx_f_19_dirstate_helpers_c_6Reader__parse_dirblocks(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_19_dirstate_helpers_c_6Reader__parse_dirblocks[] = "Parse all dirblocks in the state file.";
static PyObject *__pyx_f_19_dirstate_helpers_c_6Reader__parse_dirblocks(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_v_num_trees;
  PyObject *__pyx_v_current_block;
  PyObject *__pyx_v_entry;
  void *__pyx_v_current_dirname;
  int __pyx_v_new_block;
  int __pyx_v_expected_entry_count;
  int __pyx_v_entry_count;
  PyObject *__pyx_v_dirblocks;
  PyObject *__pyx_v_obj;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  PyObject *__pyx_5 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_current_block = Py_None; Py_INCREF(Py_None);
  __pyx_v_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_dirblocks = Py_None; Py_INCREF(Py_None);
  __pyx_v_obj = Py_None; Py_INCREF(Py_None);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":709 */
  __pyx_1 = PyObject_GetAttr(((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->state, __pyx_n__num_present_parents); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 709; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 709; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyInt_FromLong(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 709; goto __pyx_L1;}
  __pyx_3 = PyNumber_Add(__pyx_2, __pyx_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 709; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_4 = PyInt_AsLong(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 709; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_v_num_trees = __pyx_4;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":710 */
  __pyx_2 = PyObject_GetAttr(((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->state, __pyx_n__num_entries); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 710; goto __pyx_L1;}
  __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 710; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_v_expected_entry_count = __pyx_4;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":713 */
  __pyx_4 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->__pyx_vtab)->_init(((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)); if (__pyx_4 == (-1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 713; goto __pyx_L1;}

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":715 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 715; goto __pyx_L1;}
  Py_DECREF(__pyx_v_current_block);
  __pyx_v_current_block = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":716 */
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 716; goto __pyx_L1;}
  Py_INCREF(__pyx_k46p);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k46p);
  Py_INCREF(__pyx_v_current_block);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_current_block);
  __pyx_2 = PyList_New(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 716; goto __pyx_L1;}
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 716; goto __pyx_L1;}
  Py_INCREF(__pyx_k47p);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_k47p);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_2);
  __pyx_2 = 0;
  __pyx_2 = PyList_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 716; goto __pyx_L1;}
  PyList_SET_ITEM(__pyx_2, 0, __pyx_3);
  PyList_SET_ITEM(__pyx_2, 1, __pyx_1);
  __pyx_3 = 0;
  __pyx_1 = 0;
  Py_DECREF(__pyx_v_dirblocks);
  __pyx_v_dirblocks = __pyx_2;
  __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":717 */
  if (PyObject_SetAttr(((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->state, __pyx_n__dirblocks, __pyx_v_dirblocks) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 717; goto __pyx_L1;}

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":718 */
  Py_INCREF(__pyx_k48p);
  Py_DECREF(__pyx_v_obj);
  __pyx_v_obj = __pyx_k48p;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":719 */
  __pyx_v_current_dirname = ((void *)__pyx_v_obj);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":720 */
  __pyx_v_new_block = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":721 */
  __pyx_v_entry_count = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":730 */
  while (1) {
    __pyx_4 = (((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->cur_cstr < ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->end_cstr);
    if (!__pyx_4) break;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":731 */
    __pyx_3 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader *)((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->__pyx_vtab)->_get_entry(((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self),__pyx_v_num_trees,(&__pyx_v_current_dirname),(&__pyx_v_new_block)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 731; goto __pyx_L1;}
    Py_DECREF(__pyx_v_entry);
    __pyx_v_entry = __pyx_3;
    __pyx_3 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":732 */
    __pyx_4 = __pyx_v_new_block;
    if (__pyx_4) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":734 */
      __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 734; goto __pyx_L1;}
      Py_DECREF(__pyx_v_current_block);
      __pyx_v_current_block = __pyx_1;
      __pyx_1 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":735 */
      __pyx_2 = (PyObject *)__pyx_v_current_dirname;
      Py_INCREF(__pyx_2);
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 736; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
      Py_INCREF(__pyx_v_current_block);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_current_block);
      __pyx_2 = 0;
      __pyx_4 = PyList_Append(__pyx_v_dirblocks,__pyx_3); if (__pyx_4 == (-1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 735; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L4;
    }
    __pyx_L4:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":737 */
    __pyx_4 = PyList_Append(__pyx_v_current_block,__pyx_v_entry); if (__pyx_4 == (-1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 737; goto __pyx_L1;}

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":738 */
    __pyx_v_entry_count = (__pyx_v_entry_count + 1);
  }

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":739 */
  __pyx_4 = (__pyx_v_entry_count != __pyx_v_expected_entry_count);
  if (__pyx_4) {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 740; goto __pyx_L1;}
    __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_DirstateCorrupt); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 740; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_3 = PyInt_FromLong(__pyx_v_expected_entry_count); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 743; goto __pyx_L1;}
    __pyx_1 = PyInt_FromLong(__pyx_v_entry_count); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 743; goto __pyx_L1;}
    __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 743; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_3);
    PyTuple_SET_ITEM(__pyx_5, 1, __pyx_1);
    __pyx_3 = 0;
    __pyx_1 = 0;
    __pyx_3 = PyNumber_Remainder(__pyx_k49p, __pyx_5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 743; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 740; goto __pyx_L1;}
    Py_INCREF(((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->state);
    PyTuple_SET_ITEM(__pyx_1, 0, ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->state);
    PyTuple_SET_ITEM(__pyx_1, 1, __pyx_3);
    __pyx_3 = 0;
    __pyx_5 = PyObject_CallObject(__pyx_2, __pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 740; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __Pyx_Raise(__pyx_5, 0, 0);
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 740; goto __pyx_L1;}
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":744 */
  __pyx_3 = PyObject_GetAttr(((struct __pyx_obj_19_dirstate_helpers_c_Reader *)__pyx_v_self)->state, __pyx_n__split_root_dirblock_into_contents); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 744; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_3, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 744; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("_dirstate_helpers_c.Reader._parse_dirblocks");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_current_block);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_dirblocks);
  Py_DECREF(__pyx_v_obj);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n__state_file;
static PyObject *__pyx_n_seek;
static PyObject *__pyx_n__end_of_header;
static PyObject *__pyx_n_read;
static PyObject *__pyx_n__parse_dirblocks;
static PyObject *__pyx_n_IN_MEMORY_UNMODIFIED;
static PyObject *__pyx_n__dirblock_state;

static PyObject *__pyx_f_19_dirstate_helpers_c__read_dirblocks_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_19_dirstate_helpers_c__read_dirblocks_c[] = "Read in the dirblocks for the given DirState object.\n\n    This is tightly bound to the DirState internal representation. It should be\n    thought of as a member function, which is only separated out so that we can\n    re-write it in pyrex.\n\n    :param state: A DirState object.\n    :return: None\n    :postcondition: The dirblocks will be loaded into the appropriate fields in\n        the DirState object.\n    ";
static PyObject *__pyx_f_19_dirstate_helpers_c__read_dirblocks_c(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_state = 0;
  PyObject *__pyx_v_text;
  PyObject *__pyx_v_reader;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"state",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_state)) return 0;
  Py_INCREF(__pyx_v_state);
  __pyx_v_text = Py_None; Py_INCREF(Py_None);
  __pyx_v_reader = Py_None; Py_INCREF(Py_None);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":759 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_state, __pyx_n__state_file); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 759; goto __pyx_L1;}
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_seek); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 759; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_v_state, __pyx_n__end_of_header); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 759; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 759; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
  __pyx_1 = 0;
  __pyx_1 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 759; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":760 */
  __pyx_2 = PyObject_GetAttr(__pyx_v_state, __pyx_n__state_file); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 760; goto __pyx_L1;}
  __pyx_3 = PyObject_GetAttr(__pyx_2, __pyx_n_read); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 760; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = PyObject_CallObject(__pyx_3, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 760; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_v_text);
  __pyx_v_text = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":763 */
  __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 763; goto __pyx_L1;}
  Py_INCREF(__pyx_v_text);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_text);
  Py_INCREF(__pyx_v_state);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_state);
  __pyx_3 = PyObject_CallObject(((PyObject *)__pyx_ptype_19_dirstate_helpers_c_Reader), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 763; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_reader);
  __pyx_v_reader = __pyx_3;
  __pyx_3 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":765 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_reader, __pyx_n__parse_dirblocks); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 765; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 765; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":766 */
  __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_DirState); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 766; goto __pyx_L1;}
  __pyx_1 = PyObject_GetAttr(__pyx_3, __pyx_n_IN_MEMORY_UNMODIFIED); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 766; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (PyObject_SetAttr(__pyx_v_state, __pyx_n__dirblock_state, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 766; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_c._read_dirblocks_c");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_text);
  Py_DECREF(__pyx_v_reader);
  Py_DECREF(__pyx_v_state);
  return __pyx_r;
}

static int __pyx_f_19_dirstate_helpers_c_minikind_from_mode(int __pyx_v_mode) {
  int __pyx_r;
  int __pyx_1;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":771 */
  __pyx_1 = S_ISREG(__pyx_v_mode);
  if (__pyx_1) {
    __pyx_r = 'f';
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":773 */
  __pyx_1 = S_ISDIR(__pyx_v_mode);
  if (__pyx_1) {
    __pyx_r = 'd';
    goto __pyx_L0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":775 */
  __pyx_1 = S_ISLNK(__pyx_v_mode);
  if (__pyx_1) {
    __pyx_r = 'l';
    goto __pyx_L0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":777 */
  __pyx_r = 0;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_n_st_size;
static PyObject *__pyx_n_st_mtime;
static PyObject *__pyx_n_st_ctime;
static PyObject *__pyx_n_st_dev;
static PyObject *__pyx_n_st_ino;
static PyObject *__pyx_n_st_mode;

static PyObject *__pyx_f_19_dirstate_helpers_c__pack_stat(PyObject *__pyx_v_stat_value) {
  char __pyx_v_result[(6 * 4)];
  int *__pyx_v_aliased;
  PyObject *__pyx_v_packed;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  unsigned long __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF(__pyx_v_stat_value);
  __pyx_v_packed = Py_None; Py_INCREF(Py_None);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":792 */
  __pyx_v_aliased = ((int *)__pyx_v_result);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":793 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 793; goto __pyx_L1;}
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 793; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  (__pyx_v_aliased[0]) = htonl(__pyx_2);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":794 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mtime); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 794; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 794; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
  __pyx_1 = 0;
  __pyx_1 = PyObject_CallObject(((PyObject *)(&PyInt_Type)), __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 794; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 794; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  (__pyx_v_aliased[1]) = htonl(__pyx_2);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":795 */
  __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_ctime); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 795; goto __pyx_L1;}
  __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 795; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_3);
  __pyx_3 = 0;
  __pyx_3 = PyObject_CallObject(((PyObject *)(&PyInt_Type)), __pyx_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 795; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 795; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  (__pyx_v_aliased[2]) = htonl(__pyx_2);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":796 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_dev); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 796; goto __pyx_L1;}
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 796; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  (__pyx_v_aliased[3]) = htonl(__pyx_2);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":797 */
  __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_ino); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 797; goto __pyx_L1;}
  __pyx_1 = PyInt_FromLong(0xFFFFFFFF); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 797; goto __pyx_L1;}
  __pyx_4 = PyNumber_And(__pyx_3, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 797; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_4); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 797; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  (__pyx_v_aliased[4]) = htonl(__pyx_2);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":798 */
  __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mode); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 798; goto __pyx_L1;}
  __pyx_2 = PyInt_AsUnsignedLongMask(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 798; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  (__pyx_v_aliased[5]) = htonl(__pyx_2);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":799 */
  __pyx_1 = PyString_FromStringAndSize(__pyx_v_result,(6 * 4)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 799; goto __pyx_L1;}
  Py_DECREF(__pyx_v_packed);
  __pyx_v_packed = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":800 */
  __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n__encode); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  Py_INCREF(__pyx_v_packed);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_packed);
  __pyx_1 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_4 = PySequence_GetSlice(__pyx_1, 0, (-1)); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_4;
  __pyx_4 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("_dirstate_helpers_c._pack_stat");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_packed);
  Py_DECREF(__pyx_v_stat_value);
  return __pyx_r;
}

static PyObject *__pyx_f_19_dirstate_helpers_c_update_entry(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_19_dirstate_helpers_c_update_entry[] = "Update the entry based on what is actually on disk.\n\n    This function only calculates the sha if it needs to - if the entry is\n    uncachable, or clearly different to the first parent\'s entry, no sha\n    is calculated, and None is returned.\n\n    :param entry: This is the dirblock entry for the file in question.\n    :param abspath: The path on disk for this file.\n    :param stat_value: (optional) if we already have done a stat on the\n        file, re-use it.\n    :return: None, or The sha1 hexdigest of the file (40 bytes) or link\n        target of a symlink.\n    ";
static PyObject *__pyx_f_19_dirstate_helpers_c_update_entry(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_self = 0;
  PyObject *__pyx_v_entry = 0;
  PyObject *__pyx_v_abspath = 0;
  PyObject *__pyx_v_stat_value = 0;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {"self","entry","abspath","stat_value",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OOOO", __pyx_argnames, &__pyx_v_self, &__pyx_v_entry, &__pyx_v_abspath, &__pyx_v_stat_value)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_entry);
  Py_INCREF(__pyx_v_abspath);
  Py_INCREF(__pyx_v_stat_value);
  __pyx_1 = __pyx_f_19_dirstate_helpers_c__update_entry(__pyx_v_self,__pyx_v_entry,__pyx_v_abspath,__pyx_v_stat_value); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 817; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("_dirstate_helpers_c.update_entry");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_abspath);
  Py_DECREF(__pyx_v_stat_value);
  return __pyx_r;
}

static PyObject *__pyx_n__is_executable;
static PyObject *__pyx_n__cutoff_time;
static PyObject *__pyx_n__sha_cutoff_time;
static PyObject *__pyx_n_a;
static PyObject *__pyx_n__sha1_file;
static PyObject *__pyx_n_f;
static PyObject *__pyx_n_NULLSTAT;
static PyObject *__pyx_n_d;
static PyObject *__pyx_n__get_block_entry_index;
static PyObject *__pyx_n__ensure_block;
static PyObject *__pyx_n__read_link;
static PyObject *__pyx_n_l;
static PyObject *__pyx_n_IN_MEMORY_MODIFIED;

static PyObject *__pyx_k53p;
static PyObject *__pyx_k55p;
static PyObject *__pyx_k58p;

static char __pyx_k53[] = "";
static char __pyx_k55[] = "";
static char __pyx_k58[] = "";

static PyObject *__pyx_f_19_dirstate_helpers_c__update_entry(PyObject *__pyx_v_self,PyObject *__pyx_v_entry,PyObject *__pyx_v_abspath,PyObject *__pyx_v_stat_value) {
  int __pyx_v_minikind;
  int __pyx_v_saved_minikind;
  void *__pyx_v_details;
  PyObject *__pyx_v_packed_stat;
  PyObject *__pyx_v_saved_link_or_sha1;
  PyObject *__pyx_v_saved_file_size;
  PyObject *__pyx_v_saved_executable;
  PyObject *__pyx_v_saved_packed_stat;
  PyObject *__pyx_v_link_or_sha1;
  PyObject *__pyx_v_executable;
  PyObject *__pyx_v_block_index;
  PyObject *__pyx_v_entry_index;
  PyObject *__pyx_v_dir_present;
  PyObject *__pyx_v_file_present;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_ssize_t __pyx_5;
  PyObject *__pyx_6 = 0;
  PyObject *__pyx_7 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_entry);
  Py_INCREF(__pyx_v_abspath);
  Py_INCREF(__pyx_v_stat_value);
  __pyx_v_packed_stat = Py_None; Py_INCREF(Py_None);
  __pyx_v_saved_link_or_sha1 = Py_None; Py_INCREF(Py_None);
  __pyx_v_saved_file_size = Py_None; Py_INCREF(Py_None);
  __pyx_v_saved_executable = Py_None; Py_INCREF(Py_None);
  __pyx_v_saved_packed_stat = Py_None; Py_INCREF(Py_None);
  __pyx_v_link_or_sha1 = Py_None; Py_INCREF(Py_None);
  __pyx_v_executable = Py_None; Py_INCREF(Py_None);
  __pyx_v_block_index = Py_None; Py_INCREF(Py_None);
  __pyx_v_entry_index = Py_None; Py_INCREF(Py_None);
  __pyx_v_dir_present = Py_None; Py_INCREF(Py_None);
  __pyx_v_file_present = Py_None; Py_INCREF(Py_None);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":838 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mode); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 838; goto __pyx_L1;}
  __pyx_2 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 838; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_v_minikind = __pyx_f_19_dirstate_helpers_c_minikind_from_mode(__pyx_2);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":839 */
  __pyx_2 = (0 == __pyx_v_minikind);
  if (__pyx_2) {
    Py_INCREF(Py_None);
    __pyx_r = Py_None;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":841 */
  __pyx_1 = __pyx_f_19_dirstate_helpers_c__pack_stat(__pyx_v_stat_value); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 841; goto __pyx_L1;}
  Py_DECREF(__pyx_v_packed_stat);
  __pyx_v_packed_stat = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":842 */
  __pyx_v_details = PyList_GET_ITEM(PyTuple_GET_ITEM(((void *)__pyx_v_entry),1),0);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":843 */
  __pyx_v_saved_minikind = (PyString_AsString(((PyObject *)PyTuple_GET_ITEM(__pyx_v_details,0)))[0]);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":844 */
  __pyx_2 = (__pyx_v_minikind == 'd');
  if (__pyx_2) {
    __pyx_2 = (__pyx_v_saved_minikind == 't');
  }
  if (__pyx_2) {
    __pyx_v_minikind = 't';
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":846 */
  __pyx_1 = PyTuple_GET_ITEM(__pyx_v_details,1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 846; goto __pyx_L1;}
  Py_DECREF(__pyx_v_saved_link_or_sha1);
  __pyx_v_saved_link_or_sha1 = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":847 */
  __pyx_1 = PyTuple_GET_ITEM(__pyx_v_details,2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 847; goto __pyx_L1;}
  Py_DECREF(__pyx_v_saved_file_size);
  __pyx_v_saved_file_size = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":848 */
  __pyx_1 = PyTuple_GET_ITEM(__pyx_v_details,3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 848; goto __pyx_L1;}
  Py_DECREF(__pyx_v_saved_executable);
  __pyx_v_saved_executable = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":849 */
  __pyx_1 = PyTuple_GET_ITEM(__pyx_v_details,4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 849; goto __pyx_L1;}
  Py_DECREF(__pyx_v_saved_packed_stat);
  __pyx_v_saved_packed_stat = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":851 */
  Py_INCREF(__pyx_v_saved_link_or_sha1);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":852 */
  Py_INCREF(__pyx_v_saved_file_size);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":853 */
  Py_INCREF(__pyx_v_saved_executable);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":854 */
  Py_INCREF(__pyx_v_saved_packed_stat);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":858 */
  __pyx_2 = (__pyx_v_minikind == __pyx_v_saved_minikind);
  if (__pyx_2) {
    if (PyObject_Cmp(__pyx_v_packed_stat, __pyx_v_saved_packed_stat, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 859; goto __pyx_L1;}
    __pyx_2 = __pyx_2 == 0;
  }
  if (__pyx_2) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":862 */
    __pyx_2 = (__pyx_v_minikind == 'd');
    if (__pyx_2) {
      Py_INCREF(Py_None);
      __pyx_r = Py_None;
      goto __pyx_L0;
      goto __pyx_L5;
    }
    __pyx_L5:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":866 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 866; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_v_saved_file_size, __pyx_1, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 866; goto __pyx_L1;}
    __pyx_2 = __pyx_2 == 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    if (__pyx_2) {
      Py_INCREF(__pyx_v_saved_link_or_sha1);
      __pyx_r = __pyx_v_saved_link_or_sha1;
      goto __pyx_L0;
      goto __pyx_L6;
    }
    __pyx_L6:;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":871 */
  Py_INCREF(Py_None);
  Py_DECREF(__pyx_v_link_or_sha1);
  __pyx_v_link_or_sha1 = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":872 */
  __pyx_2 = (__pyx_v_minikind == 'f');
  if (__pyx_2) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":873 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n__is_executable); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 873; goto __pyx_L1;}
    __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mode); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 873; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 873; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
    Py_INCREF(__pyx_v_saved_executable);
    PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_saved_executable);
    __pyx_3 = 0;
    __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 873; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_v_executable);
    __pyx_v_executable = __pyx_3;
    __pyx_3 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":875 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 875; goto __pyx_L1;}
    __pyx_2 = __pyx_1 == Py_None;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    if (__pyx_2) {
      __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__sha_cutoff_time); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 876; goto __pyx_L1;}
      __pyx_3 = PyObject_CallObject(__pyx_4, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 876; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L8;
    }
    __pyx_L8:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":877 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mtime); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 877; goto __pyx_L1;}
    __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 877; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_1, __pyx_4, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 877; goto __pyx_L1;}
    __pyx_2 = __pyx_2 < 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    if (__pyx_2) {
      __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_ctime); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 878; goto __pyx_L1;}
      __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 878; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_3, __pyx_1, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 878; goto __pyx_L1;}
      __pyx_2 = __pyx_2 < 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      if (__pyx_2) {
        __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 879; goto __pyx_L1;}
        __pyx_5 = PyObject_Length(__pyx_4); if (__pyx_5 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 879; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        __pyx_2 = (__pyx_5 > 1);
        if (__pyx_2) {
          __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 880; goto __pyx_L1;}
          __pyx_1 = __Pyx_GetItemInt(__pyx_3, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 880; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          __pyx_4 = __Pyx_GetItemInt(__pyx_1, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 880; goto __pyx_L1;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          if (PyObject_Cmp(__pyx_4, __pyx_n_a, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 880; goto __pyx_L1;}
          __pyx_2 = __pyx_2 != 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
        }
      }
    }
    if (__pyx_2) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":884 */
      __pyx_3 = PyObject_GetAttr(__pyx_v_self, __pyx_n__sha1_file); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 884; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 884; goto __pyx_L1;}
      Py_INCREF(__pyx_v_abspath);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_abspath);
      __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 884; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_v_link_or_sha1);
      __pyx_v_link_or_sha1 = __pyx_4;
      __pyx_4 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":885 */
      __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 885; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 885; goto __pyx_L1;}
      Py_INCREF(__pyx_n_f);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_n_f);
      Py_INCREF(__pyx_v_link_or_sha1);
      PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_link_or_sha1);
      PyTuple_SET_ITEM(__pyx_1, 2, __pyx_3);
      Py_INCREF(__pyx_v_executable);
      PyTuple_SET_ITEM(__pyx_1, 3, __pyx_v_executable);
      Py_INCREF(__pyx_v_packed_stat);
      PyTuple_SET_ITEM(__pyx_1, 4, __pyx_v_packed_stat);
      __pyx_3 = 0;
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 885; goto __pyx_L1;}
      if (__Pyx_SetItemInt(__pyx_4, 0, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 885; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      goto __pyx_L9;
    }
    /*else*/ {
      __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 888; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_DirState); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 889; goto __pyx_L1;}
      __pyx_4 = PyObject_GetAttr(__pyx_1, __pyx_n_NULLSTAT); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 889; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_1 = PyTuple_New(5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 888; goto __pyx_L1;}
      Py_INCREF(__pyx_n_f);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_n_f);
      Py_INCREF(__pyx_k53p);
      PyTuple_SET_ITEM(__pyx_1, 1, __pyx_k53p);
      PyTuple_SET_ITEM(__pyx_1, 2, __pyx_3);
      Py_INCREF(__pyx_v_executable);
      PyTuple_SET_ITEM(__pyx_1, 3, __pyx_v_executable);
      PyTuple_SET_ITEM(__pyx_1, 4, __pyx_4);
      __pyx_3 = 0;
      __pyx_4 = 0;
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 888; goto __pyx_L1;}
      if (__Pyx_SetItemInt(__pyx_3, 0, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 888; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
    }
    __pyx_L9:;
    goto __pyx_L7;
  }
  __pyx_2 = (__pyx_v_minikind == 'd');
  if (__pyx_2) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":891 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_link_or_sha1);
    __pyx_v_link_or_sha1 = Py_None;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":892 */
    __pyx_4 = PyInt_FromLong(0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 892; goto __pyx_L1;}
    __pyx_1 = PyTuple_New(5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 892; goto __pyx_L1;}
    Py_INCREF(__pyx_n_d);
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_n_d);
    Py_INCREF(__pyx_k55p);
    PyTuple_SET_ITEM(__pyx_1, 1, __pyx_k55p);
    PyTuple_SET_ITEM(__pyx_1, 2, __pyx_4);
    Py_INCREF(Py_False);
    PyTuple_SET_ITEM(__pyx_1, 3, Py_False);
    Py_INCREF(__pyx_v_packed_stat);
    PyTuple_SET_ITEM(__pyx_1, 4, __pyx_v_packed_stat);
    __pyx_4 = 0;
    __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 892; goto __pyx_L1;}
    if (__Pyx_SetItemInt(__pyx_3, 0, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 892; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":893 */
    __pyx_2 = (__pyx_v_saved_minikind != 'd');
    if (__pyx_2) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":898 */
      __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__get_block_entry_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 898; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 898; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_1, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 898; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 898; goto __pyx_L1;}
      __pyx_6 = __Pyx_GetItemInt(__pyx_1, 1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 898; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 898; goto __pyx_L1;}
      __pyx_7 = PyTuple_New(3); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 898; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_7, 0, __pyx_3);
      PyTuple_SET_ITEM(__pyx_7, 1, __pyx_6);
      PyTuple_SET_ITEM(__pyx_7, 2, __pyx_1);
      __pyx_3 = 0;
      __pyx_6 = 0;
      __pyx_1 = 0;
      __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_7); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 898; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_6 = PyObject_GetIter(__pyx_3); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 897; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_1 = __Pyx_UnpackItem(__pyx_6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 897; goto __pyx_L1;}
      Py_DECREF(__pyx_v_block_index);
      __pyx_v_block_index = __pyx_1;
      __pyx_1 = 0;
      __pyx_4 = __Pyx_UnpackItem(__pyx_6); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 897; goto __pyx_L1;}
      Py_DECREF(__pyx_v_entry_index);
      __pyx_v_entry_index = __pyx_4;
      __pyx_4 = 0;
      __pyx_7 = __Pyx_UnpackItem(__pyx_6); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 897; goto __pyx_L1;}
      Py_DECREF(__pyx_v_dir_present);
      __pyx_v_dir_present = __pyx_7;
      __pyx_7 = 0;
      __pyx_3 = __Pyx_UnpackItem(__pyx_6); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 897; goto __pyx_L1;}
      Py_DECREF(__pyx_v_file_present);
      __pyx_v_file_present = __pyx_3;
      __pyx_3 = 0;
      if (__Pyx_EndUnpack(__pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 897; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":899 */
      __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n__ensure_block); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 899; goto __pyx_L1;}
      __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_pathjoin); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_7, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_6 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetItemInt(__pyx_6, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_6, 0, __pyx_3);
      PyTuple_SET_ITEM(__pyx_6, 1, __pyx_7);
      __pyx_3 = 0;
      __pyx_7 = 0;
      __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_6); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_7 = PyTuple_New(3); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 899; goto __pyx_L1;}
      Py_INCREF(__pyx_v_block_index);
      PyTuple_SET_ITEM(__pyx_7, 0, __pyx_v_block_index);
      Py_INCREF(__pyx_v_entry_index);
      PyTuple_SET_ITEM(__pyx_7, 1, __pyx_v_entry_index);
      PyTuple_SET_ITEM(__pyx_7, 2, __pyx_3);
      __pyx_3 = 0;
      __pyx_4 = PyObject_CallObject(__pyx_1, __pyx_7); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 899; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      goto __pyx_L10;
    }
    __pyx_L10:;
    goto __pyx_L7;
  }
  __pyx_2 = (__pyx_v_minikind == 'l');
  if (__pyx_2) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":902 */
    __pyx_6 = PyObject_GetAttr(__pyx_v_self, __pyx_n__read_link); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
    Py_INCREF(__pyx_v_abspath);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_abspath);
    Py_INCREF(__pyx_v_saved_link_or_sha1);
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_saved_link_or_sha1);
    __pyx_1 = PyObject_CallObject(__pyx_6, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_v_link_or_sha1);
    __pyx_v_link_or_sha1 = __pyx_1;
    __pyx_1 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":903 */
    __pyx_7 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 903; goto __pyx_L1;}
    __pyx_2 = __pyx_7 == Py_None;
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (__pyx_2) {
      __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__sha_cutoff_time); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 904; goto __pyx_L1;}
      __pyx_6 = PyObject_CallObject(__pyx_4, 0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 904; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      goto __pyx_L11;
    }
    __pyx_L11:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":905 */
    __pyx_3 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_mtime); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 905; goto __pyx_L1;}
    __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 905; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_3, __pyx_1, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 905; goto __pyx_L1;}
    __pyx_2 = __pyx_2 < 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    if (__pyx_2) {
      __pyx_7 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_ctime); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 906; goto __pyx_L1;}
      __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__cutoff_time); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 906; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_7, __pyx_4, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 906; goto __pyx_L1;}
      __pyx_2 = __pyx_2 < 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
    }
    if (__pyx_2) {
      __pyx_6 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
      __pyx_3 = PyTuple_New(5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
      Py_INCREF(__pyx_n_l);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_n_l);
      Py_INCREF(__pyx_v_link_or_sha1);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_link_or_sha1);
      PyTuple_SET_ITEM(__pyx_3, 2, __pyx_6);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_3, 3, Py_False);
      Py_INCREF(__pyx_v_packed_stat);
      PyTuple_SET_ITEM(__pyx_3, 4, __pyx_v_packed_stat);
      __pyx_6 = 0;
      __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
      if (__Pyx_SetItemInt(__pyx_1, 0, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L12;
    }
    /*else*/ {
      __pyx_7 = PyObject_GetAttr(__pyx_v_stat_value, __pyx_n_st_size); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 910; goto __pyx_L1;}
      __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_DirState); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 911; goto __pyx_L1;}
      __pyx_6 = PyObject_GetAttr(__pyx_4, __pyx_n_NULLSTAT); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 911; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_3 = PyTuple_New(5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 910; goto __pyx_L1;}
      Py_INCREF(__pyx_n_l);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_n_l);
      Py_INCREF(__pyx_k58p);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_k58p);
      PyTuple_SET_ITEM(__pyx_3, 2, __pyx_7);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_3, 3, Py_False);
      PyTuple_SET_ITEM(__pyx_3, 4, __pyx_6);
      __pyx_7 = 0;
      __pyx_6 = 0;
      __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 910; goto __pyx_L1;}
      if (__Pyx_SetItemInt(__pyx_1, 0, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 910; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
    }
    __pyx_L12:;
    goto __pyx_L7;
  }
  __pyx_L7:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":912 */
  __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_DirState); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 912; goto __pyx_L1;}
  __pyx_7 = PyObject_GetAttr(__pyx_4, __pyx_n_IN_MEMORY_MODIFIED); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 912; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  if (PyObject_SetAttr(__pyx_v_self, __pyx_n__dirblock_state, __pyx_7) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 912; goto __pyx_L1;}
  Py_DECREF(__pyx_7); __pyx_7 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":913 */
  Py_INCREF(__pyx_v_link_or_sha1);
  __pyx_r = __pyx_v_link_or_sha1;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_6);
  Py_XDECREF(__pyx_7);
  __Pyx_AddTraceback("_dirstate_helpers_c._update_entry");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_packed_stat);
  Py_DECREF(__pyx_v_saved_link_or_sha1);
  Py_DECREF(__pyx_v_saved_file_size);
  Py_DECREF(__pyx_v_saved_executable);
  Py_DECREF(__pyx_v_saved_packed_stat);
  Py_DECREF(__pyx_v_link_or_sha1);
  Py_DECREF(__pyx_v_executable);
  Py_DECREF(__pyx_v_block_index);
  Py_DECREF(__pyx_v_entry_index);
  Py_DECREF(__pyx_v_dir_present);
  Py_DECREF(__pyx_v_file_present);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_abspath);
  Py_DECREF(__pyx_v_stat_value);
  return __pyx_r;
}

static char __pyx_f_19_dirstate_helpers_c__minikind_from_string(PyObject *__pyx_v_string) {
  char __pyx_r;
  Py_INCREF(__pyx_v_string);
  __pyx_r = (PyString_AsString(__pyx_v_string)[0]);
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_string);
  return __pyx_r;
}

static PyObject *__pyx_f_19_dirstate_helpers_c__minikind_to_kind(char __pyx_v_minikind) {
  char __pyx_v__minikind[1];
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":938 */
  __pyx_1 = (__pyx_v_minikind == 'f');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_19_dirstate_helpers_c__kind_file);
    __pyx_r = __pyx_v_19_dirstate_helpers_c__kind_file;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_minikind == 'd');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_19_dirstate_helpers_c__kind_directory);
    __pyx_r = __pyx_v_19_dirstate_helpers_c__kind_directory;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_minikind == 'a');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_19_dirstate_helpers_c__kind_absent);
    __pyx_r = __pyx_v_19_dirstate_helpers_c__kind_absent;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_minikind == 'r');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_19_dirstate_helpers_c__kind_relocated);
    __pyx_r = __pyx_v_19_dirstate_helpers_c__kind_relocated;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_minikind == 'l');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_19_dirstate_helpers_c__kind_symlink);
    __pyx_r = __pyx_v_19_dirstate_helpers_c__kind_symlink;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = (__pyx_v_minikind == 't');
  if (__pyx_1) {
    Py_INCREF(__pyx_v_19_dirstate_helpers_c__kind_tree_reference);
    __pyx_r = __pyx_v_19_dirstate_helpers_c__kind_tree_reference;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":950 */
  (__pyx_v__minikind[0]) = __pyx_v_minikind;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":951 */
  __pyx_2 = PyString_FromStringAndSize(__pyx_v__minikind,1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 951; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 951; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  __pyx_2 = 0;
  __pyx_2 = PyObject_CallObject(PyExc_KeyError, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 951; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __Pyx_Raise(__pyx_2, 0, 0);
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  {__pyx_filename = __pyx_f[0]; __pyx_lineno = 951; goto __pyx_L1;}

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_c._minikind_to_kind");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static int __pyx_f_19_dirstate_helpers_c__versioned_minikind(char __pyx_v_minikind) {
  int __pyx_r;
  int __pyx_1;
  __pyx_1 = (__pyx_v_minikind == 'f');
  if (!__pyx_1) {
    __pyx_1 = (__pyx_v_minikind == 'd');
    if (!__pyx_1) {
      __pyx_1 = (__pyx_v_minikind == 'l');
      if (!__pyx_1) {
        __pyx_1 = (__pyx_v_minikind == 't');
      }
    }
  }
  __pyx_r = __pyx_1;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}

static PyObject *__pyx_n_object;
static PyObject *__pyx_n__utf8_decode;
static PyObject *__pyx_n_set;
static PyObject *__pyx_n_bisect_left;
static PyObject *__pyx_n_fstat;
static PyObject *__pyx_n_sha_file;

static int __pyx_f_19_dirstate_helpers_c_13ProcessEntryC___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_19_dirstate_helpers_c_13ProcessEntryC___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_include_unchanged = 0;
  PyObject *__pyx_v_use_filesystem_for_exec = 0;
  PyObject *__pyx_v_search_specific_files = 0;
  PyObject *__pyx_v_state = 0;
  PyObject *__pyx_v_source_index = 0;
  PyObject *__pyx_v_target_index = 0;
  PyObject *__pyx_v_want_unversioned = 0;
  PyObject *__pyx_v_tree = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  static char *__pyx_argnames[] = {"include_unchanged","use_filesystem_for_exec","search_specific_files","state","source_index","target_index","want_unversioned","tree",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OOOOOOOO", __pyx_argnames, &__pyx_v_include_unchanged, &__pyx_v_use_filesystem_for_exec, &__pyx_v_search_specific_files, &__pyx_v_state, &__pyx_v_source_index, &__pyx_v_target_index, &__pyx_v_want_unversioned, &__pyx_v_tree)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_include_unchanged);
  Py_INCREF(__pyx_v_use_filesystem_for_exec);
  Py_INCREF(__pyx_v_search_specific_files);
  Py_INCREF(__pyx_v_state);
  Py_INCREF(__pyx_v_source_index);
  Py_INCREF(__pyx_v_target_index);
  Py_INCREF(__pyx_v_want_unversioned);
  Py_INCREF(__pyx_v_tree);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1001 */
  __pyx_1 = PyDict_New(); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1001; goto __pyx_L1;}
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->old_dirname_to_file_id);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->old_dirname_to_file_id = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1002 */
  __pyx_1 = PyDict_New(); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1002; goto __pyx_L1;}
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->new_dirname_to_file_id);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->new_dirname_to_file_id = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1005 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_object); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1005; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1005; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->uninteresting);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->uninteresting = __pyx_2;
  __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1008 */
  __pyx_1 = PyList_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1008; goto __pyx_L1;}
  Py_INCREF(Py_None);
  PyList_SET_ITEM(__pyx_1, 0, Py_None);
  Py_INCREF(Py_None);
  PyList_SET_ITEM(__pyx_1, 1, Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->last_source_parent);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->last_source_parent = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1009 */
  __pyx_2 = PyList_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1009; goto __pyx_L1;}
  Py_INCREF(Py_None);
  PyList_SET_ITEM(__pyx_2, 0, Py_None);
  Py_INCREF(Py_None);
  PyList_SET_ITEM(__pyx_2, 1, Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->last_target_parent);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->last_target_parent = __pyx_2;
  __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1010 */
  Py_INCREF(__pyx_v_include_unchanged);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->include_unchanged);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->include_unchanged = __pyx_v_include_unchanged;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1011 */
  Py_INCREF(__pyx_v_use_filesystem_for_exec);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->use_filesystem_for_exec);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->use_filesystem_for_exec = __pyx_v_use_filesystem_for_exec;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1012 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_cache_utf8); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1012; goto __pyx_L1;}
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n__utf8_decode); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1012; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->utf8_decode);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->utf8_decode = __pyx_2;
  __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1017 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_set); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1017; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1017; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->searched_specific_files);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->searched_specific_files = __pyx_2;
  __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1018 */
  Py_INCREF(__pyx_v_search_specific_files);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->search_specific_files);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->search_specific_files = __pyx_v_search_specific_files;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1019 */
  Py_INCREF(__pyx_v_state);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->state);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->state = __pyx_v_state;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1020 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_root);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_root = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1021 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_root_unicode);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_root_unicode = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1022 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->root_entries);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->root_entries = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1023 */
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->root_entries_pos = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1024 */
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->root_entries_len = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1025 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->root_abspath);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->root_abspath = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1026 */
  __pyx_3 = __pyx_v_source_index == Py_None;
  if (__pyx_3) {
    ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->source_index = (-1);
    goto __pyx_L2;
  }
  /*else*/ {
    __pyx_3 = PyInt_AsLong(__pyx_v_source_index); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1029; goto __pyx_L1;}
    ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->source_index = __pyx_3;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1030 */
  __pyx_3 = PyInt_AsLong(__pyx_v_target_index); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1030; goto __pyx_L1;}
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->target_index = __pyx_3;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1031 */
  __pyx_3 = PyInt_AsLong(__pyx_v_want_unversioned); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1031; goto __pyx_L1;}
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->want_unversioned = __pyx_3;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1032 */
  Py_INCREF(__pyx_v_tree);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->tree);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->tree = __pyx_v_tree;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1033 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->dir_iterator);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->dir_iterator = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1034 */
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->block_index = (-1);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1035 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_block);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_block = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1036 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_block_list);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_block_list = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1037 */
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_block_pos = (-1);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1038 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_dir_info);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_dir_info = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1039 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_dir_list);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->current_dir_list = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1040 */
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->path_index = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1041 */
  Py_INCREF(Py_None);
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->root_dir_info);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->root_dir_info = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1042 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_bisect); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1042; goto __pyx_L1;}
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_bisect_left); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1042; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->bisect_left);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->bisect_left = __pyx_2;
  __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1043 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1043; goto __pyx_L1;}
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_pathjoin); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1043; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->pathjoin);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->pathjoin = __pyx_2;
  __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1044 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_os); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1044; goto __pyx_L1;}
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_fstat); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1044; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->fstat);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->fstat = __pyx_2;
  __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1045 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1045; goto __pyx_L1;}
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_sha_file); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1045; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->sha_file);
  ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->sha_file = __pyx_2;
  __pyx_2 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("_dirstate_helpers_c.ProcessEntryC.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_include_unchanged);
  Py_DECREF(__pyx_v_use_filesystem_for_exec);
  Py_DECREF(__pyx_v_search_specific_files);
  Py_DECREF(__pyx_v_state);
  Py_DECREF(__pyx_v_source_index);
  Py_DECREF(__pyx_v_target_index);
  Py_DECREF(__pyx_v_want_unversioned);
  Py_DECREF(__pyx_v_tree);
  return __pyx_r;
}

static PyObject *__pyx_n_NULL_PARENT_DETAILS;
static PyObject *__pyx_n_is_inside_any;
static PyObject *__pyx_n_add;
static PyObject *__pyx_n_path;
static PyObject *__pyx_n_split;
static PyObject *__pyx_n__get_entry;
static PyObject *__pyx_n_path_utf8;
static PyObject *__pyx_n_CorruptDirstate;
static PyObject *__pyx_n__filename;
static PyObject *__pyx_n__sha1_provider;
static PyObject *__pyx_n_stat_and_sha1;
static PyObject *__pyx_n__observed_sha1;

static PyObject *__pyx_k59p;
static PyObject *__pyx_k61p;
static PyObject *__pyx_k65p;
static PyObject *__pyx_k66p;
static PyObject *__pyx_k69p;
static PyObject *__pyx_k71p;
static PyObject *__pyx_k73p;

static char __pyx_k59[] = "Unsupported target index %d";
static char __pyx_k61[] = "entry '%s/%s' is considered renamed from %r but source does not exist\nentry: %s";
static char __pyx_k65[] = "tree-reference";
static char __pyx_k66[] = "unknown kind %s";
static char __pyx_k69[] = "Could not find target parent in wt: %s\nparent of: %s";
static char __pyx_k71[] = "We could not find the parent entry in index %d for the entry: %s";
static char __pyx_k73[] = "don't know how to compare source_minikind=%r, target_minikind=%r";

static PyObject *__pyx_f_19_dirstate_helpers_c_13ProcessEntryC__process_entry(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *__pyx_v_self,PyObject *__pyx_v_entry,PyObject *__pyx_v_path_info) {
  char __pyx_v_target_minikind;
  char __pyx_v_source_minikind;
  PyObject *__pyx_v_file_id;
  int __pyx_v_content_change;
  PyObject *__pyx_v_details_list;
  PyObject *__pyx_v_source_details;
  PyObject *__pyx_v_target_details;
  PyObject *__pyx_v_link_or_sha1;
  PyObject *__pyx_v_old_dirname;
  PyObject *__pyx_v_old_basename;
  PyObject *__pyx_v_old_path;
  PyObject *__pyx_v_path;
  PyObject *__pyx_v_old_entry;
  PyObject *__pyx_v_target_kind;
  PyObject *__pyx_v_target_exec;
  PyObject *__pyx_v_statvalue;
  PyObject *__pyx_v_source_parent_id;
  PyObject *__pyx_v_source_parent_entry;
  PyObject *__pyx_v_new_dirname;
  PyObject *__pyx_v_target_parent_id;
  PyObject *__pyx_v_target_parent_entry;
  PyObject *__pyx_v_source_exec;
  PyObject *__pyx_v_old_path_u;
  PyObject *__pyx_v_path_u;
  PyObject *__pyx_v_source_kind;
  PyObject *__pyx_v_parent_entry;
  PyObject *__pyx_v_parent_id;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  int __pyx_5;
  PyObject *__pyx_6 = 0;
  PyObject *__pyx_7 = 0;
  PyObject *__pyx_8 = 0;
  PyObject *__pyx_9 = 0;
  PyObject *__pyx_10 = 0;
  PyObject *__pyx_11 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_entry);
  Py_INCREF(__pyx_v_path_info);
  __pyx_v_file_id = Py_None; Py_INCREF(Py_None);
  __pyx_v_details_list = Py_None; Py_INCREF(Py_None);
  __pyx_v_source_details = Py_None; Py_INCREF(Py_None);
  __pyx_v_target_details = Py_None; Py_INCREF(Py_None);
  __pyx_v_link_or_sha1 = Py_None; Py_INCREF(Py_None);
  __pyx_v_old_dirname = Py_None; Py_INCREF(Py_None);
  __pyx_v_old_basename = Py_None; Py_INCREF(Py_None);
  __pyx_v_old_path = Py_None; Py_INCREF(Py_None);
  __pyx_v_path = Py_None; Py_INCREF(Py_None);
  __pyx_v_old_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_target_kind = Py_None; Py_INCREF(Py_None);
  __pyx_v_target_exec = Py_None; Py_INCREF(Py_None);
  __pyx_v_statvalue = Py_None; Py_INCREF(Py_None);
  __pyx_v_source_parent_id = Py_None; Py_INCREF(Py_None);
  __pyx_v_source_parent_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_new_dirname = Py_None; Py_INCREF(Py_None);
  __pyx_v_target_parent_id = Py_None; Py_INCREF(Py_None);
  __pyx_v_target_parent_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_source_exec = Py_None; Py_INCREF(Py_None);
  __pyx_v_old_path_u = Py_None; Py_INCREF(Py_None);
  __pyx_v_path_u = Py_None; Py_INCREF(Py_None);
  __pyx_v_source_kind = Py_None; Py_INCREF(Py_None);
  __pyx_v_parent_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_parent_id = Py_None; Py_INCREF(Py_None);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1066 */
  Py_INCREF(Py_None);
  Py_DECREF(__pyx_v_file_id);
  __pyx_v_file_id = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1067 */
  __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1067; goto __pyx_L1;}
  Py_DECREF(__pyx_v_details_list);
  __pyx_v_details_list = __pyx_1;
  __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1068 */
  __pyx_2 = ((-1) == __pyx_v_self->source_index);
  if (__pyx_2) {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_DirState); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1069; goto __pyx_L1;}
    __pyx_3 = PyObject_GetAttr(__pyx_1, __pyx_n_NULL_PARENT_DETAILS); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1069; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_v_source_details);
    __pyx_v_source_details = __pyx_3;
    __pyx_3 = 0;
    goto __pyx_L2;
  }
  /*else*/ {
    __pyx_1 = __Pyx_GetItemInt(__pyx_v_details_list, __pyx_v_self->source_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1071; goto __pyx_L1;}
    Py_DECREF(__pyx_v_source_details);
    __pyx_v_source_details = __pyx_1;
    __pyx_1 = 0;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1072 */
  __pyx_3 = __Pyx_GetItemInt(__pyx_v_details_list, __pyx_v_self->target_index); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1072; goto __pyx_L1;}
  Py_DECREF(__pyx_v_target_details);
  __pyx_v_target_details = __pyx_3;
  __pyx_3 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1073 */
  __pyx_1 = __Pyx_GetItemInt(__pyx_v_target_details, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1073; goto __pyx_L1;}
  __pyx_v_target_minikind = __pyx_f_19_dirstate_helpers_c__minikind_from_string(__pyx_1);
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1074 */
  __pyx_2 = __pyx_v_path_info != Py_None;
  if (__pyx_2) {
    __pyx_2 = __pyx_f_19_dirstate_helpers_c__versioned_minikind(__pyx_v_target_minikind);
  }
  if (__pyx_2) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1075 */
    __pyx_2 = (__pyx_v_self->target_index != 0);
    if (__pyx_2) {
      __pyx_3 = PyInt_FromLong(__pyx_v_self->target_index); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1077; goto __pyx_L1;}
      __pyx_1 = PyNumber_Remainder(__pyx_k59p, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1076; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1076; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
      __pyx_1 = 0;
      __pyx_1 = PyObject_CallObject(PyExc_AssertionError, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1076; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __Pyx_Raise(__pyx_1, 0, 0);
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1076; goto __pyx_L1;}
      goto __pyx_L4;
    }
    __pyx_L4:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1078 */
    __pyx_3 = __Pyx_GetItemInt(__pyx_v_path_info, 4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1078; goto __pyx_L1;}
    __pyx_1 = __Pyx_GetItemInt(__pyx_v_path_info, 3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1078; goto __pyx_L1;}
    __pyx_4 = __pyx_f_19_dirstate_helpers_c__update_entry(__pyx_v_self->state,__pyx_v_entry,__pyx_3,__pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1078; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_v_link_or_sha1);
    __pyx_v_link_or_sha1 = __pyx_4;
    __pyx_4 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1080 */
    __pyx_3 = __Pyx_GetItemInt(__pyx_v_details_list, __pyx_v_self->target_index); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1080; goto __pyx_L1;}
    Py_DECREF(__pyx_v_target_details);
    __pyx_v_target_details = __pyx_3;
    __pyx_3 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1081 */
    __pyx_1 = __Pyx_GetItemInt(__pyx_v_target_details, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1081; goto __pyx_L1;}
    __pyx_v_target_minikind = __pyx_f_19_dirstate_helpers_c__minikind_from_string(__pyx_1);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    goto __pyx_L3;
  }
  /*else*/ {
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_link_or_sha1);
    __pyx_v_link_or_sha1 = Py_None;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1086 */
  __pyx_4 = __Pyx_GetItemInt(__pyx_v_source_details, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1086; goto __pyx_L1;}
  __pyx_v_source_minikind = __pyx_f_19_dirstate_helpers_c__minikind_from_string(__pyx_4);
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1087 */
  __pyx_2 = __pyx_f_19_dirstate_helpers_c__versioned_minikind(__pyx_v_source_minikind);
  if (!__pyx_2) {
    __pyx_2 = (__pyx_v_source_minikind == 'r');
  }
  if (__pyx_2) {
    __pyx_2 = __pyx_f_19_dirstate_helpers_c__versioned_minikind(__pyx_v_target_minikind);
  }
  if (__pyx_2) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1094 */
    __pyx_2 = (__pyx_v_source_minikind != 'r');
    if (__pyx_2) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1095 */
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1095; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1095; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_v_old_dirname);
      __pyx_v_old_dirname = __pyx_1;
      __pyx_1 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1096 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1096; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_4, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1096; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_v_old_basename);
      __pyx_v_old_basename = __pyx_3;
      __pyx_3 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1097 */
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_old_path);
      __pyx_v_old_path = Py_None;
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_path);
      __pyx_v_path = Py_None;
      goto __pyx_L6;
    }
    /*else*/ {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1101 */
      __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1101; goto __pyx_L1;}
      __pyx_4 = PyObject_GetAttr(__pyx_1, __pyx_n_is_inside_any); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1101; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_source_details, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1102; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1101; goto __pyx_L1;}
      Py_INCREF(__pyx_v_self->searched_specific_files);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self->searched_specific_files);
      PyTuple_SET_ITEM(__pyx_1, 1, __pyx_3);
      __pyx_3 = 0;
      __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1101; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_2 = PyObject_IsTrue(__pyx_3); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1101; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_5 = (!__pyx_2);
      if (__pyx_5) {
        __pyx_4 = PyObject_GetAttr(__pyx_v_self->search_specific_files, __pyx_n_add); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1103; goto __pyx_L1;}
        __pyx_1 = __Pyx_GetItemInt(__pyx_v_source_details, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1103; goto __pyx_L1;}
        __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1103; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
        __pyx_1 = 0;
        __pyx_1 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1103; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        goto __pyx_L7;
      }
      __pyx_L7:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1106 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_source_details, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1106; goto __pyx_L1;}
      Py_DECREF(__pyx_v_old_path);
      __pyx_v_old_path = __pyx_4;
      __pyx_4 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1107 */
      __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_os); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1107; goto __pyx_L1;}
      __pyx_1 = PyObject_GetAttr(__pyx_3, __pyx_n_path); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1107; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_4 = PyObject_GetAttr(__pyx_1, __pyx_n_split); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1107; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1107; goto __pyx_L1;}
      Py_INCREF(__pyx_v_old_path);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_old_path);
      __pyx_1 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1107; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_4 = PyObject_GetIter(__pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1107; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_3 = __Pyx_UnpackItem(__pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1107; goto __pyx_L1;}
      Py_DECREF(__pyx_v_old_dirname);
      __pyx_v_old_dirname = __pyx_3;
      __pyx_3 = 0;
      __pyx_1 = __Pyx_UnpackItem(__pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1107; goto __pyx_L1;}
      Py_DECREF(__pyx_v_old_basename);
      __pyx_v_old_basename = __pyx_1;
      __pyx_1 = 0;
      if (__Pyx_EndUnpack(__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1107; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1108 */
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1108; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1108; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1108; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_4, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1108; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1108; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_4, 0, __pyx_1);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_3);
      __pyx_1 = 0;
      __pyx_3 = 0;
      __pyx_1 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1108; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_v_path);
      __pyx_v_path = __pyx_1;
      __pyx_1 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1109 */
      __pyx_3 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__get_entry); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1109; goto __pyx_L1;}
      __pyx_4 = PyInt_FromLong(__pyx_v_self->source_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1109; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1109; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_4);
      __pyx_4 = 0;
      __pyx_4 = PyDict_New(); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1109; goto __pyx_L1;}
      if (PyDict_SetItem(__pyx_4, __pyx_n_path_utf8, __pyx_v_old_path) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1109; goto __pyx_L1;}
      __pyx_6 = PyEval_CallObjectWithKeywords(__pyx_3, __pyx_1, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1109; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_v_old_entry);
      __pyx_v_old_entry = __pyx_6;
      __pyx_6 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1113 */
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1113; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_3, 0, Py_None);
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_3, 1, Py_None);
      if (PyObject_Cmp(__pyx_v_old_entry, __pyx_3, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1113; goto __pyx_L1;}
      __pyx_2 = __pyx_2 == 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      if (__pyx_2) {
        __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1114; goto __pyx_L1;}
        __pyx_4 = PyObject_GetAttr(__pyx_1, __pyx_n_CorruptDirstate); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1114; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        __pyx_6 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__filename); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1114; goto __pyx_L1;}
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1117; goto __pyx_L1;}
        __pyx_1 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1117; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1117; goto __pyx_L1;}
        __pyx_7 = __Pyx_GetItemInt(__pyx_3, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1117; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_3 = PyTuple_New(4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1117; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
        PyTuple_SET_ITEM(__pyx_3, 1, __pyx_7);
        Py_INCREF(__pyx_v_old_path);
        PyTuple_SET_ITEM(__pyx_3, 2, __pyx_v_old_path);
        Py_INCREF(__pyx_v_entry);
        PyTuple_SET_ITEM(__pyx_3, 3, __pyx_v_entry);
        __pyx_1 = 0;
        __pyx_7 = 0;
        __pyx_1 = PyNumber_Remainder(__pyx_k61p, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1117; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1114; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_7, 0, __pyx_6);
        PyTuple_SET_ITEM(__pyx_7, 1, __pyx_1);
        __pyx_6 = 0;
        __pyx_1 = 0;
        __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_7); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1114; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        __Pyx_Raise(__pyx_3, 0, 0);
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1114; goto __pyx_L1;}
        goto __pyx_L8;
      }
      __pyx_L8:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1118 */
      __pyx_6 = __Pyx_GetItemInt(__pyx_v_old_entry, 1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1118; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_6, __pyx_v_self->source_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1118; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      Py_DECREF(__pyx_v_source_details);
      __pyx_v_source_details = __pyx_1;
      __pyx_1 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1119 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_source_details, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1119; goto __pyx_L1;}
      __pyx_v_source_minikind = __pyx_f_19_dirstate_helpers_c__minikind_from_string(__pyx_4);
      Py_DECREF(__pyx_4); __pyx_4 = 0;
    }
    __pyx_L6:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1120 */
    __pyx_5 = __pyx_v_path_info == Py_None;
    if (__pyx_5) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1122 */
      __pyx_v_content_change = 1;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1123 */
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_target_kind);
      __pyx_v_target_kind = Py_None;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1124 */
      Py_INCREF(Py_False);
      Py_DECREF(__pyx_v_target_exec);
      __pyx_v_target_exec = Py_False;
      goto __pyx_L9;
    }
    /*else*/ {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1127 */
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_path_info, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1127; goto __pyx_L1;}
      Py_DECREF(__pyx_v_target_kind);
      __pyx_v_target_kind = __pyx_7;
      __pyx_7 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1128 */
      if (PyObject_Cmp(__pyx_v_target_kind, __pyx_n_directory, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1128; goto __pyx_L1;}
      __pyx_2 = __pyx_2 == 0;
      if (__pyx_2) {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1129 */
        __pyx_5 = __pyx_v_path == Py_None;
        if (__pyx_5) {
          __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1130; goto __pyx_L1;}
          Py_INCREF(__pyx_v_old_dirname);
          PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_old_dirname);
          Py_INCREF(__pyx_v_old_basename);
          PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_old_basename);
          __pyx_6 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_3); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1130; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          Py_INCREF(__pyx_6);
          Py_DECREF(__pyx_v_old_path);
          __pyx_v_old_path = __pyx_6;
          Py_INCREF(__pyx_6);
          Py_DECREF(__pyx_v_path);
          __pyx_v_path = __pyx_6;
          Py_DECREF(__pyx_6); __pyx_6 = 0;
          goto __pyx_L11;
        }
        __pyx_L11:;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1131 */
        __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1131; goto __pyx_L1;}
        __pyx_4 = __Pyx_GetItemInt(__pyx_1, 2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1131; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_v_file_id);
        __pyx_v_file_id = __pyx_4;
        __pyx_4 = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1132 */
        if (PyObject_SetItem(__pyx_v_self->new_dirname_to_file_id, __pyx_v_path, __pyx_v_file_id) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1132; goto __pyx_L1;}

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1133 */
        __pyx_2 = (__pyx_v_source_minikind != 'd');
        if (__pyx_2) {
          __pyx_v_content_change = 1;
          goto __pyx_L12;
        }
        /*else*/ {
          __pyx_v_content_change = 0;
        }
        __pyx_L12:;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1138 */
        Py_INCREF(Py_False);
        Py_DECREF(__pyx_v_target_exec);
        __pyx_v_target_exec = Py_False;
        goto __pyx_L10;
      }
      if (PyObject_Cmp(__pyx_v_target_kind, __pyx_n_file, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1139; goto __pyx_L1;}
      __pyx_5 = __pyx_5 == 0;
      if (__pyx_5) {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1140 */
        __pyx_2 = (__pyx_v_source_minikind != 'f');
        if (__pyx_2) {
          __pyx_v_content_change = 1;
          goto __pyx_L13;
        }
        /*else*/ {

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1146 */
          __pyx_5 = __pyx_v_link_or_sha1 == Py_None;
          if (__pyx_5) {

            /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1149 */
            __pyx_7 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__sha1_provider); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1149; goto __pyx_L1;}
            __pyx_3 = PyObject_GetAttr(__pyx_7, __pyx_n_stat_and_sha1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1149; goto __pyx_L1;}
            Py_DECREF(__pyx_7); __pyx_7 = 0;
            __pyx_6 = __Pyx_GetItemInt(__pyx_v_path_info, 4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1150; goto __pyx_L1;}
            __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1149; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_1, 0, __pyx_6);
            __pyx_6 = 0;
            __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1149; goto __pyx_L1;}
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            Py_DECREF(__pyx_1); __pyx_1 = 0;
            __pyx_7 = PyObject_GetIter(__pyx_4); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1148; goto __pyx_L1;}
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            __pyx_6 = __Pyx_UnpackItem(__pyx_7); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1148; goto __pyx_L1;}
            Py_DECREF(__pyx_v_statvalue);
            __pyx_v_statvalue = __pyx_6;
            __pyx_6 = 0;
            __pyx_3 = __Pyx_UnpackItem(__pyx_7); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1148; goto __pyx_L1;}
            Py_DECREF(__pyx_v_link_or_sha1);
            __pyx_v_link_or_sha1 = __pyx_3;
            __pyx_3 = 0;
            if (__Pyx_EndUnpack(__pyx_7) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1148; goto __pyx_L1;}
            Py_DECREF(__pyx_7); __pyx_7 = 0;

            /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1151 */
            __pyx_1 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__observed_sha1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1151; goto __pyx_L1;}
            __pyx_4 = PyTuple_New(3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1151; goto __pyx_L1;}
            Py_INCREF(__pyx_v_entry);
            PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_entry);
            Py_INCREF(__pyx_v_link_or_sha1);
            PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_link_or_sha1);
            Py_INCREF(__pyx_v_statvalue);
            PyTuple_SET_ITEM(__pyx_4, 2, __pyx_v_statvalue);
            __pyx_6 = PyObject_CallObject(__pyx_1, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1151; goto __pyx_L1;}
            Py_DECREF(__pyx_1); __pyx_1 = 0;
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            Py_DECREF(__pyx_6); __pyx_6 = 0;
            goto __pyx_L14;
          }
          __pyx_L14:;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1153 */
          __pyx_3 = __Pyx_GetItemInt(__pyx_v_source_details, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1153; goto __pyx_L1;}
          if (PyObject_Cmp(__pyx_v_link_or_sha1, __pyx_3, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1153; goto __pyx_L1;}
          __pyx_2 = __pyx_2 != 0;
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          __pyx_v_content_change = __pyx_2;
        }
        __pyx_L13:;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1155 */
        __pyx_5 = PyObject_IsTrue(__pyx_v_self->use_filesystem_for_exec); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1155; goto __pyx_L1;}
        if (__pyx_5) {
          __pyx_7 = PyInt_FromLong(S_IXUSR); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1158; goto __pyx_L1;}
          __pyx_1 = __Pyx_GetItemInt(__pyx_v_path_info, 3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1158; goto __pyx_L1;}
          __pyx_4 = PyObject_GetAttr(__pyx_1, __pyx_n_st_mode); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1158; goto __pyx_L1;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          __pyx_6 = PyNumber_And(__pyx_7, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1158; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __pyx_2 = PyObject_IsTrue(__pyx_6); if (__pyx_2 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1158; goto __pyx_L1;}
          Py_DECREF(__pyx_6); __pyx_6 = 0;
          __pyx_3 = PyInt_FromLong(__pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1158; goto __pyx_L1;}
          Py_DECREF(__pyx_v_target_exec);
          __pyx_v_target_exec = __pyx_3;
          __pyx_3 = 0;
          goto __pyx_L15;
        }
        /*else*/ {
          __pyx_1 = __Pyx_GetItemInt(__pyx_v_target_details, 3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1160; goto __pyx_L1;}
          Py_DECREF(__pyx_v_target_exec);
          __pyx_v_target_exec = __pyx_1;
          __pyx_1 = 0;
        }
        __pyx_L15:;
        goto __pyx_L10;
      }
      if (PyObject_Cmp(__pyx_v_target_kind, __pyx_n_symlink, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1161; goto __pyx_L1;}
      __pyx_5 = __pyx_5 == 0;
      if (__pyx_5) {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1162 */
        __pyx_2 = (__pyx_v_source_minikind != 'l');
        if (__pyx_2) {
          __pyx_v_content_change = 1;
          goto __pyx_L16;
        }
        /*else*/ {
          __pyx_7 = __Pyx_GetItemInt(__pyx_v_source_details, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1165; goto __pyx_L1;}
          if (PyObject_Cmp(__pyx_v_link_or_sha1, __pyx_7, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1165; goto __pyx_L1;}
          __pyx_5 = __pyx_5 != 0;
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          __pyx_v_content_change = __pyx_5;
        }
        __pyx_L16:;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1166 */
        Py_INCREF(Py_False);
        Py_DECREF(__pyx_v_target_exec);
        __pyx_v_target_exec = Py_False;
        goto __pyx_L10;
      }
      if (PyObject_Cmp(__pyx_v_target_kind, __pyx_k65p, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1167; goto __pyx_L1;}
      __pyx_2 = __pyx_2 == 0;
      if (__pyx_2) {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1168 */
        __pyx_5 = (__pyx_v_source_minikind != 't');
        if (__pyx_5) {
          __pyx_v_content_change = 1;
          goto __pyx_L17;
        }
        /*else*/ {
          __pyx_v_content_change = 0;
        }
        __pyx_L17:;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1172 */
        Py_INCREF(Py_False);
        Py_DECREF(__pyx_v_target_exec);
        __pyx_v_target_exec = Py_False;
        goto __pyx_L10;
      }
      /*else*/ {
        __pyx_4 = __Pyx_GetItemInt(__pyx_v_path_info, 2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1174; goto __pyx_L1;}
        __pyx_6 = PyNumber_Remainder(__pyx_k66p, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1174; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        __Pyx_Raise(PyExc_Exception, __pyx_6, 0);
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1174; goto __pyx_L1;}
      }
      __pyx_L10:;
    }
    __pyx_L9:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1175 */
    __pyx_2 = (__pyx_v_source_minikind == 'd');
    if (__pyx_2) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1176 */
      __pyx_5 = __pyx_v_path == Py_None;
      if (__pyx_5) {
        __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1177; goto __pyx_L1;}
        Py_INCREF(__pyx_v_old_dirname);
        PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_old_dirname);
        Py_INCREF(__pyx_v_old_basename);
        PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_old_basename);
        __pyx_1 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1177; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_INCREF(__pyx_1);
        Py_DECREF(__pyx_v_old_path);
        __pyx_v_old_path = __pyx_1;
        Py_INCREF(__pyx_1);
        Py_DECREF(__pyx_v_path);
        __pyx_v_path = __pyx_1;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        goto __pyx_L19;
      }
      __pyx_L19:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1178 */
      __pyx_2 = __pyx_v_file_id == Py_None;
      if (__pyx_2) {
        __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1179; goto __pyx_L1;}
        __pyx_4 = __Pyx_GetItemInt(__pyx_7, 2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1179; goto __pyx_L1;}
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        Py_DECREF(__pyx_v_file_id);
        __pyx_v_file_id = __pyx_4;
        __pyx_4 = 0;
        goto __pyx_L20;
      }
      __pyx_L20:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1180 */
      if (PyObject_SetItem(__pyx_v_self->old_dirname_to_file_id, __pyx_v_old_path, __pyx_v_file_id) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1180; goto __pyx_L1;}
      goto __pyx_L18;
    }
    __pyx_L18:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1182 */
    __pyx_6 = __Pyx_GetItemInt(__pyx_v_self->last_source_parent, 0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1182; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_v_old_dirname, __pyx_6, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1182; goto __pyx_L1;}
    __pyx_5 = __pyx_5 == 0;
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    if (__pyx_5) {
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->last_source_parent, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1183; goto __pyx_L1;}
      Py_DECREF(__pyx_v_source_parent_id);
      __pyx_v_source_parent_id = __pyx_3;
      __pyx_3 = 0;
      goto __pyx_L21;
    }
    /*else*/ {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1185 */
      /*try:*/ {
        __pyx_1 = PyObject_GetItem(__pyx_v_self->old_dirname_to_file_id, __pyx_v_old_dirname); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1186; goto __pyx_L22;}
        Py_DECREF(__pyx_v_source_parent_id);
        __pyx_v_source_parent_id = __pyx_1;
        __pyx_1 = 0;
      }
      goto __pyx_L23;
      __pyx_L22:;
      Py_XDECREF(__pyx_7); __pyx_7 = 0;
      Py_XDECREF(__pyx_4); __pyx_4 = 0;
      Py_XDECREF(__pyx_6); __pyx_6 = 0;
      Py_XDECREF(__pyx_3); __pyx_3 = 0;
      Py_XDECREF(__pyx_1); __pyx_1 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1187 */
      __pyx_2 = PyErr_ExceptionMatches(PyExc_KeyError);
      if (__pyx_2) {
        __Pyx_AddTraceback("_dirstate_helpers_c._process_entry");
        if (__Pyx_GetException(&__pyx_7, &__pyx_4, &__pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1187; goto __pyx_L1;}

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1188 */
        __pyx_3 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__get_entry); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1188; goto __pyx_L1;}
        __pyx_1 = PyInt_FromLong(__pyx_v_self->source_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1188; goto __pyx_L1;}
        __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1188; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_8, 0, __pyx_1);
        __pyx_1 = 0;
        __pyx_1 = PyDict_New(); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1188; goto __pyx_L1;}
        if (PyDict_SetItem(__pyx_1, __pyx_n_path_utf8, __pyx_v_old_dirname) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1188; goto __pyx_L1;}
        __pyx_9 = PyEval_CallObjectWithKeywords(__pyx_3, __pyx_8, __pyx_1); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1188; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_v_source_parent_entry);
        __pyx_v_source_parent_entry = __pyx_9;
        __pyx_9 = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1190 */
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_source_parent_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1190; goto __pyx_L1;}
        __pyx_8 = __Pyx_GetItemInt(__pyx_3, 2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1190; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_DECREF(__pyx_v_source_parent_id);
        __pyx_v_source_parent_id = __pyx_8;
        __pyx_8 = 0;
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        goto __pyx_L23;
      }
      goto __pyx_L1;
      __pyx_L23:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1191 */
      __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1191; goto __pyx_L1;}
      __pyx_9 = __Pyx_GetItemInt(__pyx_1, 2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1191; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      if (PyObject_Cmp(__pyx_v_source_parent_id, __pyx_9, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1191; goto __pyx_L1;}
      __pyx_5 = __pyx_5 == 0;
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      if (__pyx_5) {
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_source_parent_id);
        __pyx_v_source_parent_id = Py_None;
        goto __pyx_L24;
      }
      /*else*/ {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1195 */
        if (__Pyx_SetItemInt(__pyx_v_self->last_source_parent, 0, __pyx_v_old_dirname) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1195; goto __pyx_L1;}

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1196 */
        if (__Pyx_SetItemInt(__pyx_v_self->last_source_parent, 1, __pyx_v_source_parent_id) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1196; goto __pyx_L1;}
      }
      __pyx_L24:;
    }
    __pyx_L21:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1197 */
    __pyx_3 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1197; goto __pyx_L1;}
    __pyx_8 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1197; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_v_new_dirname);
    __pyx_v_new_dirname = __pyx_8;
    __pyx_8 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1198 */
    __pyx_7 = __Pyx_GetItemInt(__pyx_v_self->last_target_parent, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1198; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_v_new_dirname, __pyx_7, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1198; goto __pyx_L1;}
    __pyx_2 = __pyx_2 == 0;
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (__pyx_2) {
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_self->last_target_parent, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1199; goto __pyx_L1;}
      Py_DECREF(__pyx_v_target_parent_id);
      __pyx_v_target_parent_id = __pyx_4;
      __pyx_4 = 0;
      goto __pyx_L25;
    }
    /*else*/ {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1201 */
      /*try:*/ {
        __pyx_6 = PyObject_GetItem(__pyx_v_self->new_dirname_to_file_id, __pyx_v_new_dirname); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1202; goto __pyx_L26;}
        Py_DECREF(__pyx_v_target_parent_id);
        __pyx_v_target_parent_id = __pyx_6;
        __pyx_6 = 0;
      }
      goto __pyx_L27;
      __pyx_L26:;
      Py_XDECREF(__pyx_1); __pyx_1 = 0;
      Py_XDECREF(__pyx_9); __pyx_9 = 0;
      Py_XDECREF(__pyx_3); __pyx_3 = 0;
      Py_XDECREF(__pyx_8); __pyx_8 = 0;
      Py_XDECREF(__pyx_7); __pyx_7 = 0;
      Py_XDECREF(__pyx_4); __pyx_4 = 0;
      Py_XDECREF(__pyx_6); __pyx_6 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1203 */
      __pyx_5 = PyErr_ExceptionMatches(PyExc_KeyError);
      if (__pyx_5) {
        __Pyx_AddTraceback("_dirstate_helpers_c._process_entry");
        if (__Pyx_GetException(&__pyx_1, &__pyx_9, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1203; goto __pyx_L1;}

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1206 */
        __pyx_8 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__get_entry); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1206; goto __pyx_L1;}
        __pyx_7 = PyInt_FromLong(__pyx_v_self->target_index); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1206; goto __pyx_L1;}
        __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1206; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_4, 0, __pyx_7);
        __pyx_7 = 0;
        __pyx_6 = PyDict_New(); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1206; goto __pyx_L1;}
        if (PyDict_SetItem(__pyx_6, __pyx_n_path_utf8, __pyx_v_new_dirname) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1206; goto __pyx_L1;}
        __pyx_7 = PyEval_CallObjectWithKeywords(__pyx_8, __pyx_4, __pyx_6); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1206; goto __pyx_L1;}
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        Py_DECREF(__pyx_v_target_parent_entry);
        __pyx_v_target_parent_entry = __pyx_7;
        __pyx_7 = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1208 */
        __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1208; goto __pyx_L1;}
        Py_INCREF(Py_None);
        PyTuple_SET_ITEM(__pyx_8, 0, Py_None);
        Py_INCREF(Py_None);
        PyTuple_SET_ITEM(__pyx_8, 1, Py_None);
        if (PyObject_Cmp(__pyx_v_target_parent_entry, __pyx_8, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1208; goto __pyx_L1;}
        __pyx_2 = __pyx_2 == 0;
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        if (__pyx_2) {
          __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1211; goto __pyx_L1;}
          Py_INCREF(__pyx_v_new_dirname);
          PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_new_dirname);
          Py_INCREF(__pyx_v_entry);
          PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_entry);
          __pyx_6 = PyNumber_Remainder(__pyx_k69p, __pyx_4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1211; goto __pyx_L1;}
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __pyx_7 = PyTuple_New(1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1209; goto __pyx_L1;}
          PyTuple_SET_ITEM(__pyx_7, 0, __pyx_6);
          __pyx_6 = 0;
          __pyx_8 = PyObject_CallObject(PyExc_AssertionError, __pyx_7); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1209; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          __Pyx_Raise(__pyx_8, 0, 0);
          Py_DECREF(__pyx_8); __pyx_8 = 0;
          {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1209; goto __pyx_L1;}
          goto __pyx_L28;
        }
        __pyx_L28:;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1212 */
        __pyx_4 = __Pyx_GetItemInt(__pyx_v_target_parent_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1212; goto __pyx_L1;}
        __pyx_6 = __Pyx_GetItemInt(__pyx_4, 2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1212; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_v_target_parent_id);
        __pyx_v_target_parent_id = __pyx_6;
        __pyx_6 = 0;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        Py_DECREF(__pyx_9); __pyx_9 = 0;
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        goto __pyx_L27;
      }
      goto __pyx_L1;
      __pyx_L27:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1213 */
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1213; goto __pyx_L1;}
      __pyx_8 = __Pyx_GetItemInt(__pyx_7, 2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1213; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      if (PyObject_Cmp(__pyx_v_target_parent_id, __pyx_8, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1213; goto __pyx_L1;}
      __pyx_5 = __pyx_5 == 0;
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      if (__pyx_5) {
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_target_parent_id);
        __pyx_v_target_parent_id = Py_None;
        goto __pyx_L29;
      }
      /*else*/ {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1217 */
        if (__Pyx_SetItemInt(__pyx_v_self->last_target_parent, 0, __pyx_v_new_dirname) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1217; goto __pyx_L1;}

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1218 */
        if (__Pyx_SetItemInt(__pyx_v_self->last_target_parent, 1, __pyx_v_target_parent_id) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1218; goto __pyx_L1;}
      }
      __pyx_L29:;
    }
    __pyx_L25:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1220 */
    __pyx_4 = __Pyx_GetItemInt(__pyx_v_source_details, 3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1220; goto __pyx_L1;}
    Py_DECREF(__pyx_v_source_exec);
    __pyx_v_source_exec = __pyx_4;
    __pyx_4 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1221 */
    __pyx_6 = __pyx_v_self->include_unchanged;
    Py_INCREF(__pyx_6);
    __pyx_2 = PyObject_IsTrue(__pyx_6); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1222; goto __pyx_L1;}
    if (!__pyx_2) {
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_5 = __pyx_v_content_change;
      if (!__pyx_5) {
        if (PyObject_Cmp(__pyx_v_source_parent_id, __pyx_v_target_parent_id, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1223; goto __pyx_L1;}
        __pyx_5 = __pyx_5 != 0;
        if (!__pyx_5) {
          __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1224; goto __pyx_L1;}
          __pyx_9 = __Pyx_GetItemInt(__pyx_1, 1); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1224; goto __pyx_L1;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          if (PyObject_Cmp(__pyx_v_old_basename, __pyx_9, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1224; goto __pyx_L1;}
          __pyx_5 = __pyx_5 != 0;
          Py_DECREF(__pyx_9); __pyx_9 = 0;
          if (!__pyx_5) {
            if (PyObject_Cmp(__pyx_v_source_exec, __pyx_v_target_exec, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1225; goto __pyx_L1;}
            __pyx_5 = __pyx_5 != 0;
          }
        }
      }
      __pyx_6 = PyInt_FromLong(__pyx_5); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1223; goto __pyx_L1;}
    }
    __pyx_2 = PyObject_IsTrue(__pyx_6); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1222; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    if (__pyx_2) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1227 */
      __pyx_5 = __pyx_v_old_path == Py_None;
      if (__pyx_5) {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1228 */
        __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1228; goto __pyx_L1;}
        Py_INCREF(__pyx_v_old_dirname);
        PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_old_dirname);
        Py_INCREF(__pyx_v_old_basename);
        PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_old_basename);
        __pyx_7 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_3); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1228; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_DECREF(__pyx_v_path);
        __pyx_v_path = __pyx_7;
        __pyx_7 = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1229 */
        Py_INCREF(__pyx_v_path);
        Py_DECREF(__pyx_v_old_path);
        __pyx_v_old_path = __pyx_v_path;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1230 */
        __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1230; goto __pyx_L1;}
        Py_INCREF(__pyx_v_old_path);
        PyTuple_SET_ITEM(__pyx_8, 0, __pyx_v_old_path);
        __pyx_4 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_8); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1230; goto __pyx_L1;}
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        __pyx_1 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1230; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        Py_DECREF(__pyx_v_old_path_u);
        __pyx_v_old_path_u = __pyx_1;
        __pyx_1 = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1231 */
        Py_INCREF(__pyx_v_old_path_u);
        Py_DECREF(__pyx_v_path_u);
        __pyx_v_path_u = __pyx_v_old_path_u;
        goto __pyx_L31;
      }
      /*else*/ {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1233 */
        __pyx_9 = PyTuple_New(1); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1233; goto __pyx_L1;}
        Py_INCREF(__pyx_v_old_path);
        PyTuple_SET_ITEM(__pyx_9, 0, __pyx_v_old_path);
        __pyx_6 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_9); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1233; goto __pyx_L1;}
        Py_DECREF(__pyx_9); __pyx_9 = 0;
        __pyx_3 = __Pyx_GetItemInt(__pyx_6, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1233; goto __pyx_L1;}
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        Py_DECREF(__pyx_v_old_path_u);
        __pyx_v_old_path_u = __pyx_3;
        __pyx_3 = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1234 */
        if (PyObject_Cmp(__pyx_v_old_path, __pyx_v_path, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1234; goto __pyx_L1;}
        __pyx_2 = __pyx_2 == 0;
        if (__pyx_2) {
          Py_INCREF(__pyx_v_old_path_u);
          Py_DECREF(__pyx_v_path_u);
          __pyx_v_path_u = __pyx_v_old_path_u;
          goto __pyx_L32;
        }
        /*else*/ {
          __pyx_7 = PyTuple_New(1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1237; goto __pyx_L1;}
          Py_INCREF(__pyx_v_path);
          PyTuple_SET_ITEM(__pyx_7, 0, __pyx_v_path);
          __pyx_8 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_7); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1237; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          __pyx_4 = __Pyx_GetItemInt(__pyx_8, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1237; goto __pyx_L1;}
          Py_DECREF(__pyx_8); __pyx_8 = 0;
          Py_DECREF(__pyx_v_path_u);
          __pyx_v_path_u = __pyx_4;
          __pyx_4 = 0;
        }
        __pyx_L32:;
      }
      __pyx_L31:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1238 */
      __pyx_1 = __pyx_f_19_dirstate_helpers_c__minikind_to_kind(__pyx_v_source_minikind); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1238; goto __pyx_L1;}
      Py_DECREF(__pyx_v_source_kind);
      __pyx_v_source_kind = __pyx_1;
      __pyx_1 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1239 */
      __pyx_9 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1239; goto __pyx_L1;}
      __pyx_6 = __Pyx_GetItemInt(__pyx_9, 2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1239; goto __pyx_L1;}
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1240; goto __pyx_L1;}
      Py_INCREF(__pyx_v_old_path_u);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_old_path_u);
      Py_INCREF(__pyx_v_path_u);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_path_u);
      __pyx_7 = PyInt_FromLong(__pyx_v_content_change); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1241; goto __pyx_L1;}
      __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1242; goto __pyx_L1;}
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_8, 0, Py_True);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_8, 1, Py_True);
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1243; goto __pyx_L1;}
      Py_INCREF(__pyx_v_source_parent_id);
      PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_source_parent_id);
      Py_INCREF(__pyx_v_target_parent_id);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_target_parent_id);
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
      Py_INCREF(__pyx_v_old_basename);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_old_basename);
      __pyx_9 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_1); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_1 = __Pyx_GetItemInt(__pyx_9, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      __pyx_9 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
      __pyx_10 = __Pyx_GetItemInt(__pyx_9, 1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      __pyx_9 = PyTuple_New(1); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_9, 0, __pyx_10);
      __pyx_10 = 0;
      __pyx_10 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_9); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      __pyx_9 = __Pyx_GetItemInt(__pyx_10, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
      Py_DECREF(__pyx_10); __pyx_10 = 0;
      __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1244; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_10, 0, __pyx_1);
      PyTuple_SET_ITEM(__pyx_10, 1, __pyx_9);
      __pyx_1 = 0;
      __pyx_9 = 0;
      __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1245; goto __pyx_L1;}
      Py_INCREF(__pyx_v_source_kind);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_source_kind);
      Py_INCREF(__pyx_v_target_kind);
      PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_target_kind);
      __pyx_9 = PyTuple_New(2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1246; goto __pyx_L1;}
      Py_INCREF(__pyx_v_source_exec);
      PyTuple_SET_ITEM(__pyx_9, 0, __pyx_v_source_exec);
      Py_INCREF(__pyx_v_target_exec);
      PyTuple_SET_ITEM(__pyx_9, 1, __pyx_v_target_exec);
      __pyx_11 = PyTuple_New(8); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1239; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_11, 0, __pyx_6);
      PyTuple_SET_ITEM(__pyx_11, 1, __pyx_3);
      PyTuple_SET_ITEM(__pyx_11, 2, __pyx_7);
      PyTuple_SET_ITEM(__pyx_11, 3, __pyx_8);
      PyTuple_SET_ITEM(__pyx_11, 4, __pyx_4);
      PyTuple_SET_ITEM(__pyx_11, 5, __pyx_10);
      PyTuple_SET_ITEM(__pyx_11, 6, __pyx_1);
      PyTuple_SET_ITEM(__pyx_11, 7, __pyx_9);
      __pyx_6 = 0;
      __pyx_3 = 0;
      __pyx_7 = 0;
      __pyx_8 = 0;
      __pyx_4 = 0;
      __pyx_10 = 0;
      __pyx_1 = 0;
      __pyx_9 = 0;
      __pyx_r = __pyx_11;
      __pyx_11 = 0;
      goto __pyx_L0;
      goto __pyx_L30;
    }
    /*else*/ {
      Py_INCREF(__pyx_v_self->uninteresting);
      __pyx_r = __pyx_v_self->uninteresting;
      goto __pyx_L0;
    }
    __pyx_L30:;
    goto __pyx_L5;
  }
  __pyx_5 = (__pyx_v_source_minikind == 'a');
  if (__pyx_5) {
    __pyx_5 = __pyx_f_19_dirstate_helpers_c__versioned_minikind(__pyx_v_target_minikind);
  }
  if (__pyx_5) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1251 */
    __pyx_6 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1251; goto __pyx_L1;}
    __pyx_3 = __Pyx_GetItemInt(__pyx_6, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1251; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1251; goto __pyx_L1;}
    __pyx_8 = __Pyx_GetItemInt(__pyx_7, 1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1251; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1251; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
    PyTuple_SET_ITEM(__pyx_4, 1, __pyx_8);
    __pyx_3 = 0;
    __pyx_8 = 0;
    __pyx_10 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_4); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1251; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_v_path);
    __pyx_v_path = __pyx_10;
    __pyx_10 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1254 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__get_entry); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1254; goto __pyx_L1;}
    __pyx_9 = PyInt_FromLong(__pyx_v_self->target_index); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1254; goto __pyx_L1;}
    __pyx_11 = PyTuple_New(1); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1254; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_11, 0, __pyx_9);
    __pyx_9 = 0;
    __pyx_6 = PyDict_New(); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1254; goto __pyx_L1;}
    __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1255; goto __pyx_L1;}
    __pyx_3 = __Pyx_GetItemInt(__pyx_7, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1255; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (PyDict_SetItem(__pyx_6, __pyx_n_path_utf8, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1254; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_8 = PyEval_CallObjectWithKeywords(__pyx_1, __pyx_11, __pyx_6); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1254; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_11); __pyx_11 = 0;
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(__pyx_v_parent_entry);
    __pyx_v_parent_entry = __pyx_8;
    __pyx_8 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1256 */
    __pyx_2 = __pyx_v_parent_entry == Py_None;
    if (__pyx_2) {
      __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1257; goto __pyx_L1;}
      __pyx_10 = PyObject_GetAttr(__pyx_4, __pyx_n_DirstateCorrupt); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1257; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_9 = PyInt_FromLong(__pyx_v_self->target_index); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1260; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1260; goto __pyx_L1;}
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1260; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_9);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_7);
      __pyx_9 = 0;
      __pyx_7 = 0;
      __pyx_1 = PyNumber_Remainder(__pyx_k71p, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1260; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1257; goto __pyx_L1;}
      Py_INCREF(__pyx_v_self->state);
      PyTuple_SET_ITEM(__pyx_11, 0, __pyx_v_self->state);
      PyTuple_SET_ITEM(__pyx_11, 1, __pyx_1);
      __pyx_1 = 0;
      __pyx_6 = PyObject_CallObject(__pyx_10, __pyx_11); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1257; goto __pyx_L1;}
      Py_DECREF(__pyx_10); __pyx_10 = 0;
      Py_DECREF(__pyx_11); __pyx_11 = 0;
      __Pyx_Raise(__pyx_6, 0, 0);
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1257; goto __pyx_L1;}
      goto __pyx_L33;
    }
    __pyx_L33:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1261 */
    __pyx_8 = __Pyx_GetItemInt(__pyx_v_parent_entry, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1261; goto __pyx_L1;}
    __pyx_4 = __Pyx_GetItemInt(__pyx_8, 2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1261; goto __pyx_L1;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;
    Py_DECREF(__pyx_v_parent_id);
    __pyx_v_parent_id = __pyx_4;
    __pyx_4 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1262 */
    __pyx_9 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1262; goto __pyx_L1;}
    __pyx_7 = __Pyx_GetItemInt(__pyx_9, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1262; goto __pyx_L1;}
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    if (PyObject_Cmp(__pyx_v_parent_id, __pyx_7, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1262; goto __pyx_L1;}
    __pyx_5 = __pyx_5 == 0;
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (__pyx_5) {
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_parent_id);
      __pyx_v_parent_id = Py_None;
      goto __pyx_L34;
    }
    __pyx_L34:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1264 */
    __pyx_2 = __pyx_v_path_info != Py_None;
    if (__pyx_2) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1266 */
      __pyx_5 = PyObject_IsTrue(__pyx_v_self->use_filesystem_for_exec); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1266; goto __pyx_L1;}
      if (__pyx_5) {
        __pyx_1 = __Pyx_GetItemInt(__pyx_v_path_info, 3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1270; goto __pyx_L1;}
        __pyx_10 = PyObject_GetAttr(__pyx_1, __pyx_n_st_mode); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1270; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        __pyx_2 = PyInt_AsLong(__pyx_10); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1270; goto __pyx_L1;}
        Py_DECREF(__pyx_10); __pyx_10 = 0;
        __pyx_3 = PyInt_FromLong(S_ISREG(__pyx_2)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1270; goto __pyx_L1;}
        __pyx_5 = PyObject_IsTrue(__pyx_3); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1271; goto __pyx_L1;}
        if (__pyx_5) {
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          __pyx_11 = PyInt_FromLong(S_IXUSR); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1271; goto __pyx_L1;}
          __pyx_6 = __Pyx_GetItemInt(__pyx_v_path_info, 3); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1271; goto __pyx_L1;}
          __pyx_8 = PyObject_GetAttr(__pyx_6, __pyx_n_st_mode); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1271; goto __pyx_L1;}
          Py_DECREF(__pyx_6); __pyx_6 = 0;
          __pyx_3 = PyNumber_And(__pyx_11, __pyx_8); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1271; goto __pyx_L1;}
          Py_DECREF(__pyx_11); __pyx_11 = 0;
          Py_DECREF(__pyx_8); __pyx_8 = 0;
        }
        __pyx_2 = PyObject_IsTrue(__pyx_3); if (__pyx_2 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1269; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_4 = PyInt_FromLong(__pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1269; goto __pyx_L1;}
        Py_DECREF(__pyx_v_target_exec);
        __pyx_v_target_exec = __pyx_4;
        __pyx_4 = 0;
        goto __pyx_L36;
      }
      /*else*/ {
        __pyx_9 = __Pyx_GetItemInt(__pyx_v_target_details, 3); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1273; goto __pyx_L1;}
        Py_DECREF(__pyx_v_target_exec);
        __pyx_v_target_exec = __pyx_9;
        __pyx_9 = 0;
      }
      __pyx_L36:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1274 */
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1274; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_7, 2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1274; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_10 = PyTuple_New(1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1275; goto __pyx_L1;}
      Py_INCREF(__pyx_v_path);
      PyTuple_SET_ITEM(__pyx_10, 0, __pyx_v_path);
      __pyx_6 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_10); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1275; goto __pyx_L1;}
      Py_DECREF(__pyx_10); __pyx_10 = 0;
      __pyx_11 = __Pyx_GetItemInt(__pyx_6, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1275; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1275; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_8, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_8, 1, __pyx_11);
      __pyx_11 = 0;
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1277; goto __pyx_L1;}
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_3, 0, Py_False);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_3, 1, Py_True);
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1278; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_4, 0, Py_None);
      Py_INCREF(__pyx_v_parent_id);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_parent_id);
      __pyx_9 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetItemInt(__pyx_9, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      __pyx_10 = PyTuple_New(1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_10, 0, __pyx_7);
      __pyx_7 = 0;
      __pyx_6 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_10); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      Py_DECREF(__pyx_10); __pyx_10 = 0;
      __pyx_11 = __Pyx_GetItemInt(__pyx_6, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_9 = PyTuple_New(2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1279; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_9, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_9, 1, __pyx_11);
      __pyx_11 = 0;
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_path_info, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1280; goto __pyx_L1;}
      __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1280; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_10, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_10, 1, __pyx_7);
      __pyx_7 = 0;
      __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1281; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_6, 0, Py_None);
      Py_INCREF(__pyx_v_target_exec);
      PyTuple_SET_ITEM(__pyx_6, 1, __pyx_v_target_exec);
      __pyx_11 = PyTuple_New(8); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1274; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_11, 0, __pyx_1);
      PyTuple_SET_ITEM(__pyx_11, 1, __pyx_8);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_11, 2, Py_True);
      PyTuple_SET_ITEM(__pyx_11, 3, __pyx_3);
      PyTuple_SET_ITEM(__pyx_11, 4, __pyx_4);
      PyTuple_SET_ITEM(__pyx_11, 5, __pyx_9);
      PyTuple_SET_ITEM(__pyx_11, 6, __pyx_10);
      PyTuple_SET_ITEM(__pyx_11, 7, __pyx_6);
      __pyx_1 = 0;
      __pyx_8 = 0;
      __pyx_3 = 0;
      __pyx_4 = 0;
      __pyx_9 = 0;
      __pyx_10 = 0;
      __pyx_6 = 0;
      __pyx_r = __pyx_11;
      __pyx_11 = 0;
      goto __pyx_L0;
      goto __pyx_L35;
    }
    /*else*/ {
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1284; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetItemInt(__pyx_7, 2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1284; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1285; goto __pyx_L1;}
      Py_INCREF(__pyx_v_path);
      PyTuple_SET_ITEM(__pyx_8, 0, __pyx_v_path);
      __pyx_3 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_8); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1285; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_4 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1285; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_9 = PyTuple_New(2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1285; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_9, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_9, 1, __pyx_4);
      __pyx_4 = 0;
      __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1287; goto __pyx_L1;}
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_10, 0, Py_False);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_10, 1, Py_True);
      __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1288; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_6, 0, Py_None);
      Py_INCREF(__pyx_v_parent_id);
      PyTuple_SET_ITEM(__pyx_6, 1, __pyx_v_parent_id);
      __pyx_11 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1289; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetItemInt(__pyx_11, 1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1289; goto __pyx_L1;}
      Py_DECREF(__pyx_11); __pyx_11 = 0;
      __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1289; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_8, 0, __pyx_7);
      __pyx_7 = 0;
      __pyx_3 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_8); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1289; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_4 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1289; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1289; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_11, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_11, 1, __pyx_4);
      __pyx_4 = 0;
      __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1290; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_7, 0, Py_None);
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_7, 1, Py_None);
      __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1291; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_8, 0, Py_None);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_8, 1, Py_False);
      __pyx_3 = PyTuple_New(8); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1284; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_9);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_3, 2, Py_False);
      PyTuple_SET_ITEM(__pyx_3, 3, __pyx_10);
      PyTuple_SET_ITEM(__pyx_3, 4, __pyx_6);
      PyTuple_SET_ITEM(__pyx_3, 5, __pyx_11);
      PyTuple_SET_ITEM(__pyx_3, 6, __pyx_7);
      PyTuple_SET_ITEM(__pyx_3, 7, __pyx_8);
      __pyx_1 = 0;
      __pyx_9 = 0;
      __pyx_10 = 0;
      __pyx_6 = 0;
      __pyx_11 = 0;
      __pyx_7 = 0;
      __pyx_8 = 0;
      __pyx_r = __pyx_3;
      __pyx_3 = 0;
      goto __pyx_L0;
    }
    __pyx_L35:;
    goto __pyx_L5;
  }
  __pyx_5 = __pyx_f_19_dirstate_helpers_c__versioned_minikind(__pyx_v_source_minikind);
  if (__pyx_5) {
    __pyx_5 = (__pyx_v_target_minikind == 'a');
  }
  if (__pyx_5) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1297 */
    __pyx_4 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1297; goto __pyx_L1;}
    __pyx_1 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1297; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_9 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1297; goto __pyx_L1;}
    __pyx_10 = __Pyx_GetItemInt(__pyx_9, 1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1297; goto __pyx_L1;}
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1297; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_1);
    PyTuple_SET_ITEM(__pyx_6, 1, __pyx_10);
    __pyx_1 = 0;
    __pyx_10 = 0;
    __pyx_11 = PyObject_CallObject(__pyx_v_self->pathjoin, __pyx_6); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1297; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(__pyx_v_old_path);
    __pyx_v_old_path = __pyx_11;
    __pyx_11 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1299 */
    __pyx_7 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__get_entry); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
    __pyx_8 = PyInt_FromLong(__pyx_v_self->source_index); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_8);
    __pyx_8 = 0;
    __pyx_4 = PyDict_New(); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
    __pyx_9 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
    __pyx_1 = __Pyx_GetItemInt(__pyx_9, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    if (PyDict_SetItem(__pyx_4, __pyx_n_path_utf8, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_10 = PyEval_CallObjectWithKeywords(__pyx_7, __pyx_3, __pyx_4); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_6 = __Pyx_GetItemInt(__pyx_10, 0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
    Py_DECREF(__pyx_10); __pyx_10 = 0;
    __pyx_11 = __Pyx_GetItemInt(__pyx_6, 2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1299; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(__pyx_v_parent_id);
    __pyx_v_parent_id = __pyx_11;
    __pyx_11 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1300 */
    __pyx_8 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1300; goto __pyx_L1;}
    __pyx_9 = __Pyx_GetItemInt(__pyx_8, 2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1300; goto __pyx_L1;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;
    if (PyObject_Cmp(__pyx_v_parent_id, __pyx_9, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1300; goto __pyx_L1;}
    __pyx_2 = __pyx_2 == 0;
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    if (__pyx_2) {
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_parent_id);
      __pyx_v_parent_id = Py_None;
      goto __pyx_L37;
    }
    __pyx_L37:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1302 */
    __pyx_1 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1302; goto __pyx_L1;}
    __pyx_7 = __Pyx_GetItemInt(__pyx_1, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1302; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1303; goto __pyx_L1;}
    Py_INCREF(__pyx_v_old_path);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_old_path);
    __pyx_4 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1303; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_10 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1303; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1303; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_10);
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM(__pyx_6, 1, Py_None);
    __pyx_10 = 0;
    __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1305; goto __pyx_L1;}
    Py_INCREF(Py_True);
    PyTuple_SET_ITEM(__pyx_11, 0, Py_True);
    Py_INCREF(Py_False);
    PyTuple_SET_ITEM(__pyx_11, 1, Py_False);
    __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1306; goto __pyx_L1;}
    Py_INCREF(__pyx_v_parent_id);
    PyTuple_SET_ITEM(__pyx_8, 0, __pyx_v_parent_id);
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM(__pyx_8, 1, Py_None);
    __pyx_9 = __Pyx_GetItemInt(__pyx_v_entry, 0); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1307; goto __pyx_L1;}
    __pyx_1 = __Pyx_GetItemInt(__pyx_9, 1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1307; goto __pyx_L1;}
    Py_DECREF(__pyx_9); __pyx_9 = 0;
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1307; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
    __pyx_1 = 0;
    __pyx_4 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1307; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_10 = __Pyx_GetItemInt(__pyx_4, 0); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1307; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_9 = PyTuple_New(2); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1307; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_9, 0, __pyx_10);
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM(__pyx_9, 1, Py_None);
    __pyx_10 = 0;
    __pyx_1 = __pyx_f_19_dirstate_helpers_c__minikind_to_kind(__pyx_v_source_minikind); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1308; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1308; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM(__pyx_3, 1, Py_None);
    __pyx_1 = 0;
    __pyx_4 = __Pyx_GetItemInt(__pyx_v_source_details, 3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1309; goto __pyx_L1;}
    __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1309; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_10, 0, __pyx_4);
    Py_INCREF(Py_None);
    PyTuple_SET_ITEM(__pyx_10, 1, Py_None);
    __pyx_4 = 0;
    __pyx_1 = PyTuple_New(8); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1302; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_7);
    PyTuple_SET_ITEM(__pyx_1, 1, __pyx_6);
    Py_INCREF(Py_True);
    PyTuple_SET_ITEM(__pyx_1, 2, Py_True);
    PyTuple_SET_ITEM(__pyx_1, 3, __pyx_11);
    PyTuple_SET_ITEM(__pyx_1, 4, __pyx_8);
    PyTuple_SET_ITEM(__pyx_1, 5, __pyx_9);
    PyTuple_SET_ITEM(__pyx_1, 6, __pyx_3);
    PyTuple_SET_ITEM(__pyx_1, 7, __pyx_10);
    __pyx_7 = 0;
    __pyx_6 = 0;
    __pyx_11 = 0;
    __pyx_8 = 0;
    __pyx_9 = 0;
    __pyx_3 = 0;
    __pyx_10 = 0;
    __pyx_r = __pyx_1;
    __pyx_1 = 0;
    goto __pyx_L0;
    goto __pyx_L5;
  }
  __pyx_5 = __pyx_f_19_dirstate_helpers_c__versioned_minikind(__pyx_v_source_minikind);
  if (__pyx_5) {
    __pyx_5 = (__pyx_v_target_minikind == 'r');
  }
  if (__pyx_5) {
    __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1315; goto __pyx_L1;}
    __pyx_7 = PyObject_GetAttr(__pyx_4, __pyx_n_is_inside_any); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1315; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_6 = __Pyx_GetItemInt(__pyx_v_target_details, 1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1315; goto __pyx_L1;}
    __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1315; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->searched_specific_files);
    PyTuple_SET_ITEM(__pyx_11, 0, __pyx_v_self->searched_specific_files);
    PyTuple_SET_ITEM(__pyx_11, 1, __pyx_6);
    __pyx_6 = 0;
    __pyx_8 = PyObject_CallObject(__pyx_7, __pyx_11); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1315; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    Py_DECREF(__pyx_11); __pyx_11 = 0;
    __pyx_2 = PyObject_IsTrue(__pyx_8); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1315; goto __pyx_L1;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;
    __pyx_5 = (!__pyx_2);
    if (__pyx_5) {
      __pyx_9 = PyObject_GetAttr(__pyx_v_self->search_specific_files, __pyx_n_add); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1316; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_target_details, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1316; goto __pyx_L1;}
      __pyx_10 = PyTuple_New(1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1316; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_10, 0, __pyx_3);
      __pyx_3 = 0;
      __pyx_1 = PyObject_CallObject(__pyx_9, __pyx_10); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1316; goto __pyx_L1;}
      Py_DECREF(__pyx_9); __pyx_9 = 0;
      Py_DECREF(__pyx_10); __pyx_10 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      goto __pyx_L38;
    }
    __pyx_L38:;
    goto __pyx_L5;
  }
  __pyx_2 = (__pyx_v_source_minikind == 'r');
  if (!__pyx_2) {
    __pyx_2 = (__pyx_v_source_minikind == 'a');
  }
  if (__pyx_2) {
    __pyx_2 = (__pyx_v_target_minikind == 'r');
    if (!__pyx_2) {
      __pyx_2 = (__pyx_v_target_minikind == 'a');
    }
  }
  if (__pyx_2) {
    goto __pyx_L5;
  }
  /*else*/ {
    __pyx_4 = PyInt_FromLong(__pyx_v_source_minikind); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1326; goto __pyx_L1;}
    __pyx_6 = PyInt_FromLong(__pyx_v_target_minikind); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1326; goto __pyx_L1;}
    __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1326; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_7, 0, __pyx_4);
    PyTuple_SET_ITEM(__pyx_7, 1, __pyx_6);
    __pyx_4 = 0;
    __pyx_6 = 0;
    __pyx_11 = PyNumber_Remainder(__pyx_k73p, __pyx_7); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1326; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1324; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_8, 0, __pyx_11);
    __pyx_11 = 0;
    __pyx_3 = PyObject_CallObject(PyExc_AssertionError, __pyx_8); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1324; goto __pyx_L1;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1324; goto __pyx_L1;}
  }
  __pyx_L5:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1328 */
  Py_INCREF(Py_None);
  __pyx_r = Py_None;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_6);
  Py_XDECREF(__pyx_7);
  Py_XDECREF(__pyx_8);
  Py_XDECREF(__pyx_9);
  Py_XDECREF(__pyx_10);
  Py_XDECREF(__pyx_11);
  __Pyx_AddTraceback("_dirstate_helpers_c.ProcessEntryC._process_entry");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_file_id);
  Py_DECREF(__pyx_v_details_list);
  Py_DECREF(__pyx_v_source_details);
  Py_DECREF(__pyx_v_target_details);
  Py_DECREF(__pyx_v_link_or_sha1);
  Py_DECREF(__pyx_v_old_dirname);
  Py_DECREF(__pyx_v_old_basename);
  Py_DECREF(__pyx_v_old_path);
  Py_DECREF(__pyx_v_path);
  Py_DECREF(__pyx_v_old_entry);
  Py_DECREF(__pyx_v_target_kind);
  Py_DECREF(__pyx_v_target_exec);
  Py_DECREF(__pyx_v_statvalue);
  Py_DECREF(__pyx_v_source_parent_id);
  Py_DECREF(__pyx_v_source_parent_entry);
  Py_DECREF(__pyx_v_new_dirname);
  Py_DECREF(__pyx_v_target_parent_id);
  Py_DECREF(__pyx_v_target_parent_entry);
  Py_DECREF(__pyx_v_source_exec);
  Py_DECREF(__pyx_v_old_path_u);
  Py_DECREF(__pyx_v_path_u);
  Py_DECREF(__pyx_v_source_kind);
  Py_DECREF(__pyx_v_parent_entry);
  Py_DECREF(__pyx_v_parent_id);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_path_info);
  return __pyx_r;
}

static PyObject *__pyx_f_19_dirstate_helpers_c_13ProcessEntryC___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_19_dirstate_helpers_c_13ProcessEntryC___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_f_19_dirstate_helpers_c_13ProcessEntryC_iter_changes(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_f_19_dirstate_helpers_c_13ProcessEntryC_iter_changes(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n_is_inside;

static void __pyx_f_19_dirstate_helpers_c_13ProcessEntryC__update_current_block(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *__pyx_v_self) {
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_ssize_t __pyx_3;
  int __pyx_4;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_2 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__dirblocks); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1337; goto __pyx_L1;}
  __pyx_3 = PyObject_Length(__pyx_2); if (__pyx_3 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1337; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = PyInt_FromLong((__pyx_v_self->block_index < __pyx_3)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1337; goto __pyx_L1;}
  __pyx_4 = PyObject_IsTrue(__pyx_1); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1337; goto __pyx_L1;}
  if (__pyx_4) {
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1338; goto __pyx_L1;}
    __pyx_5 = PyObject_GetAttr(__pyx_2, __pyx_n_is_inside); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1338; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__dirblocks); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1338; goto __pyx_L1;}
    __pyx_6 = __Pyx_GetItemInt(__pyx_2, __pyx_v_self->block_index); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1338; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = __Pyx_GetItemInt(__pyx_6, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1338; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1338; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->current_root);
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_v_self->current_root);
    PyTuple_SET_ITEM(__pyx_6, 1, __pyx_2);
    __pyx_2 = 0;
    __pyx_1 = PyObject_CallObject(__pyx_5, __pyx_6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1338; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    Py_DECREF(__pyx_6); __pyx_6 = 0;
  }
  __pyx_4 = PyObject_IsTrue(__pyx_1); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1337; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_4) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1339 */
    __pyx_2 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__dirblocks); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1339; goto __pyx_L1;}
    __pyx_5 = __Pyx_GetItemInt(__pyx_2, __pyx_v_self->block_index); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1339; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_v_self->current_block);
    __pyx_v_self->current_block = __pyx_5;
    __pyx_5 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1340 */
    __pyx_6 = __Pyx_GetItemInt(__pyx_v_self->current_block, 1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1340; goto __pyx_L1;}
    Py_DECREF(__pyx_v_self->current_block_list);
    __pyx_v_self->current_block_list = __pyx_6;
    __pyx_6 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1341 */
    __pyx_v_self->current_block_pos = 0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1343 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_self->current_block);
    __pyx_v_self->current_block = Py_None;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1344 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_self->current_block_list);
    __pyx_v_self->current_block_list = Py_None;
  }
  __pyx_L2:;

  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  __Pyx_WriteUnraisable("_dirstate_helpers_c.ProcessEntryC._update_current_block");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}

static PyObject *__pyx_f_19_dirstate_helpers_c_13ProcessEntryC___next__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_19_dirstate_helpers_c_13ProcessEntryC___next__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_1 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)->__pyx_vtab)->_iter_next(((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1348; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("_dirstate_helpers_c.ProcessEntryC.__next__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n_pop;
static PyObject *__pyx_n_decode;
static PyObject *__pyx_n_utf8;
static PyObject *__pyx_n__entries_for_path;
static PyObject *__pyx_n_abspath;
static PyObject *__pyx_n_lstat;
static PyObject *__pyx_n_ENOENT;
static PyObject *__pyx_n_file_kind_from_stat_mode;
static PyObject *__pyx_n__directory_is_tree_reference;
static PyObject *__pyx_n_S_ISREG;
static PyObject *__pyx_n_S_IEXEC;
static PyObject *__pyx_n__walkdirs_utf8;
static PyObject *__pyx_n_prefix;
static PyObject *__pyx_n_next;
static PyObject *__pyx_n_ENOTDIR;
static PyObject *__pyx_n_EINVAL;
static PyObject *__pyx_n_platform;
static PyObject *__pyx_n_win32;
static PyObject *__pyx_n_winerror;
static PyObject *__pyx_n_AttributeError;
static PyObject *__pyx_n__find_block_index_from_key;

static PyObject *__pyx_k75p;
static PyObject *__pyx_k77p;
static PyObject *__pyx_k78p;
static PyObject *__pyx_k81p;
static PyObject *__pyx_k82p;
static PyObject *__pyx_k83p;
static PyObject *__pyx_k84p;
static PyObject *__pyx_k85p;
static PyObject *__pyx_k87p;
static PyObject *__pyx_k89p;

static char __pyx_k75[] = "";
static char __pyx_k77[] = "tree-reference";
static char __pyx_k78[] = "tree-reference";
static char __pyx_k81[] = "";
static char __pyx_k82[] = ".bzr";
static char __pyx_k83[] = ".bzr";
static char __pyx_k84[] = "";
static char __pyx_k85[] = "";
static char __pyx_k87[] = "tree-reference";
static char __pyx_k89[] = "tree-reference";

static PyObject *__pyx_f_19_dirstate_helpers_c_13ProcessEntryC__iter_next(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *__pyx_v_self) {
  PyObject *__pyx_v_current_dirname;
  PyObject *__pyx_v_current_blockname;
  char *__pyx_v_current_dirname_c;
  char *__pyx_v_current_blockname_c;
  int __pyx_v_path_handled;
  PyObject *__pyx_v_uninteresting;
  PyObject *__pyx_v_searched_specific_files;
  PyObject *__pyx_v_entry;
  PyObject *__pyx_v_result;
  PyObject *__pyx_v_root_stat;
  PyObject *__pyx_v_e;
  PyObject *__pyx_v_new_executable;
  PyObject *__pyx_v_e_winerror;
  PyObject *__pyx_v_win_errors;
  PyObject *__pyx_v_bzr_index;
  PyObject *__pyx_v_initial_key;
  PyObject *__pyx_v__;
  PyObject *__pyx_v_current_path_info;
  PyObject *__pyx_v_current_entry;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  Py_ssize_t __pyx_6;
  PyObject *__pyx_7 = 0;
  PyObject *__pyx_8 = 0;
  int __pyx_9;
  PyObject *__pyx_10 = 0;
  PyObject *__pyx_11 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_current_dirname = Py_None; Py_INCREF(Py_None);
  __pyx_v_current_blockname = Py_None; Py_INCREF(Py_None);
  __pyx_v_uninteresting = Py_None; Py_INCREF(Py_None);
  __pyx_v_searched_specific_files = Py_None; Py_INCREF(Py_None);
  __pyx_v_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_result = Py_None; Py_INCREF(Py_None);
  __pyx_v_root_stat = Py_None; Py_INCREF(Py_None);
  __pyx_v_e = Py_None; Py_INCREF(Py_None);
  __pyx_v_new_executable = Py_None; Py_INCREF(Py_None);
  __pyx_v_e_winerror = Py_None; Py_INCREF(Py_None);
  __pyx_v_win_errors = Py_None; Py_INCREF(Py_None);
  __pyx_v_bzr_index = Py_None; Py_INCREF(Py_None);
  __pyx_v_initial_key = Py_None; Py_INCREF(Py_None);
  __pyx_v__ = Py_None; Py_INCREF(Py_None);
  __pyx_v_current_path_info = Py_None; Py_INCREF(Py_None);
  __pyx_v_current_entry = Py_None; Py_INCREF(Py_None);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1402 */
  Py_INCREF(__pyx_v_self->uninteresting);
  Py_DECREF(__pyx_v_uninteresting);
  __pyx_v_uninteresting = __pyx_v_self->uninteresting;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1403 */
  Py_INCREF(__pyx_v_self->searched_specific_files);
  Py_DECREF(__pyx_v_searched_specific_files);
  __pyx_v_searched_specific_files = __pyx_v_self->searched_specific_files;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1405 */
  while (1) {
    __pyx_1 = (__pyx_v_self->root_entries_pos < __pyx_v_self->root_entries_len);
    if (!__pyx_1) break;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1406 */
    __pyx_2 = __Pyx_GetItemInt(__pyx_v_self->root_entries, __pyx_v_self->root_entries_pos); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1406; goto __pyx_L1;}
    Py_DECREF(__pyx_v_entry);
    __pyx_v_entry = __pyx_2;
    __pyx_2 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1407 */
    __pyx_v_self->root_entries_pos = (__pyx_v_self->root_entries_pos + 1);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1408 */
    __pyx_2 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_entry,__pyx_v_self->root_dir_info); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1408; goto __pyx_L1;}
    Py_DECREF(__pyx_v_result);
    __pyx_v_result = __pyx_2;
    __pyx_2 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1409 */
    __pyx_1 = __pyx_v_result != Py_None;
    if (__pyx_1) {
      __pyx_1 = __pyx_v_result != __pyx_v_self->uninteresting;
    }
    if (__pyx_1) {
      Py_INCREF(__pyx_v_result);
      __pyx_r = __pyx_v_result;
      goto __pyx_L0;
      goto __pyx_L4;
    }
    __pyx_L4:;
  }

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1412 */
  __pyx_1 = __pyx_v_self->current_root == Py_None;
  if (__pyx_1) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1415 */
    /*try:*/ {
      __pyx_2 = PyObject_GetAttr(__pyx_v_self->search_specific_files, __pyx_n_pop); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1416; goto __pyx_L6;}
      __pyx_3 = PyObject_CallObject(__pyx_2, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1416; goto __pyx_L6;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_v_self->current_root);
      __pyx_v_self->current_root = __pyx_3;
      __pyx_3 = 0;
    }
    goto __pyx_L7;
    __pyx_L6:;
    Py_XDECREF(__pyx_2); __pyx_2 = 0;
    Py_XDECREF(__pyx_3); __pyx_3 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1417 */
    __pyx_1 = PyErr_ExceptionMatches(PyExc_KeyError);
    if (__pyx_1) {
      __Pyx_AddTraceback("_dirstate_helpers_c._iter_next");
      if (__Pyx_GetException(&__pyx_2, &__pyx_3, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1417; goto __pyx_L1;}
      __pyx_5 = PyObject_CallObject(PyExc_StopIteration, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1418; goto __pyx_L1;}
      __Pyx_Raise(__pyx_5, 0, 0);
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1418; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      goto __pyx_L7;
    }
    goto __pyx_L1;
    __pyx_L7:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1419 */
    __pyx_5 = PyObject_GetAttr(__pyx_v_self->current_root, __pyx_n_decode); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1419; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1419; goto __pyx_L1;}
    Py_INCREF(__pyx_n_utf8);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_n_utf8);
    __pyx_3 = PyObject_CallObject(__pyx_5, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1419; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_v_self->current_root_unicode);
    __pyx_v_self->current_root_unicode = __pyx_3;
    __pyx_3 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1420 */
    __pyx_4 = PyObject_GetAttr(__pyx_v_self->searched_specific_files, __pyx_n_add); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1420; goto __pyx_L1;}
    __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1420; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->current_root);
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_v_self->current_root);
    __pyx_2 = PyObject_CallObject(__pyx_4, __pyx_5); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1420; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1423 */
    __pyx_3 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__entries_for_path); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1423; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1423; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->current_root);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_self->current_root);
    __pyx_5 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1423; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_v_self->root_entries);
    __pyx_v_self->root_entries = __pyx_5;
    __pyx_5 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1424 */
    __pyx_6 = PyObject_Length(__pyx_v_self->root_entries); if (__pyx_6 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1424; goto __pyx_L1;}
    __pyx_v_self->root_entries_len = __pyx_6;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1425 */
    __pyx_2 = PyObject_GetAttr(__pyx_v_self->tree, __pyx_n_abspath); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1425; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1425; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->current_root_unicode);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_self->current_root_unicode);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1425; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_v_self->root_abspath);
    __pyx_v_self->root_abspath = __pyx_4;
    __pyx_4 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1426 */
    /*try:*/ {
      __pyx_5 = __Pyx_GetName(__pyx_m, __pyx_n_os); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1427; goto __pyx_L8;}
      __pyx_2 = PyObject_GetAttr(__pyx_5, __pyx_n_lstat); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1427; goto __pyx_L8;}
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1427; goto __pyx_L8;}
      Py_INCREF(__pyx_v_self->root_abspath);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_self->root_abspath);
      __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1427; goto __pyx_L8;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_v_root_stat);
      __pyx_v_root_stat = __pyx_4;
      __pyx_4 = 0;
    }
    /*else:*/ {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1436 */
      __pyx_7 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1437; goto __pyx_L1;}
      __pyx_4 = PyObject_GetAttr(__pyx_7, __pyx_n_file_kind_from_stat_mode); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1437; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_8 = PyObject_GetAttr(__pyx_v_root_stat, __pyx_n_st_mode); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1437; goto __pyx_L1;}
      __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1437; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_5, 0, __pyx_8);
      __pyx_8 = 0;
      __pyx_2 = PyObject_CallObject(__pyx_4, __pyx_5); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1437; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      __pyx_3 = PyTuple_New(5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1436; goto __pyx_L1;}
      Py_INCREF(__pyx_k75p);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k75p);
      Py_INCREF(__pyx_v_self->current_root);
      PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_self->current_root);
      PyTuple_SET_ITEM(__pyx_3, 2, __pyx_2);
      Py_INCREF(__pyx_v_root_stat);
      PyTuple_SET_ITEM(__pyx_3, 3, __pyx_v_root_stat);
      Py_INCREF(__pyx_v_self->root_abspath);
      PyTuple_SET_ITEM(__pyx_3, 4, __pyx_v_self->root_abspath);
      __pyx_2 = 0;
      Py_DECREF(__pyx_v_self->root_dir_info);
      __pyx_v_self->root_dir_info = __pyx_3;
      __pyx_3 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1439 */
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_self->root_dir_info, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1439; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_7, __pyx_n_directory, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1439; goto __pyx_L1;}
      __pyx_1 = __pyx_1 == 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      if (__pyx_1) {
        __pyx_8 = PyObject_GetAttr(__pyx_v_self->tree, __pyx_n__directory_is_tree_reference); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1440; goto __pyx_L1;}
        __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1440; goto __pyx_L1;}
        Py_INCREF(__pyx_v_self->current_root_unicode);
        PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_self->current_root_unicode);
        __pyx_5 = PyObject_CallObject(__pyx_8, __pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1440; goto __pyx_L1;}
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        __pyx_1 = PyObject_IsTrue(__pyx_5); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1440; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        if (__pyx_1) {
          __pyx_2 = PySequence_GetSlice(__pyx_v_self->root_dir_info, 0, 2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1442; goto __pyx_L1;}
          __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1443; goto __pyx_L1;}
          Py_INCREF(__pyx_k77p);
          PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k77p);
          __pyx_7 = PyNumber_Add(__pyx_2, __pyx_3); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1442; goto __pyx_L1;}
          Py_DECREF(__pyx_2); __pyx_2 = 0;
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          __pyx_8 = PySequence_GetSlice(__pyx_v_self->root_dir_info, 3, PY_SSIZE_T_MAX); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1443; goto __pyx_L1;}
          __pyx_4 = PyNumber_Add(__pyx_7, __pyx_8); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1443; goto __pyx_L1;}
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          Py_DECREF(__pyx_8); __pyx_8 = 0;
          Py_DECREF(__pyx_v_self->root_dir_info);
          __pyx_v_self->root_dir_info = __pyx_4;
          __pyx_4 = 0;
          goto __pyx_L11;
        }
        __pyx_L11:;
        goto __pyx_L10;
      }
      __pyx_L10:;
    }
    goto __pyx_L9;
    __pyx_L8:;
    Py_XDECREF(__pyx_5); __pyx_5 = 0;
    Py_XDECREF(__pyx_2); __pyx_2 = 0;
    Py_XDECREF(__pyx_3); __pyx_3 = 0;
    Py_XDECREF(__pyx_4); __pyx_4 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1428 */
    __pyx_1 = PyErr_ExceptionMatches(PyExc_OSError);
    if (__pyx_1) {
      __Pyx_AddTraceback("_dirstate_helpers_c._iter_next");
      if (__Pyx_GetException(&__pyx_5, &__pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1428; goto __pyx_L1;}
      Py_INCREF(__pyx_2);
      Py_DECREF(__pyx_v_e);
      __pyx_v_e = __pyx_2;
      __pyx_4 = PyObject_GetAttr(__pyx_v_e, __pyx_n_errno); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1429; goto __pyx_L1;}
      __pyx_7 = __Pyx_GetName(__pyx_m, __pyx_n_errno); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1429; goto __pyx_L1;}
      __pyx_8 = PyObject_GetAttr(__pyx_7, __pyx_n_ENOENT); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1429; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      if (PyObject_Cmp(__pyx_4, __pyx_8, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1429; goto __pyx_L1;}
      __pyx_1 = __pyx_1 == 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      if (__pyx_1) {
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_self->root_dir_info);
        __pyx_v_self->root_dir_info = Py_None;
        goto __pyx_L12;
      }
      /*else*/ {
        __Pyx_Raise(__pyx_5, __pyx_2, __pyx_3);
        {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1434; goto __pyx_L1;}
      }
      __pyx_L12:;
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      goto __pyx_L9;
    }
    goto __pyx_L1;
    __pyx_L9:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1444 */
    __pyx_9 = PyObject_IsTrue(__pyx_v_self->root_entries); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1444; goto __pyx_L1;}
    __pyx_1 = (!__pyx_9);
    if (__pyx_1) {
      __pyx_9 = PyObject_IsTrue(__pyx_v_self->root_dir_info); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1444; goto __pyx_L1;}
      __pyx_1 = (!__pyx_9);
    }
    if (__pyx_1) {
      __pyx_5 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_iter_next(__pyx_v_self); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1448; goto __pyx_L1;}
      __pyx_r = __pyx_5;
      __pyx_5 = 0;
      goto __pyx_L0;
      goto __pyx_L13;
    }
    __pyx_L13:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1449 */
    __pyx_v_path_handled = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1450 */
    __pyx_v_self->root_entries_pos = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1455 */
    while (1) {
      __pyx_9 = (__pyx_v_self->root_entries_pos < __pyx_v_self->root_entries_len);
      if (!__pyx_9) break;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1456 */
      __pyx_2 = __Pyx_GetItemInt(__pyx_v_self->root_entries, __pyx_v_self->root_entries_pos); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1456; goto __pyx_L1;}
      Py_DECREF(__pyx_v_entry);
      __pyx_v_entry = __pyx_2;
      __pyx_2 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1457 */
      __pyx_v_self->root_entries_pos = (__pyx_v_self->root_entries_pos + 1);

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1458 */
      __pyx_3 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_entry,__pyx_v_self->root_dir_info); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1458; goto __pyx_L1;}
      Py_DECREF(__pyx_v_result);
      __pyx_v_result = __pyx_3;
      __pyx_3 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1459 */
      __pyx_1 = __pyx_v_result != Py_None;
      if (__pyx_1) {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1460 */
        __pyx_v_path_handled = (-1);

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1461 */
        __pyx_9 = __pyx_v_result != __pyx_v_self->uninteresting;
        if (__pyx_9) {
          Py_INCREF(__pyx_v_result);
          __pyx_r = __pyx_v_result;
          goto __pyx_L0;
          goto __pyx_L17;
        }
        __pyx_L17:;
        goto __pyx_L16;
      }
      __pyx_L16:;
    }

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1464 */
    __pyx_7 = PyInt_FromLong(__pyx_v_self->want_unversioned); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1464; goto __pyx_L1;}
    __pyx_1 = PyObject_IsTrue(__pyx_7); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1464; goto __pyx_L1;}
    if (__pyx_1) {
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_7 = PyInt_FromLong((!__pyx_v_path_handled)); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1464; goto __pyx_L1;}
      __pyx_9 = PyObject_IsTrue(__pyx_7); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1464; goto __pyx_L1;}
      if (__pyx_9) {
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        __pyx_7 = __pyx_v_self->root_dir_info;
        Py_INCREF(__pyx_7);
      }
    }
    __pyx_1 = PyObject_IsTrue(__pyx_7); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1464; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (__pyx_1) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1465 */
      __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1466; goto __pyx_L1;}
      __pyx_5 = PyObject_GetAttr(__pyx_4, __pyx_n_S_ISREG); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1466; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_2 = __Pyx_GetItemInt(__pyx_v_self->root_dir_info, 3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1466; goto __pyx_L1;}
      __pyx_3 = PyObject_GetAttr(__pyx_2, __pyx_n_st_mode); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1466; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_7 = PyTuple_New(1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1466; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_7, 0, __pyx_3);
      __pyx_3 = 0;
      __pyx_8 = PyObject_CallObject(__pyx_5, __pyx_7); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1466; goto __pyx_L1;}
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_9 = PyObject_IsTrue(__pyx_8); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1467; goto __pyx_L1;}
      if (__pyx_9) {
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1467; goto __pyx_L1;}
        __pyx_2 = PyObject_GetAttr(__pyx_4, __pyx_n_S_IEXEC); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1467; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->root_dir_info, 3); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1467; goto __pyx_L1;}
        __pyx_5 = PyObject_GetAttr(__pyx_3, __pyx_n_st_mode); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1467; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_8 = PyNumber_And(__pyx_2, __pyx_5); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1467; goto __pyx_L1;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        Py_DECREF(__pyx_5); __pyx_5 = 0;
      }
      __pyx_1 = PyObject_IsTrue(__pyx_8); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1465; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_7 = PyInt_FromLong(__pyx_1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1465; goto __pyx_L1;}
      Py_DECREF(__pyx_v_new_executable);
      __pyx_v_new_executable = __pyx_7;
      __pyx_7 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1468 */
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1469; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_4, 0, Py_None);
      Py_INCREF(__pyx_v_self->current_root_unicode);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_self->current_root_unicode);
      __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1471; goto __pyx_L1;}
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_3, 0, Py_False);
      Py_INCREF(Py_False);
      PyTuple_SET_ITEM(__pyx_3, 1, Py_False);
      __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1472; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_2, 0, Py_None);
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_2, 1, Py_None);
      __pyx_5 = __Pyx_GetName(__pyx_m, __pyx_n_splitpath); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1473; goto __pyx_L1;}
      __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1473; goto __pyx_L1;}
      Py_INCREF(__pyx_v_self->current_root_unicode);
      PyTuple_SET_ITEM(__pyx_8, 0, __pyx_v_self->current_root_unicode);
      __pyx_7 = PyObject_CallObject(__pyx_5, __pyx_8); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1473; goto __pyx_L1;}
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      __pyx_5 = __Pyx_GetItemInt(__pyx_7, (-1)); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1473; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1473; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_8, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_8, 1, __pyx_5);
      __pyx_5 = 0;
      __pyx_7 = __Pyx_GetItemInt(__pyx_v_self->root_dir_info, 2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1474; goto __pyx_L1;}
      __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1474; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_5, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_5, 1, __pyx_7);
      __pyx_7 = 0;
      __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1475; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_7, 0, Py_None);
      Py_INCREF(__pyx_v_new_executable);
      PyTuple_SET_ITEM(__pyx_7, 1, __pyx_v_new_executable);
      __pyx_10 = PyTuple_New(8); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1468; goto __pyx_L1;}
      Py_INCREF(Py_None);
      PyTuple_SET_ITEM(__pyx_10, 0, Py_None);
      PyTuple_SET_ITEM(__pyx_10, 1, __pyx_4);
      Py_INCREF(Py_True);
      PyTuple_SET_ITEM(__pyx_10, 2, Py_True);
      PyTuple_SET_ITEM(__pyx_10, 3, __pyx_3);
      PyTuple_SET_ITEM(__pyx_10, 4, __pyx_2);
      PyTuple_SET_ITEM(__pyx_10, 5, __pyx_8);
      PyTuple_SET_ITEM(__pyx_10, 6, __pyx_5);
      PyTuple_SET_ITEM(__pyx_10, 7, __pyx_7);
      __pyx_4 = 0;
      __pyx_3 = 0;
      __pyx_2 = 0;
      __pyx_8 = 0;
      __pyx_5 = 0;
      __pyx_7 = 0;
      __pyx_r = __pyx_10;
      __pyx_10 = 0;
      goto __pyx_L0;
      goto __pyx_L18;
    }
    __pyx_L18:;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1479 */
  __pyx_9 = __pyx_v_self->current_dir_info == Py_None;
  if (__pyx_9) {
    __pyx_9 = __pyx_v_self->current_block == Py_None;
  }
  if (__pyx_9) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1481 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_self->current_dir_list);
    __pyx_v_self->current_dir_list = Py_None;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1482 */
    __pyx_4 = __pyx_v_self->root_dir_info;
    Py_INCREF(__pyx_4);
    __pyx_1 = PyObject_IsTrue(__pyx_4); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1482; goto __pyx_L1;}
    if (__pyx_1) {
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->root_dir_info, 2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1482; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_3, __pyx_k78p, &__pyx_9) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1482; goto __pyx_L1;}
      __pyx_9 = __pyx_9 == 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_4 = PyInt_FromLong(__pyx_9); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1482; goto __pyx_L1;}
    }
    __pyx_1 = PyObject_IsTrue(__pyx_4); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1482; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    if (__pyx_1) {
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_self->current_dir_info);
      __pyx_v_self->current_dir_info = Py_None;
      goto __pyx_L20;
    }
    /*else*/ {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1485 */
      __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1485; goto __pyx_L1;}
      __pyx_8 = PyObject_GetAttr(__pyx_2, __pyx_n__walkdirs_utf8); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1485; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1485; goto __pyx_L1;}
      Py_INCREF(__pyx_v_self->root_abspath);
      PyTuple_SET_ITEM(__pyx_5, 0, __pyx_v_self->root_abspath);
      __pyx_7 = PyDict_New(); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1485; goto __pyx_L1;}
      if (PyDict_SetItem(__pyx_7, __pyx_n_prefix, __pyx_v_self->current_root) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1485; goto __pyx_L1;}
      __pyx_10 = PyEval_CallObjectWithKeywords(__pyx_8, __pyx_5, __pyx_7); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1485; goto __pyx_L1;}
      Py_DECREF(__pyx_8); __pyx_8 = 0;
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      Py_DECREF(__pyx_v_self->dir_iterator);
      __pyx_v_self->dir_iterator = __pyx_10;
      __pyx_10 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1487 */
      __pyx_v_self->path_index = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1488 */
      /*try:*/ {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1489 */
        __pyx_3 = PyObject_GetAttr(__pyx_v_self->dir_iterator, __pyx_n_next); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1489; goto __pyx_L21;}
        __pyx_4 = PyObject_CallObject(__pyx_3, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1489; goto __pyx_L21;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        Py_DECREF(__pyx_v_self->current_dir_info);
        __pyx_v_self->current_dir_info = __pyx_4;
        __pyx_4 = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1490 */
        __pyx_2 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1490; goto __pyx_L21;}
        Py_DECREF(__pyx_v_self->current_dir_list);
        __pyx_v_self->current_dir_list = __pyx_2;
        __pyx_2 = 0;
      }
      /*else:*/ {
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1514; goto __pyx_L1;}
        __pyx_11 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1514; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        if (PyObject_Cmp(__pyx_11, __pyx_k81p, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1514; goto __pyx_L1;}
        __pyx_1 = __pyx_1 == 0;
        Py_DECREF(__pyx_11); __pyx_11 = 0;
        if (__pyx_1) {

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1516 */
          __pyx_10 = PyTuple_New(1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1516; goto __pyx_L1;}
          Py_INCREF(__pyx_k82p);
          PyTuple_SET_ITEM(__pyx_10, 0, __pyx_k82p);
          __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1516; goto __pyx_L1;}
          Py_INCREF(__pyx_v_self->current_dir_list);
          PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self->current_dir_list);
          PyTuple_SET_ITEM(__pyx_2, 1, __pyx_10);
          __pyx_10 = 0;
          __pyx_4 = PyObject_CallObject(__pyx_v_self->bisect_left, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1516; goto __pyx_L1;}
          Py_DECREF(__pyx_2); __pyx_2 = 0;
          Py_DECREF(__pyx_v_bzr_index);
          __pyx_v_bzr_index = __pyx_4;
          __pyx_4 = 0;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1517 */
          __pyx_8 = PyObject_GetItem(__pyx_v_self->current_dir_list, __pyx_v_bzr_index); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1517; goto __pyx_L1;}
          __pyx_5 = __Pyx_GetItemInt(__pyx_8, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1517; goto __pyx_L1;}
          Py_DECREF(__pyx_8); __pyx_8 = 0;
          if (PyObject_Cmp(__pyx_5, __pyx_k83p, &__pyx_9) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1517; goto __pyx_L1;}
          __pyx_9 = __pyx_9 != 0;
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          if (__pyx_9) {
            __pyx_7 = PyObject_CallObject(PyExc_AssertionError, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1518; goto __pyx_L1;}
            __Pyx_Raise(__pyx_7, 0, 0);
            Py_DECREF(__pyx_7); __pyx_7 = 0;
            {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1518; goto __pyx_L1;}
            goto __pyx_L24;
          }
          __pyx_L24:;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1519 */
          if (PyObject_DelItem(__pyx_v_self->current_dir_list, __pyx_v_bzr_index) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1519; goto __pyx_L1;}
          goto __pyx_L23;
        }
        __pyx_L23:;
      }
      goto __pyx_L22;
      __pyx_L21:;
      Py_XDECREF(__pyx_8); __pyx_8 = 0;
      Py_XDECREF(__pyx_5); __pyx_5 = 0;
      Py_XDECREF(__pyx_7); __pyx_7 = 0;
      Py_XDECREF(__pyx_10); __pyx_10 = 0;
      Py_XDECREF(__pyx_3); __pyx_3 = 0;
      Py_XDECREF(__pyx_4); __pyx_4 = 0;
      Py_XDECREF(__pyx_2); __pyx_2 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1491 */
      __pyx_9 = PyErr_ExceptionMatches(PyExc_OSError);
      if (__pyx_9) {
        __Pyx_AddTraceback("_dirstate_helpers_c._iter_next");
        if (__Pyx_GetException(&__pyx_8, &__pyx_5, &__pyx_7) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1491; goto __pyx_L1;}
        Py_INCREF(__pyx_5);
        Py_DECREF(__pyx_v_e);
        __pyx_v_e = __pyx_5;
        __pyx_10 = PyObject_GetAttr(__pyx_v_e, __pyx_n_errno); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1495; goto __pyx_L1;}
        __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_errno); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1495; goto __pyx_L1;}
        __pyx_4 = PyObject_GetAttr(__pyx_3, __pyx_n_ENOENT); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1495; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_errno); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1495; goto __pyx_L1;}
        __pyx_3 = PyObject_GetAttr(__pyx_2, __pyx_n_ENOTDIR); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1495; goto __pyx_L1;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_n_errno); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1495; goto __pyx_L1;}
        __pyx_11 = PyObject_GetAttr(__pyx_2, __pyx_n_EINVAL); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1495; goto __pyx_L1;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        __pyx_2 = PyTuple_New(3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1495; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_2, 0, __pyx_4);
        PyTuple_SET_ITEM(__pyx_2, 1, __pyx_3);
        PyTuple_SET_ITEM(__pyx_2, 2, __pyx_11);
        __pyx_4 = 0;
        __pyx_3 = 0;
        __pyx_11 = 0;
        __pyx_1 = PySequence_Contains(__pyx_2, __pyx_10); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1495; goto __pyx_L1;}
        Py_DECREF(__pyx_10); __pyx_10 = 0;
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        if (__pyx_1) {
          Py_INCREF(Py_None);
          Py_DECREF(__pyx_v_self->current_dir_info);
          __pyx_v_self->current_dir_info = Py_None;
          goto __pyx_L25;
        }
        __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_sys); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1497; goto __pyx_L1;}
        __pyx_3 = PyObject_GetAttr(__pyx_4, __pyx_n_platform); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1497; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        if (PyObject_Cmp(__pyx_3, __pyx_n_win32, &__pyx_9) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1497; goto __pyx_L1;}
        __pyx_9 = __pyx_9 == 0;
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        if (__pyx_9) {

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1501 */
          /*try:*/ {
            __pyx_11 = PyObject_GetAttr(__pyx_v_e, __pyx_n_winerror); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1502; goto __pyx_L26;}
            Py_DECREF(__pyx_v_e_winerror);
            __pyx_v_e_winerror = __pyx_11;
            __pyx_11 = 0;
          }
          goto __pyx_L27;
          __pyx_L26:;
          Py_XDECREF(__pyx_10); __pyx_10 = 0;
          Py_XDECREF(__pyx_2); __pyx_2 = 0;
          Py_XDECREF(__pyx_4); __pyx_4 = 0;
          Py_XDECREF(__pyx_3); __pyx_3 = 0;
          Py_XDECREF(__pyx_11); __pyx_11 = 0;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1503 */
          __pyx_10 = __Pyx_GetName(__pyx_b, __pyx_n_AttributeError); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1503; goto __pyx_L1;}
          __pyx_1 = PyErr_ExceptionMatches(__pyx_10);
          Py_DECREF(__pyx_10); __pyx_10 = 0;
          if (__pyx_1) {
            __Pyx_AddTraceback("_dirstate_helpers_c._iter_next");
            if (__Pyx_GetException(&__pyx_2, &__pyx_4, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1503; goto __pyx_L1;}
            Py_INCREF(Py_None);
            Py_DECREF(__pyx_v_e_winerror);
            __pyx_v_e_winerror = Py_None;
            Py_DECREF(__pyx_2); __pyx_2 = 0;
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            goto __pyx_L27;
          }
          goto __pyx_L1;
          __pyx_L27:;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1505 */
          __pyx_11 = PyInt_FromLong(__pyx_v_19_dirstate_helpers_c_ERROR_DIRECTORY); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1505; goto __pyx_L1;}
          __pyx_10 = PyInt_FromLong(__pyx_v_19_dirstate_helpers_c_ERROR_PATH_NOT_FOUND); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1505; goto __pyx_L1;}
          __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1505; goto __pyx_L1;}
          PyTuple_SET_ITEM(__pyx_2, 0, __pyx_11);
          PyTuple_SET_ITEM(__pyx_2, 1, __pyx_10);
          __pyx_11 = 0;
          __pyx_10 = 0;
          Py_DECREF(__pyx_v_win_errors);
          __pyx_v_win_errors = __pyx_2;
          __pyx_2 = 0;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1506 */
          __pyx_4 = PyObject_GetAttr(__pyx_v_e, __pyx_n_errno); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1506; goto __pyx_L1;}
          __pyx_9 = PySequence_Contains(__pyx_v_win_errors, __pyx_4); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1506; goto __pyx_L1;}
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          if (!__pyx_9) {
            __pyx_9 = PySequence_Contains(__pyx_v_win_errors, __pyx_v_e_winerror); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1506; goto __pyx_L1;}
          }
          if (__pyx_9) {
            Py_INCREF(Py_None);
            Py_DECREF(__pyx_v_self->current_dir_info);
            __pyx_v_self->current_dir_info = Py_None;
            goto __pyx_L28;
          }
          /*else*/ {
            __Pyx_Raise(__pyx_8, __pyx_5, __pyx_7);
            {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1510; goto __pyx_L1;}
          }
          __pyx_L28:;
          goto __pyx_L25;
        }
        /*else*/ {
          __Pyx_Raise(__pyx_8, __pyx_5, __pyx_7);
          {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1512; goto __pyx_L1;}
        }
        __pyx_L25:;
        Py_DECREF(__pyx_8); __pyx_8 = 0;
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        goto __pyx_L22;
      }
      goto __pyx_L1;
      __pyx_L22:;
    }
    __pyx_L20:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1520 */
    __pyx_3 = PyTuple_New(3); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1520; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self->current_root);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_self->current_root);
    Py_INCREF(__pyx_k84p);
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_k84p);
    Py_INCREF(__pyx_k85p);
    PyTuple_SET_ITEM(__pyx_3, 2, __pyx_k85p);
    Py_DECREF(__pyx_v_initial_key);
    __pyx_v_initial_key = __pyx_3;
    __pyx_3 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1521 */
    __pyx_11 = PyObject_GetAttr(__pyx_v_self->state, __pyx_n__find_block_index_from_key); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1521; goto __pyx_L1;}
    __pyx_10 = PyTuple_New(1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1521; goto __pyx_L1;}
    Py_INCREF(__pyx_v_initial_key);
    PyTuple_SET_ITEM(__pyx_10, 0, __pyx_v_initial_key);
    __pyx_2 = PyObject_CallObject(__pyx_11, __pyx_10); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1521; goto __pyx_L1;}
    Py_DECREF(__pyx_11); __pyx_11 = 0;
    Py_DECREF(__pyx_10); __pyx_10 = 0;
    __pyx_4 = PyObject_GetIter(__pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1521; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_8 = __Pyx_UnpackItem(__pyx_4); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1521; goto __pyx_L1;}
    __pyx_1 = PyInt_AsLong(__pyx_8); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1521; goto __pyx_L1;}
    Py_DECREF(__pyx_8); __pyx_8 = 0;
    __pyx_v_self->block_index = __pyx_1;
    __pyx_5 = __Pyx_UnpackItem(__pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1521; goto __pyx_L1;}
    Py_DECREF(__pyx_v__);
    __pyx_v__ = __pyx_5;
    __pyx_5 = 0;
    if (__Pyx_EndUnpack(__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1521; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1522 */
    __pyx_9 = (__pyx_v_self->block_index == 0);
    if (__pyx_9) {
      __pyx_v_self->block_index = (__pyx_v_self->block_index + 1);
      goto __pyx_L29;
    }
    __pyx_L29:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1526 */
    ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_update_current_block(__pyx_v_self);
    goto __pyx_L19;
  }
  __pyx_L19:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1529 */
  while (1) {
    __pyx_1 = __pyx_v_self->current_dir_info != Py_None;
    if (!__pyx_1) {
      __pyx_1 = __pyx_v_self->current_block != Py_None;
    }
    if (!__pyx_1) break;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1532 */
    __pyx_7 = __pyx_v_self->current_dir_info;
    Py_INCREF(__pyx_7);
    __pyx_9 = PyObject_IsTrue(__pyx_7); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1532; goto __pyx_L1;}
    if (__pyx_9) {
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_7 = __pyx_v_self->current_block;
      Py_INCREF(__pyx_7);
      __pyx_1 = PyObject_IsTrue(__pyx_7); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1533; goto __pyx_L1;}
      if (__pyx_1) {
        Py_DECREF(__pyx_7); __pyx_7 = 0;
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1533; goto __pyx_L1;}
        __pyx_11 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1533; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_10 = __Pyx_GetItemInt(__pyx_v_self->current_block, 0); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1533; goto __pyx_L1;}
        if (PyObject_Cmp(__pyx_11, __pyx_10, &__pyx_9) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1533; goto __pyx_L1;}
        __pyx_9 = __pyx_9 != 0;
        Py_DECREF(__pyx_11); __pyx_11 = 0;
        Py_DECREF(__pyx_10); __pyx_10 = 0;
        __pyx_7 = PyInt_FromLong(__pyx_9); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1533; goto __pyx_L1;}
      }
    }
    __pyx_1 = PyObject_IsTrue(__pyx_7); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1532; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    if (__pyx_1) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1536 */
      __pyx_2 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1536; goto __pyx_L1;}
      __pyx_8 = __Pyx_GetItemInt(__pyx_2, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1536; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_v_current_dirname);
      __pyx_v_current_dirname = __pyx_8;
      __pyx_8 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1537 */
      __pyx_v_current_dirname_c = PyString_AS_STRING(((void *)__pyx_v_current_dirname));

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1539 */
      __pyx_5 = __Pyx_GetItemInt(__pyx_v_self->current_block, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1539; goto __pyx_L1;}
      Py_DECREF(__pyx_v_current_blockname);
      __pyx_v_current_blockname = __pyx_5;
      __pyx_5 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1540 */
      __pyx_v_current_blockname_c = PyString_AS_STRING(((void *)__pyx_v_current_blockname));

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1546 */
      __pyx_9 = (__pyx_f_19_dirstate_helpers_c__cmp_by_dirs(__pyx_v_current_dirname_c,PyString_Size(__pyx_v_current_dirname),__pyx_v_current_blockname_c,PyString_Size(__pyx_v_current_blockname)) < 0);
      if (__pyx_9) {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1560 */
        while (1) {
          __pyx_6 = PyObject_Length(__pyx_v_self->current_dir_list); if (__pyx_6 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1560; goto __pyx_L1;}
          __pyx_1 = (__pyx_v_self->path_index < __pyx_6);
          if (!__pyx_1) break;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1561 */
          __pyx_4 = __Pyx_GetItemInt(__pyx_v_self->current_dir_list, __pyx_v_self->path_index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1561; goto __pyx_L1;}
          Py_DECREF(__pyx_v_current_path_info);
          __pyx_v_current_path_info = __pyx_4;
          __pyx_4 = 0;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1564 */
          __pyx_3 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1564; goto __pyx_L1;}
          __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1564; goto __pyx_L1;}
          Py_INCREF(__pyx_n_directory);
          PyTuple_SET_ITEM(__pyx_11, 0, __pyx_n_directory);
          Py_INCREF(__pyx_k87p);
          PyTuple_SET_ITEM(__pyx_11, 1, __pyx_k87p);
          __pyx_9 = PySequence_Contains(__pyx_11, __pyx_3); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1564; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          Py_DECREF(__pyx_11); __pyx_11 = 0;
          if (__pyx_9) {

            /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1566 */
            if (PySequence_DelItem(__pyx_v_self->current_dir_list, __pyx_v_self->path_index) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1566; goto __pyx_L1;}

            /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1567 */
            __pyx_v_self->path_index = (__pyx_v_self->path_index - 1);
            goto __pyx_L36;
          }
          __pyx_L36:;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1568 */
          __pyx_v_self->path_index = (__pyx_v_self->path_index + 1);

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1569 */
          __pyx_1 = __pyx_v_self->want_unversioned;
          if (__pyx_1) {

            /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1570 */
            __pyx_10 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1570; goto __pyx_L1;}
            if (PyObject_Cmp(__pyx_10, __pyx_n_directory, &__pyx_9) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1570; goto __pyx_L1;}
            __pyx_9 = __pyx_9 == 0;
            Py_DECREF(__pyx_10); __pyx_10 = 0;
            if (__pyx_9) {
              __pyx_7 = PyObject_GetAttr(__pyx_v_self->tree, __pyx_n__directory_is_tree_reference); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1571; goto __pyx_L1;}
              __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_path_info, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1572; goto __pyx_L1;}
              __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1572; goto __pyx_L1;}
              PyTuple_SET_ITEM(__pyx_8, 0, __pyx_2);
              __pyx_2 = 0;
              __pyx_5 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_8); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1572; goto __pyx_L1;}
              Py_DECREF(__pyx_8); __pyx_8 = 0;
              __pyx_4 = __Pyx_GetItemInt(__pyx_5, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1572; goto __pyx_L1;}
              Py_DECREF(__pyx_5); __pyx_5 = 0;
              __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1571; goto __pyx_L1;}
              PyTuple_SET_ITEM(__pyx_3, 0, __pyx_4);
              __pyx_4 = 0;
              __pyx_11 = PyObject_CallObject(__pyx_7, __pyx_3); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1571; goto __pyx_L1;}
              Py_DECREF(__pyx_7); __pyx_7 = 0;
              Py_DECREF(__pyx_3); __pyx_3 = 0;
              __pyx_1 = PyObject_IsTrue(__pyx_11); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1571; goto __pyx_L1;}
              Py_DECREF(__pyx_11); __pyx_11 = 0;
              if (__pyx_1) {
                __pyx_10 = PySequence_GetSlice(__pyx_v_current_path_info, 0, 2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1573; goto __pyx_L1;}
                __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1574; goto __pyx_L1;}
                Py_INCREF(__pyx_k89p);
                PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k89p);
                __pyx_8 = PyNumber_Add(__pyx_10, __pyx_2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1573; goto __pyx_L1;}
                Py_DECREF(__pyx_10); __pyx_10 = 0;
                Py_DECREF(__pyx_2); __pyx_2 = 0;
                __pyx_5 = PySequence_GetSlice(__pyx_v_current_path_info, 3, PY_SSIZE_T_MAX); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1574; goto __pyx_L1;}
                __pyx_4 = PyNumber_Add(__pyx_8, __pyx_5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1574; goto __pyx_L1;}
                Py_DECREF(__pyx_8); __pyx_8 = 0;
                Py_DECREF(__pyx_5); __pyx_5 = 0;
                Py_DECREF(__pyx_v_current_path_info);
                __pyx_v_current_path_info = __pyx_4;
                __pyx_4 = 0;
                goto __pyx_L39;
              }
              __pyx_L39:;
              goto __pyx_L38;
            }
            __pyx_L38:;

            /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1575 */
            __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1576; goto __pyx_L1;}
            __pyx_11 = PyObject_GetAttr(__pyx_3, __pyx_n_S_ISREG); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1576; goto __pyx_L1;}
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            __pyx_10 = __Pyx_GetItemInt(__pyx_v_current_path_info, 3); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1576; goto __pyx_L1;}
            __pyx_2 = PyObject_GetAttr(__pyx_10, __pyx_n_st_mode); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1576; goto __pyx_L1;}
            Py_DECREF(__pyx_10); __pyx_10 = 0;
            __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1576; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_8, 0, __pyx_2);
            __pyx_2 = 0;
            __pyx_7 = PyObject_CallObject(__pyx_11, __pyx_8); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1576; goto __pyx_L1;}
            Py_DECREF(__pyx_11); __pyx_11 = 0;
            Py_DECREF(__pyx_8); __pyx_8 = 0;
            __pyx_9 = PyObject_IsTrue(__pyx_7); if (__pyx_9 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1577; goto __pyx_L1;}
            if (__pyx_9) {
              Py_DECREF(__pyx_7); __pyx_7 = 0;
              __pyx_5 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1577; goto __pyx_L1;}
              __pyx_4 = PyObject_GetAttr(__pyx_5, __pyx_n_S_IEXEC); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1577; goto __pyx_L1;}
              Py_DECREF(__pyx_5); __pyx_5 = 0;
              __pyx_3 = __Pyx_GetItemInt(__pyx_v_current_path_info, 3); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1577; goto __pyx_L1;}
              __pyx_10 = PyObject_GetAttr(__pyx_3, __pyx_n_st_mode); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1577; goto __pyx_L1;}
              Py_DECREF(__pyx_3); __pyx_3 = 0;
              __pyx_7 = PyNumber_And(__pyx_4, __pyx_10); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1577; goto __pyx_L1;}
              Py_DECREF(__pyx_4); __pyx_4 = 0;
              Py_DECREF(__pyx_10); __pyx_10 = 0;
            }
            __pyx_1 = PyObject_IsTrue(__pyx_7); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1575; goto __pyx_L1;}
            Py_DECREF(__pyx_7); __pyx_7 = 0;
            __pyx_2 = PyInt_FromLong(__pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1575; goto __pyx_L1;}
            Py_DECREF(__pyx_v_new_executable);
            __pyx_v_new_executable = __pyx_2;
            __pyx_2 = 0;

            /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1578 */
            __pyx_11 = __Pyx_GetItemInt(__pyx_v_current_path_info, 0); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1579; goto __pyx_L1;}
            __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1579; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_8, 0, __pyx_11);
            __pyx_11 = 0;
            __pyx_5 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_8); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1579; goto __pyx_L1;}
            Py_DECREF(__pyx_8); __pyx_8 = 0;
            __pyx_3 = __Pyx_GetItemInt(__pyx_5, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1579; goto __pyx_L1;}
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1579; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_4, 0, Py_None);
            PyTuple_SET_ITEM(__pyx_4, 1, __pyx_3);
            __pyx_3 = 0;
            __pyx_10 = PyTuple_New(2); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1581; goto __pyx_L1;}
            Py_INCREF(Py_False);
            PyTuple_SET_ITEM(__pyx_10, 0, Py_False);
            Py_INCREF(Py_False);
            PyTuple_SET_ITEM(__pyx_10, 1, Py_False);
            __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1582; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_7, 0, Py_None);
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_7, 1, Py_None);
            __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_path_info, 1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
            __pyx_11 = PyTuple_New(1); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_11, 0, __pyx_2);
            __pyx_2 = 0;
            __pyx_8 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_11); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
            Py_DECREF(__pyx_11); __pyx_11 = 0;
            __pyx_5 = __Pyx_GetItemInt(__pyx_8, 0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
            Py_DECREF(__pyx_8); __pyx_8 = 0;
            __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1583; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_3, 0, Py_None);
            PyTuple_SET_ITEM(__pyx_3, 1, __pyx_5);
            __pyx_5 = 0;
            __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1584; goto __pyx_L1;}
            __pyx_11 = PyTuple_New(2); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1584; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_11, 0, Py_None);
            PyTuple_SET_ITEM(__pyx_11, 1, __pyx_2);
            __pyx_2 = 0;
            __pyx_8 = PyTuple_New(2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1585; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_8, 0, Py_None);
            Py_INCREF(__pyx_v_new_executable);
            PyTuple_SET_ITEM(__pyx_8, 1, __pyx_v_new_executable);
            __pyx_5 = PyTuple_New(8); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1578; goto __pyx_L1;}
            Py_INCREF(Py_None);
            PyTuple_SET_ITEM(__pyx_5, 0, Py_None);
            PyTuple_SET_ITEM(__pyx_5, 1, __pyx_4);
            Py_INCREF(Py_True);
            PyTuple_SET_ITEM(__pyx_5, 2, Py_True);
            PyTuple_SET_ITEM(__pyx_5, 3, __pyx_10);
            PyTuple_SET_ITEM(__pyx_5, 4, __pyx_7);
            PyTuple_SET_ITEM(__pyx_5, 5, __pyx_3);
            PyTuple_SET_ITEM(__pyx_5, 6, __pyx_11);
            PyTuple_SET_ITEM(__pyx_5, 7, __pyx_8);
            __pyx_4 = 0;
            __pyx_10 = 0;
            __pyx_7 = 0;
            __pyx_3 = 0;
            __pyx_11 = 0;
            __pyx_8 = 0;
            __pyx_r = __pyx_5;
            __pyx_5 = 0;
            goto __pyx_L0;
            goto __pyx_L37;
          }
          __pyx_L37:;
        }

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1587 */
        __pyx_v_self->path_index = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1588 */
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_self->current_dir_list);
        __pyx_v_self->current_dir_list = Py_None;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1589 */
        /*try:*/ {

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1590 */
          __pyx_2 = PyObject_GetAttr(__pyx_v_self->dir_iterator, __pyx_n_next); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1590; goto __pyx_L40;}
          __pyx_4 = PyObject_CallObject(__pyx_2, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1590; goto __pyx_L40;}
          Py_DECREF(__pyx_2); __pyx_2 = 0;
          Py_DECREF(__pyx_v_self->current_dir_info);
          __pyx_v_self->current_dir_info = __pyx_4;
          __pyx_4 = 0;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1591 */
          __pyx_10 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 1); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1591; goto __pyx_L40;}
          Py_DECREF(__pyx_v_self->current_dir_list);
          __pyx_v_self->current_dir_list = __pyx_10;
          __pyx_10 = 0;
        }
        goto __pyx_L41;
        __pyx_L40:;
        Py_XDECREF(__pyx_7); __pyx_7 = 0;
        Py_XDECREF(__pyx_3); __pyx_3 = 0;
        Py_XDECREF(__pyx_11); __pyx_11 = 0;
        Py_XDECREF(__pyx_8); __pyx_8 = 0;
        Py_XDECREF(__pyx_5); __pyx_5 = 0;
        Py_XDECREF(__pyx_2); __pyx_2 = 0;
        Py_XDECREF(__pyx_4); __pyx_4 = 0;
        Py_XDECREF(__pyx_10); __pyx_10 = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1592 */
        __pyx_9 = PyErr_ExceptionMatches(PyExc_StopIteration);
        if (__pyx_9) {
          __Pyx_AddTraceback("_dirstate_helpers_c._iter_next");
          if (__Pyx_GetException(&__pyx_7, &__pyx_3, &__pyx_11) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1592; goto __pyx_L1;}
          Py_INCREF(Py_None);
          Py_DECREF(__pyx_v_self->current_dir_info);
          __pyx_v_self->current_dir_info = Py_None;
          Py_DECREF(__pyx_7); __pyx_7 = 0;
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          Py_DECREF(__pyx_11); __pyx_11 = 0;
          goto __pyx_L41;
        }
        goto __pyx_L1;
        __pyx_L41:;
        goto __pyx_L33;
      }
      /*else*/ {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1602 */
        while (1) {
          __pyx_6 = PyObject_Length(__pyx_v_self->current_block_list); if (__pyx_6 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1602; goto __pyx_L1;}
          __pyx_1 = (__pyx_v_self->current_block_pos < __pyx_6);
          if (!__pyx_1) break;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1603 */
          __pyx_8 = __Pyx_GetItemInt(__pyx_v_self->current_block_list, __pyx_v_self->current_block_pos); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1603; goto __pyx_L1;}
          Py_DECREF(__pyx_v_current_entry);
          __pyx_v_current_entry = __pyx_8;
          __pyx_8 = 0;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1604 */
          __pyx_v_self->current_block_pos = (__pyx_v_self->current_block_pos + 1);

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1607 */
          __pyx_5 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_current_entry,Py_None); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1607; goto __pyx_L1;}
          Py_DECREF(__pyx_v_result);
          __pyx_v_result = __pyx_5;
          __pyx_5 = 0;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1608 */
          __pyx_9 = __pyx_v_result != Py_None;
          if (__pyx_9) {
            __pyx_1 = __pyx_v_result != __pyx_v_self->uninteresting;
            if (__pyx_1) {
              Py_INCREF(__pyx_v_result);
              __pyx_r = __pyx_v_result;
              goto __pyx_L0;
              goto __pyx_L45;
            }
            __pyx_L45:;
            goto __pyx_L44;
          }
          __pyx_L44:;
        }

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1611 */
        __pyx_v_self->block_index = (__pyx_v_self->block_index + 1);

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1612 */
        ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_update_current_block(__pyx_v_self);
      }
      __pyx_L33:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1613 */
      goto __pyx_L30;
      goto __pyx_L32;
    }
    __pyx_L32:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1614 */
    __pyx_2 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_loop_one_block(__pyx_v_self); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1614; goto __pyx_L1;}
    Py_DECREF(__pyx_v_result);
    __pyx_v_result = __pyx_2;
    __pyx_2 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1615 */
    __pyx_9 = __pyx_v_result != Py_None;
    if (__pyx_9) {
      Py_INCREF(__pyx_v_result);
      __pyx_r = __pyx_v_result;
      goto __pyx_L0;
      goto __pyx_L46;
    }
    __pyx_L46:;
    __pyx_L30:;
  }

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1617 */
  __pyx_6 = PyObject_Length(__pyx_v_self->search_specific_files); if (__pyx_6 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1617; goto __pyx_L1;}
  if (__pyx_6) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1619 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_self->current_root);
    __pyx_v_self->current_root = Py_None;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1620 */
    __pyx_4 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_iter_next(__pyx_v_self); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1620; goto __pyx_L1;}
    __pyx_r = __pyx_4;
    __pyx_4 = 0;
    goto __pyx_L0;
    goto __pyx_L47;
  }
  __pyx_L47:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1621 */
  __pyx_10 = PyObject_CallObject(PyExc_StopIteration, 0); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1621; goto __pyx_L1;}
  __Pyx_Raise(__pyx_10, 0, 0);
  Py_DECREF(__pyx_10); __pyx_10 = 0;
  {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1621; goto __pyx_L1;}

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_7);
  Py_XDECREF(__pyx_8);
  Py_XDECREF(__pyx_10);
  Py_XDECREF(__pyx_11);
  __Pyx_AddTraceback("_dirstate_helpers_c.ProcessEntryC._iter_next");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_current_dirname);
  Py_DECREF(__pyx_v_current_blockname);
  Py_DECREF(__pyx_v_uninteresting);
  Py_DECREF(__pyx_v_searched_specific_files);
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_result);
  Py_DECREF(__pyx_v_root_stat);
  Py_DECREF(__pyx_v_e);
  Py_DECREF(__pyx_v_new_executable);
  Py_DECREF(__pyx_v_e_winerror);
  Py_DECREF(__pyx_v_win_errors);
  Py_DECREF(__pyx_v_bzr_index);
  Py_DECREF(__pyx_v_initial_key);
  Py_DECREF(__pyx_v__);
  Py_DECREF(__pyx_v_current_path_info);
  Py_DECREF(__pyx_v_current_entry);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_k90p;

static char __pyx_k90[] = "tree-reference";

static PyObject *__pyx_f_19_dirstate_helpers_c_13ProcessEntryC__maybe_tree_ref(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *__pyx_v_self,PyObject *__pyx_v_current_path_info) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_current_path_info);
  __pyx_1 = PyObject_GetAttr(__pyx_v_self->tree, __pyx_n__directory_is_tree_reference); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1624; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_path_info, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1625; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1625; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  __pyx_2 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1625; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_3 = __Pyx_GetItemInt(__pyx_2, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1625; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1624; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
  __pyx_3 = 0;
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1624; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_4 = PyObject_IsTrue(__pyx_3); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1624; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (__pyx_4) {
    __pyx_1 = PySequence_GetSlice(__pyx_v_current_path_info, 0, 2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1626; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1627; goto __pyx_L1;}
    Py_INCREF(__pyx_k90p);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k90p);
    __pyx_3 = PyNumber_Add(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1626; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_1 = PySequence_GetSlice(__pyx_v_current_path_info, 3, PY_SSIZE_T_MAX); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1627; goto __pyx_L1;}
    __pyx_2 = PyNumber_Add(__pyx_3, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1627; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  /*else*/ {
    Py_INCREF(__pyx_v_current_path_info);
    __pyx_r = __pyx_v_current_path_info;
    goto __pyx_L0;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_c.ProcessEntryC._maybe_tree_ref");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_current_path_info);
  return __pyx_r;
}

static PyObject *__pyx_n_cmp;
static PyObject *__pyx_n_BadFilenameEncoding;
static PyObject *__pyx_n__fs_enc;

static PyObject *__pyx_k92p;
static PyObject *__pyx_k94p;

static char __pyx_k92[] = "result is not None: %r";
static char __pyx_k94[] = "tree-reference";

static PyObject *__pyx_f_19_dirstate_helpers_c_13ProcessEntryC__loop_one_block(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *__pyx_v_self) {
  PyObject *__pyx_v_current_entry;
  PyObject *__pyx_v_current_path_info;
  int __pyx_v_path_handled;
  char __pyx_v_minikind;
  int __pyx_v_cmp_result;
  PyObject *__pyx_v_disk_kind;
  PyObject *__pyx_v_advance_entry;
  PyObject *__pyx_v_advance_path;
  PyObject *__pyx_v_result;
  PyObject *__pyx_v_new_executable;
  PyObject *__pyx_v_relpath_unicode;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  PyObject *__pyx_7 = 0;
  PyObject *__pyx_8 = 0;
  Py_ssize_t __pyx_9;
  Py_INCREF(__pyx_v_self);
  __pyx_v_current_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_current_path_info = Py_None; Py_INCREF(Py_None);
  __pyx_v_disk_kind = Py_None; Py_INCREF(Py_None);
  __pyx_v_advance_entry = Py_None; Py_INCREF(Py_None);
  __pyx_v_advance_path = Py_None; Py_INCREF(Py_None);
  __pyx_v_result = Py_None; Py_INCREF(Py_None);
  __pyx_v_new_executable = Py_None; Py_INCREF(Py_None);
  __pyx_v_relpath_unicode = Py_None; Py_INCREF(Py_None);

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1644 */
  __pyx_1 = __pyx_v_self->current_block != Py_None;
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_self->current_block_pos < PyList_GET_SIZE(__pyx_v_self->current_block_list));
  }
  if (__pyx_1) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1646 */
    __pyx_2 = PyList_GET_ITEM(__pyx_v_self->current_block_list,__pyx_v_self->current_block_pos); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1646; goto __pyx_L1;}
    Py_DECREF(__pyx_v_current_entry);
    __pyx_v_current_entry = __pyx_2;
    __pyx_2 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1649 */
    Py_INCREF(__pyx_v_current_entry);
    goto __pyx_L2;
  }
  /*else*/ {
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_current_entry);
    __pyx_v_current_entry = Py_None;
  }
  __pyx_L2:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1652 */
  __pyx_1 = __pyx_v_self->current_dir_info != Py_None;
  if (__pyx_1) {
    __pyx_1 = (__pyx_v_self->path_index < PyList_GET_SIZE(__pyx_v_self->current_dir_list));
  }
  if (__pyx_1) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1654 */
    __pyx_2 = PyList_GET_ITEM(__pyx_v_self->current_dir_list,__pyx_v_self->path_index); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1654; goto __pyx_L1;}
    Py_DECREF(__pyx_v_current_path_info);
    __pyx_v_current_path_info = __pyx_2;
    __pyx_2 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1657 */
    Py_INCREF(__pyx_v_current_path_info);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1658 */
    __pyx_2 = PyTuple_GET_ITEM(__pyx_v_current_path_info,2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1658; goto __pyx_L1;}
    Py_DECREF(__pyx_v_disk_kind);
    __pyx_v_disk_kind = __pyx_2;
    __pyx_2 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1660 */
    Py_INCREF(__pyx_v_disk_kind);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1661 */
    if (PyObject_Cmp(__pyx_v_disk_kind, __pyx_n_directory, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1661; goto __pyx_L1;}
    __pyx_1 = __pyx_1 == 0;
    if (__pyx_1) {
      __pyx_2 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_maybe_tree_ref(__pyx_v_self,__pyx_v_current_path_info); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1662; goto __pyx_L1;}
      Py_DECREF(__pyx_v_current_path_info);
      __pyx_v_current_path_info = __pyx_2;
      __pyx_2 = 0;
      goto __pyx_L4;
    }
    __pyx_L4:;
    goto __pyx_L3;
  }
  /*else*/ {
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_current_path_info);
    __pyx_v_current_path_info = Py_None;
  }
  __pyx_L3:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1665 */
  while (1) {
    __pyx_1 = __pyx_v_current_entry != Py_None;
    if (!__pyx_1) {
      __pyx_1 = __pyx_v_current_path_info != Py_None;
    }
    if (!__pyx_1) break;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1666 */
    __pyx_2 = PyInt_FromLong((-1)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1666; goto __pyx_L1;}
    Py_DECREF(__pyx_v_advance_entry);
    __pyx_v_advance_entry = __pyx_2;
    __pyx_2 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1667 */
    __pyx_2 = PyInt_FromLong((-1)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1667; goto __pyx_L1;}
    Py_DECREF(__pyx_v_advance_path);
    __pyx_v_advance_path = __pyx_2;
    __pyx_2 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1668 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_result);
    __pyx_v_result = Py_None;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1669 */
    __pyx_v_path_handled = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1670 */
    __pyx_1 = __pyx_v_current_entry == Py_None;
    if (__pyx_1) {
      goto __pyx_L7;
    }
    __pyx_1 = __pyx_v_current_path_info == Py_None;
    if (__pyx_1) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1676 */
      __pyx_2 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_current_entry,__pyx_v_current_path_info); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1676; goto __pyx_L1;}
      Py_DECREF(__pyx_v_result);
      __pyx_v_result = __pyx_2;
      __pyx_2 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1677 */
      __pyx_1 = __pyx_v_result != Py_None;
      if (__pyx_1) {
        __pyx_1 = __pyx_v_result == __pyx_v_self->uninteresting;
        if (__pyx_1) {
          Py_INCREF(Py_None);
          Py_DECREF(__pyx_v_result);
          __pyx_v_result = Py_None;
          goto __pyx_L9;
        }
        __pyx_L9:;
        goto __pyx_L8;
      }
      __pyx_L8:;
      goto __pyx_L7;
    }
    /*else*/ {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1681 */
      __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_entry, 1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1682; goto __pyx_L1;}
      __pyx_3 = __Pyx_GetItemInt(__pyx_2, __pyx_v_self->target_index); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1682; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_2 = __Pyx_GetItemInt(__pyx_3, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1682; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_v_minikind = __pyx_f_19_dirstate_helpers_c__minikind_from_string(__pyx_2);
      Py_DECREF(__pyx_2); __pyx_2 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1683 */
      __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_cmp); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1683; goto __pyx_L1;}
      __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_path_info, 1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1683; goto __pyx_L1;}
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_current_entry, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1683; goto __pyx_L1;}
      __pyx_5 = __Pyx_GetItemInt(__pyx_4, 1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1683; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1683; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_4, 0, __pyx_2);
      PyTuple_SET_ITEM(__pyx_4, 1, __pyx_5);
      __pyx_2 = 0;
      __pyx_5 = 0;
      __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1683; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_1 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1683; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_v_cmp_result = __pyx_1;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1684 */
      __pyx_1 = __pyx_v_cmp_result;
      if (!__pyx_1) {
        __pyx_1 = (__pyx_v_minikind == 'a');
        if (!__pyx_1) {
          __pyx_1 = (__pyx_v_minikind == 'r');
        }
      }
      if (__pyx_1) {
        __pyx_1 = (__pyx_v_cmp_result < 0);
        if (__pyx_1) {
          __pyx_5 = PyInt_FromLong(0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1696; goto __pyx_L1;}
          Py_DECREF(__pyx_v_advance_entry);
          __pyx_v_advance_entry = __pyx_5;
          __pyx_5 = 0;
          goto __pyx_L11;
        }
        /*else*/ {

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1700 */
          __pyx_3 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_current_entry,Py_None); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1700; goto __pyx_L1;}
          Py_DECREF(__pyx_v_result);
          __pyx_v_result = __pyx_3;
          __pyx_3 = 0;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1701 */
          __pyx_1 = __pyx_v_result != Py_None;
          if (__pyx_1) {
            __pyx_1 = __pyx_v_result == __pyx_v_self->uninteresting;
            if (__pyx_1) {
              Py_INCREF(Py_None);
              Py_DECREF(__pyx_v_result);
              __pyx_v_result = Py_None;
              goto __pyx_L13;
            }
            __pyx_L13:;
            goto __pyx_L12;
          }
          __pyx_L12:;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1704 */
          __pyx_4 = PyInt_FromLong(0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1704; goto __pyx_L1;}
          Py_DECREF(__pyx_v_advance_path);
          __pyx_v_advance_path = __pyx_4;
          __pyx_4 = 0;
        }
        __pyx_L11:;
        goto __pyx_L10;
      }
      /*else*/ {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1708 */
        __pyx_2 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_process_entry(__pyx_v_self,__pyx_v_current_entry,__pyx_v_current_path_info); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1708; goto __pyx_L1;}
        Py_DECREF(__pyx_v_result);
        __pyx_v_result = __pyx_2;
        __pyx_2 = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1709 */
        __pyx_1 = __pyx_v_result != Py_None;
        if (__pyx_1) {

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1710 */
          __pyx_v_path_handled = (-1);

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1711 */
          __pyx_1 = __pyx_v_result == __pyx_v_self->uninteresting;
          if (__pyx_1) {
            Py_INCREF(Py_None);
            Py_DECREF(__pyx_v_result);
            __pyx_v_result = Py_None;
            goto __pyx_L15;
          }
          __pyx_L15:;
          goto __pyx_L14;
        }
        __pyx_L14:;
      }
      __pyx_L10:;
    }
    __pyx_L7:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1715 */
    __pyx_5 = __pyx_v_advance_entry;
    Py_INCREF(__pyx_5);
    __pyx_1 = PyObject_IsTrue(__pyx_5); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1715; goto __pyx_L1;}
    if (__pyx_1) {
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      __pyx_1 = __pyx_v_current_entry != Py_None;
      __pyx_5 = PyInt_FromLong(__pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1715; goto __pyx_L1;}
    }
    __pyx_1 = PyObject_IsTrue(__pyx_5); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1715; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    if (__pyx_1) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1716 */
      __pyx_v_self->current_block_pos = (__pyx_v_self->current_block_pos + 1);

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1717 */
      __pyx_1 = (__pyx_v_self->current_block_pos < PyList_GET_SIZE(__pyx_v_self->current_block_list));
      if (__pyx_1) {
        __pyx_3 = __Pyx_GetItemInt(__pyx_v_self->current_block_list, __pyx_v_self->current_block_pos); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1718; goto __pyx_L1;}
        Py_DECREF(__pyx_v_current_entry);
        __pyx_v_current_entry = __pyx_3;
        __pyx_3 = 0;
        goto __pyx_L17;
      }
      /*else*/ {
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_current_entry);
        __pyx_v_current_entry = Py_None;
      }
      __pyx_L17:;
      goto __pyx_L16;
    }
    __pyx_L16:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1722 */
    __pyx_4 = __pyx_v_advance_path;
    Py_INCREF(__pyx_4);
    __pyx_1 = PyObject_IsTrue(__pyx_4); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1722; goto __pyx_L1;}
    if (__pyx_1) {
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_1 = __pyx_v_current_path_info != Py_None;
      __pyx_4 = PyInt_FromLong(__pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1722; goto __pyx_L1;}
    }
    __pyx_1 = PyObject_IsTrue(__pyx_4); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1722; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    if (__pyx_1) {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1723 */
      __pyx_1 = (!__pyx_v_path_handled);
      if (__pyx_1) {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1725 */
        __pyx_1 = __pyx_v_self->want_unversioned;
        if (__pyx_1) {

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1726 */
          __pyx_5 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1727; goto __pyx_L1;}
          __pyx_3 = PyObject_GetAttr(__pyx_5, __pyx_n_S_ISREG); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1727; goto __pyx_L1;}
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          __pyx_4 = __Pyx_GetItemInt(__pyx_v_current_path_info, 3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1727; goto __pyx_L1;}
          __pyx_5 = PyObject_GetAttr(__pyx_4, __pyx_n_st_mode); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1727; goto __pyx_L1;}
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1727; goto __pyx_L1;}
          PyTuple_SET_ITEM(__pyx_4, 0, __pyx_5);
          __pyx_5 = 0;
          __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1727; goto __pyx_L1;}
          Py_DECREF(__pyx_3); __pyx_3 = 0;
          Py_DECREF(__pyx_4); __pyx_4 = 0;
          __pyx_1 = PyObject_IsTrue(__pyx_2); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1728; goto __pyx_L1;}
          if (__pyx_1) {
            Py_DECREF(__pyx_2); __pyx_2 = 0;
            __pyx_5 = __Pyx_GetName(__pyx_m, __pyx_n_stat); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1728; goto __pyx_L1;}
            __pyx_3 = PyObject_GetAttr(__pyx_5, __pyx_n_S_IEXEC); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1728; goto __pyx_L1;}
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            __pyx_4 = __Pyx_GetItemInt(__pyx_v_current_path_info, 3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1728; goto __pyx_L1;}
            __pyx_5 = PyObject_GetAttr(__pyx_4, __pyx_n_st_mode); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1728; goto __pyx_L1;}
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            __pyx_2 = PyNumber_And(__pyx_3, __pyx_5); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1728; goto __pyx_L1;}
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            Py_DECREF(__pyx_5); __pyx_5 = 0;
          }
          __pyx_1 = PyObject_IsTrue(__pyx_2); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1726; goto __pyx_L1;}
          Py_DECREF(__pyx_2); __pyx_2 = 0;
          __pyx_4 = PyInt_FromLong(__pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1726; goto __pyx_L1;}
          Py_DECREF(__pyx_v_new_executable);
          __pyx_v_new_executable = __pyx_4;
          __pyx_4 = 0;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1729 */
          /*try:*/ {
            __pyx_3 = __Pyx_GetItemInt(__pyx_v_current_path_info, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1730; goto __pyx_L21;}
            __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1730; goto __pyx_L21;}
            PyTuple_SET_ITEM(__pyx_5, 0, __pyx_3);
            __pyx_3 = 0;
            __pyx_2 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_5); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1730; goto __pyx_L21;}
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            __pyx_4 = __Pyx_GetItemInt(__pyx_2, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1730; goto __pyx_L21;}
            Py_DECREF(__pyx_2); __pyx_2 = 0;
            Py_DECREF(__pyx_v_relpath_unicode);
            __pyx_v_relpath_unicode = __pyx_4;
            __pyx_4 = 0;
          }
          goto __pyx_L22;
          __pyx_L21:;
          Py_XDECREF(__pyx_3); __pyx_3 = 0;
          Py_XDECREF(__pyx_5); __pyx_5 = 0;
          Py_XDECREF(__pyx_2); __pyx_2 = 0;
          Py_XDECREF(__pyx_4); __pyx_4 = 0;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1731 */
          __pyx_1 = PyErr_ExceptionMatches(PyExc_UnicodeDecodeError);
          if (__pyx_1) {
            __Pyx_AddTraceback("_dirstate_helpers_c._loop_one_block");
            if (__Pyx_GetException(&__pyx_3, &__pyx_5, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1731; goto __pyx_L1;}
            __pyx_4 = __Pyx_GetName(__pyx_m, __pyx_n_errors); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1732; goto __pyx_L1;}
            __pyx_6 = PyObject_GetAttr(__pyx_4, __pyx_n_BadFilenameEncoding); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1732; goto __pyx_L1;}
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            __pyx_4 = __Pyx_GetItemInt(__pyx_v_current_path_info, 0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1733; goto __pyx_L1;}
            __pyx_7 = __Pyx_GetName(__pyx_m, __pyx_n_osutils); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1733; goto __pyx_L1;}
            __pyx_8 = PyObject_GetAttr(__pyx_7, __pyx_n__fs_enc); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1733; goto __pyx_L1;}
            Py_DECREF(__pyx_7); __pyx_7 = 0;
            __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1732; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_7, 0, __pyx_4);
            PyTuple_SET_ITEM(__pyx_7, 1, __pyx_8);
            __pyx_4 = 0;
            __pyx_8 = 0;
            __pyx_4 = PyObject_CallObject(__pyx_6, __pyx_7); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1732; goto __pyx_L1;}
            Py_DECREF(__pyx_6); __pyx_6 = 0;
            Py_DECREF(__pyx_7); __pyx_7 = 0;
            __Pyx_Raise(__pyx_4, 0, 0);
            Py_DECREF(__pyx_4); __pyx_4 = 0;
            {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1732; goto __pyx_L1;}
            Py_DECREF(__pyx_3); __pyx_3 = 0;
            Py_DECREF(__pyx_5); __pyx_5 = 0;
            Py_DECREF(__pyx_2); __pyx_2 = 0;
            goto __pyx_L22;
          }
          goto __pyx_L1;
          __pyx_L22:;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1734 */
          __pyx_1 = __pyx_v_result != Py_None;
          if (__pyx_1) {
            __pyx_8 = PyNumber_Remainder(__pyx_k92p, __pyx_v_result); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1736; goto __pyx_L1;}
            __pyx_6 = PyTuple_New(1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1735; goto __pyx_L1;}
            PyTuple_SET_ITEM(__pyx_6, 0, __pyx_8);
            __pyx_8 = 0;
            __pyx_7 = PyObject_CallObject(PyExc_AssertionError, __pyx_6); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1735; goto __pyx_L1;}
            Py_DECREF(__pyx_6); __pyx_6 = 0;
            __Pyx_Raise(__pyx_7, 0, 0);
            Py_DECREF(__pyx_7); __pyx_7 = 0;
            {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1735; goto __pyx_L1;}
            goto __pyx_L23;
          }
          __pyx_L23:;

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1737 */
          __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1738; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_4, 0, Py_None);
          Py_INCREF(__pyx_v_relpath_unicode);
          PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_relpath_unicode);
          __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1740; goto __pyx_L1;}
          Py_INCREF(Py_False);
          PyTuple_SET_ITEM(__pyx_3, 0, Py_False);
          Py_INCREF(Py_False);
          PyTuple_SET_ITEM(__pyx_3, 1, Py_False);
          __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1741; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_5, 0, Py_None);
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_5, 1, Py_None);
          __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_path_info, 1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1742; goto __pyx_L1;}
          __pyx_8 = PyTuple_New(1); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1742; goto __pyx_L1;}
          PyTuple_SET_ITEM(__pyx_8, 0, __pyx_2);
          __pyx_2 = 0;
          __pyx_6 = PyObject_CallObject(__pyx_v_self->utf8_decode, __pyx_8); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1742; goto __pyx_L1;}
          Py_DECREF(__pyx_8); __pyx_8 = 0;
          __pyx_7 = __Pyx_GetItemInt(__pyx_6, 0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1742; goto __pyx_L1;}
          Py_DECREF(__pyx_6); __pyx_6 = 0;
          __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1742; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_2, 0, Py_None);
          PyTuple_SET_ITEM(__pyx_2, 1, __pyx_7);
          __pyx_7 = 0;
          __pyx_8 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1743; goto __pyx_L1;}
          __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1743; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_6, 0, Py_None);
          PyTuple_SET_ITEM(__pyx_6, 1, __pyx_8);
          __pyx_8 = 0;
          __pyx_7 = PyTuple_New(2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1744; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_7, 0, Py_None);
          Py_INCREF(__pyx_v_new_executable);
          PyTuple_SET_ITEM(__pyx_7, 1, __pyx_v_new_executable);
          __pyx_8 = PyTuple_New(8); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1737; goto __pyx_L1;}
          Py_INCREF(Py_None);
          PyTuple_SET_ITEM(__pyx_8, 0, Py_None);
          PyTuple_SET_ITEM(__pyx_8, 1, __pyx_4);
          Py_INCREF(Py_True);
          PyTuple_SET_ITEM(__pyx_8, 2, Py_True);
          PyTuple_SET_ITEM(__pyx_8, 3, __pyx_3);
          PyTuple_SET_ITEM(__pyx_8, 4, __pyx_5);
          PyTuple_SET_ITEM(__pyx_8, 5, __pyx_2);
          PyTuple_SET_ITEM(__pyx_8, 6, __pyx_6);
          PyTuple_SET_ITEM(__pyx_8, 7, __pyx_7);
          __pyx_4 = 0;
          __pyx_3 = 0;
          __pyx_5 = 0;
          __pyx_2 = 0;
          __pyx_6 = 0;
          __pyx_7 = 0;
          Py_DECREF(__pyx_v_result);
          __pyx_v_result = __pyx_8;
          __pyx_8 = 0;
          goto __pyx_L20;
        }
        __pyx_L20:;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1747 */
        __pyx_4 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1747; goto __pyx_L1;}
        __pyx_1 = PySequence_Contains(__pyx_n_directory, __pyx_4); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1747; goto __pyx_L1;}
        Py_DECREF(__pyx_4); __pyx_4 = 0;
        if (__pyx_1) {

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1748 */
          if (PySequence_DelItem(__pyx_v_self->current_dir_list, __pyx_v_self->path_index) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1748; goto __pyx_L1;}

          /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1749 */
          __pyx_v_self->path_index = (__pyx_v_self->path_index - 1);
          goto __pyx_L24;
        }
        __pyx_L24:;
        goto __pyx_L19;
      }
      __pyx_L19:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1752 */
      __pyx_3 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1752; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_3, __pyx_k94p, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1752; goto __pyx_L1;}
      __pyx_1 = __pyx_1 == 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      if (__pyx_1) {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1753 */
        if (PySequence_DelItem(__pyx_v_self->current_dir_list, __pyx_v_self->path_index) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1753; goto __pyx_L1;}

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1754 */
        __pyx_v_self->path_index = (__pyx_v_self->path_index - 1);
        goto __pyx_L25;
      }
      __pyx_L25:;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1755 */
      __pyx_v_self->path_index = (__pyx_v_self->path_index + 1);

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1756 */
      __pyx_9 = PyObject_Length(__pyx_v_self->current_dir_list); if (__pyx_9 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1756; goto __pyx_L1;}
      __pyx_1 = (__pyx_v_self->path_index < __pyx_9);
      if (__pyx_1) {

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1757 */
        __pyx_5 = __Pyx_GetItemInt(__pyx_v_self->current_dir_list, __pyx_v_self->path_index); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1757; goto __pyx_L1;}
        Py_DECREF(__pyx_v_current_path_info);
        __pyx_v_current_path_info = __pyx_5;
        __pyx_5 = 0;

        /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1758 */
        __pyx_2 = __Pyx_GetItemInt(__pyx_v_current_path_info, 2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1758; goto __pyx_L1;}
        if (PyObject_Cmp(__pyx_2, __pyx_n_directory, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1758; goto __pyx_L1;}
        __pyx_1 = __pyx_1 == 0;
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        if (__pyx_1) {
          __pyx_6 = ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_maybe_tree_ref(__pyx_v_self,__pyx_v_current_path_info); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1759; goto __pyx_L1;}
          Py_DECREF(__pyx_v_current_path_info);
          __pyx_v_current_path_info = __pyx_6;
          __pyx_6 = 0;
          goto __pyx_L27;
        }
        __pyx_L27:;
        goto __pyx_L26;
      }
      /*else*/ {
        Py_INCREF(Py_None);
        Py_DECREF(__pyx_v_current_path_info);
        __pyx_v_current_path_info = Py_None;
      }
      __pyx_L26:;
      goto __pyx_L18;
    }
    __pyx_L18:;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1763 */
    __pyx_1 = __pyx_v_result != Py_None;
    if (__pyx_1) {
      Py_INCREF(__pyx_v_result);
      __pyx_r = __pyx_v_result;
      goto __pyx_L0;
      goto __pyx_L28;
    }
    __pyx_L28:;
  }

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1766 */
  __pyx_1 = __pyx_v_self->current_block != Py_None;
  if (__pyx_1) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1767 */
    __pyx_v_self->block_index = (__pyx_v_self->block_index + 1);

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1768 */
    ((struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC *)__pyx_v_self->__pyx_vtab)->_update_current_block(__pyx_v_self);
    goto __pyx_L29;
  }
  __pyx_L29:;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1769 */
  __pyx_1 = __pyx_v_self->current_dir_info != Py_None;
  if (__pyx_1) {

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1770 */
    __pyx_v_self->path_index = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1771 */
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_self->current_dir_list);
    __pyx_v_self->current_dir_list = Py_None;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1772 */
    /*try:*/ {

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1773 */
      __pyx_7 = PyObject_GetAttr(__pyx_v_self->dir_iterator, __pyx_n_next); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1773; goto __pyx_L31;}
      __pyx_8 = PyObject_CallObject(__pyx_7, 0); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1773; goto __pyx_L31;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      Py_DECREF(__pyx_v_self->current_dir_info);
      __pyx_v_self->current_dir_info = __pyx_8;
      __pyx_8 = 0;

      /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1774 */
      __pyx_4 = __Pyx_GetItemInt(__pyx_v_self->current_dir_info, 1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1774; goto __pyx_L31;}
      Py_DECREF(__pyx_v_self->current_dir_list);
      __pyx_v_self->current_dir_list = __pyx_4;
      __pyx_4 = 0;
    }
    goto __pyx_L32;
    __pyx_L31:;
    Py_XDECREF(__pyx_3); __pyx_3 = 0;
    Py_XDECREF(__pyx_5); __pyx_5 = 0;
    Py_XDECREF(__pyx_2); __pyx_2 = 0;
    Py_XDECREF(__pyx_6); __pyx_6 = 0;
    Py_XDECREF(__pyx_7); __pyx_7 = 0;
    Py_XDECREF(__pyx_8); __pyx_8 = 0;
    Py_XDECREF(__pyx_4); __pyx_4 = 0;

    /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1775 */
    __pyx_1 = PyErr_ExceptionMatches(PyExc_StopIteration);
    if (__pyx_1) {
      __Pyx_AddTraceback("_dirstate_helpers_c._loop_one_block");
      if (__Pyx_GetException(&__pyx_3, &__pyx_5, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1775; goto __pyx_L1;}
      Py_INCREF(Py_None);
      Py_DECREF(__pyx_v_self->current_dir_info);
      __pyx_v_self->current_dir_info = Py_None;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      goto __pyx_L32;
    }
    goto __pyx_L1;
    __pyx_L32:;
    goto __pyx_L30;
  }
  __pyx_L30:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  Py_XDECREF(__pyx_7);
  Py_XDECREF(__pyx_8);
  __Pyx_AddTraceback("_dirstate_helpers_c.ProcessEntryC._loop_one_block");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_current_entry);
  Py_DECREF(__pyx_v_current_path_info);
  Py_DECREF(__pyx_v_disk_kind);
  Py_DECREF(__pyx_v_advance_entry);
  Py_DECREF(__pyx_v_advance_path);
  Py_DECREF(__pyx_v_result);
  Py_DECREF(__pyx_v_new_executable);
  Py_DECREF(__pyx_v_relpath_unicode);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static __Pyx_InternTabEntry __pyx_intern_tab[] = {
  {&__pyx_n_AttributeError, "AttributeError"},
  {&__pyx_n_BadFilenameEncoding, "BadFilenameEncoding"},
  {&__pyx_n_CorruptDirstate, "CorruptDirstate"},
  {&__pyx_n_DirState, "DirState"},
  {&__pyx_n_DirstateCorrupt, "DirstateCorrupt"},
  {&__pyx_n_EINVAL, "EINVAL"},
  {&__pyx_n_ENOENT, "ENOENT"},
  {&__pyx_n_ENOTDIR, "ENOTDIR"},
  {&__pyx_n_IN_MEMORY_MODIFIED, "IN_MEMORY_MODIFIED"},
  {&__pyx_n_IN_MEMORY_UNMODIFIED, "IN_MEMORY_UNMODIFIED"},
  {&__pyx_n_NULLSTAT, "NULLSTAT"},
  {&__pyx_n_NULL_PARENT_DETAILS, "NULL_PARENT_DETAILS"},
  {&__pyx_n_S_IEXEC, "S_IEXEC"},
  {&__pyx_n_S_ISREG, "S_ISREG"},
  {&__pyx_n__cutoff_time, "_cutoff_time"},
  {&__pyx_n__dirblock_state, "_dirblock_state"},
  {&__pyx_n__dirblocks, "_dirblocks"},
  {&__pyx_n__directory_is_tree_reference, "_directory_is_tree_reference"},
  {&__pyx_n__encode, "_encode"},
  {&__pyx_n__end_of_header, "_end_of_header"},
  {&__pyx_n__ensure_block, "_ensure_block"},
  {&__pyx_n__entries_for_path, "_entries_for_path"},
  {&__pyx_n__filename, "_filename"},
  {&__pyx_n__find_block_index_from_key, "_find_block_index_from_key"},
  {&__pyx_n__fs_enc, "_fs_enc"},
  {&__pyx_n__get_block_entry_index, "_get_block_entry_index"},
  {&__pyx_n__get_entry, "_get_entry"},
  {&__pyx_n__is_executable, "_is_executable"},
  {&__pyx_n__num_entries, "_num_entries"},
  {&__pyx_n__num_present_parents, "_num_present_parents"},
  {&__pyx_n__observed_sha1, "_observed_sha1"},
  {&__pyx_n__parse_dirblocks, "_parse_dirblocks"},
  {&__pyx_n__read_link, "_read_link"},
  {&__pyx_n__sha1_file, "_sha1_file"},
  {&__pyx_n__sha1_provider, "_sha1_provider"},
  {&__pyx_n__sha_cutoff_time, "_sha_cutoff_time"},
  {&__pyx_n__split_root_dirblock_into_contents, "_split_root_dirblock_into_contents"},
  {&__pyx_n__state_file, "_state_file"},
  {&__pyx_n__utf8_decode, "_utf8_decode"},
  {&__pyx_n__walkdirs_utf8, "_walkdirs_utf8"},
  {&__pyx_n_a, "a"},
  {&__pyx_n_absent, "absent"},
  {&__pyx_n_abspath, "abspath"},
  {&__pyx_n_add, "add"},
  {&__pyx_n_b2a_base64, "b2a_base64"},
  {&__pyx_n_binascii, "binascii"},
  {&__pyx_n_bisect, "bisect"},
  {&__pyx_n_bisect_left, "bisect_left"},
  {&__pyx_n_bzrlib, "bzrlib"},
  {&__pyx_n_cache_utf8, "cache_utf8"},
  {&__pyx_n_cmp, "cmp"},
  {&__pyx_n_d, "d"},
  {&__pyx_n_decode, "decode"},
  {&__pyx_n_directory, "directory"},
  {&__pyx_n_errno, "errno"},
  {&__pyx_n_errors, "errors"},
  {&__pyx_n_f, "f"},
  {&__pyx_n_file, "file"},
  {&__pyx_n_file_kind_from_stat_mode, "file_kind_from_stat_mode"},
  {&__pyx_n_fstat, "fstat"},
  {&__pyx_n_is_inside, "is_inside"},
  {&__pyx_n_is_inside_any, "is_inside_any"},
  {&__pyx_n_l, "l"},
  {&__pyx_n_lstat, "lstat"},
  {&__pyx_n_next, "next"},
  {&__pyx_n_object, "object"},
  {&__pyx_n_os, "os"},
  {&__pyx_n_osutils, "osutils"},
  {&__pyx_n_pack, "pack"},
  {&__pyx_n_path, "path"},
  {&__pyx_n_path_utf8, "path_utf8"},
  {&__pyx_n_pathjoin, "pathjoin"},
  {&__pyx_n_platform, "platform"},
  {&__pyx_n_pop, "pop"},
  {&__pyx_n_prefix, "prefix"},
  {&__pyx_n_read, "read"},
  {&__pyx_n_relocated, "relocated"},
  {&__pyx_n_seek, "seek"},
  {&__pyx_n_set, "set"},
  {&__pyx_n_sha_file, "sha_file"},
  {&__pyx_n_split, "split"},
  {&__pyx_n_splitpath, "splitpath"},
  {&__pyx_n_st_ctime, "st_ctime"},
  {&__pyx_n_st_dev, "st_dev"},
  {&__pyx_n_st_ino, "st_ino"},
  {&__pyx_n_st_mode, "st_mode"},
  {&__pyx_n_st_mtime, "st_mtime"},
  {&__pyx_n_st_size, "st_size"},
  {&__pyx_n_stat, "stat"},
  {&__pyx_n_stat_and_sha1, "stat_and_sha1"},
  {&__pyx_n_struct, "struct"},
  {&__pyx_n_symlink, "symlink"},
  {&__pyx_n_sys, "sys"},
  {&__pyx_n_utf8, "utf8"},
  {&__pyx_n_win32, "win32"},
  {&__pyx_n_winerror, "winerror"},
  {0, 0}
};

static __Pyx_StringTabEntry __pyx_string_tab[] = {
  {&__pyx_k11p, __pyx_k11, sizeof(__pyx_k11)},
  {&__pyx_k13p, __pyx_k13, sizeof(__pyx_k13)},
  {&__pyx_k26p, __pyx_k26, sizeof(__pyx_k26)},
  {&__pyx_k27p, __pyx_k27, sizeof(__pyx_k27)},
  {&__pyx_k28p, __pyx_k28, sizeof(__pyx_k28)},
  {&__pyx_k29p, __pyx_k29, sizeof(__pyx_k29)},
  {&__pyx_k30p, __pyx_k30, sizeof(__pyx_k30)},
  {&__pyx_k31p, __pyx_k31, sizeof(__pyx_k31)},
  {&__pyx_k32p, __pyx_k32, sizeof(__pyx_k32)},
  {&__pyx_k35p, __pyx_k35, sizeof(__pyx_k35)},
  {&__pyx_k36p, __pyx_k36, sizeof(__pyx_k36)},
  {&__pyx_k37p, __pyx_k37, sizeof(__pyx_k37)},
  {&__pyx_k38p, __pyx_k38, sizeof(__pyx_k38)},
  {&__pyx_k39p, __pyx_k39, sizeof(__pyx_k39)},
  {&__pyx_k40p, __pyx_k40, sizeof(__pyx_k40)},
  {&__pyx_k41p, __pyx_k41, sizeof(__pyx_k41)},
  {&__pyx_k42p, __pyx_k42, sizeof(__pyx_k42)},
  {&__pyx_k43p, __pyx_k43, sizeof(__pyx_k43)},
  {&__pyx_k44p, __pyx_k44, sizeof(__pyx_k44)},
  {&__pyx_k45p, __pyx_k45, sizeof(__pyx_k45)},
  {&__pyx_k46p, __pyx_k46, sizeof(__pyx_k46)},
  {&__pyx_k47p, __pyx_k47, sizeof(__pyx_k47)},
  {&__pyx_k48p, __pyx_k48, sizeof(__pyx_k48)},
  {&__pyx_k49p, __pyx_k49, sizeof(__pyx_k49)},
  {&__pyx_k53p, __pyx_k53, sizeof(__pyx_k53)},
  {&__pyx_k55p, __pyx_k55, sizeof(__pyx_k55)},
  {&__pyx_k58p, __pyx_k58, sizeof(__pyx_k58)},
  {&__pyx_k59p, __pyx_k59, sizeof(__pyx_k59)},
  {&__pyx_k61p, __pyx_k61, sizeof(__pyx_k61)},
  {&__pyx_k65p, __pyx_k65, sizeof(__pyx_k65)},
  {&__pyx_k66p, __pyx_k66, sizeof(__pyx_k66)},
  {&__pyx_k69p, __pyx_k69, sizeof(__pyx_k69)},
  {&__pyx_k71p, __pyx_k71, sizeof(__pyx_k71)},
  {&__pyx_k73p, __pyx_k73, sizeof(__pyx_k73)},
  {&__pyx_k75p, __pyx_k75, sizeof(__pyx_k75)},
  {&__pyx_k77p, __pyx_k77, sizeof(__pyx_k77)},
  {&__pyx_k78p, __pyx_k78, sizeof(__pyx_k78)},
  {&__pyx_k81p, __pyx_k81, sizeof(__pyx_k81)},
  {&__pyx_k82p, __pyx_k82, sizeof(__pyx_k82)},
  {&__pyx_k83p, __pyx_k83, sizeof(__pyx_k83)},
  {&__pyx_k84p, __pyx_k84, sizeof(__pyx_k84)},
  {&__pyx_k85p, __pyx_k85, sizeof(__pyx_k85)},
  {&__pyx_k87p, __pyx_k87, sizeof(__pyx_k87)},
  {&__pyx_k89p, __pyx_k89, sizeof(__pyx_k89)},
  {&__pyx_k90p, __pyx_k90, sizeof(__pyx_k90)},
  {&__pyx_k92p, __pyx_k92, sizeof(__pyx_k92)},
  {&__pyx_k94p, __pyx_k94, sizeof(__pyx_k94)},
  {0, 0, 0}
};
static struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader __pyx_vtable_19_dirstate_helpers_c_Reader;

static PyObject *__pyx_tp_new_19_dirstate_helpers_c_Reader(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_19_dirstate_helpers_c_Reader *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_19_dirstate_helpers_c_Reader *)o);
  *(struct __pyx_vtabstruct_19_dirstate_helpers_c_Reader **)&p->__pyx_vtab = __pyx_vtabptr_19_dirstate_helpers_c_Reader;
  p->state = Py_None; Py_INCREF(Py_None);
  p->text = Py_None; Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_19_dirstate_helpers_c_Reader(PyObject *o) {
  struct __pyx_obj_19_dirstate_helpers_c_Reader *p = (struct __pyx_obj_19_dirstate_helpers_c_Reader *)o;
  Py_XDECREF(p->state);
  Py_XDECREF(p->text);
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_19_dirstate_helpers_c_Reader(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_19_dirstate_helpers_c_Reader *p = (struct __pyx_obj_19_dirstate_helpers_c_Reader *)o;
  if (p->state) {
    e = (*v)(p->state, a); if (e) return e;
  }
  if (p->text) {
    e = (*v)(p->text, a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_19_dirstate_helpers_c_Reader(PyObject *o) {
  struct __pyx_obj_19_dirstate_helpers_c_Reader *p = (struct __pyx_obj_19_dirstate_helpers_c_Reader *)o;
  PyObject *t;
  t = p->state; 
  p->state = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->text; 
  p->text = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  return 0;
}

static struct PyMethodDef __pyx_methods_19_dirstate_helpers_c_Reader[] = {
  {"_parse_dirblocks", (PyCFunction)__pyx_f_19_dirstate_helpers_c_6Reader__parse_dirblocks, METH_VARARGS|METH_KEYWORDS, __pyx_doc_19_dirstate_helpers_c_6Reader__parse_dirblocks},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_Reader = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_Reader = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_Reader = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_Reader = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_19_dirstate_helpers_c_Reader = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "_dirstate_helpers_c.Reader", /*tp_name*/
  sizeof(struct __pyx_obj_19_dirstate_helpers_c_Reader), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_19_dirstate_helpers_c_Reader, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_Reader, /*tp_as_number*/
  &__pyx_tp_as_sequence_Reader, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_Reader, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_Reader, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  "Maintain the current location, and return fields as you parse them.", /*tp_doc*/
  __pyx_tp_traverse_19_dirstate_helpers_c_Reader, /*tp_traverse*/
  __pyx_tp_clear_19_dirstate_helpers_c_Reader, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_19_dirstate_helpers_c_Reader, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_19_dirstate_helpers_c_6Reader___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_19_dirstate_helpers_c_Reader, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};
static struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC __pyx_vtable_19_dirstate_helpers_c_ProcessEntryC;

static PyObject *__pyx_tp_new_19_dirstate_helpers_c_ProcessEntryC(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)o);
  *(struct __pyx_vtabstruct_19_dirstate_helpers_c_ProcessEntryC **)&p->__pyx_vtab = __pyx_vtabptr_19_dirstate_helpers_c_ProcessEntryC;
  p->old_dirname_to_file_id = Py_None; Py_INCREF(Py_None);
  p->new_dirname_to_file_id = Py_None; Py_INCREF(Py_None);
  p->uninteresting = Py_None; Py_INCREF(Py_None);
  p->last_source_parent = Py_None; Py_INCREF(Py_None);
  p->last_target_parent = Py_None; Py_INCREF(Py_None);
  p->include_unchanged = Py_None; Py_INCREF(Py_None);
  p->use_filesystem_for_exec = Py_None; Py_INCREF(Py_None);
  p->utf8_decode = Py_None; Py_INCREF(Py_None);
  p->searched_specific_files = Py_None; Py_INCREF(Py_None);
  p->search_specific_files = Py_None; Py_INCREF(Py_None);
  p->state = Py_None; Py_INCREF(Py_None);
  p->current_root = Py_None; Py_INCREF(Py_None);
  p->current_root_unicode = Py_None; Py_INCREF(Py_None);
  p->root_entries = Py_None; Py_INCREF(Py_None);
  p->root_abspath = Py_None; Py_INCREF(Py_None);
  p->tree = Py_None; Py_INCREF(Py_None);
  p->dir_iterator = Py_None; Py_INCREF(Py_None);
  p->current_block = Py_None; Py_INCREF(Py_None);
  p->current_block_list = Py_None; Py_INCREF(Py_None);
  p->current_dir_info = Py_None; Py_INCREF(Py_None);
  p->current_dir_list = Py_None; Py_INCREF(Py_None);
  p->root_dir_info = Py_None; Py_INCREF(Py_None);
  p->bisect_left = Py_None; Py_INCREF(Py_None);
  p->pathjoin = Py_None; Py_INCREF(Py_None);
  p->fstat = Py_None; Py_INCREF(Py_None);
  p->sha_file = Py_None; Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_19_dirstate_helpers_c_ProcessEntryC(PyObject *o) {
  struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *p = (struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)o;
  Py_XDECREF(p->old_dirname_to_file_id);
  Py_XDECREF(p->new_dirname_to_file_id);
  Py_XDECREF(p->uninteresting);
  Py_XDECREF(p->last_source_parent);
  Py_XDECREF(p->last_target_parent);
  Py_XDECREF(p->include_unchanged);
  Py_XDECREF(p->use_filesystem_for_exec);
  Py_XDECREF(p->utf8_decode);
  Py_XDECREF(p->searched_specific_files);
  Py_XDECREF(p->search_specific_files);
  Py_XDECREF(p->state);
  Py_XDECREF(p->current_root);
  Py_XDECREF(p->current_root_unicode);
  Py_XDECREF(p->root_entries);
  Py_XDECREF(p->root_abspath);
  Py_XDECREF(p->tree);
  Py_XDECREF(p->dir_iterator);
  Py_XDECREF(p->current_block);
  Py_XDECREF(p->current_block_list);
  Py_XDECREF(p->current_dir_info);
  Py_XDECREF(p->current_dir_list);
  Py_XDECREF(p->root_dir_info);
  Py_XDECREF(p->bisect_left);
  Py_XDECREF(p->pathjoin);
  Py_XDECREF(p->fstat);
  Py_XDECREF(p->sha_file);
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_19_dirstate_helpers_c_ProcessEntryC(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *p = (struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)o;
  if (p->old_dirname_to_file_id) {
    e = (*v)(p->old_dirname_to_file_id, a); if (e) return e;
  }
  if (p->new_dirname_to_file_id) {
    e = (*v)(p->new_dirname_to_file_id, a); if (e) return e;
  }
  if (p->uninteresting) {
    e = (*v)(p->uninteresting, a); if (e) return e;
  }
  if (p->last_source_parent) {
    e = (*v)(p->last_source_parent, a); if (e) return e;
  }
  if (p->last_target_parent) {
    e = (*v)(p->last_target_parent, a); if (e) return e;
  }
  if (p->include_unchanged) {
    e = (*v)(p->include_unchanged, a); if (e) return e;
  }
  if (p->use_filesystem_for_exec) {
    e = (*v)(p->use_filesystem_for_exec, a); if (e) return e;
  }
  if (p->utf8_decode) {
    e = (*v)(p->utf8_decode, a); if (e) return e;
  }
  if (p->searched_specific_files) {
    e = (*v)(p->searched_specific_files, a); if (e) return e;
  }
  if (p->search_specific_files) {
    e = (*v)(p->search_specific_files, a); if (e) return e;
  }
  if (p->state) {
    e = (*v)(p->state, a); if (e) return e;
  }
  if (p->current_root) {
    e = (*v)(p->current_root, a); if (e) return e;
  }
  if (p->current_root_unicode) {
    e = (*v)(p->current_root_unicode, a); if (e) return e;
  }
  if (p->root_entries) {
    e = (*v)(p->root_entries, a); if (e) return e;
  }
  if (p->root_abspath) {
    e = (*v)(p->root_abspath, a); if (e) return e;
  }
  if (p->tree) {
    e = (*v)(p->tree, a); if (e) return e;
  }
  if (p->dir_iterator) {
    e = (*v)(p->dir_iterator, a); if (e) return e;
  }
  if (p->current_block) {
    e = (*v)(p->current_block, a); if (e) return e;
  }
  if (p->current_block_list) {
    e = (*v)(p->current_block_list, a); if (e) return e;
  }
  if (p->current_dir_info) {
    e = (*v)(p->current_dir_info, a); if (e) return e;
  }
  if (p->current_dir_list) {
    e = (*v)(p->current_dir_list, a); if (e) return e;
  }
  if (p->root_dir_info) {
    e = (*v)(p->root_dir_info, a); if (e) return e;
  }
  if (p->bisect_left) {
    e = (*v)(p->bisect_left, a); if (e) return e;
  }
  if (p->pathjoin) {
    e = (*v)(p->pathjoin, a); if (e) return e;
  }
  if (p->fstat) {
    e = (*v)(p->fstat, a); if (e) return e;
  }
  if (p->sha_file) {
    e = (*v)(p->sha_file, a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_19_dirstate_helpers_c_ProcessEntryC(PyObject *o) {
  struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *p = (struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC *)o;
  PyObject *t;
  t = p->old_dirname_to_file_id; 
  p->old_dirname_to_file_id = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->new_dirname_to_file_id; 
  p->new_dirname_to_file_id = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->uninteresting; 
  p->uninteresting = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->last_source_parent; 
  p->last_source_parent = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->last_target_parent; 
  p->last_target_parent = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->include_unchanged; 
  p->include_unchanged = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->use_filesystem_for_exec; 
  p->use_filesystem_for_exec = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->utf8_decode; 
  p->utf8_decode = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->searched_specific_files; 
  p->searched_specific_files = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->search_specific_files; 
  p->search_specific_files = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->state; 
  p->state = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_root; 
  p->current_root = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_root_unicode; 
  p->current_root_unicode = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->root_entries; 
  p->root_entries = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->root_abspath; 
  p->root_abspath = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->tree; 
  p->tree = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->dir_iterator; 
  p->dir_iterator = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_block; 
  p->current_block = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_block_list; 
  p->current_block_list = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_dir_info; 
  p->current_dir_info = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->current_dir_list; 
  p->current_dir_list = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->root_dir_info; 
  p->root_dir_info = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->bisect_left; 
  p->bisect_left = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->pathjoin; 
  p->pathjoin = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->fstat; 
  p->fstat = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  t = p->sha_file; 
  p->sha_file = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(t);
  return 0;
}

static struct PyMethodDef __pyx_methods_19_dirstate_helpers_c_ProcessEntryC[] = {
  {"iter_changes", (PyCFunction)__pyx_f_19_dirstate_helpers_c_13ProcessEntryC_iter_changes, METH_VARARGS|METH_KEYWORDS, 0},
  {0, 0, 0, 0}
};

static struct PyMemberDef __pyx_members_19_dirstate_helpers_c_ProcessEntryC[] = {
  {"uninteresting", T_OBJECT, offsetof(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC, uninteresting), READONLY, 0},
  {"searched_specific_files", T_OBJECT, offsetof(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC, searched_specific_files), READONLY, 0},
  {0, 0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_ProcessEntryC = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_ProcessEntryC = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_ProcessEntryC = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_ProcessEntryC = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_19_dirstate_helpers_c_ProcessEntryC = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "_dirstate_helpers_c.ProcessEntryC", /*tp_name*/
  sizeof(struct __pyx_obj_19_dirstate_helpers_c_ProcessEntryC), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_19_dirstate_helpers_c_ProcessEntryC, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_ProcessEntryC, /*tp_as_number*/
  &__pyx_tp_as_sequence_ProcessEntryC, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_ProcessEntryC, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_ProcessEntryC, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_19_dirstate_helpers_c_ProcessEntryC, /*tp_traverse*/
  __pyx_tp_clear_19_dirstate_helpers_c_ProcessEntryC, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_19_dirstate_helpers_c_13ProcessEntryC___iter__, /*tp_iter*/
  __pyx_f_19_dirstate_helpers_c_13ProcessEntryC___next__, /*tp_iternext*/
  __pyx_methods_19_dirstate_helpers_c_ProcessEntryC, /*tp_methods*/
  __pyx_members_19_dirstate_helpers_c_ProcessEntryC, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_19_dirstate_helpers_c_13ProcessEntryC___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_19_dirstate_helpers_c_ProcessEntryC, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static struct PyMethodDef __pyx_methods[] = {
  {"_py_memrchr", (PyCFunction)__pyx_f_19_dirstate_helpers_c__py_memrchr, METH_VARARGS|METH_KEYWORDS, __pyx_doc_19_dirstate_helpers_c__py_memrchr},
  {"cmp_by_dirs_c", (PyCFunction)__pyx_f_19_dirstate_helpers_c_cmp_by_dirs_c, METH_VARARGS|METH_KEYWORDS, __pyx_doc_19_dirstate_helpers_c_cmp_by_dirs_c},
  {"_cmp_path_by_dirblock_c", (PyCFunction)__pyx_f_19_dirstate_helpers_c__cmp_path_by_dirblock_c, METH_VARARGS|METH_KEYWORDS, __pyx_doc_19_dirstate_helpers_c__cmp_path_by_dirblock_c},
  {"_bisect_path_left_c", (PyCFunction)__pyx_f_19_dirstate_helpers_c__bisect_path_left_c, METH_VARARGS|METH_KEYWORDS, __pyx_doc_19_dirstate_helpers_c__bisect_path_left_c},
  {"_bisect_path_right_c", (PyCFunction)__pyx_f_19_dirstate_helpers_c__bisect_path_right_c, METH_VARARGS|METH_KEYWORDS, __pyx_doc_19_dirstate_helpers_c__bisect_path_right_c},
  {"bisect_dirblock_c", (PyCFunction)__pyx_f_19_dirstate_helpers_c_bisect_dirblock_c, METH_VARARGS|METH_KEYWORDS, __pyx_doc_19_dirstate_helpers_c_bisect_dirblock_c},
  {"_read_dirblocks_c", (PyCFunction)__pyx_f_19_dirstate_helpers_c__read_dirblocks_c, METH_VARARGS|METH_KEYWORDS, __pyx_doc_19_dirstate_helpers_c__read_dirblocks_c},
  {"update_entry", (PyCFunction)__pyx_f_19_dirstate_helpers_c_update_entry, METH_VARARGS|METH_KEYWORDS, __pyx_doc_19_dirstate_helpers_c_update_entry},
  {0, 0, 0, 0}
};

static void __pyx_init_filenames(void); /*proto*/

PyMODINIT_FUNC init_dirstate_helpers_c(void); /*proto*/
PyMODINIT_FUNC init_dirstate_helpers_c(void) {
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  __pyx_init_filenames();
  __pyx_m = Py_InitModule4("_dirstate_helpers_c", __pyx_methods, __pyx_mdoc, 0, PYTHON_API_VERSION);
  if (!__pyx_m) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;};
  Py_INCREF(__pyx_m);
  __pyx_b = PyImport_AddModule("__builtin__");
  if (!__pyx_b) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;};
  if (PyObject_SetAttrString(__pyx_m, "__builtins__", __pyx_b) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;};
  if (__Pyx_InternStrings(__pyx_intern_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;};
  if (__Pyx_InitStrings(__pyx_string_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;};
  __pyx_v_19_dirstate_helpers_c__kind_absent = Py_None; Py_INCREF(Py_None);
  __pyx_v_19_dirstate_helpers_c__kind_file = Py_None; Py_INCREF(Py_None);
  __pyx_v_19_dirstate_helpers_c__kind_directory = Py_None; Py_INCREF(Py_None);
  __pyx_v_19_dirstate_helpers_c__kind_symlink = Py_None; Py_INCREF(Py_None);
  __pyx_v_19_dirstate_helpers_c__kind_relocated = Py_None; Py_INCREF(Py_None);
  __pyx_v_19_dirstate_helpers_c__kind_tree_reference = Py_None; Py_INCREF(Py_None);
  __pyx_vtabptr_19_dirstate_helpers_c_Reader = &__pyx_vtable_19_dirstate_helpers_c_Reader;
  *(void(**)(void))&__pyx_vtable_19_dirstate_helpers_c_Reader.get_next = (void(*)(void))__pyx_f_19_dirstate_helpers_c_6Reader_get_next;
  *(void(**)(void))&__pyx_vtable_19_dirstate_helpers_c_Reader.get_next_str = (void(*)(void))__pyx_f_19_dirstate_helpers_c_6Reader_get_next_str;
  *(void(**)(void))&__pyx_vtable_19_dirstate_helpers_c_Reader._init = (void(*)(void))__pyx_f_19_dirstate_helpers_c_6Reader__init;
  *(void(**)(void))&__pyx_vtable_19_dirstate_helpers_c_Reader._get_entry = (void(*)(void))__pyx_f_19_dirstate_helpers_c_6Reader__get_entry;
  __pyx_type_19_dirstate_helpers_c_Reader.tp_free = _PyObject_GC_Del;
  if (PyType_Ready(&__pyx_type_19_dirstate_helpers_c_Reader) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 524; goto __pyx_L1;}
  if (__Pyx_SetVtable(__pyx_type_19_dirstate_helpers_c_Reader.tp_dict, __pyx_vtabptr_19_dirstate_helpers_c_Reader) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 524; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "Reader", (PyObject *)&__pyx_type_19_dirstate_helpers_c_Reader) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 524; goto __pyx_L1;}
  __pyx_ptype_19_dirstate_helpers_c_Reader = &__pyx_type_19_dirstate_helpers_c_Reader;
  __pyx_vtabptr_19_dirstate_helpers_c_ProcessEntryC = &__pyx_vtable_19_dirstate_helpers_c_ProcessEntryC;
  *(void(**)(void))&__pyx_vtable_19_dirstate_helpers_c_ProcessEntryC._process_entry = (void(*)(void))__pyx_f_19_dirstate_helpers_c_13ProcessEntryC__process_entry;
  *(void(**)(void))&__pyx_vtable_19_dirstate_helpers_c_ProcessEntryC._update_current_block = (void(*)(void))__pyx_f_19_dirstate_helpers_c_13ProcessEntryC__update_current_block;
  *(void(**)(void))&__pyx_vtable_19_dirstate_helpers_c_ProcessEntryC._iter_next = (void(*)(void))__pyx_f_19_dirstate_helpers_c_13ProcessEntryC__iter_next;
  *(void(**)(void))&__pyx_vtable_19_dirstate_helpers_c_ProcessEntryC._maybe_tree_ref = (void(*)(void))__pyx_f_19_dirstate_helpers_c_13ProcessEntryC__maybe_tree_ref;
  *(void(**)(void))&__pyx_vtable_19_dirstate_helpers_c_ProcessEntryC._loop_one_block = (void(*)(void))__pyx_f_19_dirstate_helpers_c_13ProcessEntryC__loop_one_block;
  __pyx_type_19_dirstate_helpers_c_ProcessEntryC.tp_free = _PyObject_GC_Del;
  if (PyType_Ready(&__pyx_type_19_dirstate_helpers_c_ProcessEntryC) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 962; goto __pyx_L1;}
  if (__Pyx_SetVtable(__pyx_type_19_dirstate_helpers_c_ProcessEntryC.tp_dict, __pyx_vtabptr_19_dirstate_helpers_c_ProcessEntryC) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 962; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ProcessEntryC", (PyObject *)&__pyx_type_19_dirstate_helpers_c_ProcessEntryC) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 962; goto __pyx_L1;}
  __pyx_ptype_19_dirstate_helpers_c_ProcessEntryC = &__pyx_type_19_dirstate_helpers_c_ProcessEntryC;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":22 */
  __pyx_1 = __Pyx_Import(__pyx_n_binascii, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 22; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_binascii, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 22; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":23 */
  __pyx_1 = __Pyx_Import(__pyx_n_bisect, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 23; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_bisect, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 23; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":24 */
  __pyx_1 = __Pyx_Import(__pyx_n_errno, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 24; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_errno, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 24; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":25 */
  __pyx_1 = __Pyx_Import(__pyx_n_os, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 25; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_os, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 25; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":26 */
  __pyx_1 = __Pyx_Import(__pyx_n_stat, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 26; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_stat, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 26; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":27 */
  __pyx_1 = __Pyx_Import(__pyx_n_sys, 0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 27; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_sys, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 27; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":29 */
  __pyx_1 = PyList_New(3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  Py_INCREF(__pyx_n_cache_utf8);
  PyList_SET_ITEM(__pyx_1, 0, __pyx_n_cache_utf8);
  Py_INCREF(__pyx_n_errors);
  PyList_SET_ITEM(__pyx_1, 1, __pyx_n_errors);
  Py_INCREF(__pyx_n_osutils);
  PyList_SET_ITEM(__pyx_1, 2, __pyx_n_osutils);
  __pyx_2 = __Pyx_Import(__pyx_n_bzrlib, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_cache_utf8); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_cache_utf8, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_errors); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_errors, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_osutils); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_osutils, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 29; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":30 */
  __pyx_2 = PyList_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 30; goto __pyx_L1;}
  Py_INCREF(__pyx_n_DirState);
  PyList_SET_ITEM(__pyx_2, 0, __pyx_n_DirState);
  __pyx_1 = __Pyx_Import(__pyx_k11p, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 30; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_n_DirState); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 30; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_DirState, __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 30; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":31 */
  __pyx_1 = PyList_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  Py_INCREF(__pyx_n_pathjoin);
  PyList_SET_ITEM(__pyx_1, 0, __pyx_n_pathjoin);
  Py_INCREF(__pyx_n_splitpath);
  PyList_SET_ITEM(__pyx_1, 1, __pyx_n_splitpath);
  __pyx_2 = __Pyx_Import(__pyx_k13p, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_pathjoin); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_pathjoin, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_splitpath); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_splitpath, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 31; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":39 */
  __pyx_v_19_dirstate_helpers_c_ERROR_PATH_NOT_FOUND = 3;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":41 */
  __pyx_v_19_dirstate_helpers_c_ERROR_DIRECTORY = 267;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":475 */
  __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 475; goto __pyx_L1;}
  __pyx_k16 = __pyx_2;
  __pyx_2 = 0;
  Py_INCREF(Py_None);
  __pyx_k17 = Py_None;
  Py_INCREF(Py_None);
  __pyx_k18 = Py_None;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":780 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_n_binascii); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 780; goto __pyx_L1;}
  __pyx_3 = PyObject_GetAttr(__pyx_1, __pyx_n_b2a_base64); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 780; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (PyObject_SetAttr(__pyx_m, __pyx_n__encode, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 780; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":783 */
  __pyx_1 = PyList_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 783; goto __pyx_L1;}
  Py_INCREF(__pyx_n_pack);
  PyList_SET_ITEM(__pyx_1, 0, __pyx_n_pack);
  __pyx_3 = __Pyx_Import(__pyx_n_struct, __pyx_1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 783; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_3, __pyx_n_pack); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 783; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n_pack, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 783; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":927 */
  Py_INCREF(__pyx_n_absent);
  Py_DECREF(__pyx_v_19_dirstate_helpers_c__kind_absent);
  __pyx_v_19_dirstate_helpers_c__kind_absent = __pyx_n_absent;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":928 */
  Py_INCREF(__pyx_n_file);
  Py_DECREF(__pyx_v_19_dirstate_helpers_c__kind_file);
  __pyx_v_19_dirstate_helpers_c__kind_file = __pyx_n_file;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":929 */
  Py_INCREF(__pyx_n_directory);
  Py_DECREF(__pyx_v_19_dirstate_helpers_c__kind_directory);
  __pyx_v_19_dirstate_helpers_c__kind_directory = __pyx_n_directory;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":930 */
  Py_INCREF(__pyx_n_symlink);
  Py_DECREF(__pyx_v_19_dirstate_helpers_c__kind_symlink);
  __pyx_v_19_dirstate_helpers_c__kind_symlink = __pyx_n_symlink;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":931 */
  Py_INCREF(__pyx_n_relocated);
  Py_DECREF(__pyx_v_19_dirstate_helpers_c__kind_relocated);
  __pyx_v_19_dirstate_helpers_c__kind_relocated = __pyx_n_relocated;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":932 */
  Py_INCREF(__pyx_k26p);
  Py_DECREF(__pyx_v_19_dirstate_helpers_c__kind_tree_reference);
  __pyx_v_19_dirstate_helpers_c__kind_tree_reference = __pyx_k26p;

  /* "/home/jml/src/bzr/bzr.1.16/bzrlib/_dirstate_helpers_c.pyx":1631 */
  return;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("_dirstate_helpers_c");
}

static char *__pyx_filenames[] = {
  "_dirstate_helpers_c.pyx",
};

/* Runtime support code */

static void __pyx_init_filenames(void) {
  __pyx_f = __pyx_filenames;
}

static PyObject *__Pyx_Import(PyObject *name, PyObject *from_list) {
    PyObject *__import__ = 0;
    PyObject *empty_list = 0;
    PyObject *module = 0;
    PyObject *global_dict = 0;
    PyObject *empty_dict = 0;
    PyObject *list;
    __import__ = PyObject_GetAttrString(__pyx_b, "__import__");
    if (!__import__)
        goto bad;
    if (from_list)
        list = from_list;
    else {
        empty_list = PyList_New(0);
        if (!empty_list)
            goto bad;
        list = empty_list;
    }
    global_dict = PyModule_GetDict(__pyx_m);
    if (!global_dict)
        goto bad;
    empty_dict = PyDict_New();
    if (!empty_dict)
        goto bad;
    module = PyObject_CallFunction(__import__, "OOOO",
        name, global_dict, empty_dict, list);
bad:
    Py_XDECREF(empty_list);
    Py_XDECREF(__import__);
    Py_XDECREF(empty_dict);
    return module;
}

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name) {
    PyObject *result;
    result = PyObject_GetAttr(dict, name);
    if (!result)
        PyErr_SetObject(PyExc_NameError, name);
    return result;
}

static PyObject *__Pyx_GetItemInt(PyObject *o, Py_ssize_t i) {
    PyTypeObject *t = o->ob_type;
    PyObject *r;
    if (t->tp_as_sequence && t->tp_as_sequence->sq_item)
        r = PySequence_GetItem(o, i);
    else {
        PyObject *j = PyInt_FromLong(i);
        if (!j)
            return 0;
        r = PyObject_GetItem(o, j);
        Py_DECREF(j);
    }
    return r;
}

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb) {
    Py_XINCREF(type);
    Py_XINCREF(value);
    Py_XINCREF(tb);
    /* First, check the traceback argument, replacing None with NULL. */
    if (tb == Py_None) {
        Py_DECREF(tb);
        tb = 0;
    }
    else if (tb != NULL && !PyTraceBack_Check(tb)) {
        PyErr_SetString(PyExc_TypeError,
            "raise: arg 3 must be a traceback or None");
        goto raise_error;
    }
    /* Next, replace a missing value with None */
    if (value == NULL) {
        value = Py_None;
        Py_INCREF(value);
    }
    #if PY_VERSION_HEX < 0x02050000
    if (!PyClass_Check(type))
    #else
    if (!PyType_Check(type))
    #endif
    {
        /* Raising an instance.  The value should be a dummy. */
        if (value != Py_None) {
            PyErr_SetString(PyExc_TypeError,
                "instance exception may not have a separate value");
            goto raise_error;
        }
        /* Normalize to raise <class>, <instance> */
        Py_DECREF(value);
        value = type;
        #if PY_VERSION_HEX < 0x02050000
            if (PyInstance_Check(type)) {
                type = (PyObject*) ((PyInstanceObject*)type)->in_class;
                Py_INCREF(type);
            }
            else {
                PyErr_SetString(PyExc_TypeError,
                    "raise: exception must be an old-style class or instance");
                goto raise_error;
            }
        #else
            type = (PyObject*) type->ob_type;
            Py_INCREF(type);
            if (!PyType_IsSubtype((PyTypeObject *)type, (PyTypeObject *)PyExc_BaseException)) {
                PyErr_SetString(PyExc_TypeError,
                    "raise: exception class must be a subclass of BaseException");
                goto raise_error;
            }
        #endif
    }
    PyErr_Restore(type, value, tb);
    return;
raise_error:
    Py_XDECREF(value);
    Py_XDECREF(type);
    Py_XDECREF(tb);
    return;
}

static int __Pyx_SetItemInt(PyObject *o, Py_ssize_t i, PyObject *v) {
    PyTypeObject *t = o->ob_type;
    int r;
    if (t->tp_as_sequence && t->tp_as_sequence->sq_item)
        r = PySequence_SetItem(o, i, v);
    else {
        PyObject *j = PyInt_FromLong(i);
        if (!j)
            return -1;
        r = PyObject_SetItem(o, j, v);
        Py_DECREF(j);
    }
    return r;
}

static void __Pyx_UnpackError(void) {
    PyErr_SetString(PyExc_ValueError, "unpack sequence of wrong size");
}

static PyObject *__Pyx_UnpackItem(PyObject *iter) {
    PyObject *item;
    if (!(item = PyIter_Next(iter))) {
        if (!PyErr_Occurred())
            __Pyx_UnpackError();
    }
    return item;
}

static int __Pyx_EndUnpack(PyObject *iter) {
    PyObject *item;
    if ((item = PyIter_Next(iter))) {
        Py_DECREF(item);
        __Pyx_UnpackError();
        return -1;
    }
    else if (!PyErr_Occurred())
        return 0;
    else
        return -1;
}

static int __Pyx_GetException(PyObject **type, PyObject **value, PyObject **tb) {
    PyThreadState *tstate = PyThreadState_Get();
    PyErr_Fetch(type, value, tb);
    PyErr_NormalizeException(type, value, tb);
    if (PyErr_Occurred())
        goto bad;
    Py_INCREF(*type);
    Py_INCREF(*value);
    Py_INCREF(*tb);
    Py_XDECREF(tstate->exc_type);
    Py_XDECREF(tstate->exc_value);
    Py_XDECREF(tstate->exc_traceback);
    tstate->exc_type = *type;
    tstate->exc_value = *value;
    tstate->exc_traceback = *tb;
    return 0;
bad:
    Py_XDECREF(*type);
    Py_XDECREF(*value);
    Py_XDECREF(*tb);
    return -1;
}

static void __Pyx_WriteUnraisable(char *name) {
    PyObject *old_exc, *old_val, *old_tb;
    PyObject *ctx;
    PyErr_Fetch(&old_exc, &old_val, &old_tb);
    ctx = PyString_FromString(name);
    PyErr_Restore(old_exc, old_val, old_tb);
    if (!ctx)
        ctx = Py_None;
    PyErr_WriteUnraisable(ctx);
}

static int __Pyx_InternStrings(__Pyx_InternTabEntry *t) {
    while (t->p) {
        *t->p = PyString_InternFromString(t->s);
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t) {
    while (t->p) {
        *t->p = PyString_FromStringAndSize(t->s, t->n - 1);
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

static int __Pyx_SetVtable(PyObject *dict, void *vtable) {
    PyObject *pycobj = 0;
    int result;
    
    pycobj = PyCObject_FromVoidPtr(vtable, 0);
    if (!pycobj)
        goto bad;
    if (PyDict_SetItemString(dict, "__pyx_vtable__", pycobj) < 0)
        goto bad;
    result = 0;
    goto done;

bad:
    result = -1;
done:
    Py_XDECREF(pycobj);
    return result;
}

#include "compile.h"
#include "frameobject.h"
#include "traceback.h"

static void __Pyx_AddTraceback(char *funcname) {
    PyObject *py_srcfile = 0;
    PyObject *py_funcname = 0;
    PyObject *py_globals = 0;
    PyObject *empty_tuple = 0;
    PyObject *empty_string = 0;
    PyCodeObject *py_code = 0;
    PyFrameObject *py_frame = 0;
    
    py_srcfile = PyString_FromString(__pyx_filename);
    if (!py_srcfile) goto bad;
    py_funcname = PyString_FromString(funcname);
    if (!py_funcname) goto bad;
    py_globals = PyModule_GetDict(__pyx_m);
    if (!py_globals) goto bad;
    empty_tuple = PyTuple_New(0);
    if (!empty_tuple) goto bad;
    empty_string = PyString_FromString("");
    if (!empty_string) goto bad;
    py_code = PyCode_New(
        0,            /*int argcount,*/
        0,            /*int nlocals,*/
        0,            /*int stacksize,*/
        0,            /*int flags,*/
        empty_string, /*PyObject *code,*/
        empty_tuple,  /*PyObject *consts,*/
        empty_tuple,  /*PyObject *names,*/
        empty_tuple,  /*PyObject *varnames,*/
        empty_tuple,  /*PyObject *freevars,*/
        empty_tuple,  /*PyObject *cellvars,*/
        py_srcfile,   /*PyObject *filename,*/
        py_funcname,  /*PyObject *name,*/
        __pyx_lineno,   /*int firstlineno,*/
        empty_string  /*PyObject *lnotab*/
    );
    if (!py_code) goto bad;
    py_frame = PyFrame_New(
        PyThreadState_Get(), /*PyThreadState *tstate,*/
        py_code,             /*PyCodeObject *code,*/
        py_globals,          /*PyObject *globals,*/
        0                    /*PyObject *locals*/
    );
    if (!py_frame) goto bad;
    py_frame->f_lineno = __pyx_lineno;
    PyTraceBack_Here(py_frame);
bad:
    Py_XDECREF(py_srcfile);
    Py_XDECREF(py_funcname);
    Py_XDECREF(empty_tuple);
    Py_XDECREF(empty_string);
    Py_XDECREF(py_code);
    Py_XDECREF(py_frame);
}
