/*
 *  libghal
 *
 *  Copyright (c) 2007 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ghal-volume-disc.h"
#include "ghal-private.h"

struct _GHalVolumeDiscPrivate
{
    
};

static void ghal_volume_disc_class_init(GHalVolumeDiscClass *klass);

static void ghal_volume_disc_init(GHalVolumeDisc *instance);
static void ghal_volume_disc_finalize(GObject *obj);


G_DEFINE_TYPE(GHalVolumeDisc, ghal_volume_disc, GHAL_TYPE_VOLUME)


static void
ghal_volume_disc_class_init(GHalVolumeDiscClass *klass)
{
     GObjectClass *object_class = (GObjectClass *)klass;
     
     g_type_class_add_private(klass, sizeof(GHalVolumeDiscPrivate));
     
     object_class->finalize = ghal_volume_disc_finalize;
}

static void
ghal_volume_disc_init(GHalVolumeDisc *disc)
{
    disc->priv = G_TYPE_INSTANCE_GET_PRIVATE(disc, GHAL_TYPE_VOLUME_DISC,
                                             GHalVolumeDiscPrivate);
}

static void
ghal_volume_disc_finalize(GObject *obj)
{
    G_OBJECT_CLASS(ghal_volume_disc_parent_class)->finalize(obj);
}



guint64
ghal_volume_disc_get_capacity(GHalVolumeDisc *disc)
{
    LibHalVolume *hal_volume = NULL;
    
    g_return_val_if_fail(GHAL_IS_VOLUME_DISC(disc)
                         && (hal_volume = _ghal_volume_peek_libhal_volume(GHAL_VOLUME(disc))),
                         0);
    
    return libhal_volume_get_disc_capacity(hal_volume);
}

gboolean
ghal_volume_disc_has_audio(GHalVolumeDisc *disc)
{
    LibHalVolume *hal_volume = NULL;
    
    g_return_val_if_fail(GHAL_IS_VOLUME_DISC(disc)
                         && (hal_volume = _ghal_volume_peek_libhal_volume(GHAL_VOLUME(disc))),
                         FALSE);
    
    return libhal_volume_disc_has_audio(hal_volume);
}

gboolean
ghal_volume_disc_has_data(GHalVolumeDisc *disc)
{
    LibHalVolume *hal_volume = NULL;
    
    g_return_val_if_fail(GHAL_IS_VOLUME_DISC(disc)
                         && (hal_volume = _ghal_volume_peek_libhal_volume(GHAL_VOLUME(disc))),
                         FALSE);
    
    return libhal_volume_disc_has_data(hal_volume);
}

gboolean
ghal_volume_disc_is_blank(GHalVolumeDisc *disc)
{
    LibHalVolume *hal_volume = NULL;
    
    g_return_val_if_fail(GHAL_IS_VOLUME_DISC(disc)
                         && (hal_volume = _ghal_volume_peek_libhal_volume(GHAL_VOLUME(disc))),
                         FALSE);
    
    return libhal_volume_disc_is_blank(hal_volume);
}

gboolean
ghal_volume_disc_is_rewritable(GHalVolumeDisc *disc)
{
    LibHalVolume *hal_volume = NULL;
    
    g_return_val_if_fail(GHAL_IS_VOLUME_DISC(disc)
                         && (hal_volume = _ghal_volume_peek_libhal_volume(GHAL_VOLUME(disc))),
                         FALSE);
    
    return libhal_volume_disc_is_rewritable(hal_volume);
}

gboolean
ghal_volume_disc_is_appendable(GHalVolumeDisc *disc)
{
    LibHalVolume *hal_volume = NULL;
    
    g_return_val_if_fail(GHAL_IS_VOLUME_DISC(disc)
                         && (hal_volume = _ghal_volume_peek_libhal_volume(GHAL_VOLUME(disc))),
                         FALSE);
    
    return libhal_volume_disc_is_appendable(hal_volume);
}

LibHalVolumeDiscType
ghal_volume_disc_get_disc_type(GHalVolumeDisc *disc)
{
    LibHalVolume *hal_volume = NULL;
    
    g_return_val_if_fail(GHAL_IS_VOLUME_DISC(disc)
                         && (hal_volume = _ghal_volume_peek_libhal_volume(GHAL_VOLUME(disc))),
                         -1);
    
    return libhal_volume_get_disc_type(hal_volume);
}
