/*
 *  libghal
 *
 *  Copyright (c) 2007 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GHAL_VOLUME_H__
#define __GHAL_VOLUME_H__

#if !defined(GHAL_IN_GHAL_H) && !defined(GHAL_COMPILATION)
#error "Do not include ghal-volume.h directly.  Instead use <ghal/ghal.h>"
#endif

#include <libhal-storage.h>

#include <ghal/ghal-device.h>

#define GHAL_TYPE_VOLUME     (ghal_volume_get_type())
#define GHAL_VOLUME(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), GHAL_TYPE_VOLUME, GHalVolume))
#define GHAL_IS_VOLUME(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GHAL_TYPE_VOLUME))

G_BEGIN_DECLS

typedef struct _GHalVolume         GHalVolume;
typedef struct _GHalVolumeClass    GHalVolumeClass;
typedef struct _GHalVolumePrivate  GHalVolumePrivate;

struct _GHalVolume
{
    GHalDevice parent;
    
    /*< private >*/
    GHalVolumePrivate *priv;
};

struct _GHalVolumeClass
{
    GHalDeviceClass parent;
    
    /*< signals >*/
    void (*mounted)(GHalVolume *volume);
    void (*unmounted)(GHalVolume *volume);
};

GType ghal_volume_get_type() G_GNUC_CONST;

guint64 ghal_volume_get_size(GHalVolume *volume);

const gchar *ghal_volume_get_fstype(GHalVolume *volume);
const gchar *ghal_volume_get_fsversion(GHalVolume *volume);
LibHalVolumeUsage ghal_volume_get_fsusage(GHalVolume *volume);

gboolean ghal_volume_is_mounted(GHalVolume *volume);
gboolean ghal_volume_is_mounted_read_only(GHalVolume *volume);

const char *ghal_volume_get_label(GHalVolume *volume);
const char *ghal_volume_get_mount_point(GHalVolume *volume);
const char *ghal_volume_get_uuid(GHalVolume *volume);

gboolean ghal_volume_should_ignore(GHalVolume *volume);

GHalDevice *ghal_volume_get_storage_device(GHalVolume *volume);

gchar *ghal_volume_get_display_name(GHalVolume *volume);
GList *ghal_volume_get_icon_list(GHalVolume *volume);

G_END_DECLS

#endif  /* __GHAL_VOLUME_H__ */
