#ifdef NETWORK

#include "menu.h"
#include "button.h"
#include "team.h"
#include "files.h"
#include "satellite.h"
#include "update.h"
#include "network.h"
#include "client.h"

#ifdef THREADS
#include <pthread.h>
#include "sky.h"
#endif





// Here we try to match the buffer with an action. We then attempt to
// perform the action. Remember, this is a command from the server, so
// it is either giving us some info or telling us to create something.
int Parse_Client_Data(GLOBALDATA *global, ENVIRONMENT *env, char *buffer)
{
   char args[4][BUFFER_SIZE];
   char letter;
   int dest_string;
   int line_length = strlen(buffer);
   int source_index = 0, dest_index = 0;
  
   // clear buffers
   for (dest_string = 0; dest_string < 4; dest_string++)
       memset(args[dest_string], '\0', BUFFER_SIZE);

   dest_string = 0; 
   // copy buffer into cmd and argument variables
   while ( ( source_index < line_length ) && (dest_string < 4) )
   { 
       letter = buffer[source_index];
       if ( letter == ' ' )
       {
           letter = '\0';
           args[dest_string][dest_index] = letter;
           dest_index = 0;
           dest_string++;
       }
       else
       {
          args[dest_string][dest_index] = letter;
          dest_index++;
       }
       source_index++;
   }
  
   // let us see what we have
   if (! strcmp(args[0], "SERVERVERSION") )
   {
       if (! strcmp(args[1], VERSION) )
          printf("Server version matchs us. OK.\n");
       else
          printf("Server version is %s, we are %s. This is likely to cause problems.\n",
                 args[1], VERSION);
       return TRUE;
   }
   else if (! strcmp(args[0], "WIND") )
   {
       sscanf(args[1], "%lf", & (env->wind) );
       printf("Got wind: %lf\n", env->wind);
       return TRUE;
   }
   else if (! strcmp(args[0], "NUMPLAYERS") )
   {
      int counter;
      sscanf(args[1], "%d", & (global->numPlayers) );
      // create the players in question
      for (counter = 0; counter < global->numPlayers; counter++)
      {
          global->players[counter] = new PLAYER(global, env);
          global->players[counter]->tank = new TANK(global, env);
      }
      printf("Created %d players.\n", global->numPlayers);
      return TRUE;
   }
   else if (! strcmp(args[0], "SURFACE") )
   {
       int x, y;
       sscanf(args[1], "%d", &x);
       sscanf(args[2], "%d", &y);
       env->surface[x] = y;
       printf("Got some surface data at position %d for hieght %d.\n", x, y);
       if (x >= (global->screenWidth - 1) )
         return TRUE;
   }
   else if (! strcmp(args[0], "SCREEN") )
   {
       int width, height;

       sscanf(args[1], "%d", &width);
       sscanf(args[2], "%d", &height);
       if ( (width == global->screenWidth) &&
            (height == global->screenHeight) )
           printf("Host's screen resolution matches ours.\n");
       else
       {
           printf("Host's screen resolution is %d by %d.\n", width, height);
           printf("Ours is %d by %d. This is going to cause problems!\n",
                  global->screenWidth, global->screenHeight);
        }
       return TRUE;
   }
   else if (! strcmp(args[0], "TANKPOSITION") )
   {
       int player_number, x, y;
       PLAYER *my_player;

       sscanf(args[1], "%d", &player_number);
       my_player = global->players[player_number];
       if ( (my_player) && (my_player->tank) )
       {
           sscanf(args[2], "%d", &x);
           sscanf(args[3], "%d", &y);
           my_player->tank->x = x;
           my_player->tank->y = y;
       }
       printf("Placing tank %d at X=%d Y=%d\n", player_number, x, y);
       if (player_number == global->numPlayers - 1)
         return TRUE;
   }
   else if (! strcmp(args[0], "YOUARE") )
   {
       int index;
       sscanf(args[1], "%d", &index );
       if ( (index >= 0) && (index < global->numPlayers) )
          global->client_player = global->players[index];
       return TRUE;
   }

   return FALSE;
}




void Create_Sky(ENVIRONMENT *env, GLOBALDATA *global)
{
 if ( (env->custom_background) && (env->bitmap_filenames) )
  {
     if ( env->sky) destroy_bitmap(env->sky);
     env->sky = load_bitmap( env->bitmap_filenames[ rand() % env->number_of_bitmaps ], NULL);
  }

    if ( (! env->custom_background) || (! env->sky) )
    {
      if ( env->sky ) destroy_bitmap(env->sky);
#ifdef THREADS
      if (env->waiting_sky)
      {
           env->sky = env->waiting_sky;
           env->waiting_sky = NULL;
      }
      else
      {
#endif
      env->sky = create_bitmap( global->screenWidth, global->screenHeight - MENUHEIGHT);
      generate_sky (global, env->sky, sky_gradients[global->cursky],
                   (global->ditherGradients ? GENSKY_DITHERGRAD : 0 ) |
                   (global->detailedSky ? GENSKY_DETAILED : 0 )  );
#ifdef THREADS
      }
#endif
  }

}         // end of create sky function



// Send a shot command to the server
int Client_Fire(PLAYER *my_player, int my_socket)
{
   char buffer[256];

   if (!my_player) return FALSE;
   if (! my_player->tank) return FALSE;

   sprintf(buffer, "FIRE %d %d %d", my_player->tank->cw, my_player->tank->a,
                   my_player->tank->p);
   write(my_socket, buffer, strlen(buffer));
   return TRUE;
}





#endif

