#ifndef CLIENT_HEADER_FILE__
#define CLIENT_HEADER_FILE__

#include "globaldata.h"
#include "environment.h"

#ifdef NETWORK

#define CLIENT_VERSION 1
#define CLIENT_SCREEN 2
#define CLIENT_WIND 3
#define CLIENT_NUMPLAYERS 4
#define CLIENT_TANK_POSITION 5
#define CLIENT_SURFACE 6
#define CLIENT_WHOAMI 7
#define CLIENT_PLAYING 8

#endif

// This function takes some data from the server
// and tries to figure out what to do with it.
// The game stage is returned.
int Parse_Client_Data(GLOBALDATA *global, ENVIRONMENT *env, char *buffer);


// Draws a background
void Create_Sky(ENVIRONMENT *env, GLOBALDATA *global);

// Sends fire command to the server
// MEssage must be in format "FIRE item angle power"
int Client_Fire(PLAYER *my_player, int my_socket);

#endif

