/*****************************************************************************
*
* File: TextWriter.cpp
*
* Project: Osmose emulator.
*
* Description: This class is use to display textual information into
* a SDL_Surface.
*
* Author: Vedder Bruno
* Date: 26/02/2005, 14h13
*
* URL: http://bcz.emu-france.com/
*****************************************************************************/
#include "TextWriter.h"

const char TextWriter::asciiToFont[128] =
{
/*   0    1    2    3    4    5    6    7    8    9   10   11   12   13   14   15             */
    53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53, /*   0-15  */

/*  16   17   18   19   20   21   22   23   24   25   26   27   28   29   30   31             */
    53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53, /*  16-31  */

/*  ' '   !    "    #    $    %    &    '    (    )    *    +    ,    -    .    /             */
    26,  37,  39,  40,  53,  41,  42,  43,  44,  45,  46,  47,  48,  49,  38,  50, /*  32-47  */

/*   0    1    2    3    4    5    6    7    8    9    :    ;    <    =    >    ?             */
    27,  28,  29,  30,  31,  32,  33,  34,  35,  36,  51,  53,  54,  56,  55,  53, /*  48-63  */

/*   @    A    B    C    D    E    F    G    H    I    J    K    L    M    N    O             */
    53,   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14, /*  64-79  */

/*   P    Q    R    S    T    U    V    W    X    Y    Z    [    \    ]    ^    _             */
    15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  57,  59,  58,  60,  61, /*  80-95  */

/*   '    a    b    c    d    e    f    g    h    i    j    k    l    m    n    o             */
    53,   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14, /*  96-111 */

/*   p    q    r    s    t    u    v    w    x    y    z    {    |    }    ~                  */
    15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  57,  59,  58,  60,  53  /* 112-127 */
};

/*--------------------------------------------------------------------*/
/* This array contains 8x496 pixels picture of our font. Each value is*/
/* an index in palete.                                                */
/*--------------------------------------------------------------------*/
const unsigned char TextWriter::font[8*496] = {
    0,1,1,1,1,1,0,0,1,2,2,2,2,2,1,0,1,2,2,1,2,2,1,0,1,2,2,2,2,2,1,0,
    1,2,2,1,2,2,1,0,1,2,2,1,2,2,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,0,0,0,1,2,2,2,2,1,0,0,1,2,2,1,2,1,0,0,1,2,2,2,2,1,0,
    0,1,2,2,1,2,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,1,2,2,1,1,1,0,0,1,2,2,1,0,0,0,
    0,1,2,2,1,1,1,0,0,1,2,2,2,2,1,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,0,0,0,1,2,2,2,2,1,0,0,1,2,2,1,2,1,0,0,1,2,2,1,2,1,0,
    0,1,2,2,1,2,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,1,2,2,1,1,1,0,0,1,2,2,2,2,1,0,
    0,1,2,2,1,1,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,1,2,2,1,1,1,0,0,1,2,2,2,2,1,0,
    0,1,2,2,1,1,1,0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,1,2,2,1,1,1,0,0,1,2,2,1,2,1,0,
    0,1,2,2,1,2,1,0,0,1,2,2,2,2,1,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,1,0,1,2,2,1,2,2,1,0,1,2,2,1,2,2,1,0,1,2,2,2,2,2,1,
    0,1,2,2,1,2,2,1,0,1,2,2,1,2,2,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,0,0,0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,
    0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,0,1,1,2,2,1,0,0,0,0,1,2,2,1,0,
    0,1,1,1,2,2,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,1,0,1,2,2,1,2,2,1,0,1,2,2,2,2,1,0,0,1,2,2,2,2,1,0,
    0,1,2,2,2,2,1,0,0,1,2,2,1,2,2,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
    0,1,1,1,1,0,0,0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,0,
    0,1,2,2,1,1,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    1,1,1,1,1,1,1,0,1,2,2,1,2,2,1,0,1,2,2,2,2,2,1,0,1,2,2,2,2,2,1,0,
    1,2,1,2,1,2,1,0,1,2,1,2,1,2,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    1,1,1,1,1,1,0,0,1,2,2,2,2,2,1,0,1,2,2,2,2,2,1,0,1,2,2,1,2,2,1,0,
    1,2,2,1,2,2,1,0,1,2,2,1,2,2,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,0,0,1,2,2,2,2,2,1,0,1,2,1,2,2,2,1,0,1,2,1,2,2,2,1,0,
    1,2,1,2,2,2,1,0,1,2,2,2,2,2,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    1,1,1,1,1,1,0,0,1,2,2,2,2,2,1,0,1,2,2,1,2,2,1,0,1,2,2,2,2,2,1,0,
    1,2,2,1,1,1,0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,0,0,1,2,2,2,2,2,1,0,1,2,2,1,2,2,1,0,1,2,2,1,2,2,1,0,
    1,2,2,1,2,2,1,0,1,2,2,2,2,2,2,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,0,0,0,1,2,2,2,2,1,0,0,1,2,2,1,2,1,0,0,1,2,2,2,2,1,0,
    0,1,2,2,1,2,2,1,0,1,2,2,1,2,2,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,0,0,0,1,2,2,2,2,1,0,0,1,2,2,1,1,1,0,0,1,2,2,2,2,1,0,
    0,1,1,1,1,2,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,1,1,2,2,1,1,0,0,0,1,2,2,1,0,0,
    0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,0,1,2,1,2,2,1,0,0,1,2,1,2,2,1,0,0,1,2,2,2,2,1,0,
    0,1,2,2,2,2,1,0,0,1,2,2,2,2,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,0,1,2,1,2,2,1,0,0,1,2,1,2,2,1,0,0,1,2,2,2,2,1,0,
    0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,
    1,1,1,1,1,1,1,0,1,2,1,2,1,2,1,0,1,2,1,2,1,2,1,0,1,2,2,2,2,2,1,0,
    0,1,2,2,2,1,0,0,0,1,2,1,2,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,
    0,1,1,0,0,1,1,0,0,1,2,1,1,2,1,0,0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,
    0,0,1,2,2,1,0,0,0,1,2,1,1,2,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,
    1,1,1,0,0,1,1,1,1,2,2,1,1,2,2,1,0,1,2,2,2,2,1,0,0,1,2,2,2,2,1,0,
    0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,1,1,1,2,2,1,0,0,0,1,2,2,1,0,0,
    0,1,2,2,1,1,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,0,0,0,1,2,2,2,2,1,0,0,1,2,1,2,2,1,0,0,1,2,1,2,2,1,0,
    0,1,2,1,2,2,1,0,0,1,2,2,2,2,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,0,0,0,1,2,2,2,1,0,0,0,1,1,2,2,1,0,0,0,0,1,2,2,1,0,0,
    0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,0,0,0,1,2,2,2,2,1,0,0,1,1,1,2,2,1,0,0,0,1,2,2,2,1,0,
    0,1,2,2,1,1,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,0,0,0,1,2,2,2,2,1,0,0,1,1,1,2,2,1,0,0,0,1,2,2,2,1,0,
    0,1,1,1,2,2,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,0,1,1,1,0,0,0,0,1,2,2,1,0,0,0,1,2,2,2,1,1,0,1,2,2,1,2,2,1,0,
    1,2,2,2,2,2,1,0,1,1,1,2,2,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,1,2,1,1,1,0,0,0,1,2,2,2,2,1,0,
    0,0,1,1,2,2,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,1,2,2,1,1,0,0,0,1,2,2,2,2,1,0,
    0,1,2,2,1,2,1,0,0,1,2,2,2,2,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,1,1,1,2,2,1,0,0,0,0,1,2,2,1,0,
    0,0,1,2,2,1,0,0,0,1,2,2,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,0,0,0,1,2,2,2,2,1,0,0,1,2,1,2,2,1,0,0,1,2,2,2,2,1,0,
    0,1,2,1,2,2,1,0,0,1,2,2,2,2,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,0,0,0,1,2,2,2,2,1,0,0,1,2,1,2,2,1,0,0,1,2,2,2,2,1,0,
    0,0,1,1,2,2,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,0,0,0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,
    0,0,1,1,1,1,0,0,0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,1,1,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,1,0,0,0,1,2,1,2,1,0,0,0,1,2,1,2,1,0,0,0,1,1,1,1,1,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,0,0,1,1,2,1,2,1,1,0,1,2,2,2,2,2,1,0,1,1,2,2,2,1,1,0,
    1,2,2,2,2,2,1,0,1,1,2,1,2,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    1,1,1,0,1,1,1,0,1,2,1,0,1,2,1,0,1,1,1,1,2,1,1,0,0,0,1,2,1,1,0,0,
    1,1,2,1,1,1,1,0,1,2,1,0,1,2,1,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,0,0,0,0,1,2,2,2,1,0,0,0,1,2,1,2,1,0,0,0,1,2,2,2,1,0,0,
    0,0,1,2,1,0,0,0,0,1,2,1,2,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,0,1,1,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,1,1,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,1,1,1,0,0,0,0,1,2,2,1,0,0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,
    0,0,1,2,2,1,0,0,0,0,0,1,2,2,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,
    0,1,1,1,0,0,0,0,0,1,2,2,1,0,0,0,0,0,1,2,2,1,0,0,0,0,1,2,2,1,0,0,
    0,0,1,2,2,1,0,0,0,1,2,2,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,1,2,1,2,1,0,0,0,0,1,2,1,0,0,0,
    0,1,2,1,2,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,2,1,1,0,0,0,1,2,2,2,1,0,0,
    0,1,1,2,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,1,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,2,2,1,0,0,
    0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,1,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,2,1,0,0,0,0,1,2,1,0,0,0,
    0,0,1,2,1,0,0,0,0,1,2,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,1,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,1,1,0,0,0,
    0,0,1,2,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,1,1,0,0,
    0,0,0,1,2,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,0,0,1,2,2,2,2,2,1,0,1,2,2,1,2,2,1,0,1,1,1,1,2,2,1,0,
    0,0,1,2,2,1,0,0,0,0,1,1,1,0,0,0,0,0,1,2,1,0,0,0,0,0,1,1,1,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,2,2,1,0,0,1,2,2,1,1,1,0,
    0,1,2,2,2,2,1,0,0,0,1,1,2,2,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,2,2,1,1,0,0,0,1,1,1,2,2,1,0,
    0,1,2,2,2,2,1,0,0,1,2,2,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,
    0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,0,0,0,0,1,2,2,1,0,0,0,0,1,2,1,1,0,0,0,0,1,2,1,0,0,0,
    0,0,1,2,1,1,0,0,0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,0,0,0,0,1,2,2,1,0,0,0,0,1,1,2,1,0,0,0,0,0,1,2,1,0,0,
    0,0,1,1,2,1,0,0,0,0,1,2,2,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,0,0,0,0,0,0,1,2,1,0,0,0,0,0,1,2,1,0,0,0,0,0,0,1,2,1,0,0,
    0,0,0,1,2,1,0,0,0,0,0,0,1,2,1,0,0,0,0,0,1,2,1,0,0,0,0,0,0,1,1,0,
    0,0,1,1,0,0,0,0,0,1,2,2,1,0,0,0,1,2,1,1,2,1,0,0,1,1,0,0,1,1,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,2,2,2,2,1,0,0,1,1,1,1,1,1,0,
};

/*--------------------------------------------------------------------*/
/* Constructor initialize internal values.                            */
/*--------------------------------------------------------------------*/
TextWriter::TextWriter()
{
    hasMessage = false;
    memset(message, 0, MESSAGE_LENGTH);
    messageDuration = 0;

    // Set colors for messages.
    fontCols[0] = 0;
    fontCols[1] = 0x0000;
    fontCols[2] = 0xFFFF;
}

/*--------------------------------------------------------------------*/
/* This routine simply copy message to be displayed into internal     */
/* buffer. Display duration is stored too. The update routine is      */
/* called 60hz. If you want a message beeing displayed 5 second you   */
/* should pass 300 in counter parameter.                              */
/*--------------------------------------------------------------------*/
void TextWriter::addText(const char *msg, unsigned int counter)
{
    strncpy(message,(char *) msg, MESSAGE_LENGTH);
    messageDuration = counter;
    hasMessage= true;
}

/*--------------------------------------------------------------------*/
/* This routine must be call each time screen is refreshed. It writes */
/* message (if any) into SDL_Surface and decrease the duration counter*/
/* If counter reaches 0 the message is removed. This routine is called*/
/* at 60hz.	                                                      */
/*--------------------------------------------------------------------*/
void TextWriter::update(SDL_Surface *s, bool display)
{
    if (hasMessage)
    {
	int ind = 0;
	int x = 8;

	if (messageDuration != 0) messageDuration--; // To avoid wrapping.
	if (messageDuration ==0) hasMessage = false;
        if (display == true) // False means frame render skipped. So dont display message.
	{
	    while ((message[ind] !=0) && (ind < MESSAGE_LENGTH))
	    {

		unsigned char car;

		car = asciiToFont[message[ind] & 127];
		writeChar(s, car, x, 0);
		ind++;
		x+=8;
	    }
        }
    }
}

void TextWriter::writeText(SDL_Surface *s,char *str, unsigned int x, unsigned int y)
{
	unsigned int ind = 0;

	while ((str[ind] !='\0') && (ind < strlen(str)))
    {
		unsigned char car;

		car = asciiToFont[str[ind] & 127];
		writeChar(s, car, x, y);
        ind++;
        x+=8;
    }
}


/*--------------------------------------------------------------------*/
/* This routine renders 8x8 char into SDL surface.                    */
/*--------------------------------------------------------------------*/
void TextWriter::writeChar(SDL_Surface *s,unsigned char c, unsigned int x, unsigned int y)
{
    unsigned int dw;                  // Display width;
    unsigned int c_index;             // Char index into font array.
    unsigned short *d_index;          // Dest index into pixel array.

    dw = s->w;
    c_index = c << 6; // Each bitmap char is 64 bytes long.
    d_index = (unsigned short *)(s->pixels);

    d_index += (y * dw + x);

    for (int o = 0; o < 8; o++)
    {
	for (int i = 0; i < 8; i++)
	{
	    unsigned short col;
	    unsigned i_col;

	    i_col = font[c_index++];
	    if (i_col != 0) // Transparency if i_col = 0;
	    {
	        col = fontCols[i_col];
    	        *d_index = col;
            }
	    d_index++;
	}
        d_index += dw - 8; // Jump next line.
    }
}


/*--------------------------------------------------------------------*/
/* This routine returns remaing duration.                             */
/*--------------------------------------------------------------------*/
unsigned int TextWriter::getDuration()
{
    return messageDuration;
}



