/*
 *      Miscellaneous utilities.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
 * http://www.gnu.org/copyleft/gpl.html .
 *
 */

/* $Id: util.c 336 2007-02-11 16:59:22Z nyaochi $ */

#ifdef  HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/
#ifdef  HAVE_STRING_H
#include <string.h>
#endif/*HAVE_STRING_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>

#include "util.h"
#include "console.h"

/** 
 *  Generic display method for progress messages consisting of a
 *  number and a string.
 * 
 * @param fp  
 * @param n   number to be shown in the numeric part
 * @param msg message
 * 
 * @return 
 */
int easypmp_progress_num_str(FILE *fp, size_t n, const ucs2char_t* msg)
{
	/* 
	   A terminal must be of a certain width in order to usefully
	   show progress when enumerating/reading media files.
	   Specifically, it needs to be wide enough to display the
	   number of files read.

	   display_line is used to truncate the line in this way.
	*/
	ucs2char_t *str = alloca(sizeof(ucs2char_t) * (ucs2len(msg) + 32));
	ucs2char_t *p = str;

	/* sprintf(str, "  %u: %S", n, msg); */
	*p++ = ' ';
	*p++ = ' ';
	itoucs2((int)n, p, 10);
	p = str + ucs2len(str);
	*p++ = ':';
	*p++ = ' ';
	ucs2cpy(p, msg);

	console_clearln(fp);
	console_println(fp, str, 0);
	fflush(fp);
	return 0;
}

void fprints(FILE *fp, const char *format, const ucs2char_t* value)
{
	fprints_fixed(fp, format, value, ucs2len(value));
}

void fprints_fixed(FILE *fp, const char *format, const ucs2char_t* value,
                   size_t length)
{
	char *mbs = NULL;
	ucs2char_t* tmp = alloca(sizeof(ucs2char_t) * (length+1));
	memset(tmp, 0, sizeof(ucs2char_t) * (length+1));
	ucs2ncpy(tmp, value, length);
	mbs = ucs2dupmbs(tmp);
	if (mbs) {
		fprintf(fp, format, mbs);
		ucs2free(mbs);
	}
}

void fputucs2str_path(FILE *fp, const ucs2char_t* str)
{
	while (*str) {
		ucs2char_t c = *str;
		if (c == 0x005C) {
			c = PATHCHAR;
		}
		if (c == 0x002F) {
			c = PATHCHAR;
		}
		fputucs2c(c, fp);
		str++;
	}
}
