/*
 *      Tag and audio information retrieval by libvorbisfile.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
 * http://www.gnu.org/copyleft/gpl.html .
 *
 */

/* $Id: gmi_vorbis.c 328 2007-02-10 17:50:11Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/

#include <os.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <pmplib/ucs2char.h>
#include <gmi.h>

#include <vorbis/codec.h>
#include <vorbis/vorbisfile.h>

/**
 * \addtogroup gmi
 * @{
 */

#ifdef WIN32
#define strncasecmp _strnicmp
#endif

int gmi_vorbis(media_info_t* info, const ucs2char_t *filename, const char *charset)
{
	int i, ret = 0;
	long lval = 0;
	double dval = 0;
	FILE *fp = NULL;
	OggVorbis_File vf;
	vorbis_info *vi = NULL;
	vorbis_comment* vc = NULL;

	/* Set the pathname and filename. */
	/*
	info->filename = ucs2dup(filename);
	info->filesize = filepath_size(filename);
	*/

	/* Open the target file. */
	fp = ucs2fopen(filename, "rb");
	if (!fp) {
		return -1;
	}

	/* Open as a vorbis stream. */
	if (ov_open(fp, &vf, NULL, 0) < 0) {
		goto error_exit;
	}

	/* Obtain vorbis information. */
	if ((vi = ov_info(&vf, -1)) == NULL) {
		ov_clear(&vf);
		goto error_exit;
	}

	/* Store sample rate. */
	info->sample_rate = vi->rate;

	/* Obtain bitrate. */
	lval = ov_bitrate(&vf, -1);
	if (lval < 0) {
		ov_clear(&vf);
		goto error_exit;
	}
	info->bitrate = (uint32_t)lval;

	/* Obtain duration. */
	dval = ov_time_total(&vf, -1);
	if (dval < 0) {
		ov_clear(&vf);
		goto error_exit;
	}
	info->duration = (uint32_t)dval;

	vc = ov_comment(&vf, -1);
	for (i = 0;i < vc->comments;++i) {
		const char *fieldvalue = vc->user_comments[i];
		if (strncasecmp(fieldvalue, "TITLE=", 6) == 0) {
			info->title = utf8dupucs2(fieldvalue+6);
		} else if (strncasecmp(fieldvalue, "ARTIST=", 7) == 0) {
			info->artist = utf8dupucs2(fieldvalue+7);
		} else if (strncasecmp(fieldvalue, "ALBUM=", 6) == 0) {
			info->album = utf8dupucs2(fieldvalue+6);
		} else if (strncasecmp(fieldvalue, "GENRE=", 6) == 0) {
			info->genre = utf8dupucs2(fieldvalue+6);
		} else if (strncasecmp(fieldvalue, "TRACKNUMBER=", 12) == 0) {
			info->track_number = atoi(fieldvalue+12);
		} else if (strncasecmp(fieldvalue, "DATE=", 5) == 0) {
			info->date = utf8dupucs2(fieldvalue+5);
		}
	}

	info->codec = PMPCODEC_VORBIS;
	
	// Clear the decoders buffers, also closes fp.
	ov_clear(&vf);

	return 0;

error_exit:
	if (fp) {
		fclose(fp);
	}
	return -1;
}

/** @} */
