/*
 *      PLS playlist routines.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: rw_pls.c 328 2007-02-10 17:50:11Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/
#ifdef	HAVE_STRING_H
#include <string.h>
#endif/*HAVE_STRING_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>
#include <playlist.h>

static char *strip(char *line)
{
	char *p = line;
	while (*p && *p != '\n' && *p != '\r') {
		p++;
	}
	*p = 0;

	return line;
}

static int is_pls_entry(const char *line)
{
	return (tolower(line[0]) == 'f' && tolower(line[1]) == 'i' && tolower(line[2]) == 'l' && tolower(line[3]) == 'e');
}

static int strcmp_nocase(const char *x, const char *y)
{
	char a, b;

	do {
		a = tolower(*x);
		b = tolower(*y);
		if (!*x || !*y) {
			break;
		}
		x++;
		y++;
	} while (a == b);
	return (a - b);
}

int playlist_pls_read(playlists_t* pls, const ucs2char_t *filename)
{
	int is_pls = 0;
	FILE *fp = ucs2fopen(filename, "r");
	if (!fp) {
		return -1;
	} else {
		char line[MAX_PATH * 8];
		playlist_t* pl = calloc(1, sizeof(playlist_t));

		pl->entries = 0;
		pl->num_entries = 0;
		ucs2cpy(pl->name, filename);

		while (fgets(line, sizeof(line)-1, fp) != NULL) {
			strip(line);

			if (line[0] == 0) {
				continue;
			}

			if (strcmp_nocase(line, "[playlist]") == 0) {
				is_pls = 1;
				continue;
			}

			if (is_pls && is_pls_entry(line)) {
				char *p = NULL;
				int number = strtol(line+4, &p, 10);
				if (p && *p == '=') {
					p++;
					number--;	/* convert it to zero-based index. */
					if (number <= pl->num_entries) {
						pl->entries = (playlist_entry_t*)realloc(pl->entries, sizeof(playlist_entry_t) * (number+1));
						pl->num_entries = number+1;
					}
					mbstoucs2(
						pl->entries[number].filename,
						sizeof(pl->entries[number].filename),
						p,
						strlen(p)+1
						);
					pl->entries[number].valid = 1;
					pl->entries[number].order = number;
				}
			}
		}

		fclose(fp);

		pls->playlists = pl;
		pls->num_playlists = 1;

		return 0;
	}
}
