/*
 *      Header page in idx.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: idx_header.c 328 2007-02-10 17:50:11Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/
#ifdef	HAVE_STRING_H
#include <string.h>
#endif/*HAVE_STRING_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>

#include "util.h"
#include "serialize.h"
#include "ip2db.h"

void idxheader_setget_unknown1(uint8_t* block, uint8_t* array, int is_storing)
{
	serialize_uint8_array(&block[0x000], array, 33, is_storing);
}

void idxheader_setget_num_entries(uint8_t* block, uint32_t* value, int is_storing)
{
	serialize_uint32be(&block[0x0021], value, is_storing);
}

void idxheader_setget_num_pages(uint8_t* block, uint32_t* value, int is_storing)
{
	serialize_uint32be(&block[0x0025], value, is_storing);
}

void idxheader_setget_unknown2(uint8_t* block, uint32_t* value, int is_storing)
{
	serialize_uint32be(&block[0x0029], value, is_storing);
}

void idxheader_setget_unknown3(uint8_t* block, uint32_t* value, int is_storing)
{
	serialize_uint32be(&block[0x002D], value, is_storing);
}

void idxheader_setget_unknown4(uint8_t* block, uint32_t* value, int is_storing)
{
	serialize_uint32be(&block[0x0031], value, is_storing);
}

void idxheader_setget_unknown5(uint8_t* block, uint32_t* value, int is_storing)
{
	serialize_uint32be(&block[0x0035], value, is_storing);
}

void idxheader_setget_unknown6(uint8_t* block, uint32_t* value, int is_storing)
{
	serialize_uint32be(&block[0x0039], value, is_storing);
}

void idxheader_setget_leaftail(uint8_t* block, uint32_t* values, int is_storing)
{
	int i;
	uint8_t* p = &block[0x003D];
	for (i = 0;i < NUM_LEAF_CHAIN_LISTS;++i) {
		p += serialize_uint32be(p, &values[i], is_storing);
	}
}

void idxheader_setget_unknown7(uint8_t* block, uint8_t* array, int is_storing)
{
	serialize_uint8_array(&block[0x051], array, 43, is_storing);
}

void idxheader_setget_unknown8(uint8_t* block, uint32_t* value, int is_storing)
{
	serialize_uint32be(&block[0x007C], value, is_storing);
}

void idxheader_init(uint8_t* block)
{
	static uint8_t unknown1[33] = {
		0xFE, 0x53, 0x02, 0x02, 0x04, 0x04, 0x03, 0xFF, 0x00, 0x0E, 0x07, 0x04, 0x00, 0x01, 0x38, 0x00,
		0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00
	};
	uint32_t num_pages = 16;
	uint32_t unknown2 = 1;
	uint32_t unknown3 = 1;
	uint32_t unknown5 = 524288;
	uint32_t unknown6 = 3384;

	memset(block, 0, PAGESIZE);
	idxheader_setget_unknown1(block, unknown1, 1);
	idxheader_setget_num_pages(block, &num_pages, 1);
	idxheader_setget_unknown2(block, &unknown2, 1);
	idxheader_setget_unknown3(block, &unknown3, 1);
	idxheader_setget_unknown5(block, &unknown5, 1);
	idxheader_setget_unknown6(block, &unknown6, 1);
}

void idxheader_repr(uint8_t* block, uint32_t offset, FILE *fp)
{
	int i;
	uint8_t  unknown1[33];
	uint32_t num_entries, num_pages, unknown2, unknown3, unknown4;
	uint32_t unknown5, unknown6;
	uint32_t leaftail[NUM_LEAF_CHAIN_LISTS];
	uint8_t  unknown7[43];
	uint32_t unknown8;

	idxheader_setget_unknown1(block, unknown1, 0);
	idxheader_setget_num_entries(block, &num_entries, 0);
	idxheader_setget_num_pages(block, &num_pages, 0);
	idxheader_setget_unknown2(block, &unknown2, 0);
	idxheader_setget_unknown3(block, &unknown3, 0);
	idxheader_setget_unknown4(block, &unknown4, 0);
	idxheader_setget_unknown5(block, &unknown5, 0);
	idxheader_setget_unknown6(block, &unknown6, 0);
	idxheader_setget_leaftail(block, leaftail, 0);
	idxheader_setget_unknown7(block, unknown7, 0);
	idxheader_setget_unknown8(block, &unknown8, 0);

	fprintf(fp, "PAGE %d (0x%08X) HEADER = [\n", offset / 0x400 + 1, offset);

	fprintf(fp, "  unknown1:");
	for (i = 0;i < sizeof(unknown1);i++) {
		fprintf(fp, " %02X", unknown1[i]);
	}
	fprintf(fp, "\n");

	fprintf(fp, "  num_entries: %d\n", num_entries);
	fprintf(fp, "  num_pages: %d\n", num_pages);
	fprintf(fp, "  unknown2: %d\n", unknown2);
	fprintf(fp, "  unknown3: %d\n", unknown3);
	fprintf(fp, "  unknown4: %d\n", unknown4);
	fprintf(fp, "  unknown5: %d\n", unknown5);
	fprintf(fp, "  unknown6: %d\n", unknown6);
	for (i = 0;i < NUM_LEAF_CHAIN_LISTS;++i) {
		fprintf(fp, "  leaf_tail_%d: %d\n", i, leaftail[i]);
	}

	fprintf(fp, "  unknown7:");
	for (i = 0;i < sizeof(unknown7);++i) {
		fprintf(fp, " %02X", unknown7[i]);
	}
	fprintf(fp, "\n");

	fprintf(fp, "  unknown8: %d\n", unknown8);

	fprintf(fp, "]\n");
}
