/*
 *      Low-level library for db.dic.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: dic.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__IP3DB_DIC_H__
#define	__IP3DB_DIC_H__

typedef struct {
	uint32_t	size;
	uint32_t	num_dat_pages;
	uint32_t	num_idx_pages;
	uint32_t	unknown1;
} dic_header_t;

typedef struct {
	uint32_t	next;
	uint32_t	type;
	uint32_t	idx_root;
	ucs2char_t*	name;
} dic_field_t;

typedef struct {
	uint32_t	idx_root;
	uint32_t	offset;
	int			fields[IP3DBIDX_MAX_KEYLEVEL];
} dic_index_t;

typedef struct {
	uint32_t	unknown0;
	uint32_t	next;
	uint32_t	unknown1;
	uint32_t	dat_page;
	uint32_t	offset_fields;
	uint32_t	offset_indices;
	ucs2char_t* name;

	int			num_fields;
	dic_field_t	*fields;
	int			num_indices;
	dic_index_t	*indices;
} dic_table_t;

struct tag_dic_t {
	dic_header_t	header;
	dic_table_t		music;
	dic_table_t		references;
	dic_table_t		objects;

	uint8_t*	buffer;
	long		size;
};

dic_t* dic_new();
void dic_finish(dic_t* dic);
int dic_read(dic_t* dic, FILE *fpi);
int dic_write(dic_t* dic, FILE *fpo);
void dic_dump(dic_t* dic, FILE *fp);
uint32_t dic_get_idxroot(dic_t* dic, int table, int index);
void dic_set_idxroot(dic_t* dic, int table, int index, uint32_t root);
void dic_repr_index(dic_t* dic, int table, int index, FILE *fp);
uint8_t *dic_get_template(long* size);

#endif/*__IP3DB_DIC_H__*/
