/*
 *      Playlist reader/writer for H100/300 (M3U).
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: playlist.c 328 2007-02-10 17:50:11Z nyaochi $ */

/*
 * H100/H300 playlist must be represented by absolute paths that begin with
 * the root folder '\' without a driver letter and colon.
 *
 * Example:
 *	\Music\hoge1\fuga2.mp3
 *	\Music\hoge3\fuga4.ogg
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>
#include <pmplib/filepath.h>

#include "irivnavi.h"

int playlist_write(
	const ucs2char_t *filename,
	ucs2char_t* const mediafiles[],
	int num_mediafiles,
	const ucs2char_t *path_to_root
	)
{
	int i;
	FILE *fp = NULL;
	
	// Open a playlist for writing.
	fp = ucs2fopen(filename, "w");
	if (!fp) {
		return -1;
	}

	for (i = 0;i < num_mediafiles;i++) {
		// Skip empty entry just in case.
		if (mediafiles[i][0]) {
			char *mbs = NULL;
			ucs2char_t filename[MAX_PATH];
			ucs2cpy(filename, filepath_changeroot(mediafiles[i], path_to_root));

			filepath_encode(filename);

			mbs = ucs2dupmbs(filename);
			fputs(mbs, fp);
			fputc('\n', fp);
		}
	}

	fclose(fp);
	return 0;
}
