/*
 *      Low level interface for field descriptor.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: field_descriptor.c 328 2007-02-10 17:50:11Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/
#ifdef	HAVE_STRING_H
#include <string.h>
#endif/*HAVE_STRING_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>

#include "serialize.h"
#include "util.h"
#include "pp1db.h"

void field_descriptor_init(field_descriptor_t* fd)
{
	memset(fd, 0, sizeof(*fd));
}

void field_descriptor_finish(field_descriptor_t* fd)
{
	field_descriptor_init(fd);
}

size_t field_descriptor_serialize(uint8_t* block, field_descriptor_t* fd, int is_storing)
{
	uint8_t *p = block;
	p += serialize_uint32le(p, &fd->id, is_storing);
	p += serialize_uint32le(p, &fd->field_type, is_storing);
	p += serialize_uint32le(p, &fd->max_length, is_storing);
	p += serialize_uint32le(p, &fd->unknown4, is_storing);
	p += serialize_uint32le(p, &fd->unknown5, is_storing);
	p += serialize_uint32le(p, &fd->has_index, is_storing);
	p += serialize_uint32le(p, &fd->unknown6, is_storing);
	p += serialize_uint32le(p, &fd->unknown7, is_storing);
	p += serialize_ucs2le_string_fixed(p, fd->index_pathname, PP1DB_PATHLENGTH, is_storing) * sizeof(ucs2char_t);
	return (size_t)(p - block);
}

void field_descriptor_repr(const field_descriptor_t* fd, FILE *fp)
{
	fprintf(fp, "{");
	fprintf(fp, "0x%08X, ", fd->id);
	fprintf(fp, "%d, ", fd->field_type);
	fprintf(fp, "%3d, ", fd->max_length);
	fprintf(fp, "%d, ", fd->unknown4);
	fprintf(fp, "%d, ", fd->unknown5);
	fprintf(fp, "%d, ", fd->has_index);
	fprintf(fp, "%d, ", fd->unknown6);
	fprintf(fp, "%d, ", fd->unknown7);
	fprints(fp, "\"%s\"", fd->index_pathname);
	fprintf(fp, "}");
}

uint32_t field_descriptor_get_max_record_size(const hdr_t* hdr)
{
	uint32_t i, size = 8;

	for (i = 0;i < hdr->num_dat_fields;++i) {
		switch (hdr->fd[i].field_type) {
		case PP1DB_FIELDTYPE_STRING:
			size += hdr->fd[i].max_length * sizeof(ucs2char_t);
			break;
		case PP1DB_FIELDTYPE_INTEGER:
			size += hdr->fd[i].max_length;
			break;
		}
	}

	return size;
}
