/*
 *      Database template.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: hdr_template.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__HDR_TEMPLATE_H__
#define	__HDR_TEMPLATE_H__

typedef struct {
	uint32_t	id;				/**< Field identifier. */
	uint32_t	field_type;		/**< 1: UCS2-LE String; 2: uint32_t. */
	uint32_t	max_length;		/**< Maximum length of the field */
	uint32_t	unknown4;
	uint32_t	unknown5;
	uint32_t	has_index;		/**< 1 if this field needs an index (*.idx), otherwise 0. */
	uint32_t	unknown6;
	uint32_t	unknown7;
	const char*	index_pathname;	/**< Pathname of the index file */
} fd_template_t;

typedef struct {
	uint32_t	unknown1;					/**< 0 AFAIK */
	uint32_t	unknown2;					/**< 0 AFAIK */
	const char*	pathname_dat;				/**< Pathname of H10DB.dat file */
	uint32_t	unknown3;					/**< 1 AFAIK */
	const char*	pathname_hdr;				/**< Pathname of H10DB.hdr file */
	uint32_t	unknown4;					/**< Version of the database specification? (0x0000042C) */
	uint32_t	num_dat_entries;			/**< Number of entries in H10DB.DAT */
	uint32_t	num_dat_inactive_entries;	/**< Number of inactive entries in H10DB.DAT */
	uint32_t	num_dat_fields;				/**< H10DB_NUM_DAT_FIELDS (22) AFAIK */
	fd_template_t*	fd;						/**< Field descriptors. */
											/**< 1032 bytes padding. */
	uint32_t*	max_dat_field_size;
	uint32_t	dat_size;					/**< Size of H10DB.dat file */
	uint32_t	unknown5;					/**< 1 AFAIK (This field exists only in 20GB MTP 2.50) */

	/* These fields are not serizlied in H10DB.hdr */
	hdr_parameter_t		param;
} hdr_template_t;

int apply_template(hdr_t* hdr, const hdr_template_t* tmpl);

int hdr_init_h10_5gb_ums_0205_0253(hdr_t* hdr);
int hdr_init_h10_5gb_mtp_0203_0210(hdr_t* hdr);
int hdr_init_h10_5gb_mtp_0251(hdr_t* hdr);
int hdr_init_h10_20gb_mtp_0100_0102(hdr_t* hdr);
int hdr_init_h10_20gb_mtp_0251(hdr_t* hdr);
int hdr_init_medion_mdjuke220(hdr_t* hdr);
int hdr_init_medion_mdjuke440(hdr_t* hdr);
int hdr_init_samsung_yh820(hdr_t* hdr);
int hdr_init_samsung_yh920(hdr_t* hdr);
int hdr_init_samsung_yh925(hdr_t* hdr);
int hdr_init_sirius_s50(hdr_t* hdr);
int hdr_init_philips_hdd6320(hdr_t* hdr);
int hdr_init_msi_megaplayer540(hdr_t* hdr);

int iriver_h10_parse_model(const ucs2char_t* firmware, pp1model_t* model);
int medion_mdjuke220_parse_model(const ucs2char_t* firmware, pp1model_t* model);
int samsung_parse_model(const ucs2char_t* firmware, pp1model_t* model);
int philips_hdd6320_parse_model(const ucs2char_t* firmware, pp1model_t* model);
int megaplayer_parse_model(const ucs2char_t* firmware, pp1model_t* model);

#endif/*__HDR_TEMPLATE_H__*/
