#ifndef MENUCONTENT_HEADER_
#define MENUCONTENT_HEADER_

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */

char *onOffText[2] = { "Off", "On"};
char *onOffRandomText[3] = { "Off", "On", "Random"};
char *landSlideText[5] = { "None", "Tank Only", "Instant", "Gravity", "Cartoon"};
char *wallTypeText[5] = { "Rubber", "Steel", "Spring", "Wrap", "Random"};
char *mouseText[2] = { "Custom", "Default"};
char *meteorText[4] = { "Off", "Light", "Heavy", "Lethal"};
char *lightningText[4] = { "Off", "Weak", "Energetic", "Violent"};
char *laserSatelliteText[4] = { "Off", "Weak", "Strong", "Super"};
char *languageText[6] = { "English", "Português", "Français", "Deutsch", "Slovak", "Russian"};
char *colourText[2] = { "Regular", "Crispy"};
char *landTypeText[8] = { "Random", "Canyons", "Mountains", "Valleys", "Hills", "Foothills", "Plains", "None" };
char *turnTypeText[4] = { "High+", "Low+", "Random", "Simul" };
char *skipTypeText[2] = { "Off", "Humans Dead"};
char *soundDriver[6] = { "Auto Detect", "OSS", "ESD", "ARTS", "ALSA", "JACK" };

// portuege version
char *onOffText_ptbr[2] = { "Desligado", "Ligado"};
/*translate*/
char *onOffRandomText_ptbr[3] = { "Desligado", "Ligado", "Random"};
char *landSlideText_ptbr[5] = { "Nenhum", "Tanque Somente", "InstantÃ¢neo", "Gravidade", "Cartoon"};
char *wallTypeText_ptbr[5] = { "ElÃ¡stico", "AÃ§o", "Mola", "Envoltório", "AleatÃ³rio"};
char *mouseText_ptbr[2] = { "Personalizado", "PadrÃ£o"};
char *meteorText_ptbr[4] = { "Desligado", "Fraco", "Forte", "Letal"};
char *lightningText_ptbr[4] = { "Desligado", "Fraco", "EnergÃ©tico", "Violento"};
char *laserSatelliteText_ptbr[4] = { "Desligado", "Fraco", "Forte", "Super"};
char *languageText_ptbr[6] = { "English", "Português", "Français", "Deutsch", "Slovak", "Russian"};
char *colourText_ptbr[2] = { "Regular", "Crispy"};
char *landTypeText_ptbr[8] = { "aleatÃ³rio", "Canyons", "Montanhas", "Vales", "Colinas", "Morros", "Planos", "Nenhum" };
char *turnTypeText_ptbr[4] = { "Melhores+", "Piores+", "AleatÃ³rio", "Simul" };
char *skipTypeText_ptbr[2] = { "Desligado", "Humanos Mortos" };


// french version
char *onOffText_fr[2] = { "loin", "sur"};
/*translate*/
char *onOffRandomText_fr[3] = { "loin", "sur", "Random"};
char *landSlideText_fr[5] = { "Aucun", "Réservoir Seulement", "Instantané", "Gravité", "Dessin animé"};
char *wallTypeText_fr[5] = { "Elastique", "Acier", "Mou", "Znveloppe", "Aléatoire"};
char *mouseText_fr[2] = { "Pesonnel", "Défaut"};
char *meteorText_fr[4] = { "Off", "Light", "Heavy", "Lethal"};
char *lightningText_fr[4] = { "Aucun", "Faible", "Energique", "Violent"};
char *laserSatelliteText_fr[4] = { "Aucun", "Faible", "Fort", "Super"};
char *languageText_fr[6] = { "English", "Português", "Français", "Deutsch", "Slovak", "Russian"};
char *colourText_fr[2] = { "Régulier", "Croustillant"};
char *landTypeText_fr[8] = { "Aléatoire", "Canyons", "Mountagnes", "Vallées", "Collines", "Contreforts", "Plaines", "Aucun" };
char *turnTypeText_fr[4] = { "Haut", "Bas", "Aléatoire", "Simulé" };
char *skipTypeText_fr[2] = { "Aucun", "Mort des humains"};


// german version
char *onOffText_de[2] = { "Aus", "An"};
char *onOffRandomText_de[3] = { "Aus", "An", "Zufällig"};
char *landSlideText_de[5] = { "Keine", "Nur Panzer", "Sofort", "Schwerkraft", "Cartoon"};
char *wallTypeText_de[5] = { "Gummi", "Stahl", "Federnd", "Verbunden", "Zufällig"};
char *mouseText_de[2] = { "Angepasst", "Standard"};
char *meteorText_de[4] = { "Aus", "Leicht", "Schwer", "Tödlich"};
char *lightningText_de[4] = { "Aus", "Schwach", "Stark", "Brutal"};
char *laserSatelliteText_de[4] = { "Aus", "Schwach", "Stark", "Super"};
char *languageText_de[6] = { "English", "Português", "Français", "Deutsch", "Slovak", "Russian"};
char *colourText_de[2] = { "Normal", "Kontrastreich"};
char *landTypeText_de[8] = { "Zufällig", "Canyons", "Berge", "Täler", "Hügel", "Flache Hügel", "Ebene", "Nichts" };
char *turnTypeText_de[4] = { "Hoch+", "Niedrig+", "Zufällig", "Simul" };
char *skipTypeText_de[2] = { "Aus", "An"};

// slovak version
char *onOffText_sk[2] = { "Vypnuté", "Zapnuté"};
char *onOffRandomText_sk[3] = { "Vypnutý", "Zapnutý", "Náhodný"};
char *landSlideText_sk[5] = { "Žiaden", "Iba tank", "Okamžitý", "Gravitácia", "Kresl.film"};
char *wallTypeText_sk[5] = { "Guma", "Oceľ", "Pružina", "Prikrývka", "Náhodný"};
char *mouseText_sk[2] = { "Vlastné", "Východzie"};
char *meteorText_sk[4] = { "Vypnuté", "Ľahké", "Ťažké", "Smrteľné"};
char *lightningText_sk[4] = { "Vypnuté", "Slabé", "Energetické", "Kruté"};
char *laserSatelliteText_sk[4] = { "Vypnutý", "Slabý", "Silný", "Super"};
char *languageText_sk[6] = { "Anglicky", "Portugalsky", "Francúzsky", "Nemecky", "Slovensky", "Rusky"};
char *colourText_sk[2] = { "Normálna", "Svieža"};
char *landTypeText_sk[8] = { "Náhodná", "Kaňony", "Hory", "Údolia", "Kopce", "Úpätia", "Nížiny", "Žiadna" };
char *turnTypeText_sk[4] = { "Vysoký+", "Nízky+", "Náhodný", "Simul" };
char *skipTypeText_sk[2] = { "Vypnuté", "Smrť ľudí"};

// Russian version
char *onOffText_ru[2] = { "Выкл.", "Вкл."};
char *onOffRandomText_ru[3] = { "Выкл.", "Вкл.", "Случайно"};
char *landSlideText_ru[5] = { "Выкл.", "Только танки", "Сразу же", "По умолчанию", "Как в мультиках"};
char *wallTypeText_ru[5] = { "Резиновые", "Непробиваемые", "Пружинящие", "Бесконечность", "Случайные"};
char *mouseText_ru[2] = { "Собственный", "По умолчанию"};
char *meteorText_ru[4] = { "Нет", "Слабый", "Сильный", "Смертельный"};
char *lightningText_ru[4] = { "Нет", "Слабые", "Сильные", "Мощные"};
char *laserSatelliteText_ru[4] = { "Нет", "Слабые", "Сильные", "Супер!!"};
char *languageText_ru[6] = { "English", "Português", "Français", "Deutsch", "Slovak", "Русский"};
char *colourText_ru[2] = { "Обычная", "Четкая"};
char *landTypeText_ru[8] = { "Случайный", "Каньоны", "Горы", "Возвышенность", "Холмы", "Предгорья", "Равнины", "Выкл." };
char *turnTypeText_ru[4] = { "Сильные +", "Слабые +", "Случайно", "Все сразу" };
char *skipTypeText_ru[2] = { "Выкл.", "Вкл."};




// declare variables
MENUDESC mainMenu;

if (global->language == LANGUAGE_ENGLISH)
  {
    MENUENTRY physicsOpts[8] =
    {
      { "Gravity", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { "Viscosity", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 60},
      { "Land Slide", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { "Land Slide Delay", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { "Wall Type", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      { "Boxed Mode", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { "Violent Death", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { "Timed Shots", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}
    };
    MENUDESC physicsMenu = { "Physics", 7, physicsOpts, TRUE, FALSE};

    MENUENTRY weatherOpts[7] =
    {
      { "Meteor Showers", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Lightning", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Falling Dirt", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Laser Satellite", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0, laserSatelliteText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Fog", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Max Wind Strength", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Wind Variation", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { "Weather", 7, weatherOpts, TRUE, FALSE};


    MENUENTRY soundOpts[3] =
    {
      { "All Sound", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Sound Driver", NULL, WHITE, &global->sound_driver, NULL, "%s", 0, 5, 1, 0, soundDriver, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Music", NULL, WHITE, &global->play_music, NULL, "%s", 0, 1, 1, 0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28}
    };
   MENUDESC soundMenu = { "Sound", 3, soundOpts, TRUE, FALSE};


    MENUENTRY graphicsOpts[12] =
    {
      { "Full Screen", NULL, WHITE, &global->full_screen, NULL, "%s", 0, 1, 1, 0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 108},
      { "Dithering", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { "Detailed Land", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Detailed Sky", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Fading Text", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Shadowed Text", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Colour Theme", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Screen Width", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Screen Height", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Mouse Pointer", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 72},
      { "Game Speed", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "Custom Background", NULL, WHITE, &env->custom_background, NULL, "%s", 0, 1, 1, 0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}
    };
    MENUDESC graphicsMenu = { "Graphics", 12, graphicsOpts, TRUE, FALSE};

    MENUENTRY financeOpts[9] =
    {
      { "Starting Money", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Interest Rate", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Round Win Bonus", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Damage Bounty", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Self-Damage Penalty", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Tank Destruction Bonus", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Tank Self-Destruction Penalty", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { "Item Sell Multiplier", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
      { "Teams Share", NULL, WHITE, (double *) &global->divide_money, NULL, "%s", 0.0, 1.0, 1.0, 0.0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}
    };
    MENUDESC financeMenu = { "Money", 9, financeOpts, TRUE, FALSE};

    MENUENTRY networkOpts[5] =
    {
       {  "Check Updates", NULL, WHITE, (double*) &global->check_for_updates, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
       {  "Networking", NULL, WHITE, (double*) &global->enable_network, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
       {  "Listen Port", NULL, WHITE, (double*) &global->listen_port, NULL, "%5.0f", 10645, 64645, 1000, 25645, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
       {  "Server address", NULL, WHITE, (double *) &(global->server_name), NULL, "%s", 0, 0, 0, 0, NULL, OPTION_TEXTTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12 },
       { "Server port", NULL, WHITE, (double *) &(global->server_port), NULL, "%s", 0, 0, 0, 0, NULL, OPTION_TEXTTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32}
    };
    MENUDESC networkMenu = { "Network", 5, networkOpts, TRUE, FALSE};

    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;
    void *pnetworkMenu =        &networkMenu;
    void *pSoundMenu   =        &soundMenu;

    MENUENTRY mainOpts[12] =
    {
      { "Physics", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { "Weather", NULL, WHITE, (double*)pWeatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Graphics", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Money", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Network", NULL, WHITE, (double*)pnetworkMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Sound", NULL, WHITE, (double*) pSoundMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Weapon Tech Level", NULL, WHITE, (double*)&env->weapontechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Item Tech Level", NULL, WHITE, (double *) &env->itemtechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Landscape", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7, 1, LANDTYPE_HILLS, landTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { "Turn Order", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "Skip AI-only play", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 1, 1, 1, skipTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112},
      { "Language", NULL, WHITE, &global->language, NULL, "%s", 0, 5, 1, 0, languageText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}
    };
// mainMenu = { "Main Menu", 10, mainOpts, TRUE, FALSE};
    mainMenu.title = "Main Menu";
    mainMenu.numEntries = 12;
    mainMenu.entries = mainOpts;
    mainMenu.quitButton = TRUE;
    mainMenu.okayButton = FALSE;

  }  // end of English

if (global->language == LANGUAGE_PORTUGUESE)  // Portuguese
  {
    MENUENTRY physicsOpts[8] =
    {
      { "Gravidade", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { "Viscosidade", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 60},
      { "Deslizamento de Terra", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { "corrediça da terra atrasa", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { "Tipo de Parede", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      { "modalidade encaixotada", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { "morte violenta", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { "tiro programado", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}

    };
    MENUDESC physicsMenu = { "FÃ", 7, physicsOpts, TRUE, FALSE};

    MENUENTRY weatherOpts[7] =
    {
      { "Chuvas de Meteoro", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1,
        0, meteorText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 68},
      { "RelÃ¢mpagos", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0,
        lightningText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 48},
      { "Sujeira de queda", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Satélite do Laser", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0,
        laserSatelliteText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 8},
      { "Neblina", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1,
        0, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight + 12},
      { "Velocidade Max do Vento", NULL, WHITE, (double*)&env->windstrength,
        NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 32 },
      { "VariaÃ§Ã£o do Vento", NULL, WHITE, (double*)&env->windvariation,
        NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { "CondiÃ§Ãµes MeteorolÃ³gicas", 7, weatherOpts,
                             TRUE, FALSE
                           };

    MENUENTRY soundOpts[3] =
    {
      { "All Sound", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Sound Driver", NULL, WHITE, &global->sound_driver, NULL, "%s", 0, 5, 1, 0, soundDriver, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Music", NULL, WHITE, &global->play_music, NULL, "%s", 0, 1, 1, 0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28}
    };
   MENUDESC soundMenu = { "Sound", 3, soundOpts, TRUE, FALSE};


    MENUENTRY graphicsOpts[12] =
    {
      { "Full Screen", NULL, WHITE, &global->full_screen, NULL, "%s", 0, 1, 1, 0, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 108},
      { "Pontilhamento", NULL, WHITE, &global->ditherGradients, NULL, "%s",
        0, 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 88},
      { "Detalhes do Terreno", NULL, WHITE, &global->detailedLandscape, NULL,
        "%s", 0, 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE,
        global->halfWidth - 3, global->halfHeight - 68},
      { "Detalhes do CÃ©u", NULL, WHITE, &global->detailedSky, NULL, "%s", 0,
        1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 48},
      { "texto sombreado", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "texto de desvanecimento", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "tema da cor", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},

      { "Largura da Tela", NULL, WHITE, &global->temp_screenWidth,
        NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 32 },
      { "Altura da Tela", NULL, WHITE, &global->temp_screenHeight,
        NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 52},
      { "Ponteiro do Mouse", NULL, WHITE, &global->os_mouse, NULL,
        "%s", 0, 1, 1, 1, mouseText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth
        - 1, global->halfHeight + 72},
      { "velocidade do jogo", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "fundo feito sob encomenda", NULL, WHITE, &env->custom_background, NULL, "%s", 0, 1, 1, 0, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}

    };
    MENUDESC graphicsMenu = { "GrÃ¡ficos", 12, graphicsOpts, TRUE, FALSE};

    MENUENTRY financeOpts[9] =
    {
      { "Dinheiro inicial", NULL, WHITE, (double*)&global->startmoney, NULL,
        "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight - 68},
      { "Taxa de Juros", NULL, WHITE, (double*)&global->interest, NULL,
        "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight - 48},
      { "BÃ´nus por VitÃ³ria", NULL, WHITE,
        (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE,
        FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "BÃ´nus por Estrago", NULL, WHITE, (double*)&global->scoreHitUnit,
        NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 12},
      { "Penalidade por Auto-Estrago", NULL, WHITE,
        (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE,
        FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "BÃ´nus por Tanque DestruÃ", NULL, WHITE,
        (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL,
        OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Penalidade por Auto-DestruiÃ§Ã£o", NULL, WHITE,
        (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL,
        OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { "Multiplicador de Item Vendido", NULL, WHITE,
        (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE,
        FALSE, global->halfWidth -3, global->halfHeight + 92},
      { "Parte das equipes", NULL, WHITE, (double *) &global->divide_money, NULL, "%s", 0.0, 1.0, 1.0, 0.0, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}

    };
    MENUDESC financeMenu = { "Dinheiro", 9, financeOpts, TRUE, FALSE};

    MENUENTRY networkOpts[3] =
    {
       {  "Check Updates", NULL, WHITE, (double*) &global->check_for_updates, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
       {  "Networking", NULL, WHITE, (double*) &global->enable_network, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
       {  "Listen Port", NULL, WHITE, (double*) &global->listen_port, NULL, "%5.0f", 10645, 64645, 1000, 25645, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8}
    };
    MENUDESC networkMenu = { "Network", 3, networkOpts, TRUE, FALSE};


    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;
    void *pnetworkMenu  =       &networkMenu;
    void *pSoundMenu    =       &soundMenu;

    MENUENTRY mainOpts[12] =
    {
      { "FÃ", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0,
        0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 88},
      { "CondiÃ§Ãµes MeteorolÃ³gicas", NULL, WHITE, (double*)pWeatherMenu,
        NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth -
        3, global->halfHeight - 68},
      { "GrÃ¡ficos", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0,
        0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 48},
      { "Dinheiro", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0,
        0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 28},
       { "Network", NULL, WHITE, (double*)pnetworkMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Sound", NULL, WHITE, (double*) pSoundMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Arma NÃ TecnolÃ³gico", NULL, WHITE, (double*)&env->weapontechLevel, NULL,
        "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -
        3, global->halfHeight + 32},
      { "Artigo NÃ TecnolÃ³gico", NULL, WHITE, (double*) &env->itemtechLevel, NULL,
        "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "CenÃ¡rio", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7,
        1, LANDTYPE_HILLS, landTypeText_ptbr, OPTION_SPECIALTYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 72},
      { "Ordem de Jogadas", NULL, WHITE, (double*)&global->turntype, NULL,
        "%s", 0, 3, 1, TURN_RANDOM, turnTypeText_ptbr, OPTION_SPECIALTYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 92},
      { "Pular Jogo SÃ³ com RobÃ´s", NULL, WHITE, &global->skipComputerPlay,
        NULL, "%s", 0, 2, 1, 1, skipTypeText_ptbr, OPTION_SPECIALTYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 112},
      { "língua", NULL, WHITE, &global->language, NULL, "%s", 0, 5, 1, 0, languageText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}

    };
// mainMenu = { "Menu Principal", 10, mainOpts, TRUE, FALSE};
    mainMenu.title = "Menu Principal";
    mainMenu.numEntries = 12;
    mainMenu.entries = mainOpts;
    mainMenu.quitButton = TRUE;
    mainMenu.okayButton = FALSE;

  }   // end of Portuguese


// french
if (global->language == LANGUAGE_FRENCH)
  {
    MENUENTRY physicsOpts[8] =
    {
      { "Gravité", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { "Viscosité", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { "Glissements de terrain", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { "Délai glissements de terrain", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { "Murs", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      { "enfermé dans boîte", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { "mort violente", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { "projectile synchronisé", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}

    };
    MENUDESC physicsMenu = { "Physique", 7, physicsOpts, TRUE, FALSE};

    MENUENTRY weatherOpts[7] =
    {
      { "Orages de météorites", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Éclairs", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Saleté en chute", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Satellites Laser", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0, laserSatelliteText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Brouillard", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Force maxi du vent", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Variation du vent", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { "Météo", 7, weatherOpts, TRUE, FALSE};

    MENUENTRY soundOpts[3] =
    {
      { "All Sound", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Sound Driver", NULL, WHITE, &global->sound_driver, NULL, "%s", 0, 5, 1, 0, soundDriver, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Music", NULL, WHITE, &global->play_music, NULL, "%s", 0, 1, 1, 0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28}
    };
   MENUDESC soundMenu = { "Sound", 3, soundOpts, TRUE, FALSE};


    MENUENTRY graphicsOpts[12] =
    {
      { "Full Screen", NULL, WHITE, &global->full_screen, NULL, "%s", 0, 1, 1, 0, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 108},
      { "Tramage", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { "Détails du terrain", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Ciel détaillé", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "texte ombragé", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "texte de effacement", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Thème de couleurs", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Largeur d'écran", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Hauteur d'écran", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Curseur de souris", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 72},
      { "Vitesse du jeu", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "fond fait sur commande", NULL, WHITE, &env->custom_background, NULL, "%s", 0, 1, 1, 0, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}
    };
    MENUDESC graphicsMenu = { "Graphismes", 12, graphicsOpts, TRUE, FALSE};

    MENUENTRY financeOpts[9] =
    {
      { "Somme de départ", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Taux d'intérêt", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Gains par victoire", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Bonus dommages", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Pénalité auto-dommages", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Bonus destruction tank", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Pénalité autodestruction tank", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { "Coeff. vente item", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
      { "Part d'equipes", NULL, WHITE, (double *) &global->divide_money, NULL, "%s", 0.0, 1.0, 1.0, 0.0, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}

    };
    MENUDESC financeMenu = { "Money", 9, financeOpts, TRUE, FALSE};

    MENUENTRY networkOpts[3] =
    {
       {  "Check Updates", NULL, WHITE, (double*) &global->check_for_updates, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
       {  "Networking", NULL, WHITE, (double*) &global->enable_network, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
       {  "Listen Port", NULL, WHITE, (double*) &global->listen_port, NULL, "%5.0f", 10645, 64645, 1000, 25645, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8}
    };
    MENUDESC networkMenu = { "Network", 3, networkOpts, TRUE, FALSE};



    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;
    void *pnetworkMenu  =       &networkMenu;
    void *pSoundMenu    =       &soundMenu;

    MENUENTRY mainOpts[12] =
    {
      { "Physique", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { "Métao", NULL, WHITE, (double*)pWeatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Graphismes", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Finances", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
       { "Network", NULL, WHITE, (double*)pnetworkMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Sound", NULL, WHITE, (double*) pSoundMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Niveau technique armes", NULL, WHITE, (double*)&env->weapontechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Niveau technique équipement", NULL, WHITE, (double *) &env->itemtechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Paysage", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7, 1, LANDTYPE_HILLS, landTypeText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { "Ordre de passage", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "Jeu IA seule", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 1, 1, 1, skipTypeText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112},
      { "Langue", NULL, WHITE, &global->language, NULL, "%s", 0, 5, 1, 0, languageText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}
    };
// mainMenu = { "Menu principal", 10, mainOpts, TRUE, FALSE};
    mainMenu.title = "Menu principal";
    mainMenu.numEntries = 12;
    mainMenu.entries = mainOpts;
    mainMenu.quitButton = TRUE;
    mainMenu.okayButton = FALSE;


  }       // end of french

if (global->language == LANGUAGE_GERMAN)
  {
    MENUENTRY physicsOpts[8] =
    {
      { "Gravitation", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { "Reibung", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 60},
      { "Erdrutsch", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { "Erdrutsch Verzögerung", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1,3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { "Wand Art", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      { "Höhlenmodus", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { "Gewalttätiger Tod", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { "Zeitlimit", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}
    };
    MENUDESC physicsMenu = { "Physik", 8, physicsOpts, TRUE, FALSE};

    MENUENTRY weatherOpts[7] =
    {
      { "Meteoritenregen", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Gewitter", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText_de,OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Schmutzregen", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Lasersatellit", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0, laserSatelliteText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Nebel", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Max Windstärke", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Windveränderung", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { "Wetter", 7, weatherOpts, TRUE, FALSE};

    MENUENTRY soundOpts[3] =
    {
      { "Alle Sounds", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Sound Treiber", NULL, WHITE, &global->sound_driver, NULL, "%s", 0, 5, 1, 0, soundDriver, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Musik", NULL, WHITE, &global->play_music, NULL, "%s", 0, 1, 1, 0, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28}
    };
   MENUDESC soundMenu = { "Sounds", 3, soundOpts, TRUE, FALSE};



    MENUENTRY graphicsOpts[12] =
    {
      { "Full Screen", NULL, WHITE, &global->full_screen, NULL, "%s", 0, 1, 1, 0, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 108},
      { "Dithering", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { "Landdetails", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Himmeldetails", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Ausblendender Text", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Schattierter Text", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Farbschema", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Bildschirmbreite", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Bildschirmhöhe", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Mauszeiger", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText_de,OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 72},
      { "Spielgeschwindigket", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "kundenspezifischer Hintergrund", NULL, WHITE, &env->custom_background, NULL, "%s", 0, 1, 1, 0, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}
    };
    MENUDESC graphicsMenu = { "Grafik", 12, graphicsOpts, TRUE, FALSE};


    MENUENTRY financeOpts[9] =
    {
      { "Startgeld", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Zinssatz", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05,1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Rundenbonus", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0,50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Schadensbonus", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Strafe für Selbstschaden", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Zerstörungsbonus", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Selbstzerstörungsstrafe", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { "Verkaufsmultiplikator", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f",0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
      { "Mannschaftanteil", NULL, WHITE, (double *) &global->divide_money, NULL, "%s", 0.0, 1.0, 1.0, 0.0, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}

    };
    MENUDESC financeMenu = { "Geld", 9, financeOpts, TRUE, FALSE};

    MENUENTRY networkOpts[3] =
    {
       {  "Auf Aktualisierungen prüfen", NULL, WHITE, (double*) &global->check_for_updates, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
       {  "Netzwerk", NULL, WHITE, (double*) &global->enable_network, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
       {  "offener Port", NULL, WHITE, (double*) &global->listen_port, NULL, "%5.0f", 10645, 64645, 1000, 25645, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8}
    };
    MENUDESC networkMenu = { "Netzwerk", 3, networkOpts, TRUE, FALSE};


    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;
    void *pnetworkMenu  =       &networkMenu;
    void *pSoundMenu    =       &soundMenu;

    MENUENTRY mainOpts[12] =
    {
      { "Physik", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { "Wetter", NULL, WHITE, (double*)pWeatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Grafik", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Geld", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Netzwerk", NULL, WHITE, (double*)pnetworkMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Sounds", NULL, WHITE, (double*) pSoundMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Technologiestufe Waffen", NULL, WHITE, (double*)&env->weapontechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Technologiestufe Gegenstände", NULL, WHITE, (double *) &env->itemtechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Landschaft", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7, 1, LANDTYPE_HILLS, landTypeText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight+ 72},
      { "Reihenfolge", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "Überspringe Nur-KI", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 1, 1, 1, skipTypeText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112},
      { "Sprache", NULL, WHITE, &global->language, NULL, "%s", 0, 5, 1, 0, languageText_de,OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}
    };
// mainMenu = { "Hauptmenü", 10, mainOpts, TRUE, FALSE};
    mainMenu.title = "Hauptmenü";
    mainMenu.numEntries = 12;
    mainMenu.entries = mainOpts;
    mainMenu.quitButton = TRUE;
    mainMenu.okayButton = FALSE;

  }  // end of German


if (global->language == LANGUAGE_SLOVAK)
  {
    MENUENTRY physicsOpts[8] =
    {
      { "Gravitácia", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { "Viskozita", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 60},
      { "Zosun zeme", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { "Zdržanie zosunu zeme", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { "Typ steny", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      { "Režim krabíc", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { "Krutá smrť", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { "Časované strely", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}
    };
    MENUDESC physicsMenu = { "Fyzika", 7, physicsOpts, TRUE, FALSE};

    MENUENTRY weatherOpts[7] =
    {
      { "Dážď meteorov", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Blesky", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Padajúca zem", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Laserový satelit", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0, laserSatelliteText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Hmla", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Maximálna sila vetra", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Zmena vetra", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { "Počasie", 7, weatherOpts, TRUE, FALSE};

    MENUENTRY soundOpts[3] =
    {
      { "Všetky zvuky", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Ovládač zvuku", NULL, WHITE, &global->sound_driver, NULL, "%s", 0, 5, 1, 0, soundDriver, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Hudba", NULL, WHITE, &global->play_music, NULL, "%s", 0, 1, 1, 0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28}
    };
   MENUDESC soundMenu = { "Zvuk", 3, soundOpts, TRUE, FALSE};



    MENUENTRY graphicsOpts[12] =
    {
      { "Na celú obrazovku", NULL, WHITE, &global->full_screen, NULL, "%s", 0, 1, 1, 0, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 108},
      { "Rozptyl", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { "Detaily krajiny", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Detaily oblohy", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Slabnúci text", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Text s tieňom", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Farebná téma", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Šírka obrazovky", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Výška obrazovky", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Ukazovateľ myši", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 72},
      { "Rýchlosť hry", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "Vlastné pozadie", NULL, WHITE, &env->custom_background, NULL, "%s", 0, 1, 1, 0, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}
    };
    MENUDESC graphicsMenu = { "Grafika", 12, graphicsOpts, TRUE, FALSE};

    MENUENTRY financeOpts[9] =
    {
      { "Peniaze na začiatku", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Úroková miera", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Bonus pri skončení kola", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Odmena za poškodenie", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Pokuta za vlastné poškodenie", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Bonus za zničenie tanku", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Pokuta za vlastné zničenie tanku", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { "Násobiteľ pri predaji položiek", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
      { "Teamy zdieľajú peniaze", NULL, WHITE, (double *) &global->divide_money, NULL, "%s", 0.0, 1.0, 1.0, 0.0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}

    };
    MENUDESC financeMenu = { "Peniaze", 9, financeOpts, TRUE, FALSE};


    MENUENTRY networkOpts[3] =
    {
       {  "Kontrola aktualizácii", NULL, WHITE, (double*) &global->check_for_updates, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
       {  "Sieťová hra", NULL, WHITE, (double*) &global->enable_network, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
       {  "Port pre načúvanie", NULL, WHITE, (double*) &global->listen_port, NULL, "%5.0f", 10645, 64645, 1000, 25645, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8}
    };
    MENUDESC networkMenu = { "Sieť", 3, networkOpts, TRUE, FALSE};


    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;
    void *pnetworkMenu  =       &networkMenu;
    void *pSoundMenu    =       &soundMenu;


    MENUENTRY mainOpts[12] =
    {
      { "Fyzika", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { "Počasie", NULL, WHITE, (double*)pWeatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Grafika", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Peniaze", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Sieť", NULL, WHITE, (double*)pnetworkMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Zvuk", NULL, WHITE, (double*) pSoundMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Tech úroveň zbraní", NULL, WHITE, (double*)&env->weapontechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Tech úroveň vecí", NULL, WHITE, (double *) &env->itemtechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Krajina", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7, 1, LANDTYPE_HILLS, landTypeText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { "Poradie", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "Preskočiť hru samotného PC", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 1, 1, 1, skipTypeText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112},
      { "Jazyk", NULL, WHITE, &global->language, NULL, "%s", 0, 5, 1, 0, languageText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}
    };
    mainMenu.title = "Hlavné menu";
    mainMenu.numEntries = 12;
    mainMenu.entries = mainOpts;
    mainMenu.quitButton = TRUE;
    mainMenu.okayButton = FALSE;

  }  // end of Slovak


if (global->language == LANGUAGE_RUSSIAN)
{
    MENUENTRY physicsOpts[8] =
    {
      { "Гравитация", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { "Сила трения", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 60},
      { "Падение земли", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { "Задержка падения земли", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { "Тип стен", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      { "Потолок", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { "Мощные взрывы танков", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { "Задержка выстрела", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}
    };
    MENUDESC physicsMenu = { "Физика", 7, physicsOpts, TRUE, FALSE};


    MENUENTRY weatherOpts[7] =
    {
      { "Метеоритный дождь", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Молнии", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Падающая грязь", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Удары со спутника", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0, laserSatelliteText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Туман", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Макс. сила ветра", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Изменения силы ветра", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { "Погода", 7, weatherOpts, TRUE, FALSE};


    MENUENTRY soundOpts[3] =
    {
      { "All Sound", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Sound Driver", NULL, WHITE, &global->sound_driver, NULL, "%s", 0, 5, 1, 0, soundDriver, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Music", NULL, WHITE, &global->play_music, NULL, "%s", 0, 1, 1, 0, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28}
    };
   MENUDESC soundMenu = { "Sound", 3, soundOpts, TRUE, FALSE};


    MENUENTRY graphicsOpts[12] =
    {
      { "Full Screen", NULL, WHITE, &global->full_screen, NULL, "%s", 0, 1, 1, 0, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 108},
      { "Сглаживание", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { "Детализированный ландшафт", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Детализированное небо", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Исчезающий текст", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Оттененный текст", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Цветовая тема", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Ширина окна игры", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Высота окна игры", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Курсор в игре", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 72},
      { "Скорость игры", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "Собственный фон", NULL, WHITE, &env->custom_background, NULL, "%s", 0, 1, 1, 0, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}
    };
    MENUDESC graphicsMenu = { "Графика", 12, graphicsOpts, TRUE, FALSE};


    MENUENTRY financeOpts[9] =
    {
      { "Начальные деньги", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Банковский процент", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Бонус за победу", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Бонус за попадание", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Штраф за попадание в себя", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Бонус за уничтожение", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Штраф за самоуничтожение", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { "Коэфф. продажи снаряжения", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
      { "Командные боеприпасы", NULL, WHITE, (double *) &global->divide_money, NULL, "%s", 0.0, 1.0, 1.0, 0.0, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}
    };
    MENUDESC financeMenu = { "Экономика", 9, financeOpts, TRUE, FALSE};


    MENUENTRY networkOpts[3] =
    {
       {  "Проверять обновления", NULL, WHITE, (double*) &global->check_for_updates, NULL, "%s", 0, 1, 1, 1, onOffText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
       {  "Networking", NULL, WHITE, (double*) &global->enable_network, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
       {  "Listen Port", NULL, WHITE, (double*) &global->listen_port, NULL, "%5.0f", 10645, 64645, 1000, 25645, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8}
    };
    MENUDESC networkMenu = { "Настройки сети", 3, networkOpts, TRUE, FALSE};

    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;
    void *pnetworkMenu  =       &networkMenu;
    void *pSoundMenu    =       &soundMenu;


    MENUENTRY mainOpts[12] =
    {
      { "Физика", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { "Погода", NULL, WHITE, (double*)pWeatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { "Графика", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { "Экономика", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { "Настройки сети", NULL, WHITE, (double*)pnetworkMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { "Звук", NULL, WHITE, (double*)pSoundMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { "Уровень оружия", NULL, WHITE, (double*)&env->weapontechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { "Уровень снаряжения", NULL, WHITE, (double *) &env->itemtechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { "Тип ландшафта", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7, 1, LANDTYPE_HILLS, landTypeText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { "Порядок хода", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { "Пропускать игру компьютеров", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 1, 1, 1, skipTypeText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112},
      { "Язык (Language)", NULL, WHITE, &global->language, NULL, "%s", 0, 5, 1, 0, languageText_ru, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}
    };
// mainMenu = { "Main Menu", 10, mainOpts, TRUE, FALSE};
     mainMenu.title = "Главное меню";
     mainMenu.numEntries = 12;
     mainMenu.entries = mainOpts;
     mainMenu.quitButton = TRUE;
     mainMenu.okayButton = FALSE;

}   // end of Russian



#endif

