#!/usr/bin/perl -w

# options.pl: generate options dialog boxes
# $Id: options.pl 3768 2008-09-07 01:33:19Z specu $

# Copyright (c) 2001-2007 Philip Kendall, Marek Januszewski, Stuart Brady

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

# Author contact information:

# E-mail: philip-fuse@shadowmagic.org.uk

use strict;

use Fuse;
use Fuse::Dialog;

die "No data file specified" unless @ARGV;

my @dialogs = Fuse::Dialog::read( shift @ARGV );

print Fuse::GPL( 'options.c: options dialog boxes',
		 '2001-2007 Philip Kendall, Marek Januszewski, Stuart Brady' ) . << "CODE";

/* This file is autogenerated from options.dat by options.pl.
   Do not edit unless you know what you\'re doing! */

#include <config.h>

#ifdef UI_WIN32		/* Use this file iff we're using WIN32 */

#include <libspectrum.h>

#include "display.h"
#include "fuse.h"
#include "options.h"
#include "periph.h"
#include "settings.h"
#include "win32internals.h"

CODE

foreach( @dialogs ) {
    my $idcname = uc( "IDC_OPT_$_->{name}" );
    my $optname = uc( "OPT_$_->{name}" );

print << "CODE";

static BOOL CALLBACK
menu_options_$_->{name}_proc( HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
  char buffer[80];
  buffer[0] = '\\0';		/* Shut gcc up */
  
  switch( msg )
  {
    case WM_INITDIALOG:
    {
      /* FIXME: save the handle returned by LoadIcon() in win32ui.c */
      SendMessage( hwndDlg, WM_SETICON, ICON_SMALL,
	(LPARAM)LoadIcon( fuse_hInstance, "win32_icon" ) );

      /* initialize the controls with current settings */

      /* FIXME split *_init and *_done functions out of *_proc function */
CODE

    foreach my $widget ( @{ $_->{widgets} } ) {
	my $type = $widget->{type};

	if( $type eq "Checkbox" ) {
	    my $idcname = uc( "$widget->{value}" );
        print << "CODE";
      SendDlgItemMessage( hwndDlg, IDC_${optname}_${idcname}, BM_SETCHECK,
        settings_current.$widget->{value} ? BST_CHECKED : BST_UNCHECKED, 0 );
CODE
	} elsif( $widget->{type} eq "Entry" ) {
	    my $idcname = uc( "$widget->{value}" );
        print << "CODE";
      /* FIXME This is asuming SendDlgItemMessage is not UNICODE */
      snprintf( buffer, 80, "%d", settings_current.$widget->{value} );
      SendDlgItemMessage( hwndDlg, IDC_${optname}_${idcname}, WM_SETTEXT,
        0, (LPARAM) buffer );
CODE
	}
    }

print << "CODE";

      return FALSE;
    }

    case WM_COMMAND:
      switch( LOWORD( wParam ) )
      {
	case IDOK:
	{
          /* Read the controls and apply the settings */
CODE
    foreach my $widget ( @{ $_->{widgets} } ) {
	my $type = $widget->{type};

	if( $type eq "Checkbox" ) {
	    my $idcname = uc( "$widget->{value}" );

	    print << "CODE";
          settings_current.$widget->{value} =
            IsDlgButtonChecked( hwndDlg, IDC_${optname}_${idcname} );
CODE
	} elsif( $widget->{type} eq "Entry" ) {
	    my $idcname = uc( "$widget->{value}" );
        print << "CODE";
      /* FIXME This is asuming SendDlgItemMessage is not UNICODE */
      SendDlgItemMessage( hwndDlg, IDC_${optname}_${idcname}, WM_GETTEXT,
        80, (LPARAM) buffer );
      settings_current.$widget->{value} = atoi( buffer );  
CODE
	}
    }

    print "          $_->{posthook}();\n\n" if $_->{posthook};

    print << "CODE";
          win32statusbar_set_visibility( settings_current.statusbar );
          display_refresh_all();

	  EndDialog( hwndDlg, 0 );
	  return 0;
	}

	case IDCANCEL:
	  EndDialog( hwndDlg, 0 );
	  return 0;
      }
      break;

    case WM_CLOSE:
      EndDialog( hwndDlg, 0 );
      return 0;
  }
  return FALSE;
}

void
menu_options_$_->{name}( int action )
{
  fuse_emulation_pause();

  DialogBox( fuse_hInstance, MAKEINTRESOURCE( IDD_$optname ),
             fuse_hWnd, (DLGPROC) menu_options_$_->{name}_proc );

  fuse_emulation_unpause();
}

CODE
}

    print << "CODE";

#endif                 /* #ifdef UI_WIN32 */

CODE
