/***************************************************************************
 * Gens: Input Handler - Win32 Key Mappings.                               *
 *                                                                         *
 * Copyright (c) 1999-2002 by Stéphane Dallongeville                       *
 * Copyright (c) 2003-2004 by Stéphane Akhoun                              *
 * Copyright (c) 2008-2009 by David Korth                                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at your  *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.           *
 ***************************************************************************/

#ifndef GENS_INPUT_WIN32_KEYS_H
#define GENS_INPUT_WIN32_KEYS_H

// Win32 includes.
#define WIN32_LEAN_AND_MEAN
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <windows.h>

// Win32 virtual keycodes reported in WM_KEYDOWN's wParam parameter.
#define GENS_KEY_BACKSPACE	VK_BACK
#define GENS_KEY_TAB		VK_TAB
#define GENS_KEY_CLEAR		VK_CLEAR
#define GENS_KEY_RETURN		VK_RETURN
#define GENS_KEY_PAUSE		VK_PAUSE
#define GENS_KEY_ESCAPE		VK_ESCAPE
#define GENS_KEY_SPACE		VK_SPACE

#define GENS_KEY_EXCLAIM	'!'
#define GENS_KEY_QUOTEDBL	'"'
#define GENS_KEY_HASH		'#'
#define GENS_KEY_DOLLAR		'$'
#define GENS_KEY_AMPERSAND	'&'
#define GENS_KEY_QUOTE		'\''
#define GENS_KEY_LEFTPAREN	'('
#define GENS_KEY_RIGHTPAREN	')'
#define GENS_KEY_ASTERISK	'*'
#define GENS_KEY_PLUS		'+'
#define GENS_KEY_COMMA		','
#define GENS_KEY_MINUS		'-'
#define GENS_KEY_PERIOD		'.'
#define GENS_KEY_SLASH		'/'
#define GENS_KEY_COLON		':'
#define GENS_KEY_SEMICOLON	';'
#define GENS_KEY_LESS		'<'
#define GENS_KEY_EQUALS		'='
#define GENS_KEY_GREATER	'>'
#define GENS_KEY_QUESTION	'?'
#define GENS_KEY_AT		'@'
#define GENS_KEY_LEFTBRACKET	'['
#define GENS_KEY_BACKSLASH	'\\'
#define GENS_KEY_RIGHTBRACKET	']'
#define GENS_KEY_CARET		'^'
#define GENS_KEY_UNDERSCORE	'_'
#define GENS_KEY_BACKQUOTE	'`'

// Numbers
#define GENS_KEY_0		'0'
#define GENS_KEY_1		'1'
#define GENS_KEY_2		'2'
#define GENS_KEY_3		'3'
#define GENS_KEY_4		'4'
#define GENS_KEY_5		'5'
#define GENS_KEY_6		'6'
#define GENS_KEY_7		'7'
#define GENS_KEY_8		'8'
#define GENS_KEY_9		'9'

// Letters
#define	GENS_KEY_a		'A'
#define	GENS_KEY_b		'B'
#define	GENS_KEY_c		'C'
#define	GENS_KEY_d		'D'
#define	GENS_KEY_e		'E'
#define	GENS_KEY_f		'F'
#define	GENS_KEY_g		'G'
#define	GENS_KEY_h		'H'
#define	GENS_KEY_i		'I'
#define	GENS_KEY_j		'J'
#define	GENS_KEY_k		'K'
#define	GENS_KEY_l		'L'
#define	GENS_KEY_m		'M'
#define	GENS_KEY_n		'N'
#define	GENS_KEY_o		'O'
#define	GENS_KEY_p		'P'
#define	GENS_KEY_q		'Q'
#define	GENS_KEY_r		'R'
#define	GENS_KEY_s		'S'
#define	GENS_KEY_t		'T'
#define	GENS_KEY_u		'U'
#define	GENS_KEY_v		'V'
#define	GENS_KEY_w		'W'
#define	GENS_KEY_x		'X'
#define	GENS_KEY_y		'Y'
#define	GENS_KEY_z		'Z'

// Numeric Keypad
#define GENS_KEY_NUM_0		VK_NUMPAD0
#define GENS_KEY_NUM_1		VK_NUMPAD1
#define GENS_KEY_NUM_2		VK_NUMPAD2
#define GENS_KEY_NUM_3		VK_NUMPAD3
#define GENS_KEY_NUM_4		VK_NUMPAD4
#define GENS_KEY_NUM_5		VK_NUMPAD5
#define GENS_KEY_NUM_6		VK_NUMPAD6
#define GENS_KEY_NUM_7		VK_NUMPAD7
#define GENS_KEY_NUM_8		VK_NUMPAD8
#define GENS_KEY_NUM_9		VK_NUMPAD9
#define GENS_KEY_NUM_PERIOD	VK_DECIMAL
#define GENS_KEY_NUM_DIVIDE	VK_DIVIDE
#define GENS_KEY_NUM_MULTIPLY	VK_MULTIPLY
#define GENS_KEY_NUM_MINUS	VK_SUBTRACT
#define GENS_KEY_NUM_PLUS	VK_ADD
// TODO
#if 0
#define GENS_KEY_NUM_ENTER
#define GENS_KEY_NUM_EQUALS
#endif

// Arrow Keys
#define GENS_KEY_UP		VK_UP
#define GENS_KEY_DOWN		VK_DOWN
#define GENS_KEY_LEFT		VK_LEFT
#define GENS_KEY_RIGHT		VK_RIGHT

// Home/End section
#define GENS_KEY_INSERT		VK_INSERT
#define GENS_KEY_DELETE		VK_DELETE
#define GENS_KEY_HOME		VK_HOME
#define GENS_KEY_END		VK_END
#define GENS_KEY_PAGEUP		VK_PRIOR
#define GENS_KEY_PAGEDOWN	VK_NEXT

// Function Keys
#define GENS_KEY_F1		VK_F1
#define GENS_KEY_F2		VK_F2
#define GENS_KEY_F3		VK_F3
#define GENS_KEY_F4		VK_F4
#define GENS_KEY_F5		VK_F5
#define GENS_KEY_F6		VK_F6
#define GENS_KEY_F7		VK_F7
#define GENS_KEY_F8		VK_F8
#define GENS_KEY_F9		VK_F9
#define GENS_KEY_F10		VK_F10
#define GENS_KEY_F11		VK_F11
#define GENS_KEY_F12		VK_F12
#define GENS_KEY_F13		VK_F13
#define GENS_KEY_F14		VK_F14
#define GENS_KEY_F15		VK_F15

// Modifier Keys (not the same as modifiers, which are included with regular keypresses)
#define GENS_KEY_NUMLOCK	VK_NUMLOCK
// TODO: Verify GENS_KEY_CAPSLOCK.
#define GENS_KEY_CAPSLOCK	VK_CAPITAL
#define GENS_KEY_SCROLLLOCK	VK_SCROLL
#define GENS_KEY_LSHIFT		VK_LSHIFT
#define GENS_KEY_RSHIFT		VK_RSHIFT
#define GENS_KEY_LCTRL		VK_LCONTROL
#define GENS_KEY_RCTRL		VK_RCONTROL
// TODO: Figure out the following keys.
#if 0
#define GENS_KEY_LALT		SDLK_LALT
#define GENS_KEY_RALT		SDLK_RALT
#define GENS_KEY_LMETA		SDLK_LMETA
#define GENS_KEY_RMETA		SDLK_RMETA
#endif
#define GENS_KEY_LSUPER		VK_LWIN
#define GENS_KEY_RSUPER		VK_RWIN
//#define GENS_KEY_MODE		SDLK_MODE
//#define GENS_KEY_COMPOSE	SDLK_COMPOSE

// Miscellaneous function keys
#define GENS_KEY_HELP		VK_HELP
#define GENS_KEY_PRINT		VK_PRINT
//#define GENS_KEY_SYSREQ		SDLK_SYSREQ
//#define GENS_KEY_BREAK		SDLK_BREAK
#define GENS_KEY_MENU		VK_MENU
#define GENS_KEY_POWER		SDLK_POWER
//#define GENS_KEY_EURO		SDLK_EURO
//#define GENS_KEY_UNDO		SDLK_UNDO

// Maps key modifiers from SDL to OS-independent key modifiers.
// TODO: Separate L and R keys.
#define GENS_KMOD_NONE		0
#define GENS_KMOD_LSHIFT	MOD_SHIFT
#define GENS_KMOD_RSHIFT	MOD_SHIFT
#define GENS_KMOD_LCTRL		MOD_CONTROL
#define GENS_KMOD_RCTRL		MOD_CONTROL
#define GENS_KMOD_LALT		MOD_ALT
#define GENS_KMOD_RALT		MOD_ALT
#define GENS_KMOD_LMETA		MOD_WIN
#define GENS_KMOD_RMETA		MOD_WIN
#define GENS_KMOD_NUM		0
#define GENS_KMOD_CAPS		0
#define GENS_KMOD_MODE		0

// Composite modifiers.
#define GENS_KMOD_CTRL		(GENS_KMOD_LCTRL | GENS_KMOD_RCTRL)
#define GENS_KMOD_SHIFT		(GENS_KMOD_LSHIFT | GENS_KMOD_RSHIFT)
#define GENS_KMOD_ALT		(GENS_KMOD_LALT | GENS_KMOD_RALT)
#define GENS_KMOD_META		(GENS_KMOD_LMETA | GENS_KMOD_RMETA)

#endif /* GENS_INPUT_WIN32_KEYS_H */
