/***************************************************************************
 * mdZ80: Gens Z80 Emulator                                                *
 * mdZ80_DAA.c: Decimal Adjust Accumulator.                                *
 *                                                                         *
 * Copyright (c) 1999-2002 by Stéphane Dallongeville                       *
 * Copyright (c) 2003-2004 by Stéphane Akhoun                              *
 * Copyright (c) 2008 by David Korth                                       *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at your  *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.           *
 ***************************************************************************/


/*
 * DAA: Decimal Adjust Accumulator
 * This instruction is used to adjust the accumulator after manipulating
 * binary-coded decimal values. In order to improve performance in the
 * Z80 emulator, a lookup table is used instead of manually calculating
 * the correct adjustment.
 */


/*
 * DAA table ('borrowed' from Z80Emul, by unknown)
 * Offset:
 * - Offset & 0x00FF: "A" register
 * - Offset & 0x03FF: Lower three bits of the "F" register.
 * - Offset & 0x0800: Set if ("Main data" & 0x0100) == true. (TODO: Check this.)
 */
const unsigned short mdZ80_DAA_Table[256 * 8] =
{
	0x4400, 0x0001, 0x0002, 0x0403, 0x0004, 0x0405, 0x0406, 0x0007,
	0x0808, 0x0C09, 0x1010, 0x1411, 0x1412, 0x1013, 0x1414, 0x1015,
	0x0010, 0x0411, 0x0412, 0x0013, 0x0414, 0x0015, 0x0016, 0x0417,
	0x0C18, 0x0819, 0x3020, 0x3421, 0x3422, 0x3023, 0x3424, 0x3025,
	0x2020, 0x2421, 0x2422, 0x2023, 0x2424, 0x2025, 0x2026, 0x2427,
	0x2C28, 0x2829, 0x3430, 0x3031, 0x3032, 0x3433, 0x3034, 0x3435,
	0x2430, 0x2031, 0x2032, 0x2433, 0x2034, 0x2435, 0x2436, 0x2037,
	0x2838, 0x2C39, 0x1040, 0x1441, 0x1442, 0x1043, 0x1444, 0x1045,
	0x0040, 0x0441, 0x0442, 0x0043, 0x0444, 0x0045, 0x0046, 0x0447,
	0x0C48, 0x0849, 0x1450, 0x1051, 0x1052, 0x1453, 0x1054, 0x1455,
	0x0450, 0x0051, 0x0052, 0x0453, 0x0054, 0x0455, 0x0456, 0x0057,
	0x0858, 0x0C59, 0x3460, 0x3061, 0x3062, 0x3463, 0x3064, 0x3465,
	0x2460, 0x2061, 0x2062, 0x2463, 0x2064, 0x2465, 0x2466, 0x2067,
	0x2868, 0x2C69, 0x3070, 0x3471, 0x3472, 0x3073, 0x3474, 0x3075,
	0x2070, 0x2471, 0x2472, 0x2073, 0x2474, 0x2075, 0x2076, 0x2477,
	0x2C78, 0x2879, 0x9080, 0x9481, 0x9482, 0x9083, 0x9484, 0x9085,
	0x8080, 0x8481, 0x8482, 0x8083, 0x8484, 0x8085, 0x8086, 0x8487,
	0x8C88, 0x8889, 0x9490, 0x9091, 0x9092, 0x9493, 0x9094, 0x9495,
	0x8490, 0x8091, 0x8092, 0x8493, 0x8094, 0x8495, 0x8496, 0x8097,
	0x8898, 0x8C99, 0x5500, 0x1101, 0x1102, 0x1503, 0x1104, 0x1505,
	0x4500, 0x0101, 0x0102, 0x0503, 0x0104, 0x0505, 0x0506, 0x0107,
	0x0908, 0x0D09, 0x1110, 0x1511, 0x1512, 0x1113, 0x1514, 0x1115,
	0x0110, 0x0511, 0x0512, 0x0113, 0x0514, 0x0115, 0x0116, 0x0517,
	0x0D18, 0x0919, 0x3120, 0x3521, 0x3522, 0x3123, 0x3524, 0x3125,
	0x2120, 0x2521, 0x2522, 0x2123, 0x2524, 0x2125, 0x2126, 0x2527,
	0x2D28, 0x2929, 0x3530, 0x3131, 0x3132, 0x3533, 0x3134, 0x3535,
	0x2530, 0x2131, 0x2132, 0x2533, 0x2134, 0x2535, 0x2536, 0x2137,
	0x2938, 0x2D39, 0x1140, 0x1541, 0x1542, 0x1143, 0x1544, 0x1145,
	0x0140, 0x0541, 0x0542, 0x0143, 0x0544, 0x0145, 0x0146, 0x0547,
	0x0D48, 0x0949, 0x1550, 0x1151, 0x1152, 0x1553, 0x1154, 0x1555,
	0x0550, 0x0151, 0x0152, 0x0553, 0x0154, 0x0555, 0x0556, 0x0157,
	0x0958, 0x0D59, 0x3560, 0x3161, 0x3162, 0x3563, 0x3164, 0x3565,
	
	0x2560, 0x2161, 0x2162, 0x2563, 0x2164, 0x2565, 0x2566, 0x2167,
	0x2968, 0x2D69, 0x3170, 0x3571, 0x3572, 0x3173, 0x3574, 0x3175,
	0x2170, 0x2571, 0x2572, 0x2173, 0x2574, 0x2175, 0x2176, 0x2577,
	0x2D78, 0x2979, 0x9180, 0x9581, 0x9582, 0x9183, 0x9584, 0x9185,
	0x8180, 0x8581, 0x8582, 0x8183, 0x8584, 0x8185, 0x8186, 0x8587,
	0x8D88, 0x8989, 0x9590, 0x9191, 0x9192, 0x9593, 0x9194, 0x9595,
	0x8590, 0x8191, 0x8192, 0x8593, 0x8194, 0x8595, 0x8596, 0x8197,
	0x8998, 0x8D99, 0xB5A0, 0xB1A1, 0xB1A2, 0xB5A3, 0xB1A4, 0xB5A5,
	0xA5A0, 0xA1A1, 0xA1A2, 0xA5A3, 0xA1A4, 0xA5A5, 0xA5A6, 0xA1A7,
	0xA9A8, 0xADA9, 0xB1B0, 0xB5B1, 0xB5B2, 0xB1B3, 0xB5B4, 0xB1B5,
	0xA1B0, 0xA5B1, 0xA5B2, 0xA1B3, 0xA5B4, 0xA1B5, 0xA1B6, 0xA5B7,
	0xADB8, 0xA9B9, 0x95C0, 0x91C1, 0x91C2, 0x95C3, 0x91C4, 0x95C5,
	0x85C0, 0x81C1, 0x81C2, 0x85C3, 0x81C4, 0x85C5, 0x85C6, 0x81C7,
	0x89C8, 0x8DC9, 0x91D0, 0x95D1, 0x95D2, 0x91D3, 0x95D4, 0x91D5,
	0x81D0, 0x85D1, 0x85D2, 0x81D3, 0x85D4, 0x81D5, 0x81D6, 0x85D7,
	0x8DD8, 0x89D9, 0xB1E0, 0xB5E1, 0xB5E2, 0xB1E3, 0xB5E4, 0xB1E5,
	0xA1E0, 0xA5E1, 0xA5E2, 0xA1E3, 0xA5E4, 0xA1E5, 0xA1E6, 0xA5E7,
	0xADE8, 0xA9E9, 0xB5F0, 0xB1F1, 0xB1F2, 0xB5F3, 0xB1F4, 0xB5F5,
	0xA5F0, 0xA1F1, 0xA1F2, 0xA5F3, 0xA1F4, 0xA5F5, 0xA5F6, 0xA1F7,
	0xA9F8, 0xADF9, 0x5500, 0x1101, 0x1102, 0x1503, 0x1104, 0x1505,
	0x4500, 0x0101, 0x0102, 0x0503, 0x0104, 0x0505, 0x0506, 0x0107,
	0x0908, 0x0D09, 0x1110, 0x1511, 0x1512, 0x1113, 0x1514, 0x1115,
	0x0110, 0x0511, 0x0512, 0x0113, 0x0514, 0x0115, 0x0116, 0x0517,
	0x0D18, 0x0919, 0x3120, 0x3521, 0x3522, 0x3123, 0x3524, 0x3125,
	0x2120, 0x2521, 0x2522, 0x2123, 0x2524, 0x2125, 0x2126, 0x2527,
	0x2D28, 0x2929, 0x3530, 0x3131, 0x3132, 0x3533, 0x3134, 0x3535,
	0x2530, 0x2131, 0x2132, 0x2533, 0x2134, 0x2535, 0x2536, 0x2137,
	0x2938, 0x2D39, 0x1140, 0x1541, 0x1542, 0x1143, 0x1544, 0x1145,
	0x0140, 0x0541, 0x0542, 0x0143, 0x0544, 0x0145, 0x0146, 0x0547,
	0x0D48, 0x0949, 0x1550, 0x1151, 0x1152, 0x1553, 0x1154, 0x1555,
	0x0550, 0x0151, 0x0152, 0x0553, 0x0154, 0x0555, 0x0556, 0x0157,
	0x0958, 0x0D59, 0x3560, 0x3161, 0x3162, 0x3563, 0x3164, 0x3565,
	
	0x4600, 0x0201, 0x0202, 0x0603, 0x0204, 0x0605, 0x0606, 0x0207,
	0x0A08, 0x0E09, 0x0204, 0x0605, 0x0606, 0x0207, 0x0A08, 0x0E09,
	0x0210, 0x0611, 0x0612, 0x0213, 0x0614, 0x0215, 0x0216, 0x0617,
	0x0E18, 0x0A19, 0x0614, 0x0215, 0x0216, 0x0617, 0x0E18, 0x0A19,
	0x2220, 0x2621, 0x2622, 0x2223, 0x2624, 0x2225, 0x2226, 0x2627,
	0x2E28, 0x2A29, 0x2624, 0x2225, 0x2226, 0x2627, 0x2E28, 0x2A29,
	0x2630, 0x2231, 0x2232, 0x2633, 0x2234, 0x2635, 0x2636, 0x2237,
	0x2A38, 0x2E39, 0x2234, 0x2635, 0x2636, 0x2237, 0x2A38, 0x2E39,
	0x0240, 0x0641, 0x0642, 0x0243, 0x0644, 0x0245, 0x0246, 0x0647,
	0x0E48, 0x0A49, 0x0644, 0x0245, 0x0246, 0x0647, 0x0E48, 0x0A49,
	0x0650, 0x0251, 0x0252, 0x0653, 0x0254, 0x0655, 0x0656, 0x0257,
	0x0A58, 0x0E59, 0x0254, 0x0655, 0x0656, 0x0257, 0x0A58, 0x0E59,
	0x2660, 0x2261, 0x2262, 0x2663, 0x2264, 0x2665, 0x2666, 0x2267,
	0x2A68, 0x2E69, 0x2264, 0x2665, 0x2666, 0x2267, 0x2A68, 0x2E69,
	0x2270, 0x2671, 0x2672, 0x2273, 0x2674, 0x2275, 0x2276, 0x2677,
	0x2E78, 0x2A79, 0x2674, 0x2275, 0x2276, 0x2677, 0x2E78, 0x2A79,
	0x8280, 0x8681, 0x8682, 0x8283, 0x8684, 0x8285, 0x8286, 0x8687,
	0x8E88, 0x8A89, 0x8684, 0x8285, 0x8286, 0x8687, 0x8E88, 0x8A89,
	0x8690, 0x8291, 0x8292, 0x8693, 0x8294, 0x8695, 0x8696, 0x8297,
	0x8A98, 0x8E99, 0x2334, 0x2735, 0x2736, 0x2337, 0x2B38, 0x2F39,
	0x0340, 0x0741, 0x0742, 0x0343, 0x0744, 0x0345, 0x0346, 0x0747,
	0x0F48, 0x0B49, 0x0744, 0x0345, 0x0346, 0x0747, 0x0F48, 0x0B49,
	0x0750, 0x0351, 0x0352, 0x0753, 0x0354, 0x0755, 0x0756, 0x0357,
	0x0B58, 0x0F59, 0x0354, 0x0755, 0x0756, 0x0357, 0x0B58, 0x0F59,
	0x2760, 0x2361, 0x2362, 0x2763, 0x2364, 0x2765, 0x2766, 0x2367,
	0x2B68, 0x2F69, 0x2364, 0x2765, 0x2766, 0x2367, 0x2B68, 0x2F69,
	0x2370, 0x2771, 0x2772, 0x2373, 0x2774, 0x2375, 0x2376, 0x2777,
	0x2F78, 0x2B79, 0x2774, 0x2375, 0x2376, 0x2777, 0x2F78, 0x2B79,
	0x8380, 0x8781, 0x8782, 0x8383, 0x8784, 0x8385, 0x8386, 0x8787,
	0x8F88, 0x8B89, 0x8784, 0x8385, 0x8386, 0x8787, 0x8F88, 0x8B89,
	0x8790, 0x8391, 0x8392, 0x8793, 0x8394, 0x8795, 0x8796, 0x8397,
	0x8B98, 0x8F99, 0x8394, 0x8795, 0x8796, 0x8397, 0x8B98, 0x8F99,
	
	0xA7A0, 0xA3A1, 0xA3A2, 0xA7A3, 0xA3A4, 0xA7A5, 0xA7A6, 0xA3A7,
	0xABA8, 0xAFA9, 0xA3A4, 0xA7A5, 0xA7A6, 0xA3A7, 0xABA8, 0xAFA9,
	0xA3B0, 0xA7B1, 0xA7B2, 0xA3B3, 0xA7B4, 0xA3B5, 0xA3B6, 0xA7B7,
	0xAFB8, 0xABB9, 0xA7B4, 0xA3B5, 0xA3B6, 0xA7B7, 0xAFB8, 0xABB9,
	0x87C0, 0x83C1, 0x83C2, 0x87C3, 0x83C4, 0x87C5, 0x87C6, 0x83C7,
	0x8BC8, 0x8FC9, 0x83C4, 0x87C5, 0x87C6, 0x83C7, 0x8BC8, 0x8FC9,
	0x83D0, 0x87D1, 0x87D2, 0x83D3, 0x87D4, 0x83D5, 0x83D6, 0x87D7,
	0x8FD8, 0x8BD9, 0x87D4, 0x83D5, 0x83D6, 0x87D7, 0x8FD8, 0x8BD9,
	0xA3E0, 0xA7E1, 0xA7E2, 0xA3E3, 0xA7E4, 0xA3E5, 0xA3E6, 0xA7E7,
	0xAFE8, 0xABE9, 0xA7E4, 0xA3E5, 0xA3E6, 0xA7E7, 0xAFE8, 0xABE9,
	0xA7F0, 0xA3F1, 0xA3F2, 0xA7F3, 0xA3F4, 0xA7F5, 0xA7F6, 0xA3F7,
	0xABF8, 0xAFF9, 0xA3F4, 0xA7F5, 0xA7F6, 0xA3F7, 0xABF8, 0xAFF9,
	0x4700, 0x0301, 0x0302, 0x0703, 0x0304, 0x0705, 0x0706, 0x0307,
	0x0B08, 0x0F09, 0x0304, 0x0705, 0x0706, 0x0307, 0x0B08, 0x0F09,
	0x0310, 0x0711, 0x0712, 0x0313, 0x0714, 0x0315, 0x0316, 0x0717,
	0x0F18, 0x0B19, 0x0714, 0x0315, 0x0316, 0x0717, 0x0F18, 0x0B19,
	0x2320, 0x2721, 0x2722, 0x2323, 0x2724, 0x2325, 0x2326, 0x2727,
	0x2F28, 0x2B29, 0x2724, 0x2325, 0x2326, 0x2727, 0x2F28, 0x2B29,
	0x2730, 0x2331, 0x2332, 0x2733, 0x2334, 0x2735, 0x2736, 0x2337,
	0x2B38, 0x2F39, 0x2334, 0x2735, 0x2736, 0x2337, 0x2B38, 0x2F39,
	0x0340, 0x0741, 0x0742, 0x0343, 0x0744, 0x0345, 0x0346, 0x0747,
	0x0F48, 0x0B49, 0x0744, 0x0345, 0x0346, 0x0747, 0x0F48, 0x0B49,
	0x0750, 0x0351, 0x0352, 0x0753, 0x0354, 0x0755, 0x0756, 0x0357,
	0x0B58, 0x0F59, 0x0354, 0x0755, 0x0756, 0x0357, 0x0B58, 0x0F59,
	0x2760, 0x2361, 0x2362, 0x2763, 0x2364, 0x2765, 0x2766, 0x2367,
	0x2B68, 0x2F69, 0x2364, 0x2765, 0x2766, 0x2367, 0x2B68, 0x2F69,
	0x2370, 0x2771, 0x2772, 0x2373, 0x2774, 0x2375, 0x2376, 0x2777,
	0x2F78, 0x2B79, 0x2774, 0x2375, 0x2376, 0x2777, 0x2F78, 0x2B79,
	0x8380, 0x8781, 0x8782, 0x8383, 0x8784, 0x8385, 0x8386, 0x8787,
	0x8F88, 0x8B89, 0x8784, 0x8385, 0x8386, 0x8787, 0x8F88, 0x8B89,
	0x8790, 0x8391, 0x8392, 0x8793, 0x8394, 0x8795, 0x8796, 0x8397,
	0x8B98, 0x8F99, 0x8394, 0x8795, 0x8796, 0x8397, 0x8B98, 0x8F99,
	
	0x0406, 0x0007, 0x0808, 0x0C09, 0x0C0A, 0x080B, 0x0C0C, 0x080D,
	0x080E, 0x0C0F, 0x1010, 0x1411, 0x1412, 0x1013, 0x1414, 0x1015,
	0x0016, 0x0417, 0x0C18, 0x0819, 0x081A, 0x0C1B, 0x081C, 0x0C1D,
	0x0C1E, 0x081F, 0x3020, 0x3421, 0x3422, 0x3023, 0x3424, 0x3025,
	0x2026, 0x2427, 0x2C28, 0x2829, 0x282A, 0x2C2B, 0x282C, 0x2C2D,
	0x2C2E, 0x282F, 0x3430, 0x3031, 0x3032, 0x3433, 0x3034, 0x3435,
	0x2436, 0x2037, 0x2838, 0x2C39, 0x2C3A, 0x283B, 0x2C3C, 0x283D,
	0x283E, 0x2C3F, 0x1040, 0x1441, 0x1442, 0x1043, 0x1444, 0x1045,
	0x0046, 0x0447, 0x0C48, 0x0849, 0x084A, 0x0C4B, 0x084C, 0x0C4D,
	0x0C4E, 0x084F, 0x1450, 0x1051, 0x1052, 0x1453, 0x1054, 0x1455,
	0x0456, 0x0057, 0x0858, 0x0C59, 0x0C5A, 0x085B, 0x0C5C, 0x085D,
	0x085E, 0x0C5F, 0x3460, 0x3061, 0x3062, 0x3463, 0x3064, 0x3465,
	0x2466, 0x2067, 0x2868, 0x2C69, 0x2C6A, 0x286B, 0x2C6C, 0x286D,
	0x286E, 0x2C6F, 0x3070, 0x3471, 0x3472, 0x3073, 0x3474, 0x3075,
	0x2076, 0x2477, 0x2C78, 0x2879, 0x287A, 0x2C7B, 0x287C, 0x2C7D,
	0x2C7E, 0x287F, 0x9080, 0x9481, 0x9482, 0x9083, 0x9484, 0x9085,
	0x8086, 0x8487, 0x8C88, 0x8889, 0x888A, 0x8C8B, 0x888C, 0x8C8D,
	0x8C8E, 0x888F, 0x9490, 0x9091, 0x9092, 0x9493, 0x9094, 0x9495,
	0x8496, 0x8097, 0x8898, 0x8C99, 0x8C9A, 0x889B, 0x8C9C, 0x889D,
	0x889E, 0x8C9F, 0x5500, 0x1101, 0x1102, 0x1503, 0x1104, 0x1505,
	0x0506, 0x0107, 0x0908, 0x0D09, 0x0D0A, 0x090B, 0x0D0C, 0x090D,
	0x090E, 0x0D0F, 0x1110, 0x1511, 0x1512, 0x1113, 0x1514, 0x1115,
	0x0116, 0x0517, 0x0D18, 0x0919, 0x091A, 0x0D1B, 0x091C, 0x0D1D,
	0x0D1E, 0x091F, 0x3120, 0x3521, 0x3522, 0x3123, 0x3524, 0x3125,
	0x2126, 0x2527, 0x2D28, 0x2929, 0x292A, 0x2D2B, 0x292C, 0x2D2D,
	0x2D2E, 0x292F, 0x3530, 0x3131, 0x3132, 0x3533, 0x3134, 0x3535,
	0x2536, 0x2137, 0x2938, 0x2D39, 0x2D3A, 0x293B, 0x2D3C, 0x293D,
	0x293E, 0x2D3F, 0x1140, 0x1541, 0x1542, 0x1143, 0x1544, 0x1145,
	0x0146, 0x0547, 0x0D48, 0x0949, 0x094A, 0x0D4B, 0x094C, 0x0D4D,
	0x0D4E, 0x094F, 0x1550, 0x1151, 0x1152, 0x1553, 0x1154, 0x1555,
	0x0556, 0x0157, 0x0958, 0x0D59, 0x0D5A, 0x095B, 0x0D5C, 0x095D,
	0x095E, 0x0D5F, 0x3560, 0x3161, 0x3162, 0x3563, 0x3164, 0x3565,
	
	0x2566, 0x2167, 0x2968, 0x2D69, 0x2D6A, 0x296B, 0x2D6C, 0x296D,
	0x296E, 0x2D6F, 0x3170, 0x3571, 0x3572, 0x3173, 0x3574, 0x3175,
	0x2176, 0x2577, 0x2D78, 0x2979, 0x297A, 0x2D7B, 0x297C, 0x2D7D,
	0x2D7E, 0x297F, 0x9180, 0x9581, 0x9582, 0x9183, 0x9584, 0x9185,
	0x8186, 0x8587, 0x8D88, 0x8989, 0x898A, 0x8D8B, 0x898C, 0x8D8D,
	0x8D8E, 0x898F, 0x9590, 0x9191, 0x9192, 0x9593, 0x9194, 0x9595,
	0x8596, 0x8197, 0x8998, 0x8D99, 0x8D9A, 0x899B, 0x8D9C, 0x899D,
	0x899E, 0x8D9F, 0xB5A0, 0xB1A1, 0xB1A2, 0xB5A3, 0xB1A4, 0xB5A5,
	0xA5A6, 0xA1A7, 0xA9A8, 0xADA9, 0xADAA, 0xA9AB, 0xADAC, 0xA9AD,
	0xA9AE, 0xADAF, 0xB1B0, 0xB5B1, 0xB5B2, 0xB1B3, 0xB5B4, 0xB1B5,
	0xA1B6, 0xA5B7, 0xADB8, 0xA9B9, 0xA9BA, 0xADBB, 0xA9BC, 0xADBD,
	0xADBE, 0xA9BF, 0x95C0, 0x91C1, 0x91C2, 0x95C3, 0x91C4, 0x95C5,
	0x85C6, 0x81C7, 0x89C8, 0x8DC9, 0x8DCA, 0x89CB, 0x8DCC, 0x89CD,
	0x89CE, 0x8DCF, 0x91D0, 0x95D1, 0x95D2, 0x91D3, 0x95D4, 0x91D5,
	0x81D6, 0x85D7, 0x8DD8, 0x89D9, 0x89DA, 0x8DDB, 0x89DC, 0x8DDD,
	0x8DDE, 0x89DF, 0xB1E0, 0xB5E1, 0xB5E2, 0xB1E3, 0xB5E4, 0xB1E5,
	0xA1E6, 0xA5E7, 0xADE8, 0xA9E9, 0xA9EA, 0xADEB, 0xA9EC, 0xADED,
	0xADEE, 0xA9EF, 0xB5F0, 0xB1F1, 0xB1F2, 0xB5F3, 0xB1F4, 0xB5F5,
	0xA5F6, 0xA1F7, 0xA9F8, 0xADF9, 0xADFA, 0xA9FB, 0xADFC, 0xA9FD,
	0xA9FE, 0xADFF, 0x5500, 0x1101, 0x1102, 0x1503, 0x1104, 0x1505,
	0x0506, 0x0107, 0x0908, 0x0D09, 0x0D0A, 0x090B, 0x0D0C, 0x090D,
	0x090E, 0x0D0F, 0x1110, 0x1511, 0x1512, 0x1113, 0x1514, 0x1115,
	0x0116, 0x0517, 0x0D18, 0x0919, 0x091A, 0x0D1B, 0x091C, 0x0D1D,
	0x0D1E, 0x091F, 0x3120, 0x3521, 0x3522, 0x3123, 0x3524, 0x3125,
	0x2126, 0x2527, 0x2D28, 0x2929, 0x292A, 0x2D2B, 0x292C, 0x2D2D,
	0x2D2E, 0x292F, 0x3530, 0x3131, 0x3132, 0x3533, 0x3134, 0x3535,
	0x2536, 0x2137, 0x2938, 0x2D39, 0x2D3A, 0x293B, 0x2D3C, 0x293D,
	0x293E, 0x2D3F, 0x1140, 0x1541, 0x1542, 0x1143, 0x1544, 0x1145,
	0x0146, 0x0547, 0x0D48, 0x0949, 0x094A, 0x0D4B, 0x094C, 0x0D4D,
	0x0D4E, 0x094F, 0x1550, 0x1151, 0x1152, 0x1553, 0x1154, 0x1555,
	0x0556, 0x0157, 0x0958, 0x0D59, 0x0D5A, 0x095B, 0x0D5C, 0x095D,
	0x095E, 0x0D5F, 0x3560, 0x3161, 0x3162, 0x3563, 0x3164, 0x3565,
	
	0xBEFA, 0xBAFB, 0xBEFC, 0xBAFD, 0xBAFE, 0xBEFF, 0x4600, 0x0201,
	0x0202, 0x0603, 0x0204, 0x0605, 0x0606, 0x0207, 0x0A08, 0x0E09,
	0x1E0A, 0x1A0B, 0x1E0C, 0x1A0D, 0x1A0E, 0x1E0F, 0x0210, 0x0611,
	0x0612, 0x0213, 0x0614, 0x0215, 0x0216, 0x0617, 0x0E18, 0x0A19,
	0x1A1A, 0x1E1B, 0x1A1C, 0x1E1D, 0x1E1E, 0x1A1F, 0x2220, 0x2621,
	0x2622, 0x2223, 0x2624, 0x2225, 0x2226, 0x2627, 0x2E28, 0x2A29,
	0x3A2A, 0x3E2B, 0x3A2C, 0x3E2D, 0x3E2E, 0x3A2F, 0x2630, 0x2231,
	0x2232, 0x2633, 0x2234, 0x2635, 0x2636, 0x2237, 0x2A38, 0x2E39,
	0x3E3A, 0x3A3B, 0x3E3C, 0x3A3D, 0x3A3E, 0x3E3F, 0x0240, 0x0641,
	0x0642, 0x0243, 0x0644, 0x0245, 0x0246, 0x0647, 0x0E48, 0x0A49,
	0x1A4A, 0x1E4B, 0x1A4C, 0x1E4D, 0x1E4E, 0x1A4F, 0x0650, 0x0251,
	0x0252, 0x0653, 0x0254, 0x0655, 0x0656, 0x0257, 0x0A58, 0x0E59,
	0x1E5A, 0x1A5B, 0x1E5C, 0x1A5D, 0x1A5E, 0x1E5F, 0x2660, 0x2261,
	0x2262, 0x2663, 0x2264, 0x2665, 0x2666, 0x2267, 0x2A68, 0x2E69,
	0x3E6A, 0x3A6B, 0x3E6C, 0x3A6D, 0x3A6E, 0x3E6F, 0x2270, 0x2671,
	0x2672, 0x2273, 0x2674, 0x2275, 0x2276, 0x2677, 0x2E78, 0x2A79,
	0x3A7A, 0x3E7B, 0x3A7C, 0x3E7D, 0x3E7E, 0x3A7F, 0x8280, 0x8681,
	0x8682, 0x8283, 0x8684, 0x8285, 0x8286, 0x8687, 0x8E88, 0x8A89,
	0x9A8A, 0x9E8B, 0x9A8C, 0x9E8D, 0x9E8E, 0x9A8F, 0x8690, 0x8291,
	0x8292, 0x8693, 0x2334, 0x2735, 0x2736, 0x2337, 0x2B38, 0x2F39,
	0x3F3A, 0x3B3B, 0x3F3C, 0x3B3D, 0x3B3E, 0x3F3F, 0x0340, 0x0741,
	0x0742, 0x0343, 0x0744, 0x0345, 0x0346, 0x0747, 0x0F48, 0x0B49,
	0x1B4A, 0x1F4B, 0x1B4C, 0x1F4D, 0x1F4E, 0x1B4F, 0x0750, 0x0351,
	0x0352, 0x0753, 0x0354, 0x0755, 0x0756, 0x0357, 0x0B58, 0x0F59,
	0x1F5A, 0x1B5B, 0x1F5C, 0x1B5D, 0x1B5E, 0x1F5F, 0x2760, 0x2361,
	0x2362, 0x2763, 0x2364, 0x2765, 0x2766, 0x2367, 0x2B68, 0x2F69,
	0x3F6A, 0x3B6B, 0x3F6C, 0x3B6D, 0x3B6E, 0x3F6F, 0x2370, 0x2771,
	0x2772, 0x2373, 0x2774, 0x2375, 0x2376, 0x2777, 0x2F78, 0x2B79,
	0x3B7A, 0x3F7B, 0x3B7C, 0x3F7D, 0x3F7E, 0x3B7F, 0x8380, 0x8781,
	0x8782, 0x8383, 0x8784, 0x8385, 0x8386, 0x8787, 0x8F88, 0x8B89,
	0x9B8A, 0x9F8B, 0x9B8C, 0x9F8D, 0x9F8E, 0x9B8F, 0x8790, 0x8391,
	0x8392, 0x8793, 0x8394, 0x8795, 0x8796, 0x8397, 0x8B98, 0x8F99,
	
	0x9F9A, 0x9B9B, 0x9F9C, 0x9B9D, 0x9B9E, 0x9F9F, 0xA7A0, 0xA3A1,
	0xA3A2, 0xA7A3, 0xA3A4, 0xA7A5, 0xA7A6, 0xA3A7, 0xABA8, 0xAFA9,
	0xBFAA, 0xBBAB, 0xBFAC, 0xBBAD, 0xBBAE, 0xBFAF, 0xA3B0, 0xA7B1,
	0xA7B2, 0xA3B3, 0xA7B4, 0xA3B5, 0xA3B6, 0xA7B7, 0xAFB8, 0xABB9,
	0xBBBA, 0xBFBB, 0xBBBC, 0xBFBD, 0xBFBE, 0xBBBF, 0x87C0, 0x83C1,
	0x83C2, 0x87C3, 0x83C4, 0x87C5, 0x87C6, 0x83C7, 0x8BC8, 0x8FC9,
	0x9FCA, 0x9BCB, 0x9FCC, 0x9BCD, 0x9BCE, 0x9FCF, 0x83D0, 0x87D1,
	0x87D2, 0x83D3, 0x87D4, 0x83D5, 0x83D6, 0x87D7, 0x8FD8, 0x8BD9,
	0x9BDA, 0x9FDB, 0x9BDC, 0x9FDD, 0x9FDE, 0x9BDF, 0xA3E0, 0xA7E1,
	0xA7E2, 0xA3E3, 0xA7E4, 0xA3E5, 0xA3E6, 0xA7E7, 0xAFE8, 0xABE9,
	0xBBEA, 0xBFEB, 0xBBEC, 0xBFED, 0xBFEE, 0xBBEF, 0xA7F0, 0xA3F1,
	0xA3F2, 0xA7F3, 0xA3F4, 0xA7F5, 0xA7F6, 0xA3F7, 0xABF8, 0xAFF9,
	0xBFFA, 0xBBFB, 0xBFFC, 0xBBFD, 0xBBFE, 0xBFFF, 0x4700, 0x0301,
	0x0302, 0x0703, 0x0304, 0x0705, 0x0706, 0x0307, 0x0B08, 0x0F09,
	0x1F0A, 0x1B0B, 0x1F0C, 0x1B0D, 0x1B0E, 0x1F0F, 0x0310, 0x0711,
	0x0712, 0x0313, 0x0714, 0x0315, 0x0316, 0x0717, 0x0F18, 0x0B19,
	0x1B1A, 0x1F1B, 0x1B1C, 0x1F1D, 0x1F1E, 0x1B1F, 0x2320, 0x2721,
	0x2722, 0x2323, 0x2724, 0x2325, 0x2326, 0x2727, 0x2F28, 0x2B29,
	0x3B2A, 0x3F2B, 0x3B2C, 0x3F2D, 0x3F2E, 0x3B2F, 0x2730, 0x2331,
	0x2332, 0x2733, 0x2334, 0x2735, 0x2736, 0x2337, 0x2B38, 0x2F39,
	0x3F3A, 0x3B3B, 0x3F3C, 0x3B3D, 0x3B3E, 0x3F3F, 0x0340, 0x0741,
	0x0742, 0x0343, 0x0744, 0x0345, 0x0346, 0x0747, 0x0F48, 0x0B49,
	0x1B4A, 0x1F4B, 0x1B4C, 0x1F4D, 0x1F4E, 0x1B4F, 0x0750, 0x0351,
	0x0352, 0x0753, 0x0354, 0x0755, 0x0756, 0x0357, 0x0B58, 0x0F59,
	0x1F5A, 0x1B5B, 0x1F5C, 0x1B5D, 0x1B5E, 0x1F5F, 0x2760, 0x2361,
	0x2362, 0x2763, 0x2364, 0x2765, 0x2766, 0x2367, 0x2B68, 0x2F69,
	0x3F6A, 0x3B6B, 0x3F6C, 0x3B6D, 0x3B6E, 0x3F6F, 0x2370, 0x2771,
	0x2772, 0x2373, 0x2774, 0x2375, 0x2376, 0x2777, 0x2F78, 0x2B79,
	0x3B7A, 0x3F7B, 0x3B7C, 0x3F7D, 0x3F7E, 0x3B7F, 0x8380, 0x8781,
	0x8782, 0x8383, 0x8784, 0x8385, 0x8386, 0x8787, 0x8F88, 0x8B89,
	0x9B8A, 0x9F8B, 0x9B8C, 0x9F8D, 0x9F8E, 0x9B8F, 0x8790, 0x8391,
	0x8392, 0x8793, 0x8394, 0x8795, 0x8796, 0x8397, 0x8B98, 0x8F99
};
