/* abstractmultiset.c generated by valac, the Vala compiler
 * generated from abstractmultiset.vala, do not modify */

/* abstractmultiset.vala
 *
 * Copyright (C) 2009  Ali Sabil
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Ali Sabil <ali.sabil@gmail.com>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_MULTI_SET (gee_multi_set_get_type ())
#define GEE_MULTI_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MULTI_SET, GeeMultiSet))
#define GEE_IS_MULTI_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MULTI_SET))
#define GEE_MULTI_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MULTI_SET, GeeMultiSetIface))

typedef struct _GeeMultiSet GeeMultiSet;
typedef struct _GeeMultiSetIface GeeMultiSetIface;

#define GEE_TYPE_ABSTRACT_MULTI_SET (gee_abstract_multi_set_get_type ())
#define GEE_ABSTRACT_MULTI_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_MULTI_SET, GeeAbstractMultiSet))
#define GEE_ABSTRACT_MULTI_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_MULTI_SET, GeeAbstractMultiSetClass))
#define GEE_IS_ABSTRACT_MULTI_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_MULTI_SET))
#define GEE_IS_ABSTRACT_MULTI_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_MULTI_SET))
#define GEE_ABSTRACT_MULTI_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_MULTI_SET, GeeAbstractMultiSetClass))

typedef struct _GeeAbstractMultiSet GeeAbstractMultiSet;
typedef struct _GeeAbstractMultiSetClass GeeAbstractMultiSetClass;
typedef struct _GeeAbstractMultiSetPrivate GeeAbstractMultiSetPrivate;

#define GEE_TYPE_MAP (gee_map_get_type ())
#define GEE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP, GeeMap))
#define GEE_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP))
#define GEE_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP, GeeMapIface))

typedef struct _GeeMap GeeMap;
typedef struct _GeeMapIface GeeMapIface;

#define GEE_TYPE_MAP_ITERATOR (gee_map_iterator_get_type ())
#define GEE_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIterator))
#define GEE_IS_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP_ITERATOR))
#define GEE_MAP_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIteratorIface))

typedef struct _GeeMapIterator GeeMapIterator;
typedef struct _GeeMapIteratorIface GeeMapIteratorIface;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_MAP_TYPE_ENTRY (gee_map_entry_get_type ())
#define GEE_MAP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_MAP_TYPE_ENTRY, GeeMapEntry))
#define GEE_MAP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_MAP_TYPE_ENTRY, GeeMapEntryClass))
#define GEE_MAP_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_MAP_TYPE_ENTRY))
#define GEE_MAP_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_MAP_TYPE_ENTRY))
#define GEE_MAP_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_MAP_TYPE_ENTRY, GeeMapEntryClass))

typedef struct _GeeMapEntry GeeMapEntry;
typedef struct _GeeMapEntryClass GeeMapEntryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_ABSTRACT_MULTI_SET_TYPE_ITERATOR (gee_abstract_multi_set_iterator_get_type ())
#define GEE_ABSTRACT_MULTI_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_ABSTRACT_MULTI_SET_TYPE_ITERATOR, GeeAbstractMultiSetIterator))
#define GEE_ABSTRACT_MULTI_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_ABSTRACT_MULTI_SET_TYPE_ITERATOR, GeeAbstractMultiSetIteratorClass))
#define GEE_ABSTRACT_MULTI_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_ABSTRACT_MULTI_SET_TYPE_ITERATOR))
#define GEE_ABSTRACT_MULTI_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_ABSTRACT_MULTI_SET_TYPE_ITERATOR))
#define GEE_ABSTRACT_MULTI_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_ABSTRACT_MULTI_SET_TYPE_ITERATOR, GeeAbstractMultiSetIteratorClass))

typedef struct _GeeAbstractMultiSetIterator GeeAbstractMultiSetIterator;
typedef struct _GeeAbstractMultiSetIteratorClass GeeAbstractMultiSetIteratorClass;
typedef struct _GeeAbstractMultiSetIteratorPrivate GeeAbstractMultiSetIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeMultiSetIface {
	GTypeInterface parent_iface;
	gint (*count) (GeeMultiSet* self, gconstpointer item);
};

struct _GeeMapIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeMapIterator* self);
	gboolean (*has_next) (GeeMapIterator* self);
	gboolean (*first) (GeeMapIterator* self);
	gpointer (*get_key) (GeeMapIterator* self);
	gpointer (*get_value) (GeeMapIterator* self);
	void (*set_value) (GeeMapIterator* self, gconstpointer value);
	void (*unset) (GeeMapIterator* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeMapIface {
	GTypeInterface parent_iface;
	gboolean (*has_key) (GeeMap* self, gconstpointer key);
	gboolean (*contains) (GeeMap* self, gconstpointer key);
	gboolean (*has) (GeeMap* self, gconstpointer key, gconstpointer value);
	gpointer (*get) (GeeMap* self, gconstpointer key);
	void (*set) (GeeMap* self, gconstpointer key, gconstpointer value);
	gboolean (*unset) (GeeMap* self, gconstpointer key, gpointer* value);
	gboolean (*remove) (GeeMap* self, gconstpointer key, gpointer* value);
	void (*clear) (GeeMap* self);
	GeeMapIterator* (*map_iterator) (GeeMap* self);
	void (*set_all) (GeeMap* self, GeeMap* map);
	gboolean (*unset_all) (GeeMap* self, GeeMap* map);
	gboolean (*remove_all) (GeeMap* self, GeeMap* map);
	gboolean (*has_all) (GeeMap* self, GeeMap* map);
	gboolean (*contains_all) (GeeMap* self, GeeMap* map);
	gint (*get_size) (GeeMap* self);
	gboolean (*get_is_empty) (GeeMap* self);
	GeeSet* (*get_keys) (GeeMap* self);
	GeeCollection* (*get_values) (GeeMap* self);
	GeeSet* (*get_entries) (GeeMap* self);
	GeeMap* (*get_read_only_view) (GeeMap* self);
	GType (*get_key_type) (GeeMap* self);
	GType (*get_value_type) (GeeMap* self);
};

struct _GeeAbstractMultiSet {
	GeeAbstractCollection parent_instance;
	GeeAbstractMultiSetPrivate * priv;
	GeeMap* _storage_map;
};

struct _GeeAbstractMultiSetClass {
	GeeAbstractCollectionClass parent_class;
};

struct _GeeAbstractMultiSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _nitems;
};

struct _GeeAbstractMultiSetIterator {
	GObject parent_instance;
	GeeAbstractMultiSetIteratorPrivate * priv;
};

struct _GeeAbstractMultiSetIteratorClass {
	GObjectClass parent_class;
};

struct _GeeAbstractMultiSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeAbstractMultiSet* _set;
	GeeMapIterator* _iter;
	gint _pending;
	gboolean _removed;
};


static gpointer gee_abstract_multi_set_iterator_parent_class = NULL;
static GeeIteratorIface* gee_abstract_multi_set_iterator_gee_iterator_parent_iface = NULL;
static gpointer gee_abstract_multi_set_parent_class = NULL;
static GeeMultiSetIface* gee_abstract_multi_set_gee_multi_set_parent_iface = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_abstract_collection_get_type (void);
GType gee_multi_set_get_type (void);
GType gee_abstract_multi_set_get_type (void);
GType gee_map_iterator_get_type (void);
GType gee_set_get_type (void);
GType gee_map_entry_get_type (void);
GType gee_map_get_type (void);
#define GEE_ABSTRACT_MULTI_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ABSTRACT_MULTI_SET, GeeAbstractMultiSetPrivate))
enum  {
	GEE_ABSTRACT_MULTI_SET_DUMMY_PROPERTY,
	GEE_ABSTRACT_MULTI_SET_SIZE,
	GEE_ABSTRACT_MULTI_SET_G_TYPE,
	GEE_ABSTRACT_MULTI_SET_G_DUP_FUNC,
	GEE_ABSTRACT_MULTI_SET_G_DESTROY_FUNC
};
GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeAbstractMultiSet* gee_abstract_multi_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeMap* storage_map);
gboolean gee_map_contains (GeeMap* self, gconstpointer key);
gpointer gee_map_get (GeeMap* self, gconstpointer key);
static gint gee_abstract_multi_set_real_count (GeeMultiSet* base, gconstpointer item);
static gboolean gee_abstract_multi_set_real_contains (GeeAbstractCollection* base, gconstpointer item);
static GeeAbstractMultiSetIterator* gee_abstract_multi_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeAbstractMultiSet* set);
static GeeAbstractMultiSetIterator* gee_abstract_multi_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeAbstractMultiSet* set);
static GType gee_abstract_multi_set_iterator_get_type (void);
static GeeIterator* gee_abstract_multi_set_real_iterator (GeeAbstractCollection* base);
void gee_map_set (GeeMap* self, gconstpointer key, gconstpointer value);
static gboolean gee_abstract_multi_set_real_add (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_map_remove (GeeMap* self, gconstpointer key, gpointer* value);
static gboolean gee_abstract_multi_set_real_remove (GeeAbstractCollection* base, gconstpointer item);
void gee_map_clear (GeeMap* self);
static void gee_abstract_multi_set_real_clear (GeeAbstractCollection* base);
#define GEE_ABSTRACT_MULTI_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_ABSTRACT_MULTI_SET_TYPE_ITERATOR, GeeAbstractMultiSetIteratorPrivate))
enum  {
	GEE_ABSTRACT_MULTI_SET_ITERATOR_DUMMY_PROPERTY,
	GEE_ABSTRACT_MULTI_SET_ITERATOR_G_TYPE,
	GEE_ABSTRACT_MULTI_SET_ITERATOR_G_DUP_FUNC,
	GEE_ABSTRACT_MULTI_SET_ITERATOR_G_DESTROY_FUNC
};
GeeMapIterator* gee_map_map_iterator (GeeMap* self);
gboolean gee_map_iterator_next (GeeMapIterator* self);
gpointer gee_map_iterator_get_value (GeeMapIterator* self);
static gboolean gee_abstract_multi_set_iterator_real_next (GeeIterator* base);
gboolean gee_map_iterator_has_next (GeeMapIterator* self);
static gboolean gee_abstract_multi_set_iterator_real_has_next (GeeIterator* base);
gboolean gee_map_iterator_first (GeeMapIterator* self);
static gboolean gee_abstract_multi_set_iterator_real_first (GeeIterator* base);
gpointer gee_map_iterator_get_key (GeeMapIterator* self);
static gpointer gee_abstract_multi_set_iterator_real_get (GeeIterator* base);
void gee_map_iterator_set_value (GeeMapIterator* self, gconstpointer value);
void gee_map_iterator_unset (GeeMapIterator* self);
static void gee_abstract_multi_set_iterator_real_remove (GeeIterator* base);
static void gee_abstract_multi_set_iterator_finalize (GObject* obj);
static void gee_abstract_multi_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_abstract_multi_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_abstract_multi_set_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static void gee_abstract_multi_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_abstract_multi_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 41 "abstractmultiset.vala"
GeeAbstractMultiSet* gee_abstract_multi_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeMap* storage_map) {
#line 345 "abstractmultiset.c"
	GeeAbstractMultiSet * self;
	GeeMap* _tmp0_;
#line 41 "abstractmultiset.vala"
	g_return_val_if_fail (storage_map != NULL, NULL);
#line 41 "abstractmultiset.vala"
	self = (GeeAbstractMultiSet*) gee_abstract_collection_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 41 "abstractmultiset.vala"
	self->priv->g_type = g_type;
#line 41 "abstractmultiset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 41 "abstractmultiset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 42 "abstractmultiset.vala"
	self->_storage_map = (_tmp0_ = _g_object_ref0 (storage_map), _g_object_unref0 (self->_storage_map), _tmp0_);
#line 360 "abstractmultiset.c"
	return self;
}


#line 45 "abstractmultiset.vala"
static gint gee_abstract_multi_set_real_count (GeeMultiSet* base, gconstpointer item) {
#line 367 "abstractmultiset.c"
	GeeAbstractMultiSet * self;
	gint result;
	gint _result_;
	self = (GeeAbstractMultiSet*) base;
#line 46 "abstractmultiset.vala"
	_result_ = 0;
#line 47 "abstractmultiset.vala"
	if (gee_map_contains (self->_storage_map, item)) {
#line 48 "abstractmultiset.vala"
		_result_ = GPOINTER_TO_INT (gee_map_get (self->_storage_map, item));
#line 378 "abstractmultiset.c"
	}
	result = _result_;
#line 50 "abstractmultiset.vala"
	return result;
#line 383 "abstractmultiset.c"
}


#line 53 "abstractmultiset.vala"
static gboolean gee_abstract_multi_set_real_contains (GeeAbstractCollection* base, gconstpointer item) {
#line 389 "abstractmultiset.c"
	GeeAbstractMultiSet * self;
	gboolean result;
	self = (GeeAbstractMultiSet*) base;
	result = gee_map_contains (self->_storage_map, item);
#line 54 "abstractmultiset.vala"
	return result;
#line 396 "abstractmultiset.c"
}


#line 57 "abstractmultiset.vala"
static GeeIterator* gee_abstract_multi_set_real_iterator (GeeAbstractCollection* base) {
#line 402 "abstractmultiset.c"
	GeeAbstractMultiSet * self;
	GeeIterator* result;
	self = (GeeAbstractMultiSet*) base;
	result = (GeeIterator*) gee_abstract_multi_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 58 "abstractmultiset.vala"
	return result;
#line 409 "abstractmultiset.c"
}


#line 61 "abstractmultiset.vala"
static gboolean gee_abstract_multi_set_real_add (GeeAbstractCollection* base, gconstpointer item) {
#line 415 "abstractmultiset.c"
	GeeAbstractMultiSet * self;
	gboolean result;
	self = (GeeAbstractMultiSet*) base;
#line 62 "abstractmultiset.vala"
	if (gee_map_contains (self->_storage_map, item)) {
#line 421 "abstractmultiset.c"
		gint current_count;
#line 63 "abstractmultiset.vala"
		current_count = GPOINTER_TO_INT (gee_map_get (self->_storage_map, item));
#line 64 "abstractmultiset.vala"
		gee_map_set (self->_storage_map, item, GINT_TO_POINTER (current_count + 1));
#line 427 "abstractmultiset.c"
	} else {
#line 66 "abstractmultiset.vala"
		gee_map_set (self->_storage_map, item, GINT_TO_POINTER (1));
#line 431 "abstractmultiset.c"
	}
#line 68 "abstractmultiset.vala"
	self->priv->_nitems++;
#line 435 "abstractmultiset.c"
	result = TRUE;
#line 69 "abstractmultiset.vala"
	return result;
#line 439 "abstractmultiset.c"
}


#line 72 "abstractmultiset.vala"
static gboolean gee_abstract_multi_set_real_remove (GeeAbstractCollection* base, gconstpointer item) {
#line 445 "abstractmultiset.c"
	GeeAbstractMultiSet * self;
	gboolean result;
	gboolean _tmp0_ = FALSE;
	self = (GeeAbstractMultiSet*) base;
#line 73 "abstractmultiset.vala"
	if (self->priv->_nitems > 0) {
#line 73 "abstractmultiset.vala"
		_tmp0_ = gee_map_contains (self->_storage_map, item);
#line 454 "abstractmultiset.c"
	} else {
#line 73 "abstractmultiset.vala"
		_tmp0_ = FALSE;
#line 458 "abstractmultiset.c"
	}
#line 73 "abstractmultiset.vala"
	if (_tmp0_) {
#line 462 "abstractmultiset.c"
		gint current_count;
#line 74 "abstractmultiset.vala"
		current_count = GPOINTER_TO_INT (gee_map_get (self->_storage_map, item));
#line 75 "abstractmultiset.vala"
		if (current_count <= 1) {
#line 76 "abstractmultiset.vala"
			gee_map_remove (self->_storage_map, item, NULL);
#line 470 "abstractmultiset.c"
		} else {
#line 78 "abstractmultiset.vala"
			gee_map_set (self->_storage_map, item, GINT_TO_POINTER (current_count - 1));
#line 474 "abstractmultiset.c"
		}
#line 80 "abstractmultiset.vala"
		self->priv->_nitems--;
#line 478 "abstractmultiset.c"
		result = TRUE;
#line 81 "abstractmultiset.vala"
		return result;
#line 482 "abstractmultiset.c"
	}
	result = FALSE;
#line 83 "abstractmultiset.vala"
	return result;
#line 487 "abstractmultiset.c"
}


#line 86 "abstractmultiset.vala"
static void gee_abstract_multi_set_real_clear (GeeAbstractCollection* base) {
#line 493 "abstractmultiset.c"
	GeeAbstractMultiSet * self;
	self = (GeeAbstractMultiSet*) base;
#line 87 "abstractmultiset.vala"
	gee_map_clear (self->_storage_map);
#line 88 "abstractmultiset.vala"
	self->priv->_nitems = 0;
#line 500 "abstractmultiset.c"
}


static gint gee_abstract_multi_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeAbstractMultiSet* self;
	self = (GeeAbstractMultiSet*) base;
	result = self->priv->_nitems;
#line 32 "abstractmultiset.vala"
	return result;
#line 511 "abstractmultiset.c"
}


#line 98 "abstractmultiset.vala"
static GeeAbstractMultiSetIterator* gee_abstract_multi_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeAbstractMultiSet* set) {
#line 517 "abstractmultiset.c"
	GeeAbstractMultiSetIterator * self;
	GeeAbstractMultiSet* _tmp0_;
	GeeMapIterator* _tmp1_;
#line 98 "abstractmultiset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 98 "abstractmultiset.vala"
	self = (GeeAbstractMultiSetIterator*) g_object_new (object_type, NULL);
#line 98 "abstractmultiset.vala"
	self->priv->g_type = g_type;
#line 98 "abstractmultiset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 98 "abstractmultiset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 99 "abstractmultiset.vala"
	self->priv->_set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->_set), _tmp0_);
#line 100 "abstractmultiset.vala"
	self->priv->_iter = (_tmp1_ = gee_map_map_iterator (self->priv->_set->_storage_map), _g_object_unref0 (self->priv->_iter), _tmp1_);
#line 535 "abstractmultiset.c"
	return self;
}


#line 98 "abstractmultiset.vala"
static GeeAbstractMultiSetIterator* gee_abstract_multi_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeAbstractMultiSet* set) {
#line 98 "abstractmultiset.vala"
	return gee_abstract_multi_set_iterator_construct (GEE_ABSTRACT_MULTI_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
#line 544 "abstractmultiset.c"
}


#line 103 "abstractmultiset.vala"
static gboolean gee_abstract_multi_set_iterator_real_next (GeeIterator* base) {
#line 550 "abstractmultiset.c"
	GeeAbstractMultiSetIterator * self;
	gboolean result;
	self = (GeeAbstractMultiSetIterator*) base;
#line 104 "abstractmultiset.vala"
	self->priv->_removed = FALSE;
#line 105 "abstractmultiset.vala"
	if (self->priv->_pending == 0) {
#line 106 "abstractmultiset.vala"
		if (gee_map_iterator_next (self->priv->_iter)) {
#line 107 "abstractmultiset.vala"
			self->priv->_pending = GPOINTER_TO_INT (gee_map_iterator_get_value (self->priv->_iter)) - 1;
#line 562 "abstractmultiset.c"
			result = TRUE;
#line 108 "abstractmultiset.vala"
			return result;
#line 566 "abstractmultiset.c"
		}
	} else {
#line 111 "abstractmultiset.vala"
		self->priv->_pending--;
#line 571 "abstractmultiset.c"
		result = TRUE;
#line 112 "abstractmultiset.vala"
		return result;
#line 575 "abstractmultiset.c"
	}
	result = FALSE;
#line 114 "abstractmultiset.vala"
	return result;
#line 580 "abstractmultiset.c"
}


#line 117 "abstractmultiset.vala"
static gboolean gee_abstract_multi_set_iterator_real_has_next (GeeIterator* base) {
#line 586 "abstractmultiset.c"
	GeeAbstractMultiSetIterator * self;
	gboolean result;
	gboolean _tmp0_ = FALSE;
	self = (GeeAbstractMultiSetIterator*) base;
#line 118 "abstractmultiset.vala"
	if (self->priv->_pending > 0) {
#line 118 "abstractmultiset.vala"
		_tmp0_ = TRUE;
#line 595 "abstractmultiset.c"
	} else {
#line 118 "abstractmultiset.vala"
		_tmp0_ = gee_map_iterator_has_next (self->priv->_iter);
#line 599 "abstractmultiset.c"
	}
	result = _tmp0_;
#line 118 "abstractmultiset.vala"
	return result;
#line 604 "abstractmultiset.c"
}


#line 121 "abstractmultiset.vala"
static gboolean gee_abstract_multi_set_iterator_real_first (GeeIterator* base) {
#line 610 "abstractmultiset.c"
	GeeAbstractMultiSetIterator * self;
	gboolean result;
	self = (GeeAbstractMultiSetIterator*) base;
#line 122 "abstractmultiset.vala"
	if (self->priv->_set->priv->_nitems == 0) {
#line 616 "abstractmultiset.c"
		result = FALSE;
#line 123 "abstractmultiset.vala"
		return result;
#line 620 "abstractmultiset.c"
	}
#line 125 "abstractmultiset.vala"
	self->priv->_pending = 0;
#line 126 "abstractmultiset.vala"
	if (gee_map_iterator_first (self->priv->_iter)) {
#line 127 "abstractmultiset.vala"
		self->priv->_pending = GPOINTER_TO_INT (gee_map_iterator_get_value (self->priv->_iter)) - 1;
#line 628 "abstractmultiset.c"
	}
	result = TRUE;
#line 129 "abstractmultiset.vala"
	return result;
#line 633 "abstractmultiset.c"
}


#line 132 "abstractmultiset.vala"
static gpointer gee_abstract_multi_set_iterator_real_get (GeeIterator* base) {
#line 639 "abstractmultiset.c"
	GeeAbstractMultiSetIterator * self;
	gpointer result;
	self = (GeeAbstractMultiSetIterator*) base;
#line 133 "abstractmultiset.vala"
	g_assert (!self->priv->_removed);
#line 645 "abstractmultiset.c"
	result = gee_map_iterator_get_key (self->priv->_iter);
#line 134 "abstractmultiset.vala"
	return result;
#line 649 "abstractmultiset.c"
}


#line 137 "abstractmultiset.vala"
static void gee_abstract_multi_set_iterator_real_remove (GeeIterator* base) {
#line 655 "abstractmultiset.c"
	GeeAbstractMultiSetIterator * self;
	self = (GeeAbstractMultiSetIterator*) base;
#line 138 "abstractmultiset.vala"
	g_assert (!self->priv->_removed);
#line 139 "abstractmultiset.vala"
	gee_map_iterator_set_value (self->priv->_iter, GINT_TO_POINTER (self->priv->_pending = GPOINTER_TO_INT (gee_map_iterator_get_value (self->priv->_iter)) - 1));
#line 140 "abstractmultiset.vala"
	if (self->priv->_pending == 0) {
#line 141 "abstractmultiset.vala"
		gee_map_iterator_unset (self->priv->_iter);
#line 666 "abstractmultiset.c"
	}
#line 143 "abstractmultiset.vala"
	self->priv->_set->priv->_nitems--;
#line 144 "abstractmultiset.vala"
	self->priv->_removed = TRUE;
#line 672 "abstractmultiset.c"
}


static void gee_abstract_multi_set_iterator_class_init (GeeAbstractMultiSetIteratorClass * klass) {
	gee_abstract_multi_set_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeAbstractMultiSetIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_abstract_multi_set_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_abstract_multi_set_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_abstract_multi_set_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_SET_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_SET_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_SET_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_abstract_multi_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_abstract_multi_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_abstract_multi_set_iterator_real_next;
	iface->has_next = gee_abstract_multi_set_iterator_real_has_next;
	iface->first = gee_abstract_multi_set_iterator_real_first;
	iface->get = gee_abstract_multi_set_iterator_real_get;
	iface->remove = gee_abstract_multi_set_iterator_real_remove;
}


static void gee_abstract_multi_set_iterator_instance_init (GeeAbstractMultiSetIterator * self) {
	self->priv = GEE_ABSTRACT_MULTI_SET_ITERATOR_GET_PRIVATE (self);
	self->priv->_pending = 0;
	self->priv->_removed = FALSE;
}


static void gee_abstract_multi_set_iterator_finalize (GObject* obj) {
	GeeAbstractMultiSetIterator * self;
	self = GEE_ABSTRACT_MULTI_SET_ITERATOR (obj);
	_g_object_unref0 (self->priv->_set);
	_g_object_unref0 (self->priv->_iter);
	G_OBJECT_CLASS (gee_abstract_multi_set_iterator_parent_class)->finalize (obj);
}


static GType gee_abstract_multi_set_iterator_get_type (void) {
	static GType gee_abstract_multi_set_iterator_type_id = 0;
	if (gee_abstract_multi_set_iterator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeAbstractMultiSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_abstract_multi_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeAbstractMultiSetIterator), 0, (GInstanceInitFunc) gee_abstract_multi_set_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_abstract_multi_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_abstract_multi_set_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeAbstractMultiSetIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_abstract_multi_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	}
	return gee_abstract_multi_set_iterator_type_id;
}


static void gee_abstract_multi_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeAbstractMultiSetIterator * self;
	self = GEE_ABSTRACT_MULTI_SET_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_abstract_multi_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeAbstractMultiSetIterator * self;
	self = GEE_ABSTRACT_MULTI_SET_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ABSTRACT_MULTI_SET_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_MULTI_SET_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MULTI_SET_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_abstract_multi_set_class_init (GeeAbstractMultiSetClass * klass) {
	gee_abstract_multi_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeAbstractMultiSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_abstract_multi_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_abstract_multi_set_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_abstract_multi_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_abstract_multi_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_abstract_multi_set_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_abstract_multi_set_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_abstract_multi_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_abstract_multi_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_abstract_multi_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_SET_SIZE, "size");
}


static void gee_abstract_multi_set_gee_multi_set_interface_init (GeeMultiSetIface * iface) {
	gee_abstract_multi_set_gee_multi_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->count = gee_abstract_multi_set_real_count;
}


static void gee_abstract_multi_set_instance_init (GeeAbstractMultiSet * self) {
	self->priv = GEE_ABSTRACT_MULTI_SET_GET_PRIVATE (self);
	self->priv->_nitems = 0;
}


static void gee_abstract_multi_set_finalize (GObject* obj) {
	GeeAbstractMultiSet * self;
	self = GEE_ABSTRACT_MULTI_SET (obj);
	_g_object_unref0 (self->_storage_map);
	G_OBJECT_CLASS (gee_abstract_multi_set_parent_class)->finalize (obj);
}


GType gee_abstract_multi_set_get_type (void) {
	static GType gee_abstract_multi_set_type_id = 0;
	if (gee_abstract_multi_set_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeAbstractMultiSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_abstract_multi_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeAbstractMultiSet), 0, (GInstanceInitFunc) gee_abstract_multi_set_instance_init, NULL };
		static const GInterfaceInfo gee_multi_set_info = { (GInterfaceInitFunc) gee_abstract_multi_set_gee_multi_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_abstract_multi_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_COLLECTION, "GeeAbstractMultiSet", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gee_abstract_multi_set_type_id, GEE_TYPE_MULTI_SET, &gee_multi_set_info);
	}
	return gee_abstract_multi_set_type_id;
}


static void gee_abstract_multi_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeAbstractMultiSet * self;
	self = GEE_ABSTRACT_MULTI_SET (object);
	switch (property_id) {
		case GEE_ABSTRACT_MULTI_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_abstract_multi_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeAbstractMultiSet * self;
	self = GEE_ABSTRACT_MULTI_SET (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ABSTRACT_MULTI_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_MULTI_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MULTI_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}




