/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import org.limewire.core.settings.PromotionSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.promotion.InitializeException;
import org.limewire.promotion.PromotionBinderRepository;
import org.limewire.promotion.PromotionSearcher;
import org.limewire.promotion.PromotionServices;

@EagerSingleton
final class PromotionServicesImpl
implements PromotionServices,
Service {
    private final PromotionBinderRepository promotionBinderRepository;
    private final PromotionSearcher promotionSearcher;
    private volatile boolean isRunning;

    @Inject
    public PromotionServicesImpl(PromotionBinderRepository promotionBinderRepository, PromotionSearcher promotionSearcher) {
        this.promotionBinderRepository = promotionBinderRepository;
        this.promotionSearcher = promotionSearcher;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Promotion System");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        try {
            this.promotionBinderRepository.init(PromotionSettings.SEARCH_URL, PromotionSettings.BUCKET_ID_MODULUS);
            this.promotionSearcher.init(PromotionSettings.MAX_NUMBER_OF_SEARCH_RESULTS);
            this.isRunning = true;
        }
        catch (InitializeException initializeException) {
            this.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void stop() {
        this.promotionSearcher.shutDown();
        this.isRunning = false;
    }
}

