/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.util.DataUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.io.NetworkUtils;

public final class UDPReplyHandler
implements ReplyHandler {
    private final InetSocketAddress addr;
    private final UDPService udpService;

    UDPReplyHandler(InetSocketAddress addr, UDPService udpService) {
        this.udpService = udpService;
        if (!NetworkUtils.isValidSocketAddress(addr)) {
            throw new IllegalArgumentException("invalid addr: " + addr);
        }
        this.addr = addr;
    }

    UDPReplyHandler(InetAddress addr, int port, UDPService udpService) {
        this(new InetSocketAddress(addr, port), udpService);
    }

    @Override
    public void handlePingReply(PingReply pong, ReplyHandler handler) {
        this.udpService.send((Message)pong, this.addr);
    }

    @Override
    public void handleQueryReply(QueryReply hit, ReplyHandler handler) {
        this.udpService.send((Message)hit, this.addr);
    }

    @Override
    public void handlePushRequest(PushRequest request, ReplyHandler handler) {
        this.udpService.send((Message)request, this.addr);
    }

    @Override
    public void countDroppedMessage() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public int getNumMessagesReceived() {
        return 0;
    }

    @Override
    public boolean isOutgoing() {
        return false;
    }

    @Override
    public boolean isKillable() {
        return false;
    }

    @Override
    public boolean isSupernodeClientConnection() {
        return false;
    }

    @Override
    public boolean isLeafConnection() {
        return false;
    }

    @Override
    public boolean isHighDegreeConnection() {
        return false;
    }

    @Override
    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    @Override
    public boolean isGoodUltrapeer() {
        return false;
    }

    @Override
    public boolean isGoodLeaf() {
        return false;
    }

    @Override
    public boolean supportsPongCaching() {
        return false;
    }

    @Override
    public boolean allowNewPings() {
        return true;
    }

    @Override
    public void handleSimppVM(SimppVM simppVM) {
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.addr;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.addr.getAddress();
    }

    @Override
    public String getAddress() {
        return this.addr.getAddress().getHostAddress();
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public String getLocalePref() {
        return ApplicationSettings.DEFAULT_LOCALE.get();
    }

    public String toString() {
        return this.addr.toString();
    }

    public void handleUDPCrawlerPong(UDPCrawlerPong m) {
        this.udpService.send((Message)m, this.addr);
    }

    @Override
    public void reply(Message m) {
        this.udpService.send(m, this.addr);
    }

    @Override
    public int getPort() {
        return this.addr.getPort();
    }

    @Override
    public byte[] getClientGUID() {
        return DataUtils.EMPTY_GUID;
    }
}

