/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.api.connection.FWTStatusReason;
import org.limewire.core.api.connection.FirewallTransferStatus;
import org.limewire.core.api.connection.FirewallTransferStatusEvent;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.listener.AsynchronousEventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.ReadWriteObserver;
import org.limewire.rudp.ConnectionState;
import org.limewire.rudp.UDPSocketChannel;
import org.limewire.rudp.UDPSocketChannelConnectionEvent;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculator;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.service.ErrorService;

@EagerSingleton
public class UDPService
implements ReadWriteObserver {
    private static final Log LOG = LogFactory.getLog(UDPService.class);
    private static final MACCalculator PING_GENERATOR = MACCalculatorRepositoryManager.createDefaultCalculatorFactory().createMACCalculator();
    private DatagramChannel _channel;
    private final List<SendBundle> OUTGOING_MSGS;
    private final ByteBuffer BUFFER;
    private final int BUFFER_SIZE = 2048;
    private volatile boolean _acceptedSolicitedIncoming = false;
    private volatile boolean _acceptedUnsolicitedIncoming = false;
    private long _lastUnsolicitedIncomingTime = 0L;
    private volatile long _lastReceivedAny = 0L;
    private long _lastConnectBackTime = System.currentTimeMillis();
    private volatile boolean _successfulFWT;
    private int _lastReportedPort;
    private int _lastReportedClassC;
    private int _numReceivedIPPongs;
    private final GUID CONNECT_BACK_GUID = new GUID(GUID.makeGuid());
    private final GUID SOLICITED_PING_GUID = new GUID(GUID.makeGuid());
    private boolean _started = false;
    private static final long PING_PERIOD = 85000L;
    private static final byte[] IN_HEADER_BUF = new byte[23];
    private final NetworkManager networkManager;
    private final Provider<MessageDispatcher> messageDispatcher;
    private final Provider<IPFilter> ipFilter;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<Acceptor> acceptor;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final ScheduledExecutorService backgroundExecutor;
    private final ConnectionServices connectionServices;
    private final MessageFactory messageFactory;
    private final PingRequestFactory pingRequestFactory;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final AsynchronousEventBroadcaster<FirewallTransferStatusEvent> fwtStatusBroadcaster;
    @InspectionPoint(value="udp sent messages")
    private final Message.MessageCounter sentMessageCounter = new Message.MessageCounter(50);
    @InspectionPoint(value="fwt capable")
    private final Inspectable fwtCapable = new Inspectable(){

        @Override
        public Object inspect() {
            return UDPService.this.canDoFWT();
        }
    };

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - this.acceptor.get().getIncomingExpireTime();
    }

    @Inject
    public UDPService(NetworkManager networkManager, Provider<MessageDispatcher> messageDispatcher, @Named(value="hostileFilter") Provider<IPFilter> ipFilter, Provider<ConnectionManager> connectionManager, Provider<MessageRouter> messageRouter, Provider<Acceptor> acceptor, Provider<QueryUnicaster> queryUnicaster, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, ConnectionServices connectionServices, MessageFactory messageFactory, PingRequestFactory pingRequestFactory, NetworkInstanceUtils networkInstanceUtils, AsynchronousEventBroadcaster<FirewallTransferStatusEvent> fwtStatusBroadcaster, ListenerSupport<UDPSocketChannelConnectionEvent> channelEventListenerSupport) {
        this.networkManager = networkManager;
        this.messageDispatcher = messageDispatcher;
        this.ipFilter = ipFilter;
        this.connectionManager = connectionManager;
        this.messageRouter = messageRouter;
        this.acceptor = acceptor;
        this.queryUnicaster = queryUnicaster;
        this.backgroundExecutor = backgroundExecutor;
        this.connectionServices = connectionServices;
        this.messageFactory = messageFactory;
        this.pingRequestFactory = pingRequestFactory;
        this.networkInstanceUtils = networkInstanceUtils;
        this.fwtStatusBroadcaster = fwtStatusBroadcaster;
        this.OUTGOING_MSGS = new LinkedList<SendBundle>();
        byte[] backing = new byte[2048];
        this.BUFFER = ByteBuffer.wrap(backing);
        fwtStatusBroadcaster.broadcast(new FirewallTransferStatusEvent(FirewallTransferStatus.DOES_NOT_SUPPORT_FWT, FWTStatusReason.UNKNOWN));
        channelEventListenerSupport.addListener(new UDPConnectionListener());
    }

    protected void scheduleServices() {
        this.backgroundExecutor.scheduleWithFixedDelay(new IncomingValidator(), this.acceptor.get().getTimeBetweenValidates(), this.acceptor.get().getTimeBetweenValidates(), TimeUnit.MILLISECONDS);
        this.backgroundExecutor.scheduleWithFixedDelay(new PeriodicPinger(), 0L, 85000L, TimeUnit.MILLISECONDS);
    }

    public GUID getConnectBackGUID() {
        return this.CONNECT_BACK_GUID;
    }

    public GUID getSolicitedGUID() {
        return this.SOLICITED_PING_GUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        DatagramChannel channel;
        if (!this._started) {
            this.scheduleServices();
        }
        UDPService uDPService = this;
        synchronized (uDPService) {
            this._started = true;
            channel = this._channel;
        }
        if (channel != null) {
            NIODispatcher.instance().registerReadWrite(channel, this);
        }
    }

    public DatagramSocket newListeningSocket(int port) throws IOException {
        try {
            DatagramChannel channel = DatagramChannel.open();
            channel.configureBlocking(false);
            DatagramSocket s = channel.socket();
            s.setReceiveBufferSize(65536);
            s.setSendBufferSize(65536);
            s.bind(new InetSocketAddress(port));
            return s;
        }
        catch (SecurityException se) {
            throw new IOException("security exception on port: " + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListeningSocket(DatagramSocket datagramSocket) {
        if (this._channel != null) {
            try {
                LOG.debug("Closing socket");
                this._channel.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        if (datagramSocket != null) {
            boolean wasStarted;
            UDPService uDPService = this;
            synchronized (uDPService) {
                this._channel = datagramSocket.getChannel();
                if (this._channel == null) {
                    throw new IllegalArgumentException("No channel!");
                }
                wasStarted = this._started;
                this._lastReportedPort = this._channel.socket().getLocalPort();
                this._successfulFWT = false;
            }
            if (wasStarted) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getListeningPort() {
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (this._channel != null) {
                return this._channel.socket().getLocalPort();
            }
            return -1;
        }
    }

    @Override
    public void shutdown() {
        this.setListeningSocket(null);
    }

    @Override
    public void handleRead() throws IOException {
        block8: while (true) {
            try {
                while (true) {
                    SocketAddress from;
                    this.BUFFER.clear();
                    try {
                        from = this._channel.receive(this.BUFFER);
                    }
                    catch (IOException iox) {
                        break block8;
                    }
                    catch (Error error) {
                        break block8;
                    }
                    if (from == null) break block8;
                    if (!(from instanceof InetSocketAddress)) {
                        ErrorService.error(new RuntimeException("non-inet SocketAddress: " + from));
                        continue;
                    }
                    InetSocketAddress addr = (InetSocketAddress)from;
                    if (!NetworkUtils.isValidAddress(addr.getAddress()) || !NetworkUtils.isValidPort(addr.getPort())) continue;
                    if (!this.ipFilter.get().allow(addr.getAddress().getAddress())) {
                        LOG.debug("Received packet from hostile host");
                        return;
                    }
                    byte[] data = this.BUFFER.array();
                    int length = this.BUFFER.position();
                    try {
                        ByteArrayInputStream in = new ByteArrayInputStream(data, 0, length);
                        Message message = this.messageFactory.read((InputStream)in, Message.Network.UDP, IN_HEADER_BUF, addr);
                        if (message == null) {
                            LOG.debug("Received a null message");
                            continue;
                        }
                        this.processMessage(message, addr);
                        continue block8;
                    }
                    catch (IOException e) {
                        LOG.debug("Could not parse message", e);
                        continue;
                    }
                    catch (BadPacketException e) {
                        LOG.debug("Could not parse message", e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
                break;
            }
        }
    }

    @Override
    public void handleIOException(IOException iox) {
        if (!(iox instanceof ClosedChannelException)) {
            ErrorService.error(iox, "UDP Error.");
        } else {
            LOG.debug("Swallowing a UDPService ClosedChannelException", iox);
        }
    }

    void processMessage(Message message, InetSocketAddress addr) {
        if (!this.ipFilter.get().allow(message)) {
            LOG.debug("Received packet from hostile host");
            return;
        }
        if (message instanceof PingReply) {
            UDPService.mutateGUID(message.getGUID(), addr.getAddress(), addr.getPort());
        }
        this.updateState(message, addr);
        this.messageDispatcher.get().dispatchUDP(message, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(Message message, InetSocketAddress addr) {
        this._lastReceivedAny = System.currentTimeMillis();
        if (this.isValidForIncoming(addr)) {
            if (!this._acceptedSolicitedIncoming) {
                LOG.info("Can receive solicited UDP");
            }
            this._acceptedSolicitedIncoming = true;
        }
        if (!this.isGUESSCapable()) {
            if (message instanceof PingRequest) {
                GUID guid = new GUID(message.getGUID());
                if (this.CONNECT_BACK_GUID.equals(guid) && this.isValidForIncoming(addr)) {
                    UDPService uDPService = this;
                    synchronized (uDPService) {
                        if (!this._acceptedUnsolicitedIncoming) {
                            LOG.info("Can receive unsolicited UDP");
                        }
                        this._acceptedUnsolicitedIncoming = true;
                        this._lastReportedPort = this.networkManager.getPort();
                        ConnectionSettings.HAS_STABLE_PORT.setValue(true);
                    }
                    this.updateFWTState();
                }
                this._lastUnsolicitedIncomingTime = this._lastReceivedAny;
            } else if (message instanceof PingReply) {
                GUID guid = new GUID(message.getGUID());
                if (!this.SOLICITED_PING_GUID.equals(guid) || !this.isValidForIncoming(addr)) {
                    return;
                }
                PingReply r = (PingReply)message;
                if (r.getMyPort() != 0) {
                    UDPService uDPService = this;
                    synchronized (uDPService) {
                        ++this._numReceivedIPPongs;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Received IP pong from " + r.getAddress() + ":" + r.getPort() + " reporting " + r.getMyInetAddress().getHostAddress() + ":" + r.getMyPort());
                        }
                        if (this._numReceivedIPPongs > 1 && this._lastReportedClassC != NetworkUtils.getClassC(r.getInetAddress())) {
                            if (this._lastReportedPort == r.getMyPort()) {
                                ConnectionSettings.HAS_STABLE_PORT.setValue(true);
                            } else {
                                ConnectionSettings.HAS_STABLE_PORT.setValue(false);
                            }
                        }
                        this._lastReportedPort = r.getMyPort();
                        this._lastReportedClassC = NetworkUtils.getClassC(r.getInetAddress());
                    }
                    this.updateFWTState();
                }
            }
        }
        if (message instanceof ReplyNumberVendorMessage) {
            this._lastUnsolicitedIncomingTime = this._lastReceivedAny;
        }
    }

    public static void mutateGUID(byte[] guid, InetAddress ip, int port) {
        byte[] qk = PING_GENERATOR.getMACBytes(new AddressSecurityToken.AddressTokenData(ip, port));
        for (int i = 0; i < qk.length; ++i) {
            guid[i] = (byte)(guid[i] ^ qk[i]);
        }
    }

    private boolean isValidForIncoming(InetSocketAddress addr) {
        String host = addr.getAddress().getHostAddress();
        return !this.connectionManager.get().isConnectedTo(host) && !this.networkInstanceUtils.isPrivateAddress(addr.getAddress());
    }

    public void send(Message msg, IpPort host) {
        this.send(msg, host.getInetSocketAddress());
    }

    public void send(Message msg, InetAddress ip, int port) {
        this.send(msg, new InetSocketAddress(ip, port));
    }

    public void send(Message msg, InetSocketAddress addr) {
        if (msg == null) {
            throw new IllegalArgumentException("Null Message");
        }
        if (!NetworkUtils.isValidSocketAddress(addr)) {
            throw new IllegalArgumentException("Invalid addr: " + addr);
        }
        if (this._channel == null || this._channel.socket().isClosed()) {
            LOG.debug("Socket not ready for writing");
            return;
        }
        int length = msg.getTotalLength();
        ByteBuffer buffer = NIODispatcher.instance().getBufferCache().getHeap(length);
        if (buffer.remaining() != length) {
            throw new IllegalStateException("retrieved a buffer with wrong remaining! wanted: " + length + ", had: " + buffer.remaining() + ", position: " + buffer.position() + ", limit: " + buffer.limit());
        }
        ByteBufferOutputStream baos = new ByteBufferOutputStream(buffer);
        try {
            msg.writeQuickly(baos);
        }
        catch (IOException e) {
            ErrorService.error(e);
            return;
        }
        buffer.flip();
        if (msg instanceof PingRequest) {
            UDPService.mutateGUID(buffer.array(), addr.getAddress(), addr.getPort());
        }
        this.sentMessageCounter.countMessage(msg);
        this.send(buffer, addr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBuffer buffer, InetSocketAddress addr, boolean custom) {
        List<SendBundle> list = this.OUTGOING_MSGS;
        synchronized (list) {
            this.OUTGOING_MSGS.add(new SendBundle(buffer, addr, custom));
            if (this._channel != null) {
                NIODispatcher.instance().interestWrite(this._channel, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleWrite() throws IOException {
        try {
            var1_1 = this.OUTGOING_MSGS;
            synchronized (var1_1) {
                while (true) lbl-1000:
                // 5 sources

                {
                    if (this.OUTGOING_MSGS.isEmpty()) {
                        NIODispatcher.instance().interestWrite(this._channel, false);
                        return false;
                    }
                    releaseBuffer = true;
                    bundle = this.OUTGOING_MSGS.remove(0);
                    try {
                        if (this._channel.send(SendBundle.access$200(bundle), SendBundle.access$300(bundle)) != 0) ** GOTO lbl-1000
                        this.OUTGOING_MSGS.add(0, bundle);
                        releaseBuffer = false;
                        var4_6 = true;
                        return var4_6;
                    }
                    catch (IOException ignored) {
                        UDPService.LOG.warn("Ignoring exception on socket", ignored);
                    }
                    finally {
                        if (SendBundle.access$400(bundle)) {
                            SendBundle.access$200(bundle).rewind();
                            releaseBuffer = false;
                        }
                        if (!releaseBuffer) ** GOTO lbl-1000
                        NIODispatcher.instance().getBufferCache().release(SendBundle.access$200(bundle));
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
            return true;
        }
        ** GOTO lbl-1000
    }

    public boolean isGUESSCapable() {
        return this.canReceiveUnsolicited() && this.canReceiveSolicited();
    }

    public boolean canReceiveUnsolicited() {
        return this._acceptedUnsolicitedIncoming;
    }

    public boolean canReceiveSolicited() {
        return this._acceptedSolicitedIncoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDoFWT() {
        boolean retValue = false;
        if (!this.canReceiveSolicited()) {
            this.fwtStatusBroadcaster.broadcast(new FirewallTransferStatusEvent(FirewallTransferStatus.DOES_NOT_SUPPORT_FWT, FWTStatusReason.NO_SOLICITED_INCOMING_MESSAGES));
            retValue = false;
        } else {
            boolean canDoFWTSetting;
            boolean bl = canDoFWTSetting = !ConnectionSettings.CANNOT_DO_FWT.getValue();
            if (!this.connectionServices.isConnected()) {
                if (canDoFWTSetting) {
                    this.fwtStatusBroadcaster.broadcast(new FirewallTransferStatusEvent(FirewallTransferStatus.SUPPORTS_FWT, FWTStatusReason.REUSING_STATUS_FROM_PREVIOUS_SESSION));
                } else {
                    this.fwtStatusBroadcaster.broadcast(new FirewallTransferStatusEvent(FirewallTransferStatus.DOES_NOT_SUPPORT_FWT, FWTStatusReason.REUSING_STATUS_FROM_PREVIOUS_SESSION));
                }
                retValue = canDoFWTSetting;
            } else {
                boolean needToUpdateState;
                UDPService uDPService = this;
                synchronized (uDPService) {
                    if (this._numReceivedIPPongs < 1) {
                        if (canDoFWTSetting) {
                            this.fwtStatusBroadcaster.broadcast(new FirewallTransferStatusEvent(FirewallTransferStatus.SUPPORTS_FWT, FWTStatusReason.REUSING_STATUS_FROM_PREVIOUS_SESSION));
                        } else {
                            this.fwtStatusBroadcaster.broadcast(new FirewallTransferStatusEvent(FirewallTransferStatus.DOES_NOT_SUPPORT_FWT, FWTStatusReason.REUSING_STATUS_FROM_PREVIOUS_SESSION));
                        }
                        needToUpdateState = false;
                        retValue = canDoFWTSetting;
                    } else {
                        needToUpdateState = true;
                    }
                }
                if (needToUpdateState) {
                    this.updateFWTState();
                    retValue = !ConnectionSettings.CANNOT_DO_FWT.getValue();
                }
            }
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFWTState() {
        boolean newFWTSetting = true;
        FWTStatusReason reason = FWTStatusReason.UNKNOWN;
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("stable port " + ConnectionSettings.HAS_STABLE_PORT.getValue() + " last reported port " + this._lastReportedPort + " our external port " + this.networkManager.getPort() + " our non-forced port " + this.acceptor.get().getPort(false) + " number of received IP pongs " + this._numReceivedIPPongs + " valid external addr " + NetworkUtils.isValidAddress(this.networkManager.getExternalAddress()));
            }
            if (this._successfulFWT || this._acceptedUnsolicitedIncoming) {
                newFWTSetting = true;
            } else {
                if (!NetworkUtils.isValidAddress(this.networkManager.getExternalAddress())) {
                    reason = FWTStatusReason.INVALID_EXTERNAL_ADDRESS;
                    newFWTSetting = false;
                }
                boolean stablePort = ConnectionSettings.HAS_STABLE_PORT.getValue();
                boolean bl = newFWTSetting = newFWTSetting && stablePort;
                if (!stablePort) {
                    reason = this._numReceivedIPPongs < 2 ? FWTStatusReason.REUSING_STATUS_FROM_PREVIOUS_SESSION : FWTStatusReason.PORT_UNSTABLE;
                }
                if (this._numReceivedIPPongs == 1) {
                    newFWTSetting = newFWTSetting && (this._lastReportedPort == this.acceptor.get().getPort(false) || this._lastReportedPort == this.networkManager.getPort());
                }
            }
        }
        if (newFWTSetting) {
            this.fwtStatusBroadcaster.broadcast(new FirewallTransferStatusEvent(FirewallTransferStatus.SUPPORTS_FWT, FWTStatusReason.UNKNOWN));
        } else {
            this.fwtStatusBroadcaster.broadcast(new FirewallTransferStatusEvent(FirewallTransferStatus.DOES_NOT_SUPPORT_FWT, reason));
        }
        ConnectionSettings.CANNOT_DO_FWT.setValue(!newFWTSetting);
    }

    public boolean portStable() {
        return ConnectionSettings.HAS_STABLE_PORT.getValue();
    }

    public int receivedIpPong() {
        return this._numReceivedIPPongs;
    }

    public int lastReportedPort() {
        return this._lastReportedPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStableUDPPort() {
        int localPort = this.acceptor.get().getPort(false);
        int forcedPort = this.networkManager.getPort();
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (ConnectionSettings.HAS_STABLE_PORT.getValue() && this._numReceivedIPPongs > 1) {
                return this._lastReportedPort;
            }
            if (this._numReceivedIPPongs == 1 && (localPort == this._lastReportedPort || forcedPort == this._lastReportedPort)) {
                return this._lastReportedPort;
            }
        }
        return forcedPort;
    }

    public void setReceiveSolicited(boolean value) {
        this._acceptedSolicitedIncoming = value;
    }

    public long getLastReceivedTime() {
        return this._lastReceivedAny;
    }

    public boolean isListening() {
        DatagramChannel channel = this._channel;
        if (channel == null) {
            return false;
        }
        return channel.socket().getLocalPort() != -1;
    }

    public String toString() {
        return "UDPService::channel: " + this._channel;
    }

    private class UDPConnectionListener
    implements EventListener<UDPSocketChannelConnectionEvent> {
        private UDPConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(UDPSocketChannelConnectionEvent event) {
            if (event.getType() == ConnectionState.CONNECTED && !UDPService.this._successfulFWT) {
                UDPConnectionListener uDPConnectionListener = this;
                synchronized (uDPConnectionListener) {
                    UDPService.this._successfulFWT = true;
                    UDPService.this._lastReportedPort = ((UDPSocketChannel)event.getData()).socket().getLocalPort();
                    ConnectionSettings.HAS_STABLE_PORT.setValue(true);
                }
                UDPService.this.updateFWTState();
            }
        }
    }

    private class PeriodicPinger
    implements Runnable {
        private PeriodicPinger() {
        }

        @Override
        public void run() {
            GUESSEndpoint ep = ((QueryUnicaster)UDPService.this.queryUnicaster.get()).getUnicastEndpoint();
            if (ep == null) {
                return;
            }
            if (!UDPService.this.canReceiveSolicited() && !UDPService.this.canReceiveUnsolicited()) {
                return;
            }
            byte[] guid = UDPService.this.getSolicitedGUID().bytes();
            PingRequest pr = UDPService.this.pingRequestFactory.createPingRequest(guid, (byte)1, (byte)0);
            pr.addIPRequest();
            UDPService.this.send(pr, ep.getInetAddress(), ep.getPort());
        }
    }

    private class IncomingValidator
    implements Runnable {
        @Override
        public void run() {
            final long currTime = System.currentTimeMillis();
            if (UDPService.this._acceptedUnsolicitedIncoming && currTime - UDPService.this._lastUnsolicitedIncomingTime > ((Acceptor)UDPService.this.acceptor.get()).getIncomingExpireTime() || !UDPService.this._acceptedUnsolicitedIncoming && currTime - UDPService.this._lastConnectBackTime > ((Acceptor)UDPService.this.acceptor.get()).getIncomingExpireTime()) {
                final GUID cbGuid = new GUID(GUID.makeGuid());
                final MLImpl ml = new MLImpl();
                ((MessageRouter)UDPService.this.messageRouter.get()).registerMessageListener(cbGuid.bytes(), ml);
                if (((ConnectionManager)UDPService.this.connectionManager.get()).sendUDPConnectBackRequests(cbGuid)) {
                    UDPService.this._lastConnectBackTime = System.currentTimeMillis();
                    Runnable checkThread = new Runnable(){

                        @Override
                        public void run() {
                            if (UDPService.this._acceptedUnsolicitedIncoming && UDPService.this._lastUnsolicitedIncomingTime < currTime || !UDPService.this._acceptedUnsolicitedIncoming) {
                                if (ml._gotIncoming && !UDPService.this._acceptedUnsolicitedIncoming) {
                                    LOG.info("Can receive unsolicited UDP");
                                }
                                UDPService.this._acceptedUnsolicitedIncoming = ml._gotIncoming;
                            }
                            ((MessageRouter)UDPService.this.messageRouter.get()).unregisterMessageListener(cbGuid.bytes(), ml);
                        }
                    };
                    UDPService.this.backgroundExecutor.schedule(checkThread, ((Acceptor)UDPService.this.acceptor.get()).getWaitTimeAfterRequests(), TimeUnit.MILLISECONDS);
                } else {
                    ((MessageRouter)UDPService.this.messageRouter.get()).unregisterMessageListener(cbGuid.bytes(), ml);
                }
            }
        }
    }

    private static class MLImpl
    implements MessageListener {
        public boolean _gotIncoming = false;

        private MLImpl() {
        }

        @Override
        public void processMessage(Message m, ReplyHandler handler) {
            if (m instanceof PingRequest) {
                this._gotIncoming = true;
            }
        }

        @Override
        public void registered(byte[] guid) {
        }

        @Override
        public void unregistered(byte[] guid) {
        }
    }

    private static class SendBundle {
        private final ByteBuffer buffer;
        private final SocketAddress addr;
        private final boolean custom;

        SendBundle(ByteBuffer b, InetSocketAddress addr, boolean custom) {
            this.buffer = b;
            this.addr = addr;
            this.custom = custom;
        }

        static /* synthetic */ ByteBuffer access$200(SendBundle x0) {
            return x0.buffer;
        }

        static /* synthetic */ SocketAddress access$300(SendBundle x0) {
            return x0.addr;
        }

        static /* synthetic */ boolean access$400(SendBundle x0) {
            return x0.custom;
        }
    }
}

