/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.UploadServices;
import com.limegroup.gnutella.uploader.UploadSlotManager;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.core.settings.UploadSettings;

@Singleton
public class UploadServicesImpl
implements UploadServices {
    private final Provider<UploadManager> uploadManager;
    private final Provider<UploadSlotManager> uploadSlotManager;
    private final Provider<ConnectionManager> connectionManager;

    @Inject
    public UploadServicesImpl(Provider<UploadManager> uploadManager, Provider<UploadSlotManager> uploadSlotManager, Provider<ConnectionManager> connectionManager, Provider<TorrentManager> torrentManager) {
        this.uploadManager = uploadManager;
        this.uploadSlotManager = uploadSlotManager;
        this.connectionManager = connectionManager;
    }

    @Override
    public boolean hasActiveUploads() {
        this.uploadSlotManager.get().measureBandwidth();
        try {
            return this.uploadSlotManager.get().getMeasuredBandwidth() > 0.0f;
        }
        catch (InsufficientDataException insufficientDataException) {
            return false;
        }
    }

    @Override
    public float getRequestedUploadSpeed() {
        if (!UploadSettings.LIMIT_MAX_UPLOAD_SPEED.getValue()) {
            return Float.MAX_VALUE;
        }
        int uSpeed = UploadSettings.MAX_UPLOAD_SPEED.getValue();
        uSpeed = (int)((float)uSpeed - this.connectionManager.get().getMeasuredUpstreamBandwidth() * 1024.0f);
        return Math.max((float)uSpeed, 1024.0f);
    }

    @Override
    public int getNumUploads() {
        return this.uploadManager.get().uploadsInProgress();
    }

    @Override
    public int getNumQueuedUploads() {
        return this.uploadManager.get().getNumQueuedUploads();
    }
}

