/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.URN;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class UrnSet
implements Set<URN>,
Iterable<URN>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1065284624401321676L;
    private URN sha1;
    private URN ttroot;
    private URN nms1;

    public static UrnSet resolve(Set<? extends URN> set) {
        if (set instanceof UnmodifiableUrnSet || set instanceof UrnSet) {
            return (UrnSet)set;
        }
        return new UrnSet(set);
    }

    public static UrnSet modifiableSet(Set<? extends URN> set) {
        if (set instanceof UnmodifiableUrnSet) {
            UrnSet urnSet = (UrnSet)set;
            return new UrnSet(urnSet.getSHA1(), urnSet.getTTRoot(), urnSet.getNMS1());
        }
        if (set instanceof UrnSet) {
            return (UrnSet)set;
        }
        return new UrnSet(set);
    }

    public static UrnSet unmodifiableSet(Set<? extends URN> set) {
        if (set instanceof UnmodifiableUrnSet) {
            return (UrnSet)set;
        }
        return new UnmodifiableUrnSet(set);
    }

    public UrnSet() {
    }

    public UrnSet(URN urn) {
        this.add(urn);
    }

    public UrnSet(Collection<? extends URN> c) {
        this.addAll(c);
    }

    private UrnSet(URN sha1, URN ttroot, URN nms1) {
        this.sha1 = sha1;
        this.ttroot = ttroot;
        this.nms1 = nms1;
    }

    public String toString() {
        return this.isEmpty() ? "{Empty UrnSet}" : "UrnSet of: " + this.sha1;
    }

    public UrnSet clone() {
        return new UrnSet(this.sha1, this.ttroot, this.nms1);
    }

    @Override
    public int hashCode() {
        return this.sha1 == null ? 0 : this.sha1.hashCode();
    }

    public URN getSHA1() {
        return this.sha1;
    }

    public URN getTTRoot() {
        return this.ttroot;
    }

    public URN getNMS1() {
        return this.nms1;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection c = (Collection)o;
        if (c.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(c);
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public boolean add(URN o) {
        return this.addInternal(o);
    }

    protected boolean addInternal(URN o) {
        if (o.isSHA1() && this.sha1 == null) {
            this.sha1 = o;
            return true;
        }
        if (o.isTTRoot() && this.ttroot == null) {
            this.ttroot = o;
            return true;
        }
        if (o.isNMS1() && this.nms1 == null) {
            this.nms1 = o;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends URN> c) {
        return this.addAllInternal(c);
    }

    protected boolean addAllInternal(Collection<? extends URN> c) {
        boolean ret = false;
        for (URN uRN : c) {
            ret |= this.addInternal(uRN);
        }
        return ret;
    }

    @Override
    public void clear() {
        this.sha1 = null;
        this.ttroot = null;
        this.nms1 = null;
    }

    @Override
    public boolean contains(Object o) {
        return o.equals(this.sha1) || o.equals(this.ttroot) || o.equals(this.nms1);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.size() > 3) {
            return false;
        }
        if (c.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean ret = true;
        for (Object o : c) {
            ret &= this.contains(o);
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.sha1 == null && this.ttroot == null && this.nms1 == null;
    }

    @Override
    public Iterator<URN> iterator() {
        return new UrnIterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.sha1 != null && o.equals(this.sha1)) {
            this.sha1 = null;
            return true;
        }
        if (this.ttroot != null && o.equals(this.ttroot)) {
            this.ttroot = null;
            return true;
        }
        if (this.nms1 != null && o.equals(this.nms1)) {
            this.nms1 = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.sha1 == null && this.ttroot == null && this.nms1 == null || c.isEmpty()) {
            return false;
        }
        boolean ret = false;
        for (Object o : c) {
            ret |= this.remove(o);
            if (!this.isEmpty()) continue;
            break;
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = false;
        if (this.sha1 != null && !c.contains(this.sha1)) {
            this.sha1 = null;
            ret = true;
        }
        if (this.ttroot != null && !c.contains(this.ttroot)) {
            this.ttroot = null;
            ret = true;
        }
        if (this.nms1 != null && !c.contains(this.nms1)) {
            this.nms1 = null;
            ret = true;
        }
        return ret;
    }

    @Override
    public int size() {
        int ret = 0;
        if (this.sha1 != null) {
            ++ret;
        }
        if (this.ttroot != null) {
            ++ret;
        }
        if (this.nms1 != null) {
            ++ret;
        }
        return ret;
    }

    @Override
    public Object[] toArray() {
        switch (this.size()) {
            case 0: {
                return new Object[0];
            }
            case 1: {
                if (this.sha1 != null) {
                    return new Object[]{this.sha1};
                }
                if (this.ttroot != null) {
                    return new Object[]{this.ttroot};
                }
                return new Object[]{this.nms1};
            }
            case 2: {
                if (this.sha1 != null && this.ttroot != null) {
                    return new Object[]{this.sha1, this.ttroot};
                }
                if (this.sha1 != null) {
                    return new Object[]{this.sha1, this.nms1};
                }
                return new Object[]{this.ttroot, this.nms1};
            }
            case 3: {
                return new Object[]{this.sha1, this.ttroot, this.nms1};
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        switch (size) {
            case 1: {
                if (this.sha1 != null) {
                    a[0] = this.sha1;
                    break;
                }
                if (this.ttroot != null) {
                    a[0] = this.ttroot;
                    break;
                }
                a[0] = this.nms1;
                break;
            }
            case 2: {
                if (this.sha1 != null && this.ttroot != null) {
                    a[0] = this.sha1;
                    a[1] = this.ttroot;
                    break;
                }
                if (this.sha1 != null) {
                    a[0] = this.sha1;
                    a[1] = this.nms1;
                    break;
                }
                a[0] = this.ttroot;
                a[1] = this.nms1;
                break;
            }
            case 3: {
                a[0] = this.sha1;
                a[1] = this.ttroot;
                a[2] = this.nms1;
            }
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public static URN getSha1(Set<? extends URN> urns) {
        if (urns instanceof UrnSet) {
            return ((UrnSet)urns).sha1;
        }
        for (URN uRN : urns) {
            if (!uRN.isSHA1()) continue;
            return uRN;
        }
        return null;
    }

    public static URN getNMS1(Set<? extends URN> urns) {
        if (urns instanceof UrnSet) {
            return ((UrnSet)urns).nms1;
        }
        for (URN uRN : urns) {
            if (!uRN.isNMS1()) continue;
            return uRN;
        }
        return null;
    }

    private static class UnmodifiableUrnSet
    extends UrnSet {
        public UnmodifiableUrnSet(Set<? extends URN> set) {
            super.addAll((Collection<? extends URN>)set);
        }

        private UnmodifiableUrnSet(URN sha1, URN ttroot, URN nms1) {
            super(sha1, ttroot, nms1);
        }

        @Override
        public boolean add(URN o) {
            throw new UnsupportedOperationException("Can't modify an UnmodifiableUrnSet");
        }

        @Override
        public boolean addAll(Collection<? extends URN> c) {
            throw new UnsupportedOperationException("Can't modify an UnmodifiableUrnSet");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Can't modify an UnmodifiableUrnSet");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Can't modify an UnmodifiableUrnSet");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Can't modify an UnmodifiableUrnSet");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Can't modify an UnmodifiableUrnSet");
        }

        @Override
        public Iterator<URN> iterator() {
            final Iterator<URN> oldIterator = super.iterator();
            return new Iterator<URN>(){

                @Override
                public boolean hasNext() {
                    return oldIterator.hasNext();
                }

                @Override
                public URN next() {
                    return (URN)oldIterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Can't modify an UnmodifiableUrnSet");
                }
            };
        }

        @Override
        public UrnSet clone() {
            return new UnmodifiableUrnSet(this.getSHA1(), this.getTTRoot(), this.getNMS1());
        }
    }

    private class UrnIterator
    implements Iterator<URN> {
        private boolean givenSHA1;
        private boolean givenTTRoot;
        private boolean givenNMS1;

        private UrnIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.givenSHA1 && UrnSet.this.sha1 != null || !this.givenTTRoot && UrnSet.this.ttroot != null || !this.givenNMS1 && UrnSet.this.nms1 != null;
        }

        @Override
        public URN next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.givenSHA1 && UrnSet.this.sha1 != null) {
                this.givenSHA1 = true;
                return UrnSet.this.sha1;
            }
            if (!this.givenTTRoot && UrnSet.this.ttroot != null) {
                this.givenTTRoot = true;
                return UrnSet.this.ttroot;
            }
            if (!this.givenNMS1 && UrnSet.this.nms1 != null) {
                this.givenNMS1 = true;
                return UrnSet.this.nms1;
            }
            throw new IllegalStateException();
        }

        @Override
        public void remove() {
            if (!(this.givenSHA1 || this.givenTTRoot || this.givenNMS1)) {
                throw new IllegalStateException();
            }
            if (this.givenNMS1) {
                UrnSet.this.nms1 = null;
            } else if (this.givenTTRoot) {
                UrnSet.this.ttroot = null;
            } else if (this.givenSHA1) {
                UrnSet.this.sha1 = null;
            }
        }
    }
}

