/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UniqueHostPinger;
import com.limegroup.gnutella.bootstrap.UDPHostCache;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Cancellable;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.net.address.StrictIpPortSet;

@Singleton
class UDPHostCacheImpl
implements UDPHostCache {
    private static final Log LOG = LogFactory.getLog(UDPHostCacheImpl.class);
    private static final int MAXIMUM_FAILURES = 5;
    public static final int PERMANENT_SIZE = 100;
    public static final int FETCH_AMOUNT = 5;
    public static final int EXPIRY_TIME = 600000;
    private final List<ExtendedEndpoint> udpHosts = new ArrayList<ExtendedEndpoint>(100);
    private final Set<ExtendedEndpoint> udpHostsSet = new HashSet<ExtendedEndpoint>();
    private final UniqueHostPinger pinger;
    private final Set<ExtendedEndpoint> attemptedHosts;
    private boolean dirty = false;
    private boolean writeDirty = false;
    private final Provider<MessageRouter> messageRouter;
    private final PingRequestFactory pingRequestFactory;
    private final ConnectionServices connectionServices;
    private final NetworkInstanceUtils networkInstanceUtils;
    private static final Comparator<ExtendedEndpoint> FAILURE_COMPARATOR = new FailureComparator();

    @Inject
    protected UDPHostCacheImpl(UniqueHostPinger pinger, Provider<MessageRouter> messageRouter, PingRequestFactory pingRequestFactory, ConnectionServices connectionServices, NetworkInstanceUtils networkInstanceUtils) {
        this(600000, pinger, messageRouter, pingRequestFactory, connectionServices, networkInstanceUtils);
    }

    UDPHostCacheImpl(int expiryTime, UniqueHostPinger pinger, Provider<MessageRouter> messageRouter, PingRequestFactory pingRequestFactory, ConnectionServices connectionServices, NetworkInstanceUtils networkInstanceUtils) {
        this.connectionServices = connectionServices;
        this.attemptedHosts = new FixedSizeExpiringSet<ExtendedEndpoint>(100, expiryTime);
        this.pinger = pinger;
        this.messageRouter = messageRouter;
        this.pingRequestFactory = pingRequestFactory;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public synchronized void write(Writer out) throws IOException {
        for (ExtendedEndpoint e : this.udpHosts) {
            e.write(out);
        }
        this.writeDirty = false;
    }

    @Override
    public synchronized boolean isWriteDirty() {
        return this.writeDirty;
    }

    @Override
    public synchronized int getSize() {
        return this.udpHostsSet.size();
    }

    @Override
    public synchronized void resetData() {
        this.udpHosts.clear();
        this.udpHostsSet.clear();
        this.attemptedHosts.clear();
        this.dirty = false;
        this.writeDirty = false;
    }

    @Override
    public synchronized boolean fetchHosts() {
        if (this.dirty) {
            LOG.trace("Shuffling and sorting UHCs");
            Collections.shuffle(this.udpHosts);
            Collections.sort(this.udpHosts, FAILURE_COMPARATOR);
            this.dirty = false;
        }
        ArrayList<ExtendedEndpoint> validHosts = new ArrayList<ExtendedEndpoint>(Math.min(5, this.udpHosts.size()));
        LinkedList<ExtendedEndpoint> invalidHosts = new LinkedList<ExtendedEndpoint>();
        for (ExtendedEndpoint next : this.udpHosts) {
            if (validHosts.size() >= 5) break;
            if (this.attemptedHosts.contains(next)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Already attempted " + next);
                continue;
            }
            if (!this.networkInstanceUtils.isValidExternalIpPort(next)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Invalid address for " + next);
                }
                invalidHosts.add(next);
                continue;
            }
            validHosts.add(next);
        }
        for (ExtendedEndpoint next : invalidHosts) {
            this.remove(next);
        }
        this.attemptedHosts.addAll(validHosts);
        return this.fetch(validHosts);
    }

    protected boolean fetch(Collection<? extends ExtendedEndpoint> hosts) {
        if (hosts.isEmpty()) {
            LOG.info("No UHCs to try");
            return false;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Pinging UHCs " + hosts);
        }
        this.pinger.rank(hosts, new HostExpirer(hosts), new Cancellable(){

            @Override
            public boolean isCancelled() {
                return UDPHostCacheImpl.this.connectionServices.isConnected();
            }
        }, this.getPing());
        return true;
    }

    protected PingRequest getPing() {
        return this.pingRequestFactory.createUHCPing();
    }

    protected synchronized boolean remove(ExtendedEndpoint e) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Removing UHC " + e);
        }
        boolean removed1 = this.udpHosts.remove(e);
        boolean removed2 = this.udpHostsSet.remove(e);
        assert (removed1 == removed2) : "Set " + removed1 + " but queue " + removed2;
        if (removed1) {
            this.writeDirty = true;
        }
        return removed1;
    }

    @Override
    public synchronized boolean add(ExtendedEndpoint e) {
        assert (e.isUDPHostCache());
        if (this.udpHostsSet.contains(e)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Not adding known UHC " + e);
            }
            return false;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Adding UHC " + e);
        }
        if (this.udpHosts.size() >= 100) {
            ExtendedEndpoint removed = this.udpHosts.remove(this.udpHosts.size() - 1);
            this.udpHostsSet.remove(removed);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ejected UHC " + removed);
            }
        }
        this.udpHosts.add(e);
        this.udpHostsSet.add(e);
        this.dirty = true;
        this.writeDirty = true;
        return true;
    }

    @Override
    public void loadDefaults() {
        this.createAndAdd("uhc2.limewire.com", 20181);
        this.createAndAdd("uhc3.limewire.com", 51180);
        this.createAndAdd("uhc.udp-host-cache.com", 9999);
        this.createAndAdd("secondary.udp-host-cache.com", 9999);
        this.createAndAdd("tertiary.udp-host-cache.com", 9999);
        this.createAndAdd("leet.gtkg.org", 1337);
        this.createAndAdd("sissy.gtkg.org", 51557);
        this.createAndAdd("ein.gtkg.net", 60666);
        this.createAndAdd("zwei.gtkg.net", 61666);
        this.createAndAdd("drei.gtkg.net", 62666);
    }

    private void createAndAdd(String host, int port) {
        try {
            this.add(new ExtendedEndpoint(host, port, false).setUDPHostCache(true));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static class FailureComparator
    implements Comparator<ExtendedEndpoint> {
        private FailureComparator() {
        }

        @Override
        public int compare(ExtendedEndpoint e1, ExtendedEndpoint e2) {
            return e1.getUDPHostCacheFailures() - e2.getUDPHostCacheFailures();
        }
    }

    private class HostExpirer
    implements MessageListener {
        private final Set<ExtendedEndpoint> hosts = new StrictIpPortSet<ExtendedEndpoint>();
        private final Set<ExtendedEndpoint> allHosts;
        private byte[] guid;

        public HostExpirer(Collection<? extends ExtendedEndpoint> hostsToAdd) {
            this.hosts.addAll(hostsToAdd);
            this.allHosts = new HashSet<ExtendedEndpoint>(hostsToAdd);
            this.removeDuplicates(hostsToAdd, this.hosts);
        }

        private void removeDuplicates(Collection<? extends ExtendedEndpoint> all, Collection<? extends ExtendedEndpoint> some) {
            HashSet<? extends ExtendedEndpoint> duplicates = new HashSet<ExtendedEndpoint>(all);
            duplicates.removeAll(some);
            for (ExtendedEndpoint extendedEndpoint : duplicates) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Removing duplicate entry " + extendedEndpoint);
                }
                UDPHostCacheImpl.this.remove(extendedEndpoint);
            }
        }

        @Override
        public void processMessage(Message m, ReplyHandler handler) {
            if (handler instanceof UDPReplyHandler) {
                if (this.hosts.remove(handler) && LOG.isTraceEnabled()) {
                    LOG.trace("Recieved: " + m);
                }
                if (this.hosts.isEmpty()) {
                    LOG.trace("Unregistering message listener");
                    ((MessageRouter)UDPHostCacheImpl.this.messageRouter.get()).unregisterMessageListener(this.guid, this);
                }
            }
        }

        @Override
        public void registered(byte[] g) {
            this.guid = g;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregistered(byte[] g) {
            UDPHostCacheImpl uDPHostCacheImpl = UDPHostCacheImpl.this;
            synchronized (uDPHostCacheImpl) {
                for (ExtendedEndpoint ep : this.hosts) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("No response from UHC " + ep);
                    }
                    ep.recordUDPHostCacheFailure();
                    UDPHostCacheImpl.this.dirty = true;
                    UDPHostCacheImpl.this.writeDirty = true;
                    if (ep.getUDPHostCacheFailures() <= 5) continue;
                    UDPHostCacheImpl.this.remove(ep);
                }
                this.allHosts.removeAll(this.hosts);
                for (ExtendedEndpoint ep : this.allHosts) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Valid response from UHC " + ep);
                    }
                    ep.recordUDPHostCacheSuccess();
                    UDPHostCacheImpl.this.dirty = true;
                    UDPHostCacheImpl.this.writeDirty = true;
                }
            }
        }
    }
}

