/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.dht.ActiveDHTNodeController;
import com.limegroup.gnutella.dht.DHTControllerFacade;
import com.limegroup.gnutella.dht.DHTControllerFactory;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.PassiveDHTNodeController;
import com.limegroup.gnutella.dht.PassiveLeafController;
import com.limegroup.gnutella.util.EventDispatcher;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;

@Singleton
public class DHTControllerFactoryImpl
implements DHTControllerFactory {
    private final DHTControllerFacade dhtControllerFacade;

    @Inject
    public DHTControllerFactoryImpl(DHTControllerFacade dhtControllerFacade) {
        this.dhtControllerFacade = dhtControllerFacade;
    }

    @Override
    public ActiveDHTNodeController createActiveDHTNodeController(Vendor vendor, Version version, EventDispatcher<DHTEvent, DHTEventListener> dispatcher) {
        return new ActiveDHTNodeController(vendor, version, dispatcher, this.dhtControllerFacade);
    }

    @Override
    public PassiveDHTNodeController createPassiveDHTNodeController(Vendor vendor, Version version, EventDispatcher<DHTEvent, DHTEventListener> dispatcher) {
        return new PassiveDHTNodeController(vendor, version, dispatcher, this.dhtControllerFacade);
    }

    @Override
    public PassiveLeafController createPassiveLeafController(Vendor vendor, Version version, EventDispatcher<DHTEvent, DHTEventListener> dispatcher) {
        return new PassiveLeafController(vendor, version, dispatcher, this.dhtControllerFacade);
    }
}

