/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.RemoteFileDescContext;
import com.limegroup.gnutella.downloader.SourceRanker;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.limewire.util.Visitor;

public abstract class AbstractSourceRanker
implements SourceRanker {
    private MeshHandler meshHandler;
    private Visitor<RemoteFileDescContext> rfdVisitor;

    @Override
    public boolean addToPool(Collection<? extends RemoteFileDescContext> hosts) {
        boolean ret = false;
        for (RemoteFileDescContext remoteFileDescContext : hosts) {
            if (!this.addToPool(remoteFileDescContext)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public abstract boolean addToPool(RemoteFileDescContext var1);

    @Override
    public abstract boolean hasMore();

    @Override
    public abstract RemoteFileDescContext getBest();

    @Override
    public abstract Collection<RemoteFileDescContext> getShareableHosts();

    @Override
    public synchronized boolean hasUsableHosts() {
        final long now = System.currentTimeMillis();
        final Visitor<RemoteFileDescContext> rfdValidator = this.getRfdVisitor();
        final AtomicBoolean usable = new AtomicBoolean(false);
        this.visitSources(new Visitor<RemoteFileDescContext>(){

            @Override
            public boolean visit(RemoteFileDescContext context) {
                if ((rfdValidator == null || rfdValidator.visit(context)) && !context.isBusy(now)) {
                    usable.set(true);
                    return false;
                }
                return true;
            }
        });
        return usable.get();
    }

    @Override
    public synchronized int calculateWaitTime() {
        if (!this.hasMore()) {
            return 0;
        }
        final AtomicInteger waitTime = new AtomicInteger(Integer.MAX_VALUE);
        final long now = System.currentTimeMillis();
        final Visitor<RemoteFileDescContext> rfdValidator = this.getRfdVisitor();
        this.visitSources(new Visitor<RemoteFileDescContext>(){

            @Override
            public boolean visit(RemoteFileDescContext context) {
                if ((rfdValidator == null || rfdValidator.visit(context)) && context.isBusy(now)) {
                    waitTime.set(Math.min(waitTime.get(), context.getWaitTime(now)));
                }
                return true;
            }
        });
        if (waitTime.get() == Integer.MAX_VALUE) {
            return 0;
        }
        return waitTime.get() * 1000;
    }

    @Override
    public synchronized void stop() {
        this.clearState();
        this.meshHandler = null;
    }

    protected void clearState() {
    }

    @Override
    public synchronized void setMeshHandler(MeshHandler handler) {
        this.meshHandler = handler;
    }

    @Override
    public synchronized MeshHandler getMeshHandler() {
        return this.meshHandler;
    }

    @Override
    public synchronized void setRfdVisitor(Visitor<RemoteFileDescContext> rfdVisitor) {
        this.rfdVisitor = rfdVisitor;
    }

    @Override
    public synchronized Visitor<RemoteFileDescContext> getRfdVisitor() {
        return this.rfdVisitor;
    }

    protected abstract boolean visitSources(Visitor<RemoteFileDescContext> var1);
}

