/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.RandomDownloadStrategy;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.util.SystemUtils;

public class BiasedRandomDownloadStrategy
extends RandomDownloadStrategy {
    private static final Log LOG = LogFactory.getLog(BiasedRandomDownloadStrategy.class);
    private static final int MIN_PREVIEW_BYTES = 0x100000;
    private static final float MIN_PREVIEW_FRACTION = 0.1f;
    private static final float MAX_PREVIEW_FRACTION = 0.5f;
    static final int MIN_IDLE_MILLISECONDS = 300000;

    public BiasedRandomDownloadStrategy(long fileSize) {
        super(fileSize);
    }

    @Override
    public synchronized Range pickAssignment(IntervalSet candidateBytes, IntervalSet neededBytes, long blockSize) throws NoSuchElementException {
        Range ret;
        long lowerBound = neededBytes.getFirst().getLow();
        long upperBound = neededBytes.getLast().getHigh();
        if (blockSize < 1L) {
            throw new IllegalArgumentException("Block size cannot be " + blockSize);
        }
        if (lowerBound < 0L) {
            throw new IllegalArgumentException("First needed byte must be >= 0, " + lowerBound + "<0");
        }
        if (upperBound >= this.completedSize) {
            throw new IllegalArgumentException("neededBytes contains bytes beyond the end of the file." + upperBound + " >= " + this.completedSize);
        }
        if (candidateBytes.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (this.getIdleTime() >= 300000L || pseudoRandom.nextFloat() >= this.getBiasProbability(lowerBound, this.completedSize)) {
            return super.pickAssignment(candidateBytes, neededBytes, blockSize);
        }
        Range candidate = candidateBytes.getFirst();
        long alignedHigh = this.alignHigh(candidate.getLow(), blockSize);
        if (alignedHigh > candidate.getHigh()) {
            alignedHigh = candidate.getHigh();
        }
        if ((ret = candidate).getHigh() != alignedHigh) {
            ret = Range.createRange(candidate.getLow(), alignedHigh);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Non-random download, probability=" + this.getBiasProbability(lowerBound, this.completedSize) + ", range=" + ret + " out of choices " + candidateBytes);
        }
        return ret;
    }

    private float getBiasProbability(long previewBytesDownloaded, long fileSize) {
        long goal = Math.max(0x100000L, (long)(0.1f * (float)fileSize));
        if (previewBytesDownloaded < goal) {
            return 1.0f;
        }
        if ((float)previewBytesDownloaded < 0.5f * (float)fileSize) {
            return 0.5f;
        }
        return 0.0f;
    }

    protected long getIdleTime() {
        return SystemUtils.getIdleTime();
    }
}

