/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.core.api.download.DownloadPiecesInfo;

class GnutellaPieceInfo
implements DownloadPiecesInfo {
    private final IntervalSet written;
    private final IntervalSet active;
    private final IntervalSet available;
    private final long pieceSize;
    private final int pieceCount;
    private final int piecesCompletedCount;
    private final long length;

    public GnutellaPieceInfo(IntervalSet written, IntervalSet active, IntervalSet available, long pieceSize, long length) {
        this.written = written;
        this.active = active;
        this.available = available;
        this.pieceSize = pieceSize;
        this.length = length;
        this.piecesCompletedCount = this.aproximatePiecesCompleted();
        this.pieceCount = length <= 0L ? 0 : (int)Math.min(2.147483647E9, Math.ceil((double)length / (double)pieceSize));
    }

    @Override
    public int getNumPieces() {
        return this.pieceCount;
    }

    @Override
    public DownloadPiecesInfo.PieceState getPieceState(int piece) {
        long pieceStart = (long)piece * this.pieceSize;
        long pieceEnd = Math.max(0L, Math.min(pieceStart + this.pieceSize, this.length) - 1L);
        Range range = Range.createRange(pieceStart, pieceEnd);
        DownloadPiecesInfo.PieceState state = this.written.contains(range) ? DownloadPiecesInfo.PieceState.DOWNLOADED : (this.active.containsAny(range) ? DownloadPiecesInfo.PieceState.ACTIVE : (this.available.contains(range) ? (this.written.containsAny(range) ? DownloadPiecesInfo.PieceState.PARTIAL : DownloadPiecesInfo.PieceState.AVAILABLE) : DownloadPiecesInfo.PieceState.UNAVAILABLE));
        return state;
    }

    @Override
    public long getPieceSize() {
        return this.pieceSize;
    }

    @Override
    public int getNumPiecesCompleted() {
        return this.piecesCompletedCount;
    }

    private int aproximatePiecesCompleted() {
        return (int)Math.floor((double)this.written.getSize() / (double)this.pieceSize);
    }
}

