/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryRequest;
import org.limewire.collection.Buffer;
import org.limewire.io.GUID;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

public class DuplicateFilter
implements SpamFilter {
    private static Log LOG = LogFactory.getLog(DuplicateFilter.class);
    private static final int BUF_SIZE = 20;
    private static final int LAG = 500;
    private static final int TOLERANCE = 2;
    private final Buffer<GUIDPair> guids = new Buffer(20);
    private int lag = 500;

    @Override
    public boolean allow(Message m) {
        if (!(m instanceof QueryRequest) && !(m instanceof PingRequest)) {
            return true;
        }
        GUIDPair me = new GUIDPair(m.getGUID(), System.currentTimeMillis(), m.getHops());
        int size = this.guids.getSize();
        for (int i = 0; i < size; ++i) {
            GUIDPair other = this.guids.get(i);
            if (me.time - other.time > (long)this.lag) break;
            if (other.hops != me.hops) continue;
            int misses = 0;
            for (int j = 0; j < me.guid.length && misses <= 2; ++j) {
                if (me.guid[j] == other.guid[j]) continue;
                ++misses;
            }
            if (misses > 2) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debugf("not allowing: {0}", (Object)m);
            }
            this.guids.add(me);
            return false;
        }
        this.guids.add(me);
        return true;
    }

    int getLag() {
        return this.lag;
    }

    void setLag(int lag) {
        this.lag = lag;
    }

    private static class GUIDPair {
        byte[] guid;
        long time;
        int hops;

        GUIDPair(byte[] guid, long time, int hops) {
            this.guid = guid;
            this.time = time;
            this.hops = hops;
        }

        public String toString() {
            return "[" + new GUID(this.guid).toString() + ", " + this.time + "]";
        }
    }
}

