/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.FileCollectionManager;
import com.limegroup.gnutella.library.IncompleteFileCollectionImpl;
import com.limegroup.gnutella.library.LibraryFileData;
import com.limegroup.gnutella.library.SharedFileCollection;
import com.limegroup.gnutella.library.SharedFileCollectionChangeEvent;
import com.limegroup.gnutella.library.SharedFileCollectionImpl;
import com.limegroup.gnutella.library.SharedFileCollectionImplFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectionPoint;
import org.limewire.listener.EventBroadcaster;

@Singleton
class FileCollectionManagerImpl
implements FileCollectionManager {
    @InspectionPoint(value="gnutella shared file list", category=DataCategory.USAGE)
    private final SharedFileCollectionImpl defaultSharedCollection;
    @InspectionPoint(value="incomplete file list", category=DataCategory.USAGE)
    private final IncompleteFileCollectionImpl incompleteCollection;
    private final SharedFileCollectionImplFactory sharedFileCollectionImplFactory;
    private final Map<Integer, SharedFileCollectionImpl> sharedCollections = new HashMap<Integer, SharedFileCollectionImpl>();
    private final EventBroadcaster<SharedFileCollectionChangeEvent> sharedBroadcaster;
    private final Provider<LibraryFileData> libraryFileData;

    @Inject
    public FileCollectionManagerImpl(IncompleteFileCollectionImpl incompleteFileCollectionImpl, SharedFileCollectionImplFactory sharedFileCollectionImplFactory, EventBroadcaster<SharedFileCollectionChangeEvent> sharedBroadcaster, Provider<LibraryFileData> libraryFileData) {
        this.libraryFileData = libraryFileData;
        this.incompleteCollection = incompleteFileCollectionImpl;
        this.incompleteCollection.initialize();
        this.sharedFileCollectionImplFactory = sharedFileCollectionImplFactory;
        this.sharedBroadcaster = sharedBroadcaster;
        this.defaultSharedCollection = sharedFileCollectionImplFactory.createSharedFileCollectionImpl(LibraryFileData.DEFAULT_SHARED_COLLECTION_ID, true, "_@_GNUTELLA_@_");
        this.defaultSharedCollection.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadStoredCollections() {
        for (Integer id : this.libraryFileData.get().getStoredCollectionIds()) {
            if (this.sharedCollections.containsKey(id) || id == LibraryFileData.DEFAULT_SHARED_COLLECTION_ID) continue;
            SharedFileCollectionImpl collection = this.sharedFileCollectionImplFactory.createSharedFileCollectionImpl(id, false, new String[0]);
            collection.initialize();
            FileCollectionManagerImpl fileCollectionManagerImpl = this;
            synchronized (fileCollectionManagerImpl) {
                this.sharedCollections.put(id, collection);
            }
            this.sharedBroadcaster.broadcast(new SharedFileCollectionChangeEvent(SharedFileCollectionChangeEvent.Type.COLLECTION_ADDED, collection));
        }
    }

    FileCollection getGnutellaCollection() {
        return this.defaultSharedCollection;
    }

    @Override
    public synchronized SharedFileCollection getCollectionById(int collectionId) {
        if (collectionId == LibraryFileData.DEFAULT_SHARED_COLLECTION_ID) {
            return this.defaultSharedCollection;
        }
        return this.sharedCollections.get(collectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCollectionById(int collectionId) {
        if (collectionId != LibraryFileData.DEFAULT_SHARED_COLLECTION_ID) {
            SharedFileCollectionImpl removeFileList;
            FileCollectionManagerImpl fileCollectionManagerImpl = this;
            synchronized (fileCollectionManagerImpl) {
                removeFileList = this.sharedCollections.remove(collectionId);
            }
            if (removeFileList != null) {
                removeFileList.dispose();
                this.sharedBroadcaster.broadcast(new SharedFileCollectionChangeEvent(SharedFileCollectionChangeEvent.Type.COLLECTION_REMOVED, removeFileList));
            }
        }
    }

    private synchronized SharedFileCollectionImpl createNewCollectionImpl(String name) {
        int newId = this.libraryFileData.get().createNewCollection(name);
        SharedFileCollectionImpl collection = this.sharedFileCollectionImplFactory.createSharedFileCollectionImpl(newId, false, new String[0]);
        collection.initialize();
        this.sharedCollections.put(newId, collection);
        return collection;
    }

    @Override
    public SharedFileCollection createNewCollection(String name) {
        SharedFileCollectionImpl collection = this.createNewCollectionImpl(name);
        this.sharedBroadcaster.broadcast(new SharedFileCollectionChangeEvent(SharedFileCollectionChangeEvent.Type.COLLECTION_ADDED, collection));
        return collection;
    }

    @Override
    public synchronized List<SharedFileCollection> getSharedFileCollections() {
        ArrayList<SharedFileCollection> collections = new ArrayList<SharedFileCollection>(this.sharedCollections.size() + 1);
        collections.add(this.defaultSharedCollection);
        collections.addAll(this.sharedCollections.values());
        return collections;
    }
}

