/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import java.io.File;
import org.limewire.listener.SourcedEvent;
import org.limewire.util.Objects;
import org.limewire.util.StringUtils;

public class FileViewChangeEvent
implements SourcedEvent<FileView> {
    private final Type type;
    private final FileView list;
    private final FileDesc newValue;
    private final FileDesc oldValue;
    private final File oldFile;
    private final File newFile;
    private boolean isShared = false;
    private boolean libraryCleared = false;

    public FileViewChangeEvent(FileView list, Type type, boolean libraryCleared) {
        assert (type == Type.FILES_CLEARED);
        this.type = Objects.nonNull(type, "type");
        this.list = Objects.nonNull(list, "list");
        this.oldValue = null;
        this.newFile = null;
        this.oldFile = null;
        this.newValue = null;
        this.libraryCleared = libraryCleared;
    }

    public FileViewChangeEvent(FileView list, Type type, File file) {
        assert (type == Type.FILE_ADD_FAILED);
        this.type = Objects.nonNull(type, "type");
        this.list = Objects.nonNull(list, "list");
        this.oldValue = null;
        this.newFile = Objects.nonNull(file, "file");
        this.oldFile = null;
        this.newValue = null;
    }

    public FileViewChangeEvent(FileView list, Type type, File oldFile, FileDesc oldValue, File newValue) {
        assert (type == Type.FILE_CHANGE_FAILED);
        this.type = Objects.nonNull(type, "type");
        this.list = Objects.nonNull(list, "list");
        this.oldValue = oldValue;
        this.newValue = null;
        this.oldFile = Objects.nonNull(oldFile, "oldFile");
        this.newFile = Objects.nonNull(newValue, "file");
    }

    public FileViewChangeEvent(FileView list, Type type, FileDesc value) {
        assert (type == Type.FILE_ADDED || type == Type.FILE_REMOVED || type == Type.FILE_META_CHANGED);
        this.type = Objects.nonNull(type, "type");
        this.list = Objects.nonNull(list, "list");
        this.oldValue = null;
        this.newValue = Objects.nonNull(value, "value");
        this.oldFile = null;
        this.newFile = Objects.nonNull(this.newValue.getFile(), "value.getFile()");
    }

    public FileViewChangeEvent(FileView list, Type type, FileDesc oldValue, FileDesc newValue) {
        assert (type == Type.FILE_CHANGED);
        this.type = Objects.nonNull(type, "type");
        this.list = Objects.nonNull(list, "list");
        this.oldValue = Objects.nonNull(oldValue, "oldValue");
        this.newValue = Objects.nonNull(newValue, "newValue");
        this.oldFile = Objects.nonNull(oldValue.getFile(), "oldValue.getFile()");
        this.newFile = Objects.nonNull(newValue.getFile(), "newValue.getFile()");
    }

    @Override
    public FileView getSource() {
        return this.list;
    }

    public File getOldFile() {
        return this.oldFile;
    }

    public File getFile() {
        return this.newFile;
    }

    public Type getType() {
        return this.type;
    }

    public FileView getFileView() {
        return this.list;
    }

    public FileDesc getFileDesc() {
        return this.newValue;
    }

    public FileDesc getOldValue() {
        return this.oldValue;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public String toString() {
        return StringUtils.toString(this, new Object[0]);
    }

    public boolean isLibraryClear() {
        return this.libraryCleared;
    }

    public static enum Type {
        FILE_ADDED,
        FILE_REMOVED,
        FILE_CHANGED,
        FILE_META_CHANGED,
        FILE_ADD_FAILED,
        FILE_CHANGE_FAILED,
        FILES_CLEARED;

    }
}

