/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messagehandlers.OOBSecurityToken;
import com.limegroup.gnutella.messagehandlers.OOBSession;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.MessageSettings;
import org.limewire.core.settings.SearchSettings;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.GUID;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;
import org.limewire.util.ByteUtils;

@Singleton
public class OOBHandler
implements MessageHandler,
Runnable {
    private static final Log LOG = LogFactory.getLog(OOBHandler.class);
    private static final int RESPONDER_PORT_LIFETIME = 60000;
    private static final int IGNORED_ADDRESS_LIFETIME = 600000;
    private static final int IGNORE = -1;
    private static final int LOCALHOST = ByteUtils.leb2int(new byte[]{127, 0, 0, 1}, 0);
    private final MessageRouter router;
    private final MACCalculatorRepositoryManager MACCalculatorRepositoryManager;
    private final ScheduledExecutorService executor;
    private final OutOfBandStatistics outOfBandStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final Map<Integer, OOBSession> sessions = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, ResponderPort> responderPorts = Collections.synchronizedMap(new HashMap());

    @Inject
    public OOBHandler(MessageRouter router, MACCalculatorRepositoryManager MACCalculatorRepositoryManager2, @Named(value="backgroundExecutor") ScheduledExecutorService executor, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils) {
        this.router = router;
        this.MACCalculatorRepositoryManager = MACCalculatorRepositoryManager2;
        this.executor = executor;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
        if (msg instanceof ReplyNumberVendorMessage) {
            this.handleRNVM((ReplyNumberVendorMessage)msg, handler);
        } else if (msg instanceof QueryReply) {
            this.handleOOBReply((QueryReply)msg, handler);
        } else {
            throw new IllegalArgumentException("can't handle this type of message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRNVM(ReplyNumberVendorMessage msg, final ReplyHandler handler) {
        int toRequest;
        byte[] handlerAddress;
        GUID g = new GUID(msg.getGUID());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received RNVM from " + handler.getAddress() + ":" + handler.getPort() + " with " + msg.getNumResults() + " results");
        }
        if (this.shouldIgnore(handlerAddress = handler.getInetAddress().getAddress(), handler.getPort())) {
            return;
        }
        if (!this.router.isQueryAlive(g) || (toRequest = this.router.getNumOOBToRequest(msg)) <= 0) {
            LOG.debug("Bypassing source");
            this.router.addBypassedSource(msg, handler);
            this.outOfBandStatistics.addBypassedResponse(msg.getNumResults());
            return;
        }
        LimeACKVendorMessage ack = null;
        if (msg.isOOBv3()) {
            OOBSecurityToken t = new OOBSecurityToken(new OOBSecurityToken.OOBTokenData(handler, msg.getGUID(), toRequest), this.MACCalculatorRepositoryManager);
            int hash = Arrays.hashCode(t.getBytes());
            Map<Integer, OOBSession> map = this.sessions;
            synchronized (map) {
                if (!this.sessions.containsKey(hash)) {
                    this.sessions.put(hash, new OOBSession(t, toRequest, new GUID(msg.getGUID())));
                    ack = new LimeACKVendorMessage(g, toRequest, t);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending OOBv3 LimeACK to " + handler.getAddress() + ":" + handler.getPort());
                    }
                } else {
                    LOG.debug("RNVM has already been acked");
                }
            }
        } else {
            ack = new LimeACKVendorMessage(g, toRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending OOBv2 LimeACK to " + handler.getAddress() + ":" + handler.getPort());
            }
        }
        if (ack != null) {
            this.outOfBandStatistics.addRequestedResponse(toRequest);
            handler.reply(ack);
            if (MessageSettings.OOB_REDUNDANCY.getValue()) {
                LOG.debug("Sending redundant LimeACK");
                final LimeACKVendorMessage ackf = ack;
                this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        handler.reply(ackf);
                    }
                }, 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOOBReply(QueryReply reply, ReplyHandler handler) {
        byte[] handlerAddress;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling OOB reply from " + handler.getAddress() + ":" + handler.getPort() + " with " + reply.getResultCount() + " results");
        }
        if (!Arrays.equals(handlerAddress = handler.getInetAddress().getAddress(), reply.getIPBytes())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reply has wrong address " + reply.getIP() + ":" + reply.getPort());
            }
            try {
                if (reply.getNeedsPush() || !this.networkInstanceUtils.isPrivateAddress(reply.getIPBytes())) {
                    reply.setOOBAddress(handler.getInetAddress(), handler.getPort());
                }
            }
            catch (BadPacketException bpe) {
                LOG.debug("Error overriding address");
                return;
            }
        }
        SecurityToken token = null;
        try {
            token = this.getVerifiedSecurityToken(reply, handler);
        }
        catch (InvalidSecurityTokenException e) {
            LOG.debug("Invalid security token");
            return;
        }
        if (token == null) {
            LOG.debug("No security token");
            if (!SearchSettings.DISABLE_OOB_V2.getBoolean()) {
                LOG.debug("Handling as an OOBv2 reply");
                this.router.handleQueryReply(reply, handler);
            }
            return;
        }
        short numResps = reply.getResultCount();
        this.outOfBandStatistics.addReceivedResponse(numResps);
        GUID queryGUID = new GUID(reply.getGUID());
        if (!this.router.isQueryAlive(queryGUID)) {
            LOG.debug("Query is dead - bypassing source");
            this.router.addBypassedSource(reply, handler);
        } else {
            Map<Integer, OOBSession> map = this.sessions;
            synchronized (map) {
                int hashKey = Arrays.hashCode(token.getBytes());
                OOBSession session = this.sessions.get(hashKey);
                if (session == null) {
                    LOG.debug("Query is alive but OOB session has expired");
                    return;
                }
                int remaining = session.getRemainingResultsCount() - numResps;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reply has " + numResps + " results, " + remaining + " remaining");
                }
                if (remaining >= 0) {
                    try {
                        int added = session.countAddedResponses(reply.getResultsArray());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Reply has " + added + " new results");
                        }
                        if (added > 0) {
                            LOG.debug("Handling as an OOBv3 reply");
                            this.router.handleQueryReply(reply, handler);
                        }
                    }
                    catch (BadPacketException e) {
                        LOG.debug("Error getting results");
                    }
                } else {
                    this.tooManyResults(handlerAddress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldIgnore(byte[] addr, int port) {
        if (!SearchSettings.OOB_IGNORE_MULTIPLE_PORTS.getValue()) {
            return false;
        }
        Integer address = ByteUtils.leb2int(addr, 0);
        if (address == LOCALHOST) {
            return false;
        }
        long now = System.currentTimeMillis();
        Map<Integer, ResponderPort> map = this.responderPorts;
        synchronized (map) {
            ResponderPort rp = this.responderPorts.get(address);
            if (rp == null || rp.hasExpired(now)) {
                rp = new ResponderPort(port, now);
                this.responderPorts.put(address, rp);
                return false;
            }
            if (rp.port == -1) {
                rp.timestamp = now;
                return true;
            }
            if (rp.port != port) {
                if (LOG.isInfoEnabled()) {
                    String ip = NetworkUtils.ip2string(addr);
                    LOG.info("Ignoring " + ip + " - too many ports");
                }
                rp = new ResponderPort(-1, now);
                this.responderPorts.put(address, rp);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tooManyResults(byte[] addr) {
        if (!SearchSettings.OOB_IGNORE_EXCESS_RESULTS.getValue()) {
            return;
        }
        Integer address = ByteUtils.leb2int(addr, 0);
        long now = System.currentTimeMillis();
        Map<Integer, ResponderPort> map = this.responderPorts;
        synchronized (map) {
            ResponderPort rp = this.responderPorts.get(address);
            if (rp == null || rp.port != -1) {
                if (LOG.isInfoEnabled()) {
                    String ip = NetworkUtils.ip2string(addr);
                    LOG.info("Ignoring " + ip + " - too many results");
                }
                rp = new ResponderPort(-1, now);
                this.responderPorts.put(address, rp);
            } else {
                rp.timestamp = now;
            }
        }
    }

    private SecurityToken getVerifiedSecurityToken(QueryReply reply, ReplyHandler handler) throws InvalidSecurityTokenException {
        byte[] securityBytes = reply.getSecurityToken();
        if (securityBytes == null) {
            return null;
        }
        OOBSecurityToken oobKey = new OOBSecurityToken(securityBytes, this.MACCalculatorRepositoryManager);
        OOBSecurityToken.OOBTokenData data = new OOBSecurityToken.OOBTokenData(handler, reply.getGUID(), securityBytes[0] & 0xFF);
        if (oobKey.isFor(data)) {
            return oobKey;
        }
        throw new InvalidSecurityTokenException("invalid token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expire() {
        Map<Integer, OOBSession> map = this.sessions;
        synchronized (map) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.sessions.size() + " OOB sessions");
            }
            Iterator<Map.Entry<Integer, OOBSession>> iter = this.sessions.entrySet().iterator();
            while (iter.hasNext()) {
                if (this.router.isQueryAlive(iter.next().getValue().getGUID())) continue;
                iter.remove();
            }
        }
        long now = System.currentTimeMillis();
        Map<Integer, ResponderPort> map2 = this.responderPorts;
        synchronized (map2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.responderPorts.size() + " responder ports");
            }
            Iterator<Map.Entry<Integer, ResponderPort>> iter = this.responderPorts.entrySet().iterator();
            while (iter.hasNext()) {
                if (!iter.next().getValue().hasExpired(now)) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void run() {
        this.expire();
    }

    @InspectableContainer
    private class OOBInspectable {
        @InspectionPoint(value="oob sessions")
        public final Inspectable oobSessions = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                ArrayList<Object> list;
                Map map = OOBHandler.this.sessions;
                synchronized (map) {
                    list = new ArrayList<Object>(OOBHandler.this.sessions.size());
                    for (OOBSession o : OOBHandler.this.sessions.values()) {
                        list.add(o.inspect());
                    }
                }
                return list;
            }
        };

        private OOBInspectable() {
        }
    }

    private static class ResponderPort {
        final int port;
        long timestamp;

        ResponderPort(int port, long timestamp) {
            this.port = port;
            this.timestamp = timestamp;
        }

        boolean hasExpired(long now) {
            if (this.port == -1) {
                return now - this.timestamp > 600000L;
            }
            return now - this.timestamp > 60000L;
        }
    }
}

