/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.HUGEExtension;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.limewire.core.settings.MessageSettings;
import org.limewire.core.settings.SearchSettings;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.io.GUID;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;
import org.xml.sax.SAXException;

public class QueryRequestImpl
extends AbstractMessage
implements QueryRequest {
    private static final Log LOG = LogFactory.getLog(QueryRequestImpl.class);
    private final byte[] PAYLOAD;
    private final int MIN_SPEED;
    private final String QUERY;
    private final LimeXMLDocument XML_DOC;
    private int _featureSelector = 0;
    private boolean _isSecurityTokenRequired;
    private boolean _partialResultsDesired;
    private boolean _desiresNMS1Urns;
    private boolean _doNotProxy = false;
    private final Set<URN> QUERY_URNS;
    private final AddressSecurityToken QUERY_KEY;
    private Integer _metaMask = null;
    private boolean originated = false;
    private volatile int _hashCode = 0;
    private static final char[] ILLEGAL_CHARS = SearchSettings.ILLEGAL_CHARS.get();
    private static final int MAX_QUERY_LENGTH = SearchSettings.MAX_QUERY_LENGTH.getValue();
    private static final int MAX_XML_QUERY_LENGTH = SearchSettings.MAX_XML_QUERY_LENGTH.getValue();
    private static final int OLD_LW_MAX_QUERY_FIELD_LEN = 30;

    QueryRequestImpl(byte[] guid, byte ttl, int minSpeed, String query, String richQuery, Set<? extends URN> queryUrns, AddressSecurityToken addressSecurityToken, boolean isFirewalled, Message.Network network, boolean canReceiveOutOfBandReplies, int featureSelector, boolean doNotProxy, int metaFlagMask, boolean normalize, boolean canDoFWT, LimeXMLDocumentFactory limeXMLDocumentFactory) {
        super(guid, (byte)-128, ttl, (byte)0, 0, network);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating query request, OOB capable " + canReceiveOutOfBandReplies + ", do not proxy " + doNotProxy);
        }
        if (normalize && query != null) {
            query = I18NConvert.instance().getNorm(query);
        }
        if (!(query != null && query.length() != 0 || richQuery != null && richQuery.length() != 0 || queryUrns != null && queryUrns.size() != 0)) {
            throw new IllegalArgumentException("cannot create empty query");
        }
        if (query != null && query.length() > MAX_QUERY_LENGTH) {
            throw new IllegalArgumentException("query too big: " + query);
        }
        if (richQuery != null && richQuery.length() > MAX_XML_QUERY_LENGTH) {
            throw new IllegalArgumentException("xml too big: " + richQuery);
        }
        if (query != null && (queryUrns == null || queryUrns.size() <= 0 || !query.equals("\\")) && QueryRequestImpl.hasIllegalChars(query)) {
            throw new IllegalArgumentException("illegal chars: " + query);
        }
        if (featureSelector < 0) {
            throw new IllegalArgumentException("Bad feature = " + featureSelector);
        }
        this._featureSelector = featureSelector;
        if (metaFlagMask > 0 && metaFlagMask < 4 || metaFlagMask > 248) {
            throw new IllegalArgumentException("Bad Meta Flag = " + metaFlagMask);
        }
        if (metaFlagMask > 0) {
            this._metaMask = metaFlagMask;
        }
        if (minSpeed == 0) {
            minSpeed = 128;
            if (isFirewalled && !this.isMulticast()) {
                minSpeed |= 0x40;
            }
            if (isFirewalled && canDoFWT) {
                minSpeed |= 2;
            }
            if (!canReceiveOutOfBandReplies) {
                LOG.debug("Can't receive OOB replies, setting XML flag");
                minSpeed |= 0x20;
            } else if (!SearchSettings.DISABLE_OOB_V2.getBoolean()) {
                LOG.debug("Setting OOBv2 flag");
                minSpeed |= 4;
            }
        }
        this.MIN_SPEED = minSpeed;
        this.QUERY = query == null ? "" : query;
        if (richQuery == null || richQuery.equals("")) {
            this.XML_DOC = null;
        } else {
            LimeXMLDocument doc = null;
            try {
                doc = limeXMLDocumentFactory.createLimeXMLDocument(richQuery);
            }
            catch (SAXException ignored) {
            }
            catch (SchemaNotFoundException ignored) {
            }
            catch (IOException ignored) {
                // empty catch block
            }
            this.XML_DOC = doc;
        }
        UrnSet tempQueryUrns = null;
        tempQueryUrns = queryUrns != null ? new UrnSet(queryUrns) : URN.NO_URN_SET;
        this.QUERY_KEY = addressSecurityToken;
        this._doNotProxy = doNotProxy;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ByteUtils.short2leb((short)this.MIN_SPEED, baos);
            baos.write(this.getQueryFieldValue().getBytes("UTF-8"));
            baos.write(0);
            boolean addDelimiterBefore = false;
            byte[] richQueryBytes = null;
            if (this.XML_DOC != null) {
                assert (richQuery != null);
                richQueryBytes = richQuery.getBytes("UTF-8");
            }
            addDelimiterBefore = this.writeGemExtension(baos, addDelimiterBefore, richQueryBytes);
            addDelimiterBefore = this.writeGemExtensions(baos, addDelimiterBefore, tempQueryUrns == null ? null : tempQueryUrns.iterator());
            GGEP ggepBlock = new GGEP(true);
            if (this.QUERY_KEY != null) {
                ByteArrayOutputStream qkBytes = new ByteArrayOutputStream();
                this.QUERY_KEY.write(qkBytes);
                ggepBlock.put("QK", qkBytes.toByteArray());
            }
            if (this._featureSelector > 0) {
                ggepBlock.put("WH", this._featureSelector);
            }
            if (this._doNotProxy) {
                LOG.debug("Adding do not proxy OOB header");
                ggepBlock.put("NP");
            }
            if (this._metaMask != null) {
                ggepBlock.put("M", this._metaMask);
            }
            if (canReceiveOutOfBandReplies) {
                LOG.debug("Adding secure OOB header");
                this._isSecurityTokenRequired = true;
                ggepBlock.put("SO");
            }
            if (SearchSettings.desiresPartialResults()) {
                this._partialResultsDesired = true;
                ggepBlock.put("PR");
            }
            if (SearchSettings.DESIRES_NMS1_URNS.getValue()) {
                this._desiresNMS1Urns = true;
                ggepBlock.put("NM");
            }
            if (this.QUERY.length() > 30) {
                ggepBlock.put("XQ", this.QUERY);
            }
            if (!ggepBlock.isEmpty()) {
                ByteArrayOutputStream ggepBytes = new ByteArrayOutputStream();
                ggepBlock.write(ggepBytes);
                addDelimiterBefore = this.writeGemExtension(baos, addDelimiterBefore, ggepBytes.toByteArray());
            }
            baos.write(0);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("could not get UTF-8 bytes for query :" + this.QUERY + " with richquery :" + richQuery);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
        this.PAYLOAD = baos.toByteArray();
        this.updateLength(this.PAYLOAD.length);
        this.QUERY_URNS = Collections.unmodifiableSet(tempQueryUrns);
    }

    private String getQueryFieldValue() {
        Set<String> keywords = QueryUtils.extractKeywords(this.QUERY, true);
        if (this.QUERY.length() <= 30 || keywords.isEmpty()) {
            return this.QUERY;
        }
        return QueryUtils.constructQueryStringFromKeywords(30, keywords);
    }

    QueryRequestImpl(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network, LimeXMLDocumentFactory limeXMLDocumentFactory, MACCalculatorRepositoryManager manager) throws BadPacketException {
        super(guid, (byte)-128, ttl, hops, payload.length, network);
        this.PAYLOAD = payload;
        QueryRequestPayloadParser parser = new QueryRequestPayloadParser(payload, manager);
        this.QUERY = parser.query;
        LimeXMLDocument tempDoc = null;
        try {
            tempDoc = limeXMLDocumentFactory.createLimeXMLDocument(parser.richQuery);
        }
        catch (SAXException ignored) {
        }
        catch (SchemaNotFoundException ignored) {
        }
        catch (IOException ignored) {
            // empty catch block
        }
        this.XML_DOC = tempDoc;
        this.MIN_SPEED = parser.minSpeed;
        this._featureSelector = parser.featureSelector;
        this._doNotProxy = parser.doNotProxy;
        this._metaMask = parser.metaMask;
        this._isSecurityTokenRequired = parser.hasSecurityTokenRequest;
        this._partialResultsDesired = parser.partialResultsDesired;
        this._desiresNMS1Urns = parser.desiresNMS1Urns;
        this.QUERY_URNS = parser.queryUrns == null ? Collections.emptySet() : Collections.unmodifiableSet(parser.queryUrns);
        this.QUERY_KEY = parser.addressSecurityToken;
        if (this.QUERY.length() == 0 && parser.richQuery.length() == 0 && this.QUERY_URNS.size() == 0) {
            throw new BadPacketException("empty query");
        }
        if (this.QUERY.length() > MAX_QUERY_LENGTH) {
            throw new BadPacketException("query too big: " + this.QUERY);
        }
        if (parser.richQuery.length() > MAX_XML_QUERY_LENGTH) {
            throw new BadPacketException("xml too big: " + parser.richQuery);
        }
        if ((this.QUERY_URNS.size() <= 0 || !this.QUERY.equals("\\")) && QueryRequestImpl.hasIllegalChars(this.QUERY)) {
            throw new BadPacketException("illegal chars: " + this.QUERY);
        }
    }

    private static boolean hasIllegalChars(String query) {
        return StringUtils.containsCharacters(query, ILLEGAL_CHARS);
    }

    public static byte[] newQueryGUID(boolean isRequery) {
        if (isRequery) {
            return GUID.makeGuidRequery();
        }
        byte[] ret = GUID.makeGuid();
        if (MessageSettings.STAMP_QUERIES.getValue()) {
            GUID.timeStampGuid(ret);
        }
        return ret;
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        out.write(this.PAYLOAD);
    }

    @Override
    public byte[] getPayload() {
        return this.PAYLOAD;
    }

    @Override
    public String getQuery() {
        return this.QUERY;
    }

    @Override
    public LimeXMLDocument getRichQuery() {
        return this.XML_DOC;
    }

    @Override
    public String getRichQueryString() {
        if (this.XML_DOC == null) {
            return null;
        }
        return this.XML_DOC.getXMLString();
    }

    @Override
    public Set<URN> getQueryUrns() {
        return this.QUERY_URNS;
    }

    @Override
    public boolean hasQueryUrns() {
        return !this.QUERY_URNS.isEmpty();
    }

    @Override
    public int getMinSpeed() {
        return this.MIN_SPEED;
    }

    @Override
    public boolean isFirewalledSource() {
        return !this.isMulticast() && (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 0x40) > 0;
    }

    @Override
    public boolean desiresXMLResponses() {
        return (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 0x20) > 0;
    }

    @Override
    public boolean canDoFirewalledTransfer() {
        return (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 2) > 0;
    }

    @Override
    public boolean desiresOutOfBandReplies() {
        return this.desiresOutOfBandRepliesV2() || this.desiresOutOfBandRepliesV3();
    }

    @Override
    public boolean desiresOutOfBandRepliesV2() {
        return (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 4) > 0;
    }

    @Override
    public boolean desiresOutOfBandRepliesV3() {
        return this.isSecurityTokenRequired();
    }

    @Override
    public boolean doNotProxy() {
        return this._doNotProxy;
    }

    @Override
    public boolean isWhatIsNewRequest() {
        return this._featureSelector == 1;
    }

    @Override
    public boolean isFeatureQuery() {
        return this._featureSelector > 0;
    }

    @Override
    public boolean isBrowseHostQuery() {
        return "    ".equals(this.getQuery());
    }

    @Override
    public int getFeatureSelector() {
        return this._featureSelector;
    }

    @Override
    public boolean isSecurityTokenRequired() {
        return this._isSecurityTokenRequired;
    }

    @Override
    public boolean desiresPartialResults() {
        return this._partialResultsDesired;
    }

    @Override
    public boolean desiresNMS1Urn() {
        return this._desiresNMS1Urns;
    }

    @Override
    public String getReplyAddress() {
        return new GUID(this.getGUID()).getIP();
    }

    @Override
    public boolean matchesReplyAddress(byte[] ip) {
        return new GUID(this.getGUID()).matchesIP(ip);
    }

    @Override
    public int getReplyPort() {
        return new GUID(this.getGUID()).getPort();
    }

    @Override
    public boolean isLimeRequery() {
        return GUID.isLimeRequeryGUID(this.getGUID());
    }

    @Override
    public boolean isQueryForLW() {
        for (String term : SearchSettings.LIME_SEARCH_TERMS.get()) {
            if (this.getQuery().length() > 0 && this.getQuery().toLowerCase(Locale.US).contains(term)) {
                return true;
            }
            if (this.getRichQuery() == null) continue;
            for (String keyword : this.getRichQuery().getKeyWords()) {
                if (!keyword.toLowerCase(Locale.US).contains(term)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public AddressSecurityToken getQueryKey() {
        return this.QUERY_KEY;
    }

    @Override
    public boolean desiresAll() {
        return this._metaMask == null;
    }

    @Override
    public boolean desiresAudio() {
        if (this._metaMask != null) {
            return (this._metaMask & 4) > 0;
        }
        return true;
    }

    @Override
    public boolean desiresVideo() {
        if (this._metaMask != null) {
            return (this._metaMask & 8) > 0;
        }
        return true;
    }

    @Override
    public boolean desiresDocuments() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x10) > 0;
        }
        return true;
    }

    @Override
    public boolean desiresImages() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x20) > 0;
        }
        return true;
    }

    @Override
    public boolean desiresWindowsPrograms() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x40) > 0;
        }
        return true;
    }

    @Override
    public boolean desiresLinuxOSXPrograms() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x80) > 0;
        }
        return true;
    }

    @Override
    public int getMetaMask() {
        if (this._metaMask != null) {
            return this._metaMask;
        }
        return 0;
    }

    @Override
    public void originate() {
        this.originated = true;
    }

    @Override
    public boolean isOriginated() {
        return this.originated;
    }

    @Override
    public boolean shouldIncludeXMLInResponse() {
        return this.desiresXMLResponses() || this.desiresOutOfBandReplies();
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return QueryRequest.class;
    }

    protected boolean writeGemExtension(OutputStream os, boolean addPrefixDelimiter, byte[] extBytes) throws IOException {
        if (extBytes == null || extBytes.length == 0) {
            return addPrefixDelimiter;
        }
        if (addPrefixDelimiter) {
            os.write(28);
        }
        os.write(extBytes);
        return true;
    }

    protected boolean writeGemExtensions(OutputStream os, boolean addPrefixDelimiter, Iterator<URN> iter) throws IOException {
        while (iter.hasNext()) {
            addPrefixDelimiter = this.writeGemExtension(os, addPrefixDelimiter, StringUtils.toAsciiBytes(iter.next().toString()));
        }
        return addPrefixDelimiter;
    }

    protected static byte[] readNullTerminatedBytes(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (is.available() > 0 && (i = is.read()) != 0) {
            baos.write(i);
        }
        return baos.toByteArray();
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int result = 17;
            result = 37 * result + this.QUERY.hashCode();
            if (this.XML_DOC != null) {
                result = 37 * result + this.XML_DOC.hashCode();
            }
            result = 37 * result + ((Object)this.QUERY_URNS).hashCode();
            if (this.QUERY_KEY != null) {
                result = 37 * result + this.QUERY_KEY.hashCode();
            }
            this._hashCode = result;
        }
        return this._hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryRequestImpl)) {
            return false;
        }
        QueryRequestImpl qr = (QueryRequestImpl)o;
        return this.MIN_SPEED == qr.MIN_SPEED && this.QUERY.equals(qr.QUERY) && (this.XML_DOC == null ? qr.XML_DOC == null : this.XML_DOC.equals(qr.XML_DOC)) && ((Object)this.QUERY_URNS).equals(qr.QUERY_URNS) && Arrays.equals(this.getGUID(), qr.getGUID()) && Arrays.equals(this.PAYLOAD, qr.PAYLOAD);
    }

    @Override
    public String toString() {
        return "<query: \"" + this.getQuery() + "\", " + "ttl: " + this.getTTL() + ", " + "hops: " + this.getHops() + ", " + "meta: \"" + this.getRichQueryString() + "\", " + "urns: " + this.getQueryUrns().size() + ">";
    }

    static byte[] patchInGGEP(byte[] payload, GGEP ggep, MACCalculatorRepositoryManager manager) throws BadPacketException {
        HUGEExtension.GGEPBlock block;
        QueryRequestPayloadParser parser = new QueryRequestPayloadParser(payload, manager);
        HUGEExtension huge = parser.huge;
        if (huge != null && (block = QueryRequestImpl.getLastBlock(huge.getGGEPBlocks())) != null) {
            GGEP merge = new GGEP(true);
            merge.merge(block.getGGEP());
            merge.merge(ggep);
            return QueryRequestImpl.insertBytes(payload, parser.hugeStart + block.getStartPos(), parser.hugeStart + block.getEndPos(), merge.toByteArray());
        }
        if (QueryRequestImpl.isFirstNullByteAfterOffset(payload, payload.length - 1, 2)) {
            return QueryRequestImpl.insertGGEP(payload, payload.length, payload.length, ggep.toByteArray(), true);
        }
        if (payload[payload.length - 1] != 28) {
            return QueryRequestImpl.insertGGEP(payload, payload.length - 1, payload.length - 1, ggep.toByteArray(), true);
        }
        return QueryRequestImpl.insertGGEP(payload, payload.length, payload.length, ggep.toByteArray(), false);
    }

    private static boolean isFirstNullByteAfterOffset(byte[] payload, int index, int offset) {
        if (payload[index] != 0) {
            return false;
        }
        for (int i = offset; i < index; ++i) {
            if (payload[i] != 0) continue;
            return false;
        }
        return true;
    }

    private static HUGEExtension.GGEPBlock getLastBlock(List<HUGEExtension.GGEPBlock> blocks) {
        return blocks.isEmpty() ? null : blocks.get(blocks.size() - 1);
    }

    private static byte[] insertGGEP(byte[] payload, int start, int end, byte[] ggepBytes, boolean prependDelimiter) {
        if (prependDelimiter) {
            byte[] ggepBlock = new byte[ggepBytes.length + 1];
            ggepBlock[0] = 28;
            System.arraycopy(ggepBytes, 0, ggepBlock, 1, ggepBytes.length);
            return QueryRequestImpl.insertBytes(payload, start, end, ggepBlock);
        }
        return QueryRequestImpl.insertBytes(payload, start, end, ggepBytes);
    }

    private static byte[] insertBytes(byte[] payload, int start, int end, byte[] ggepBytes) {
        byte[] newPayload = new byte[payload.length + ggepBytes.length - (end - start)];
        System.arraycopy(payload, 0, newPayload, 0, start);
        System.arraycopy(ggepBytes, 0, newPayload, start, ggepBytes.length);
        if (end < payload.length) {
            System.arraycopy(payload, end, newPayload, start + ggepBytes.length, payload.length - end);
        }
        return newPayload;
    }

    static class QueryRequestPayloadParser {
        String query = "";
        String richQuery = "";
        int minSpeed = 0;
        Set<URN> queryUrns = null;
        Set<URN.Type> requestedUrnTypes = null;
        AddressSecurityToken addressSecurityToken = null;
        HUGEExtension huge;
        int featureSelector;
        boolean doNotProxy;
        boolean doNotProxyV3;
        Integer metaMask;
        boolean hasSecurityTokenRequest;
        boolean partialResultsDesired;
        boolean desiresNMS1Urns;
        int hugeStart;
        int hugeEnd;

        public QueryRequestPayloadParser(byte[] payload, MACCalculatorRepositoryManager manager) throws BadPacketException {
            try {
                PositionByteArrayInputStream bais = new PositionByteArrayInputStream(payload);
                short sp = ByteUtils.leb2short(bais);
                this.minSpeed = ByteUtils.ushort2int(sp);
                this.query = new String(QueryRequestImpl.readNullTerminatedBytes(bais), "UTF-8");
                this.hugeStart = bais.getPos();
                byte[] extsBytes = QueryRequestImpl.readNullTerminatedBytes(bais);
                this.huge = new HUGEExtension(extsBytes);
                this.hugeEnd = bais.getPos();
                GGEP ggep = this.huge.getGGEP();
                if (ggep != null) {
                    try {
                        if (ggep.hasKey("QK")) {
                            byte[] qkBytes = ggep.getBytes("QK");
                            this.addressSecurityToken = new AddressSecurityToken(qkBytes, manager);
                        }
                        if (ggep.hasKey("WH")) {
                            this.featureSelector = ggep.getInt("WH");
                        }
                        if (ggep.hasKey("NP")) {
                            this.doNotProxy = true;
                        }
                        if (ggep.hasKey("M")) {
                            this.metaMask = ggep.getInt("M");
                            if (this.metaMask < 4 || this.metaMask > 248) {
                                this.metaMask = null;
                            }
                        }
                        if (ggep.hasKey("SO")) {
                            this.hasSecurityTokenRequest = true;
                        }
                        if (ggep.hasKey("PR")) {
                            this.partialResultsDesired = true;
                        }
                        if (ggep.hasKey("NM")) {
                            this.desiresNMS1Urns = true;
                        }
                        if (ggep.hasKey("XQ")) {
                            this.query = ggep.getString("XQ");
                        }
                    }
                    catch (BadGGEPPropertyException ignored) {
                        // empty catch block
                    }
                }
                this.queryUrns = this.huge.getURNS();
                this.requestedUrnTypes = this.huge.getURNTypes();
                for (String currMiscBlock : this.huge.getMiscBlocks()) {
                    if (this.richQuery.equals("")) {
                        if (!currMiscBlock.startsWith("<?xml")) continue;
                        this.richQuery = currMiscBlock;
                        continue;
                    }
                    break;
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new BadPacketException(uee.getMessage());
            }
            catch (IOException ioe) {
                ErrorService.error(ioe);
            }
        }

        static class PositionByteArrayInputStream
        extends ByteArrayInputStream {
            public PositionByteArrayInputStream(byte[] buf) {
                super(buf);
            }

            public int getPos() {
                return this.pos;
            }
        }
    }
}

