/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.ByteOrder;
import org.limewire.io.GUID;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;

public final class PushProxyAcknowledgement
extends AbstractVendorMessage {
    public static final int VERSION = 2;
    private final InetAddress _addr;
    private final int _port;

    PushProxyAcknowledgement(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 22, version, payload, network);
        if (this.getVersion() == 1) {
            throw new BadPacketException("DEPRECATED VERSION");
        }
        if (this.getVersion() > 2) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 6) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + payload.length);
        }
        try {
            IpPort combo = NetworkUtils.getIpPort(this.getPayload(), ByteOrder.LITTLE_ENDIAN);
            this._addr = combo.getInetAddress();
            this._port = combo.getPort();
        }
        catch (InvalidDataException ide) {
            throw new BadPacketException(ide);
        }
    }

    public PushProxyAcknowledgement(InetAddress addr, int port) {
        super(F_LIME_VENDOR_ID, 22, 2, PushProxyAcknowledgement.derivePayload(addr, port));
        this._addr = addr;
        this._port = port;
    }

    public PushProxyAcknowledgement(InetAddress addr, int port, GUID guid) {
        super(F_LIME_VENDOR_ID, 22, 2, PushProxyAcknowledgement.derivePayload(addr, port));
        this._addr = addr;
        this._port = port;
        this.setGUID(guid);
    }

    public int getListeningPort() {
        return this._port;
    }

    public InetAddress getListeningAddress() {
        return this._addr;
    }

    private static byte[] derivePayload(InetAddress addr, int port) {
        return NetworkUtils.getBytes(addr, port, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }
}

