/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.util.DataUtils;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.GGEP;

public final class UpdateRequest
extends AbstractVendorMessage
implements VendorMessage.ControlMessage {
    private static final int OLD_KEY_VERSION = 1;
    public static final int VERSION = 2;
    static final String COMPRESSED_UPDATE_KEY = "C";
    static final String UNCOMPRESSED_UPDATE_KEY = "U";
    private GGEP _ggep;
    private boolean parsed;

    UpdateRequest(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 26, version, payload, network);
    }

    public UpdateRequest() {
        super(F_LIME_VENDOR_ID, 26, 2, DataUtils.EMPTY_BYTE_ARRAY);
    }

    @Override
    public String toString() {
        return "{UpdateRequest:" + super.toString() + "}";
    }

    public boolean isOldRequest() {
        return this.getVersion() == 1;
    }

    public boolean hasGGEP() {
        if (this._ggep == null && !this.parsed) {
            this._ggep = this.parseGGEP();
            this.parsed = true;
        }
        return this._ggep != null;
    }

    private GGEP parseGGEP() {
        byte[] payload = this.getPayload();
        if (payload == null || payload.length == 0) {
            return null;
        }
        try {
            return new GGEP(payload, 0, null);
        }
        catch (BadGGEPBlockException bad) {
            return null;
        }
    }

    public boolean requestsCompressed() {
        if (!this.hasGGEP()) {
            return false;
        }
        return this._ggep.hasKey(COMPRESSED_UPDATE_KEY);
    }
}

