/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.security.Certificate;
import java.security.PublicKey;
import org.limewire.util.Objects;

class CertificateImpl
implements Certificate {
    private final byte[] signature;
    private final byte[] signedPayload;
    private final int keyVersion;
    private final PublicKey publicKey;
    private final String certificateString;

    public CertificateImpl(byte[] signature, byte[] signedPayload, int keyVersion, PublicKey publicKey, String certificateString) {
        this.signature = signature;
        this.signedPayload = signedPayload;
        this.keyVersion = keyVersion;
        this.publicKey = publicKey;
        this.certificateString = Objects.nonNull(certificateString, "certificateString");
    }

    @Override
    public int getKeyVersion() {
        return this.keyVersion;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public byte[] getSignedPayload() {
        return this.signedPayload;
    }

    @Override
    public String getCertificateString() {
        return this.certificateString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Certificate)) {
            return false;
        }
        return this.certificateString.equals(((Certificate)obj).getCertificateString());
    }

    public int hashCode() {
        return this.certificateString.hashCode();
    }

    public String toString() {
        return this.certificateString;
    }
}

