/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.spam.ApproximateSizeToken;
import com.limegroup.gnutella.spam.TemplateHashToken;
import com.limegroup.gnutella.spam.TemplateHashTokenFactory;
import com.limegroup.gnutella.spam.Token;
import com.limegroup.gnutella.spam.Tokenizer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.FilterSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IOUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.util.Base32;
import org.limewire.util.CommonUtils;

@EagerSingleton
public class RatingTable
implements Service,
SimppListener {
    private static final Log LOG = LogFactory.getLog(RatingTable.class);
    private static final int MAX_SIZE = 5000;
    private static final int INITIAL_SIZE = 100;
    private final File spamDat;
    private final Map<Token, Token> tokenMap = new LinkedHashMap<Token, Token>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Token, Token> e) {
            if (this.size() > 5000) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Discarding token " + e.getValue());
                }
                return true;
            }
            return false;
        }
    };
    private final HashSet<Token> searchTokens = new HashSet();
    private boolean dirty = false;
    private final Tokenizer tokenizer;
    private final TemplateHashTokenFactory templateHashTokenFactory;
    private final ScheduledExecutorService backgroundExecutor;
    @InspectionPoint(value="spam token counts", category=DataCategory.USAGE)
    final Inspectable TOKEN_COUNTS = new Inspectable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object inspect() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("ver", 1);
            m.put("inp", "30872");
            RatingTable ratingTable = RatingTable.this;
            synchronized (ratingTable) {
                for (Token t : RatingTable.this.tokenMap.values()) {
                    String clazz = t.getClass().getSimpleName();
                    Integer i = (Integer)m.get(clazz);
                    if (i == null) {
                        m.put(clazz, 1);
                        continue;
                    }
                    m.put(clazz, i + 1);
                }
            }
            return m;
        }
    };

    @Inject
    RatingTable(Tokenizer tokenizer, TemplateHashTokenFactory templateHashTokenFactory, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor) {
        this.tokenizer = tokenizer;
        this.templateHashTokenFactory = templateHashTokenFactory;
        this.backgroundExecutor = backgroundExecutor;
        this.spamDat = new File(CommonUtils.getUserSettingsDir(), "spam.dat");
    }

    @Inject
    void register(SimppManager simppManager) {
        simppManager.addListener(this);
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Spam Management");
    }

    @Override
    public void initialize() {
    }

    @Override
    public synchronized void start() {
        this.load(this.spamDat);
        this.loadSpamTokensFromSettings();
        this.backgroundExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                RatingTable.this.save();
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }

    @Override
    public synchronized void stop() {
        this.save();
    }

    @Override
    public void simppUpdated() {
        this.loadSpamTokensFromSettings();
    }

    synchronized void loadSpamTokensFromSettings() {
        if (!FilterSettings.USE_NETWORK_FILTER.getValue()) {
            return;
        }
        for (String hash : FilterSettings.SPAM_TEMPLATES.get()) {
            this.setRatingIfUnrated(new TemplateHashToken(Base32.decode(hash)), 1.0f);
        }
        for (String size : FilterSettings.SPAM_SIZES.get()) {
            try {
                this.setRatingIfUnrated(new ApproximateSizeToken(Long.parseLong(size)), 1.0f);
            }
            catch (NumberFormatException e) {
                LOG.debug("Error parsing file size", e);
            }
        }
    }

    synchronized void clear() {
        LOG.debug("Clearing ratings");
        this.tokenMap.clear();
        this.dirty = true;
    }

    synchronized float getRating(RemoteFileDesc desc) {
        float rating = this.getRating(this.lookup(this.tokenizer.getTokens(desc)));
        if (LOG.isDebugEnabled()) {
            String addr = desc.getAddress().getAddressDescription();
            LOG.debug("Result from " + addr + " rated " + rating);
        }
        return rating;
    }

    private float getRating(Set<Token> tokens) {
        float rating = 1.0f;
        for (Token t : tokens) {
            rating *= 1.0f - t.getRating();
        }
        return 1.0f - rating;
    }

    synchronized void rate(RemoteFileDesc[] descs, float rating) {
        this.rateInternal(this.lookup(this.tokenizer.getTokens(descs)), rating);
    }

    synchronized void rate(QueryReply qr, float rating) {
        this.rateInternal(this.lookup(this.tokenizer.getNonKeywordTokens(qr)), rating);
    }

    private void setRatingIfUnrated(Token t, float rating) {
        if (rating == 0.0f) {
            return;
        }
        Token stored = this.tokenMap.get(t);
        if (stored == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting rating of " + t + " to " + rating);
            }
            t.setRating(rating);
            this.tokenMap.put(t, t);
            this.dirty = true;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Not replacing rating of " + t);
        }
    }

    synchronized void clear(QueryRequest qr) {
        for (Token t : this.tokenizer.getTokens(qr)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clearing search token " + t);
            }
            this.searchTokens.add(t);
            if (this.tokenMap.remove(t) == null) continue;
            this.dirty = true;
        }
    }

    private void rateInternal(Set<Token> tokens, float rating) {
        for (Token t : tokens) {
            float before = t.getRating();
            t.updateRating(rating);
            float after = t.getRating();
            if (LOG.isDebugEnabled()) {
                LOG.debug(t + " was rated " + before + ", now rated " + after);
            }
            if (after == 0.0f) {
                this.tokenMap.remove(t);
            } else {
                this.tokenMap.put(t, t);
            }
            this.dirty = true;
        }
    }

    private Set<Token> lookup(Set<Token> tokens) {
        HashSet<Token> newTokens = new HashSet<Token>();
        for (Token t : tokens) {
            if (!this.searchTokens.contains(t)) {
                newTokens.add(this.lookup(t));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Ignoring search token " + t);
        }
        return newTokens;
    }

    private Token lookup(Token token) {
        Token stored = this.tokenMap.get(token);
        return stored == null ? token : stored;
    }

    synchronized float lookupAndGetRating(Token token) {
        return this.getRating(Collections.singleton(this.lookup(token)));
    }

    /*
     * Exception decompiling
     */
    void load(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        ArrayList<Token> list;
        RatingTable ratingTable = this;
        synchronized (ratingTable) {
            if (!this.dirty) {
                LOG.debug("Ratings do not need to be saved");
                return;
            }
            this.dirty = false;
            list = new ArrayList<Token>(this.tokenMap.size());
            for (Map.Entry<Token, Token> e : this.tokenMap.entrySet()) {
                Token t = e.getKey();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Saving " + t + ", rated " + t.getRating());
                }
                list.add(t);
            }
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.spamDat)));
            oos.writeObject(list);
            oos.flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saved " + list.size() + " entries");
            }
            IOUtils.close(oos);
        }
        catch (IOException iox) {
            LOG.debug("Error saving spam ratings: ", iox);
        }
        finally {
            IOUtils.close(oos);
        }
    }

    synchronized int size() {
        return this.tokenMap.size();
    }

    synchronized Token getLeastRecentlyUsed() {
        Iterator<Map.Entry<Token, Token>> i$ = this.tokenMap.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<Token, Token> e = i$.next();
            return e.getKey();
        }
        return null;
    }
}

