/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.messages.OutgoingQueryReplyFactory;
import com.limegroup.gnutella.uploader.BrowseRequestHandler;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.authentication.HttpRequestFileViewProvider;
import org.limewire.core.api.browse.server.BrowseTracker;
import org.limewire.http.auth.RequiresAuthentication;

@Singleton
public class BrowseRequestHandlerFactory {
    private final HTTPUploadSessionManager sessionManager;
    private final Provider<ResponseFactory> responseFactory;
    private final OutgoingQueryReplyFactory outgoingQueryReplyFactory;
    private final BrowseTracker tracker;

    @Inject
    public BrowseRequestHandlerFactory(HTTPUploadSessionManager sessionManager, Provider<ResponseFactory> responseFactory, OutgoingQueryReplyFactory outgoingQueryReplyFactory, BrowseTracker tracker) {
        this.sessionManager = sessionManager;
        this.responseFactory = responseFactory;
        this.outgoingQueryReplyFactory = outgoingQueryReplyFactory;
        this.tracker = tracker;
    }

    public BrowseRequestHandler createBrowseRequestHandler(HttpRequestFileViewProvider browseRequestFileListProvider, boolean requiresAuthentication) {
        if (!requiresAuthentication) {
            return new BrowseRequestHandler(this.sessionManager, this.responseFactory, this.outgoingQueryReplyFactory, browseRequestFileListProvider, this.tracker);
        }
        return new ProtectedBrowseRequestHandler(this.sessionManager, this.responseFactory, this.outgoingQueryReplyFactory, browseRequestFileListProvider);
    }

    @RequiresAuthentication
    class ProtectedBrowseRequestHandler
    extends BrowseRequestHandler {
        ProtectedBrowseRequestHandler(HTTPUploadSessionManager sessionManager, Provider<ResponseFactory> responseFactory, OutgoingQueryReplyFactory outgoingQueryReplyFactory, HttpRequestFileViewProvider browseRequestFileListProvider) {
            super(sessionManager, responseFactory, outgoingQueryReplyFactory, browseRequestFileListProvider, BrowseRequestHandlerFactory.this.tracker);
        }
    }
}

