/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Provider;
import com.limegroup.gnutella.BandwidthManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.limewire.http.entity.AbstractProducingNHttpEntity;
import org.limewire.http.entity.FilePieceReader;
import org.limewire.http.entity.Piece;
import org.limewire.http.entity.PieceListener;
import org.limewire.http.reactor.HttpIOSession;
import org.limewire.nio.NIODispatcher;

public class FileResponseEntity
extends AbstractProducingNHttpEntity {
    private static final Log LOG = LogFactory.getLog(FileResponseEntity.class);
    private final HTTPUploader uploader;
    private final File file;
    private ByteBuffer buffer;
    private long length;
    private long begin;
    private long remaining;
    private FilePieceReader reader;
    private Piece piece;
    private final Provider<BandwidthManager> bandwidthManager;

    FileResponseEntity(HTTPUploader uploader, File file, Provider<BandwidthManager> bandwidthManager) {
        this.uploader = uploader;
        this.file = file;
        this.bandwidthManager = bandwidthManager;
        this.setContentType("application/binary");
        this.begin = uploader.getUploadBegin();
        long end = uploader.getUploadEnd();
        this.remaining = this.length = end - this.begin;
        if (this.length < 0L) {
            throw new IllegalStateException("upload end must be >= upload begin");
        }
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public void initialize(ContentEncoder contentEncoder, IOControl ioctrl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing upload of " + this.file.getName() + " [begin=" + this.begin + ",length=" + this.length + "]");
        }
        if (this.length == 0L) {
            return;
        }
        HttpIOSession ioSession = this.uploader.getSession().getIOSession();
        ioSession.setThrottle(this.bandwidthManager.get().getWriteThrottle(ioSession.getSocket()));
        this.reader = new FilePieceReader(NIODispatcher.instance().getBufferCache(), this.file, this.begin, this.length, new PieceHandler(ioctrl));
        this.reader.start();
    }

    @Override
    public void finish() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished upload of " + this.file.getName() + " [begin=" + this.begin + ",length=" + this.length + ",remaining=" + this.remaining + "]");
        }
        this.deactivateTimeout();
        if (this.reader != null) {
            this.reader.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeContent(ContentEncoder contentEncoder, IOControl ioctrl) throws IOException {
        int written;
        if (this.buffer != null && this.buffer.hasRemaining()) {
            written = contentEncoder.write(this.buffer);
            this.uploader.addAmountUploaded(written);
            if (this.buffer.hasRemaining()) {
                this.activateTimeout();
                return true;
            }
            if (this.remaining == 0L) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("... buffer drained and upload complete");
                }
                this.reader.release(this.piece);
                return false;
            }
        } else if (this.remaining == 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("upload complete");
            }
            return false;
        }
        do {
            if (this.buffer == null || !this.buffer.hasRemaining()) {
                if (this.piece != null) {
                    this.reader.release(this.piece);
                }
                FileResponseEntity fileResponseEntity = this;
                synchronized (fileResponseEntity) {
                    this.piece = this.reader.next();
                    if (this.piece == null) {
                        this.buffer = null;
                        ioctrl.suspendOutput();
                        this.activateTimeout();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Waiting for file contents to be read");
                        }
                        return true;
                    }
                    this.buffer = this.piece.getBuffer();
                    this.remaining -= (long)this.buffer.remaining();
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Uploading " + this.file.getName() + " [remaining=" + this.remaining + "+" + this.buffer.remaining() + "]");
            }
            written = contentEncoder.write(this.buffer);
            this.uploader.addAmountUploaded(written);
        } while (written > 0 && this.remaining > 0L);
        this.activateTimeout();
        return this.remaining > 0L || this.buffer.hasRemaining();
    }

    @Override
    public void timeout() {
        if (LOG.isWarnEnabled()) {
            LOG.warn("File transfer timed out: " + this.uploader);
        }
        this.uploader.stop();
    }

    public String toString() {
        return this.getClass().getName() + " [file=" + this.file.getName() + "]";
    }

    private class PieceHandler
    implements PieceListener {
        private final IOControl ioControl;

        public PieceHandler(IOControl ioControl) {
            this.ioControl = ioControl;
        }

        @Override
        public void readFailed(IOException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Error reading file from disk: " + FileResponseEntity.this.uploader, e);
            }
            FileResponseEntity.this.uploader.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readSuccessful() {
            FileResponseEntity fileResponseEntity = FileResponseEntity.this;
            synchronized (fileResponseEntity) {
                LOG.debug("read successful");
                this.ioControl.requestOutput();
            }
        }
    }
}

