/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec;

import com.onionnetworks.fec.FECCode;
import com.onionnetworks.fec.FECMath;
import com.onionnetworks.util.Util;

public class PureCode
extends FECCode {
    public static final int FEC_MAGIC = -20181524;
    protected static final FECMath fecMath = new FECMath(8);
    protected char[] encMatrix;

    protected void encode(byte[][] src, int[] srcOff, byte[][] repair, int[] repairOff, int[] index, int packetLength) {
        int i = 0;
        while (i < repair.length) {
            this.encode(src, srcOff, repair[i], repairOff[i], index[i], packetLength);
            ++i;
        }
    }

    protected void encode(byte[][] src, int[] srcOff, byte[] repair, int repairOff, int index, int packetLength) {
        if (index < this.k) {
            System.arraycopy(src[index], srcOff[index], repair, repairOff, packetLength);
        } else {
            int pos = index * this.k;
            Util.bzero(repair, repairOff, packetLength);
            int i = 0;
            while (i < this.k) {
                fecMath.addMul(repair, repairOff, src[i], srcOff[i], (byte)this.encMatrix[pos + i], packetLength);
                ++i;
            }
        }
    }

    protected void decode(byte[][] pkts, int[] pktsOff, int[] index, int packetLength, boolean shuffled) {
        if (!shuffled) {
            FECCode.shuffle(pkts, pktsOff, index, this.k);
        }
        char[] decMatrix = fecMath.createDecodeMatrix(this.encMatrix, index, this.k, this.n);
        byte[][] tmpPkts = new byte[this.k][];
        int row = 0;
        while (row < this.k) {
            if (index[row] >= this.k) {
                tmpPkts[row] = new byte[packetLength];
                int col = 0;
                while (col < this.k) {
                    fecMath.addMul(tmpPkts[row], 0, pkts[col], pktsOff[col], (byte)decMatrix[row * this.k + col], packetLength);
                    ++col;
                }
            }
            ++row;
        }
        row = 0;
        while (row < this.k) {
            if (index[row] >= this.k) {
                System.arraycopy(tmpPkts[row], 0, pkts[row], pktsOff[row], packetLength);
                index[row] = row;
            }
            ++row;
        }
    }

    public String toString() {
        return new String("PureCode[k=" + this.k + ",n=" + this.n + "]");
    }

    public PureCode(int k, int n) {
        this(k, n, fecMath.createEncodeMatrix(k, n));
    }

    public PureCode(int k, int n, char[] encMatrix) {
        super(k, n);
        this.encMatrix = encMatrix;
    }
}

