/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapRequestProcessor;
import de.kapsi.net.daap.DaapResponse;
import de.kapsi.net.daap.DaapResponseFactory;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.SessionId;
import de.kapsi.net.daap.nio.DaapRequestReaderNIO;
import de.kapsi.net.daap.nio.DaapResponseFactoryNIO;
import de.kapsi.net.daap.nio.DaapServerNIO;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapConnectionNIO
extends DaapConnection {
    private static final Log LOG = LogFactory.getLog(DaapConnectionNIO.class);
    private static final DaapResponseFactory FACTORY = new DaapResponseFactoryNIO();
    private static final DaapRequestProcessor PROCESSOR = new DaapRequestProcessor(FACTORY);
    private SocketChannel socketChannel;
    private DaapRequestReaderNIO reader;
    private ReadableByteChannel readChannel;
    private WritableByteChannel writeChannel;
    private long timer = System.currentTimeMillis();

    public DaapConnectionNIO(DaapServerNIO server, SocketChannel channel) {
        super(server);
        this.socketChannel = channel;
        this.readChannel = channel;
        this.writeChannel = channel;
        this.reader = new DaapRequestReaderNIO(this);
    }

    public int interrestOps() {
        if (this.isUndef()) {
            return 1;
        }
        if (this.isDaapConnection()) {
            int op = 1;
            if (!this.writer.isEmpty()) {
                op |= 4;
            }
            return op;
        }
        return 4;
    }

    public SocketChannel getChannel() {
        return this.socketChannel;
    }

    public boolean read() throws IOException {
        if (!this.isAudioStream()) {
            while (this.processRead()) {
            }
            return true;
        }
        return false;
    }

    private boolean processRead() throws IOException {
        this.timer = System.currentTimeMillis();
        DaapRequest request = this.reader.read();
        if (request == null) {
            return false;
        }
        if (this.isUndef()) {
            this.defineConnection(request);
        }
        DaapResponse response = PROCESSOR.process(request);
        if (LOG.isTraceEnabled()) {
            LOG.trace(request);
            LOG.trace(response);
        }
        if (response != null) {
            this.writer.add(response);
        }
        return true;
    }

    private void defineConnection(DaapRequest request) throws IOException {
        if (request.isSongRequest()) {
            this.setConnectionType(DaapConnection.ConnectionType.AUDIO);
            SessionId sid = request.getSessionId();
            if (!((DaapServerNIO)this.server).isSessionIdValid(sid)) {
                throw new IOException("Unknown Session-ID: " + sid);
            }
            DaapConnectionNIO connection = ((DaapServerNIO)this.server).getDaapConnection(sid);
            if (connection == null) {
                throw new IOException("No connection associated with this Session-ID: " + sid);
            }
            DaapConnectionNIO audio = ((DaapServerNIO)this.server).getAudioConnection(sid);
            if (audio != null) {
                throw new IOException("Multiple audio connections not allowed: " + sid);
            }
            this.setProtocolVersion(connection.getProtocolVersion());
        } else if (request.isServerInfoRequest()) {
            this.setConnectionType(DaapConnection.ConnectionType.DAAP);
            this.setProtocolVersion(DaapUtil.getProtocolVersion(request));
        } else {
            throw new IOException("Illegal first request: " + request);
        }
        if (!DaapUtil.isSupportedProtocolVersion(this.getProtocolVersion())) {
            throw new IOException("Unsupported Protocol Version: " + this.getProtocolVersion());
        }
        if (!((DaapServerNIO)this.server).updateConnection(this)) {
            throw new IOException("Too may connections");
        }
    }

    boolean timeout() {
        return this.isUndef() && System.currentTimeMillis() - this.timer >= 3000L || this.isDaapConnection() && System.currentTimeMillis() - this.timer >= 30000L;
    }

    public void clearLibraryQueue() {
        super.clearLibraryQueue();
        this.timer = System.currentTimeMillis();
    }

    public void update() throws IOException {
        DaapSession session;
        if (this.isDaapConnection() && !this.isLocked() && (session = this.getSession(false)) != null) {
            SessionId sessionId = session.getSessionId();
            Integer delta = (Integer)session.getAttribute("CLIENT_REVISION");
            Integer revisionNumber = new Integer(this.getFirstInQueue().getRevision());
            DaapRequest request = new DaapRequest((DaapConnection)this, sessionId, revisionNumber, delta);
            DaapResponse response = PROCESSOR.process(request);
            if (response != null) {
                this.writer.add(response);
            }
        }
    }

    public void close() {
        super.close();
        this.reader = null;
    }

    public String toString() {
        return this.socketChannel.toString();
    }

    public ReadableByteChannel getReadChannel() {
        return this.readChannel;
    }

    public void setReadChannel(ReadableByteChannel readChannel) {
        this.readChannel = readChannel;
    }

    public WritableByteChannel getWriteChannel() {
        return this.writeChannel;
    }

    public void setWriteChannel(WritableByteChannel writeChannel) {
        this.writeChannel = writeChannel;
    }
}

