/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapStreamException;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.SessionId;
import de.kapsi.net.daap.nio.DaapConnectionNIO;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaapServerNIO
extends DaapServer<DaapConnectionNIO> {
    private static final Log LOG = LogFactory.getLog(DaapServerNIO.class);
    private static final long TIMEOUT = 250L;
    private ServerSocketChannel ssc = null;
    private Selector selector = null;
    private boolean disconnectAll = false;
    private boolean update = false;

    public DaapServerNIO(Library library) {
        this(library, new DaapConfig());
    }

    public DaapServerNIO(Library library, DaapConfig config) {
        super(library, config);
    }

    @Override
    public void bind() throws IOException {
        InetSocketAddress bindAddr = this.config.getInetSocketAddress();
        int backlog = this.config.getBacklog();
        try {
            this.ssc = ServerSocketChannel.open();
            ServerSocket socket = this.ssc.socket();
            socket.setReuseAddress(false);
            try {
                socket.bind(bindAddr, backlog);
            }
            catch (SocketException err) {
                throw new BindException(err.getMessage());
            }
            this.ssc.configureBlocking(false);
            if (LOG.isInfoEnabled()) {
                LOG.info("DaapServerNIO bound to " + bindAddr);
            }
        }
        catch (IOException err) {
            this.close();
            throw err;
        }
    }

    @Override
    protected synchronized void update() {
        this.update = true;
    }

    @Override
    public synchronized void stop() {
        this.running = false;
    }

    private synchronized void close() {
        this.running = false;
        this.update = false;
        this.disconnectAll = false;
        if (this.selector != null) {
            for (SelectionKey key : this.selector.keys()) {
                this.cancel(key);
            }
            try {
                this.selector.close();
            }
            catch (IOException err) {
                LOG.error("Selector.close()", err);
            }
            this.selector = null;
        }
        if (this.ssc != null) {
            try {
                this.ssc.close();
            }
            catch (IOException err) {
                LOG.error("ServerSocketChannel.close()", err);
            }
            this.ssc = null;
        }
        this.sessionIds.clear();
        this.connections.clear();
        this.libraryQueue.clear();
    }

    @Override
    public synchronized void disconnectAll() {
        this.disconnectAll = true;
    }

    private void cancel(SelectionKey sk) {
        sk.cancel();
        SelectableChannel channel = sk.channel();
        try {
            channel.close();
        }
        catch (IOException err) {
            LOG.error("Channel.close()", err);
        }
        DaapConnection connection = (DaapConnection)sk.attachment();
        if (connection != null) {
            this.closeConnection(connection);
        }
    }

    protected void closeConnection(DaapConnection connection) {
        DaapSession session = connection.getSession(false);
        if (session != null) {
            this.destroySessionId(session.getSessionId());
        }
        connection.close();
        try {
            this.removeConnection(connection);
        }
        catch (IllegalStateException err) {
            LOG.error(err);
        }
    }

    private void processAccept(SelectionKey sk) throws IOException {
        if (!sk.isValid()) {
            return;
        }
        ServerSocketChannel ssc = (ServerSocketChannel)sk.channel();
        SocketChannel channel = ssc.accept();
        if (channel == null) {
            return;
        }
        try {
            Socket socket = channel.socket();
            if (channel.isOpen() && this.accept(socket.getInetAddress())) {
                channel.configureBlocking(false);
                DaapConnectionNIO connection = new DaapConnectionNIO(this, channel);
                channel.register(this.selector, 1, connection);
                this.addPendingConnection(connection);
            } else {
                channel.close();
            }
        }
        catch (IOException err) {
            LOG.error(err);
            try {
                channel.close();
            }
            catch (IOException iox) {
                // empty catch block
            }
        }
    }

    private void processRead(SelectionKey sk) throws IOException {
        if (!sk.isValid()) {
            return;
        }
        DaapConnectionNIO connection = (DaapConnectionNIO)sk.attachment();
        boolean keepAlive = false;
        keepAlive = connection.read();
        if (keepAlive) {
            sk.interestOps(connection.interrestOps());
        } else {
            this.cancel(sk);
        }
    }

    private void processWrite(SelectionKey sk) throws IOException {
        if (!sk.isValid()) {
            return;
        }
        DaapConnectionNIO connection = (DaapConnectionNIO)sk.attachment();
        boolean keepAlive = false;
        try {
            keepAlive = connection.write();
        }
        catch (DaapStreamException err) {
            keepAlive = false;
            LOG.error(err);
        }
        if (keepAlive) {
            sk.interestOps(connection.interrestOps());
        } else {
            this.cancel(sk);
        }
    }

    private void processDisconnectAll() {
        for (SelectionKey sk : this.selector.keys()) {
            SelectableChannel channel = sk.channel();
            if (!(channel instanceof SocketChannel)) continue;
            this.cancel(sk);
        }
        this.libraryQueue.clear();
    }

    private void processUpdate() {
        for (DaapConnectionNIO connection : this.getDaapConnections()) {
            SelectionKey sk = connection.getChannel().keyFor(this.selector);
            try {
                for (int i = 0; i < this.libraryQueue.size(); ++i) {
                    connection.enqueueLibrary((Library)this.libraryQueue.get(i));
                }
                connection.update();
                if (!sk.isValid()) continue;
                try {
                    sk.interestOps(5);
                }
                catch (CancelledKeyException err) {
                    this.cancel(sk);
                    LOG.error("SelectionKey.interestOps()", err);
                }
            }
            catch (ClosedChannelException err) {
                this.cancel(sk);
                LOG.error("DaapConnection.update()", err);
            }
            catch (IOException err) {
                this.cancel(sk);
                LOG.error("DaapConnection.update()", err);
            }
        }
        this.libraryQueue.clear();
    }

    protected void processTimeout() {
        for (DaapConnectionNIO connection : this.getPendingConnections()) {
            if (!connection.timeout()) continue;
            this.cancelConnection(connection);
        }
        for (DaapConnectionNIO connection : this.getDaapConnections()) {
            if (!connection.timeout()) continue;
            connection.clearLibraryQueue();
        }
    }

    protected void cancelConnection(DaapConnectionNIO connection) {
        SelectionKey sk = connection.getChannel().keyFor(this.selector);
        this.cancel(sk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws IOException {
        int n = -1;
        this.running = true;
        this.update = false;
        this.disconnectAll = false;
        while (this.running) {
            try {
                n = this.selector.select(250L);
            }
            catch (NullPointerException err) {
                continue;
            }
            catch (CancelledKeyException err) {
                continue;
            }
            DaapServerNIO daapServerNIO = this;
            synchronized (daapServerNIO) {
                if (!this.running) {
                    break;
                }
                if (this.disconnectAll) {
                    this.processDisconnectAll();
                    this.disconnectAll = false;
                    continue;
                }
                if (this.update) {
                    this.processUpdate();
                    this.update = false;
                }
                if (n > 0) {
                    Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                    while (it.hasNext() && this.running) {
                        SelectionKey sk = it.next();
                        it.remove();
                        try {
                            if (sk.isAcceptable()) {
                                this.processAccept(sk);
                                continue;
                            }
                            if (sk.isReadable()) {
                                try {
                                    this.processRead(sk);
                                }
                                catch (IOException err) {
                                    this.cancel(sk);
                                    LOG.error("An exception occured in processRead()", err);
                                }
                            }
                            if (!sk.isWritable()) continue;
                            try {
                                this.processWrite(sk);
                            }
                            catch (IOException err) {
                                this.cancel(sk);
                                LOG.error("An exception occured in processWrite()", err);
                            }
                        }
                        catch (CancelledKeyException err) {}
                    }
                }
                this.processTimeout();
            }
        }
    }

    @Override
    public void run() {
        try {
            if (this.running) {
                LOG.error("DaapServerNIO is already running.");
                return;
            }
            this.selector = Selector.open();
            this.ssc.register(this.selector, 16);
            this.process();
        }
        catch (IOException err) {
            LOG.error(err);
            throw new RuntimeException(err);
        }
        finally {
            this.close();
        }
    }

    @Override
    protected synchronized DaapConnectionNIO getAudioConnection(SessionId sessionId) {
        return (DaapConnectionNIO)super.getAudioConnection(sessionId);
    }

    @Override
    protected synchronized DaapConnectionNIO getDaapConnection(SessionId sessionId) {
        return (DaapConnectionNIO)super.getDaapConnection(sessionId);
    }

    @Override
    protected synchronized boolean isSessionIdValid(SessionId sessionId) {
        return super.isSessionIdValid(sessionId);
    }

    @Override
    protected synchronized boolean updateConnection(DaapConnectionNIO connection) {
        return super.updateConnection(connection);
    }
}

